/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.primitives;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public final class TransactionalInteger {
    private int value;

    public TransactionalInteger() {
        this(0);
    }

    public TransactionalInteger(int value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public int get() {
        return this.value;
    }

    public int set(int newValue) {
        int oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    public int dec() {
        --this.value;
        return this.value;
    }

    public int inc() {
        ++this.value;
        return this.value;
    }

    public int inc(int amount) {
        this.value += amount;
        return this.value;
    }

    public int dec(int amount) {
        this.value -= amount;
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public void await(int desired) {
        if (desired != this.value) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public int awaitLargerThan(int than) {
        if (this.value <= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public int awaitLargerOrEqualThan(int than) {
        if (this.value < than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public int awaitSmallerThan(int than) {
        if (this.value >= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public int awaitSmallerOrEqualThan(int than) {
        if (this.value > than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public int awaitNotEqualTo(int than) {
        if (this.value == than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public String toString() {
        return String.format("TransactionalInteger(value=%s)", this.value);
    }

    @TransactionalMethod(readonly=true)
    public int hashCode() {
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof TransactionalInteger)) {
            return false;
        }
        TransactionalInteger that = (TransactionalInteger)thatObj;
        return that.value == this.value;
    }
}

