/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api.backoff;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.api.backoff.ExponentialBackoffPolicy;

public class ExponentialBackoffPolicyTest {
    @Test
    public void construction_INSTANCE() {
        ExponentialBackoffPolicy policy = ExponentialBackoffPolicy.INSTANCE_100_MS_MAX;
        Assert.assertEquals((long)100L, (long)policy.getMinDelayNs());
        Assert.assertEquals((long)TimeUnit.MILLISECONDS.toNanos(100L), (long)policy.getMaxDelayNs());
    }

    @Test(expected=IllegalArgumentException.class)
    public void minimumDelayCantBeLargerThanMaximumDelay() {
        new ExponentialBackoffPolicy(10L, 9L, TimeUnit.NANOSECONDS);
    }

    @Test
    @Ignore
    public void noDelayForZeroIteration() {
        ExponentialBackoffPolicy policy = new ExponentialBackoffPolicy();
    }

    @Test
    @Ignore
    public void minimumDelay() {
        long minDelay = 10000L;
        ExponentialBackoffPolicy policy = new ExponentialBackoffPolicy(minDelay, 1L, TimeUnit.SECONDS);
    }

    @Test
    @Ignore
    public void tooLargeValueTruncated() {
        long maxDelayNs = 10000L;
        ExponentialBackoffPolicy policy = new ExponentialBackoffPolicy(100L, maxDelayNs, TimeUnit.NANOSECONDS);
    }

    @Test
    @Ignore
    public void happyFlow() {
        long maxDelayNs = 1000000L;
        ExponentialBackoffPolicy policy = new ExponentialBackoffPolicy(100L, maxDelayNs, TimeUnit.NANOSECONDS);
    }
}

