/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.clock.PrimitiveClock;
import org.multiverse.api.clock.StrictPrimitiveClock;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.stms.AbstractTransaction;
import org.multiverse.stms.AbstractTransactionImpl;

public class AbstractTransaction_commitTest {
    private StrictPrimitiveClock clock;

    @Before
    public void setUp() {
        this.clock = new StrictPrimitiveClock(1L);
    }

    @Test
    public void whenPrepareThrowsException_thenAbort() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        tx.start();
        RuntimeException expected = new RuntimeException();
        ((AbstractTransaction)Mockito.doThrow((Throwable)expected).when((Object)tx)).doPrepare();
        try {
            tx.commit();
            Assert.fail();
        }
        catch (RuntimeException found) {
            Assert.assertSame((Object)expected, (Object)found);
            TestUtils.assertIsAborted(new Transaction[]{tx});
        }
    }

    @Test
    public void whenActive_listenersAreNotified() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        tx.start();
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        tx.commit();
        TestUtils.assertIsCommitted(new Transaction[]{tx});
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.PreCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.PostCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.PreAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.PostAbort);
    }

    @Test
    public void whenPreCommitTaskFails_thenAbort() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.start();
        RuntimeException exception = new RuntimeException();
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)exception).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.PreCommit);
        tx.registerLifecycleListener(listener);
        try {
            tx.commit();
            Assert.fail();
        }
        catch (RuntimeException found) {
            Assert.assertSame((Object)exception, (Object)found);
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.PreCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.PostCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.PreAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.PostAbort);
    }

    @Test
    public void whenPostCommitTaskFails_exceptionThrown() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.start();
        RuntimeException exception = new RuntimeException();
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)exception).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.PostCommit);
        tx.registerLifecycleListener(listener);
        try {
            tx.commit();
            Assert.fail();
        }
        catch (RuntimeException found) {
            Assert.assertSame((Object)exception, (Object)found);
        }
        TestUtils.assertIsCommitted(new Transaction[]{tx});
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.PreCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.PostCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.PreAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.PostAbort);
    }

    @Test
    public void whenPrepared() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        tx.prepare();
        tx.commit();
        ((AbstractTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)1))).makeChangesPermanent();
    }

    @Test
    public void whenDoCommitPreparedFails_thenAbort() {
        AbstractTransaction tx = (AbstractTransaction)Mockito.spy((Object)((Object)new AbstractTransactionImpl()));
        tx.prepare();
        RuntimeException expected = new RuntimeException();
        ((AbstractTransaction)Mockito.doThrow((Throwable)expected).when((Object)tx)).makeChangesPermanent();
        try {
            tx.commit();
            Assert.fail();
        }
        catch (Exception found) {
            Assert.assertSame((Object)expected, (Object)found);
        }
        ((AbstractTransaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)1))).doAbortPrepared();
        TestUtils.assertIsAborted(new Transaction[]{tx});
    }

    @Test
    public void whenCommitted_thenIgnore() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        tx.commit();
        long version = this.clock.getVersion();
        tx.commit();
        TestUtils.assertIsCommitted(new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.clock.getVersion());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        tx.abort();
        long version = this.clock.getVersion();
        try {
            tx.commit();
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.clock.getVersion());
    }
}

