/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.clock.PrimitiveClock;
import org.multiverse.api.clock.StrictPrimitiveClock;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.stms.AbstractTransactionImpl;

public class AbstractTransaction_startOrTest {
    private StrictPrimitiveClock clock;

    @Before
    public void setUp() {
        this.clock = new StrictPrimitiveClock(1L);
    }

    @Test
    public void whenActive() {
        TestUtils.testIncomplete();
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        tx.commit();
        long version = this.clock.getVersion();
        try {
            tx.startOr();
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsCommitted(new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.clock.getVersion());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        AbstractTransactionImpl t = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        t.abort();
        long version = this.clock.getVersion();
        try {
            t.startOr();
            Assert.fail();
        }
        catch (DeadTransactionException ex) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{t});
        Assert.assertEquals((long)version, (long)this.clock.getVersion());
    }
}

