/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;
import org.multiverse.transactional.refs.Ref;

@TransactionalObject
public class BasicRef<E>
implements Ref<E> {
    private E value;

    public BasicRef() {
        this(null);
    }

    public BasicRef(E value) {
        this.value = value;
    }

    @Override
    @TransactionalMethod(readonly=true, trackReads=true)
    public final E getOrAwait() {
        if (this.value == null) {
            StmUtils.retry();
        }
        return this.value;
    }

    @Override
    @TransactionalMethod(readonly=true, trackReads=true, interruptible=true)
    public final E getOrAwaitInterruptibly() throws InterruptedException {
        if (this.value == null) {
            StmUtils.retry();
        }
        return this.value;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public final boolean isNull() {
        return this.value == null;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public final E get() {
        return this.value;
    }

    @Override
    @TransactionalMethod(trackReads=true)
    public final E set(E newValue) {
        if (this.value == newValue) {
            return newValue;
        }
        E oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @Override
    @TransactionalMethod(readonly=false, trackReads=true)
    public final E clear() {
        return this.set(null);
    }

    @TransactionalMethod(readonly=true)
    public final String toString() {
        if (this.value == null) {
            return "BasicRef(ref=null)";
        }
        return String.format("BasicRef(ref=%s)", this.value);
    }
}

