/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public class CharRef {
    private char value;

    public CharRef() {
        this('\u0000');
    }

    public CharRef(char value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public final char get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final void await(char desired) {
        if (desired != this.value) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final char awaitLargerThan(char than) {
        if (this.value <= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final char awaitLargerOrEqualThan(char than) {
        if (this.value < than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final char awaitSmallerThan(char than) {
        if (this.value >= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final char awaitSmallerOrEqualThan(char than) {
        if (this.value > than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final char awaitNotEqualTo(char than) {
        if (this.value == than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final char set(char newValue) {
        if (newValue == this.value) {
            return newValue;
        }
        char oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final char inc() {
        this.value = (char)(this.value + '\u0001');
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final char inc(char amount) {
        if (amount == '\u0000') {
            return this.value;
        }
        this.value = (char)(this.value + amount);
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final char dec() {
        this.value = (char)(this.value - '\u0001');
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final char dec(char amount) {
        if (amount == '\u0000') {
            return this.value;
        }
        this.value = (char)(this.value - amount);
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public final String toString() {
        return String.format("CharRef(value=%s)", Character.valueOf(this.value));
    }

    @TransactionalMethod(readonly=true)
    public final int hashCode() {
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public final boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof CharRef)) {
            return false;
        }
        CharRef that = (CharRef)thatObj;
        return that.value == this.value;
    }
}

