/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public class FloatRef {
    private float value;

    public FloatRef() {
        this(0.0f);
    }

    public FloatRef(float value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public float get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public void await(char desired) {
        if (!FloatRef.equals(desired, this.value)) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final float set(float newValue) {
        if (FloatRef.equals(this.value, newValue)) {
            return newValue;
        }
        float oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final float inc() {
        this.value += 1.0f;
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final float inc(float amount) {
        if (FloatRef.equals(amount, 0.0f)) {
            return this.value;
        }
        this.value += amount;
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final float dec() {
        this.value -= 1.0f;
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final float dec(float amount) {
        return this.inc(-amount);
    }

    @TransactionalMethod(readonly=true)
    public final String toString() {
        return String.format("FloatRef(value=%s)", Float.valueOf(this.value));
    }

    @TransactionalMethod(readonly=true)
    public final int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @TransactionalMethod(readonly=true)
    public final boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof FloatRef)) {
            return false;
        }
        FloatRef that = (FloatRef)thatObj;
        return FloatRef.equals(this.value, that.value);
    }

    private static boolean equals(float f1, float f2) {
        return Float.floatToIntBits(f1) == Float.floatToIntBits(f2);
    }
}

