/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.stms.AbstractTransactionImpl;

public class AbstractTransaction_startTest {
    @Test
    public void whenNew_thenStart() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.start();
        TestUtils.assertIsActive(new Transaction[]{tx});
    }

    @Test
    public void whenActive_thenIgnore() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.start();
        tx.start();
        TestUtils.assertIsActive(new Transaction[]{tx});
    }

    @Test
    public void whenPrepared() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.prepare();
        try {
            tx.start();
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsPrepared(new Transaction[]{tx});
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.abort();
        try {
            tx.start();
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.commit();
        try {
            tx.start();
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        TestUtils.assertIsCommitted(new Transaction[]{tx});
    }
}

