/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api.clock;

import java.util.concurrent.atomic.AtomicLong;
import org.multiverse.api.clock.PrimitiveClock;

public final class RelaxedPrimitiveClock
implements PrimitiveClock {
    private final AtomicLong clock;

    public RelaxedPrimitiveClock() {
        this(0L);
    }

    public RelaxedPrimitiveClock(long version) {
        if (version < 0L) {
            throw new IllegalArgumentException();
        }
        this.clock = new AtomicLong(version);
    }

    @Override
    public long tick() {
        long oldTime = this.clock.get();
        long newTime = oldTime + 1L;
        this.clock.compareAndSet(oldTime, newTime);
        return newTime;
    }

    @Override
    public long strictTick() {
        return this.clock.incrementAndGet();
    }

    @Override
    public long tickTo(long version) {
        long current;
        do {
            if (version >= (current = this.clock.get())) continue;
            return current;
        } while (!this.clock.compareAndSet(current, version));
        return version;
    }

    @Override
    public long getVersion() {
        return this.clock.get();
    }

    public String toString() {
        return String.format("RelaxedPrimitiveClock(time=%s)", this.clock.get());
    }
}

