/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.multiverse.MultiverseConstants;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.templates.TransactionBoilerplate;
import org.multiverse.templates.TransactionalCallable;

public abstract class TransactionTemplate<E>
implements MultiverseConstants {
    private final TransactionBoilerplate boilerplate;
    private final TransactionalCallable<E> callable = new TransactionalCallableImpl();

    public TransactionTemplate() {
        this(GlobalStmInstance.getGlobalStmInstance());
    }

    public TransactionTemplate(Stm stm) {
        this(stm.getTransactionFactoryBuilder().build());
    }

    public TransactionTemplate(TransactionFactory transactionFactory) {
        this(transactionFactory, true, true);
    }

    public TransactionTemplate(TransactionFactory transactionFactory, boolean threadLocalAware, boolean lifecycleListenersEnabled) {
        CallbackListener listener = lifecycleListenersEnabled ? new CallbackListener() : null;
        this.boilerplate = new TransactionBoilerplate(transactionFactory, listener, threadLocalAware);
    }

    public abstract E execute(Transaction var1) throws Exception;

    public final boolean isThreadLocalAware() {
        return this.boilerplate.isThreadLocalAware();
    }

    public final boolean isLifecycleListenersEnabled() {
        return this.boilerplate.getTransactionLifecycleListener() != null;
    }

    public final TransactionFactory getTransactionFactory() {
        return this.boilerplate.getTransactionFactory();
    }

    protected void onInit() {
    }

    protected void onPostStart(Transaction tx) {
    }

    protected void onPreCommit(Transaction tx) {
    }

    protected void onPostCommit() {
    }

    protected void onPreAbort(Transaction tx) {
    }

    protected void onPostAbort() {
    }

    public final E execute() {
        return this.boilerplate.execute(this.callable);
    }

    public final E executeChecked() throws Exception {
        return this.boilerplate.executeChecked(this.callable);
    }

    class TransactionalCallableImpl
    implements TransactionalCallable<E> {
        TransactionalCallableImpl() {
        }

        @Override
        public E call(Transaction tx) throws Exception {
            return TransactionTemplate.this.execute(tx);
        }
    }

    private class CallbackListener
    implements TransactionLifecycleListener {
        private CallbackListener() {
        }

        @Override
        public void notify(Transaction tx, TransactionLifecycleEvent event) {
            switch (event) {
                case PreStart: {
                    break;
                }
                case PostStart: {
                    TransactionTemplate.this.onPostStart(tx);
                    break;
                }
                case PrePrepare: {
                    break;
                }
                case PostPrepare: {
                    break;
                }
                case PreAbort: {
                    TransactionTemplate.this.onPreAbort(tx);
                    break;
                }
                case PostAbort: {
                    TransactionTemplate.this.onPostAbort();
                    break;
                }
                case PreCommit: {
                    TransactionTemplate.this.onPreCommit(tx);
                    break;
                }
                case PostCommit: {
                    TransactionTemplate.this.onPostCommit();
                    break;
                }
                default: {
                    throw new IllegalStateException("unhandled event: " + (Object)((Object)event));
                }
            }
        }
    }
}

