/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;
import org.multiverse.transactional.refs.Ref;

@TransactionalObject
public class AbaRef<E>
implements Ref<E> {
    private E value;
    private long writeVersion;

    public AbaRef() {
        this.value = null;
        this.writeVersion = Long.MIN_VALUE;
    }

    public AbaRef(E value) {
        this.value = value;
        this.writeVersion = Long.MIN_VALUE;
    }

    @Override
    @TransactionalMethod(readonly=true, trackReads=true)
    public final E getOrAwait() {
        if (this.value == null) {
            StmUtils.retry();
        }
        return this.value;
    }

    @Override
    @TransactionalMethod(readonly=true, trackReads=true, interruptible=true)
    public final E getOrAwaitInterruptibly() throws InterruptedException {
        if (this.value == null) {
            StmUtils.retry();
        }
        return this.value;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public final E get() {
        return this.value;
    }

    @Override
    @TransactionalMethod(readonly=true)
    public final boolean isNull() {
        return this.value == null;
    }

    @Override
    @TransactionalMethod(readonly=false, trackReads=true)
    public final E set(E newValue) {
        E initialValue = this.value;
        this.value = newValue;
        ++this.writeVersion;
        return initialValue;
    }

    @Override
    @TransactionalMethod(readonly=false, trackReads=true)
    public final E clear() {
        return this.set(null);
    }

    @TransactionalMethod(readonly=true)
    public final String toString() {
        if (this.value == null) {
            return "AbaRef(ref=null)";
        }
        return String.format("AbaRef(ref=%s)", this.value);
    }
}

