/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public class BooleanRef {
    private boolean value;

    public BooleanRef() {
        this(false);
    }

    public BooleanRef(boolean value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public final boolean get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final void await(boolean desired) {
        if (desired != this.value) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final boolean set(boolean newValue) {
        if (newValue == this.value) {
            return newValue;
        }
        boolean oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @TransactionalMethod(readonly=true)
    public final String toString() {
        if (this.value) {
            return "BooleanRef(value=true)";
        }
        return "BooleanRef(value=false)";
    }

    @TransactionalMethod(readonly=true)
    public final int hashCode() {
        return this.value ? 1 : 0;
    }

    @TransactionalMethod(readonly=true)
    public final boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof BooleanRef)) {
            return false;
        }
        BooleanRef that = (BooleanRef)thatObj;
        return that.value == this.value;
    }
}

