/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public class ShortRef {
    private short value;

    public ShortRef() {
        this(0);
    }

    public ShortRef(short value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public final short get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final void await(short desired) {
        if (desired != this.value) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final short awaitLargerThan(short than) {
        if (this.value <= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final short awaitLargerOrEqualThan(short than) {
        if (this.value < than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final short awaitSmallerThan(short than) {
        if (this.value >= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final short awaitSmallerOrEqualThan(short than) {
        if (this.value > than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final short awaitNotEqualTo(short than) {
        if (this.value == than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public short set(short newValue) {
        if (newValue == this.value) {
            return newValue;
        }
        short oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final short inc() {
        this.value = (short)(this.value + 1);
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final short inc(short amount) {
        if (amount == 0) {
            return this.value;
        }
        this.value = (short)(this.value + amount);
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final short dec() {
        this.value = (short)(this.value - 1);
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final short dec(short amount) {
        if (amount == 0) {
            return this.value;
        }
        this.value = (short)(this.value - amount);
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public final String toString() {
        return String.format("ShortRef(value=%s)", this.value);
    }

    @TransactionalMethod(readonly=true)
    public final int hashCode() {
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public final boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof ShortRef)) {
            return false;
        }
        ShortRef that = (ShortRef)thatObj;
        return that.value == this.value;
    }
}

