/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.stms.AbstractTransactionImpl;

public class AbstractTransaction_registerLifecycleListenerTest {
    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.prepare();
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        tx.commit();
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)tx, TransactionLifecycleEvent.PreCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.PostCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)tx, TransactionLifecycleEvent.PreAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)tx, TransactionLifecycleEvent.PostAbort);
    }

    @Test
    public void whenAlreadyCommitted_thenDeadTransactionException() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.commit();
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        try {
            tx.registerLifecycleListener(listener);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)Mockito.anyObject(), (TransactionLifecycleEvent)Mockito.anyObject());
    }

    @Test
    public void whenAlreadyAborted_thenDeadTransactionException() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.abort();
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        try {
            tx.registerLifecycleListener(listener);
            Assert.fail();
        }
        catch (DeadTransactionException deadTransactionException) {
            // empty catch block
        }
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)Mockito.anyObject(), (TransactionLifecycleEvent)Mockito.anyObject());
    }

    @Test
    public void scheduleFailsWithNullTask() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.start();
        try {
            tx.registerLifecycleListener(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive(new Transaction[]{tx});
    }

    @Test
    public void whenCommit_thenPreAndPostCommitTasksAreCalled() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl();
        tx.start();
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        tx.commit();
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.PreCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.PostCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)tx, TransactionLifecycleEvent.PreAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)tx, TransactionLifecycleEvent.PostAbort);
    }
}

