/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.clock.PrimitiveClock;
import org.multiverse.api.clock.StrictPrimitiveClock;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.stms.AbstractTransactionImpl;

public class AbstractTransaction_resetTest {
    private StrictPrimitiveClock clock;

    @Before
    public void setUp() {
        this.clock = new StrictPrimitiveClock(1L);
    }

    @Test
    public void whenNew() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        this.clock.tick();
        tx.reset();
        TestUtils.assertIsNew(new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenActive() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        tx.start();
        tx.reset();
        TestUtils.assertIsNew(new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenActive_thenListenersAreNotified() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        Mockito.reset((Object[])new TransactionLifecycleListener[]{listener});
        tx.reset();
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.PreAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).notify((Transaction)tx, TransactionLifecycleEvent.PostAbort);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.PreCommit);
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify((Transaction)tx, TransactionLifecycleEvent.PostCommit);
    }

    @Test
    public void whenActiveAndPreAbortListenerFails_thenTransactionAborted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.PreAbort);
        try {
            tx.reset();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
    }

    @Test
    public void whenActiveAndPostAbortListenerFails_thenTransactionAborted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.PostAbort);
        try {
            tx.reset();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
    }

    @Test
    public void whenPreparedAndPreAbortListenerFails_thenTransactionAborted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.PreAbort);
        tx.prepare();
        try {
            tx.reset();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
    }

    @Test
    public void whenPreparedAndPostAbortListenerFails_thenTransactionAborted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        ((TransactionLifecycleListener)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)listener)).notify((Transaction)tx, TransactionLifecycleEvent.PostAbort);
        tx.prepare();
        try {
            tx.reset();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TestUtils.assertIsAborted(new Transaction[]{tx});
    }

    @Test
    public void whenPrepared_thenTransactionIsRestarted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        tx.prepare();
        tx.reset();
        TestUtils.assertIsNew(new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenCommitted_thenTransactionIsRestarted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        tx.commit();
        tx.reset();
        TestUtils.assertIsNew(new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenCommitted_thenNoScheduledTasksAreExecuted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        tx.commit();
        Mockito.reset((Object[])new TransactionLifecycleListener[]{listener});
        tx.reset();
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)Mockito.any(), (TransactionLifecycleEvent)Mockito.any());
    }

    @Test
    public void whenAbortedTransactionIsRestarted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        tx.abort();
        tx.reset();
        TestUtils.assertIsNew(new Transaction[]{tx});
        Assert.assertEquals((long)0L, (long)tx.getReadVersion());
    }

    @Test
    public void whenAborted_thenNoListenersExecuted() {
        AbstractTransactionImpl tx = new AbstractTransactionImpl((PrimitiveClock)this.clock);
        TransactionLifecycleListener listener = (TransactionLifecycleListener)Mockito.mock(TransactionLifecycleListener.class);
        tx.registerLifecycleListener(listener);
        tx.abort();
        Mockito.reset((Object[])new TransactionLifecycleListener[]{listener});
        tx.reset();
        ((TransactionLifecycleListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify((Transaction)Mockito.any(), (TransactionLifecycleEvent)Mockito.any());
    }
}

