/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.utils;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.utils.StandardThreadFactory;

public class StandardThreadFactory_ConstructorTest {
    @Test
    public void testNoArg() {
        StandardThreadFactory factory = new StandardThreadFactory();
        Assert.assertEquals((long)5L, (long)factory.getPriority());
        Assert.assertFalse((boolean)factory.isProducingDaemons());
        Assert.assertNotNull((Object)factory.getThreadGroup());
    }

    @Test
    public void test_String() {
        new StandardThreadFactory(null);
        String name = "somename";
        StandardThreadFactory factory = new StandardThreadFactory(name);
        Assert.assertEquals((long)5L, (long)factory.getPriority());
        Assert.assertNotNull((Object)factory.getThreadGroup());
        Assert.assertEquals((Object)name, (Object)factory.getThreadGroup().getName());
        Assert.assertEquals((Object)Thread.currentThread().getThreadGroup(), (Object)factory.getThreadGroup().getParent());
        Assert.assertEquals((long)10L, (long)factory.getThreadGroup().getMaxPriority());
        Assert.assertFalse((boolean)factory.isProducingDaemons());
    }

    @Test
    public void test_int() {
        try {
            new StandardThreadFactory(0);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new StandardThreadFactory(11);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        int priority = 5;
        StandardThreadFactory factory = new StandardThreadFactory(priority);
        Assert.assertEquals((long)priority, (long)factory.getPriority());
        Assert.assertNotNull((Object)factory.getThreadGroup());
        Assert.assertFalse((boolean)factory.isProducingDaemons());
    }

    @Test
    public void test_int_String() {
        try {
            new StandardThreadFactory(0, "foo");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new StandardThreadFactory(11, "foo");
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        new StandardThreadFactory(1, (String)null);
        String name = "somename";
        int priority = 5;
        StandardThreadFactory factory = new StandardThreadFactory(priority, name);
        Assert.assertEquals((long)priority, (long)factory.getPriority());
        Assert.assertNotNull((Object)factory.getThreadGroup());
        Assert.assertEquals((Object)name, (Object)factory.getThreadGroup().getName());
        Assert.assertEquals((Object)Thread.currentThread().getThreadGroup(), (Object)factory.getThreadGroup().getParent());
        Assert.assertEquals((long)10L, (long)factory.getThreadGroup().getMaxPriority());
        Assert.assertFalse((boolean)factory.isProducingDaemons());
    }

    @Test
    public void test_int_ThreadGroup() {
        try {
            new StandardThreadFactory(10, (ThreadGroup)null);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException ex) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new StandardThreadFactory(11, new ThreadGroup("somename"));
            Assert.fail((String)"NullPointerException expected");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)true);
        }
        try {
            ThreadGroup threadGroup = new ThreadGroup("somename");
            threadGroup.setMaxPriority(1);
            new StandardThreadFactory(2, threadGroup);
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)true);
        }
        ThreadGroup group = new ThreadGroup("somename");
        int priority = 10;
        StandardThreadFactory factory = new StandardThreadFactory(priority, group);
        Assert.assertSame((Object)group, (Object)factory.getThreadGroup());
        Assert.assertEquals((long)priority, (long)factory.getPriority());
        Assert.assertFalse((boolean)factory.isProducingDaemons());
    }
}

