/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.multiverse.MultiverseConstants;
import org.multiverse.api.Stm;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionConfiguration;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.TransactionStatus;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.api.latches.Latch;
import org.multiverse.api.lifecycle.TransactionLifecycleEvent;
import org.multiverse.api.lifecycle.TransactionLifecycleListener;
import org.multiverse.stms.AbstractTransactionConfiguration;
import org.multiverse.stms.AbstractTransactionSnapshot;

public abstract class AbstractTransaction<C extends AbstractTransactionConfiguration, S extends AbstractTransactionSnapshot>
implements Transaction,
MultiverseConstants {
    protected final C config;
    private List<TransactionLifecycleListener> listeners;
    protected long version;
    public static final int NEW = 0;
    public static final int ACTIVE = 1;
    public static final int PREPARED = 2;
    public static final int COMMITTED = 3;
    public static final int ABORTED = 4;
    private TransactionStatus status = TransactionStatus.New;
    protected int statusInt = 0;
    protected long timeoutNs;
    private int attempt;

    public AbstractTransaction(C config) {
        assert (config != null);
        this.config = config;
        this.timeoutNs = ((AbstractTransactionConfiguration)config).getTimeoutNs();
    }

    @Override
    public final int getAttempt() {
        return this.attempt;
    }

    @Override
    public final void setAttempt(int attempt) {
        this.attempt = attempt;
    }

    @Override
    public final long getRemainingTimeoutNs() {
        return this.timeoutNs;
    }

    @Override
    public final void setRemainingTimeoutNs(long newTimeoutNs) {
        if (newTimeoutNs > this.timeoutNs) {
            throw new IllegalArgumentException();
        }
        this.timeoutNs = newTimeoutNs;
    }

    @Override
    public final long getReadVersion() {
        return this.version;
    }

    @Override
    public final TransactionStatus getStatus() {
        return this.status;
    }

    @Override
    public final TransactionConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public final Stm getStm() {
        return ((AbstractTransactionConfiguration)this.config).transactionFactory.getStm();
    }

    @Override
    public final TransactionFactory getTransactionFactory() {
        return ((AbstractTransactionConfiguration)this.config).transactionFactory;
    }

    protected void doStart() {
    }

    protected void doReset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (___TRACING_ENABLED && ((AbstractTransactionConfiguration)this.config).traceLevel.isLogableFrom(TraceLevel.course)) {
            System.out.println(((AbstractTransactionConfiguration)this.config).familyName + " starting");
        }
        switch (this.status) {
            case New: {
                boolean success = false;
                try {
                    this.notifyAll(TransactionLifecycleEvent.PreStart);
                    this.status = TransactionStatus.Active;
                    this.statusInt = 1;
                    this.version = ((AbstractTransactionConfiguration)this.config).clock.getVersion();
                    this.doStart();
                    success = true;
                    break;
                }
                finally {
                    if (!success) {
                        this.abort();
                    }
                }
            }
            case Active: {
                break;
            }
            case Prepared: {
                String preparedMsg = MessageFormat.format("Can't start already prepared transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(preparedMsg);
            }
            case Committed: {
                String committedMsg = MessageFormat.format("Can't start already committed transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case Aborted: {
                String abortMsg = MessageFormat.format("Can't start already aborted transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortMsg);
            }
            default: {
                throw new IllegalStateException("unhandled transactionStatus: " + (Object)((Object)this.status));
            }
        }
    }

    @Override
    public final void registerLifecycleListener(TransactionLifecycleListener listener) {
        if (___TRACING_ENABLED && ((AbstractTransactionConfiguration)this.config).traceLevel.isLogableFrom(TraceLevel.course)) {
            System.out.println(((AbstractTransactionConfiguration)this.config).familyName + " registerLifecycleListener");
        }
        switch (this.status) {
            case New: 
            case Active: 
            case Prepared: {
                if (listener == null) {
                    throw new NullPointerException();
                }
                if (this.listeners == null) {
                    this.listeners = new LinkedList<TransactionLifecycleListener>();
                }
                this.listeners.add(listener);
                break;
            }
            case Committed: {
                String committedMsg = MessageFormat.format("Can't register TransactionLifecycleListener on already committed transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case Aborted: {
                String abortMsg = MessageFormat.format("Can't register TransactionLifecycleListener on already aborted transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortMsg);
            }
            default: {
                throw new IllegalStateException("unhandled transactionStatus: " + (Object)((Object)this.status));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void prepare() {
        if (___TRACING_ENABLED && ((AbstractTransactionConfiguration)this.config).traceLevel.isLogableFrom(TraceLevel.course)) {
            System.out.println(((AbstractTransactionConfiguration)this.config).familyName + " preparing");
        }
        switch (this.status) {
            case New: {
                this.start();
            }
            case Active: {
                try {
                    this.notifyAll(TransactionLifecycleEvent.PreCommit);
                    this.doPrepare();
                    this.status = TransactionStatus.Prepared;
                    this.statusInt = 2;
                    break;
                }
                finally {
                    if (this.status != TransactionStatus.Prepared) {
                        this.abort();
                    }
                }
            }
            case Prepared: {
                break;
            }
            case Committed: {
                String committedMsg = MessageFormat.format("Can't prepare already committed transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case Aborted: {
                String abortedMsg = MessageFormat.format("Can't prepare already aborted transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
            default: {
                throw new IllegalStateException("unhandled transactionStatus: " + (Object)((Object)this.status));
            }
        }
    }

    protected void doPrepare() {
    }

    @Override
    public final void reset() {
        if (___TRACING_ENABLED && ((AbstractTransactionConfiguration)this.config).traceLevel.isLogableFrom(TraceLevel.course)) {
            System.out.println(((AbstractTransactionConfiguration)this.config).familyName + " reset");
        }
        switch (this.status) {
            case New: 
            case Active: 
            case Prepared: {
                this.abort();
            }
            case Committed: 
            case Aborted: {
                this.clearListeners();
                this.doReset();
                this.version = 0L;
                this.status = TransactionStatus.New;
                this.statusInt = 0;
                break;
            }
            default: {
                throw new IllegalStateException("unhandled transactionStatus: " + (Object)((Object)this.status));
            }
        }
    }

    private void clearListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    private void notifyAll(TransactionLifecycleEvent event) {
        if (this.listeners == null) {
            return;
        }
        for (TransactionLifecycleListener listener : this.listeners) {
            listener.notify(this, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void abort() {
        if (___TRACING_ENABLED && ((AbstractTransactionConfiguration)this.config).traceLevel.isLogableFrom(TraceLevel.course)) {
            System.out.println(((AbstractTransactionConfiguration)this.config).familyName + " aborting");
        }
        switch (this.status) {
            case New: 
            case Active: 
            case Prepared: {
                try {
                    try {
                        this.notifyAll(TransactionLifecycleEvent.PreAbort);
                    }
                    finally {
                        this.status = TransactionStatus.Aborted;
                        this.statusInt = 4;
                        if (this.status == TransactionStatus.Active) {
                            this.doAbortActive();
                        } else {
                            this.doAbortPrepared();
                        }
                    }
                    this.notifyAll(TransactionLifecycleEvent.PostAbort);
                    break;
                }
                finally {
                    this.clearListeners();
                }
            }
            case Committed: {
                String committedMsg = MessageFormat.format("Can't abort already committed transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case Aborted: {
                break;
            }
            default: {
                throw new IllegalStateException("unhandled transactionStatus: " + (Object)((Object)this.status));
            }
        }
    }

    protected void doAbortPrepared() {
    }

    protected void doAbortActive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void commit() {
        if (___TRACING_ENABLED && ((AbstractTransactionConfiguration)this.config).traceLevel.isLogableFrom(TraceLevel.course)) {
            System.out.println(((AbstractTransactionConfiguration)this.config).familyName + " committing");
        }
        switch (this.status) {
            case New: {
                this.status = TransactionStatus.Committed;
                this.statusInt = 3;
                break;
            }
            case Active: {
                this.prepare();
            }
            case Prepared: {
                try {
                    this.makeChangesPermanent();
                    this.status = TransactionStatus.Committed;
                    this.statusInt = 3;
                    this.notifyAll(TransactionLifecycleEvent.PostCommit);
                    break;
                }
                finally {
                    if (this.status != TransactionStatus.Committed) {
                        this.abort();
                    }
                }
            }
            case Committed: {
                return;
            }
            case Aborted: {
                String abortedMsg = MessageFormat.format("Can't commit already aborted transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
            default: {
                throw new IllegalStateException("unhandled transactionStatus: " + (Object)((Object)this.status));
            }
        }
    }

    protected void makeChangesPermanent() {
    }

    @Override
    public final void registerRetryLatch(Latch latch) {
        if (___TRACING_ENABLED && ((AbstractTransactionConfiguration)this.config).traceLevel.isLogableFrom(TraceLevel.course)) {
            System.out.println(((AbstractTransactionConfiguration)this.config).familyName + " registerRetryLatch");
        }
        switch (this.status) {
            case New: {
                this.start();
            }
            case Active: 
            case Prepared: {
                if (latch == null) {
                    throw new NullPointerException();
                }
                boolean success = this.doRegisterRetryLatch(latch, this.version + 1L);
                if (success) break;
                String msg = MessageFormat.format("No retry is possible on transaction '%s' because it has no tracked reads, or not all reads are known (because it doesn''t support automatic read tracking) ", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new NoRetryPossibleException(msg);
            }
            case Committed: {
                String commitMsg = MessageFormat.format("No retry is possible on already committed transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(commitMsg);
            }
            case Aborted: {
                String abortedMsg = MessageFormat.format("No retry is possible on already aborted transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
            default: {
                throw new IllegalStateException("unhandled transactionStatus: " + (Object)((Object)this.status));
            }
        }
    }

    protected boolean doRegisterRetryLatch(Latch latch, long wakeupVersion) {
        return false;
    }

    public final void startOr() {
        switch (this.status) {
            case Active: {
                S snapshot = this.takeSnapshot();
                ((AbstractTransactionSnapshot)snapshot).parent = this.getSnapshot();
                ((AbstractTransactionSnapshot)snapshot).tasks = null;
                this.storeSnapshot(snapshot);
                break;
            }
            case Committed: {
                String commitMsg = MessageFormat.format("Can't call startOr on already committed transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(commitMsg);
            }
            case Aborted: {
                String abortMsg = MessageFormat.format("Can't call startOr on already aborted transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortMsg);
            }
            default: {
                throw new IllegalStateException("unhandled transactionStatus: " + (Object)((Object)this.status));
            }
        }
    }

    public final void endOr() {
        switch (this.status) {
            case Active: {
                S snapshot = this.getSnapshot();
                if (snapshot == null) {
                    throw new IllegalStateException();
                }
                this.storeSnapshot(((AbstractTransactionSnapshot)snapshot).parent);
                break;
            }
            case Committed: {
                String committedMsg = MessageFormat.format("Can't call endOr on already committed transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(committedMsg);
            }
            case Aborted: {
                String abortedMsg = MessageFormat.format("Can't call endOr on already aborted transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortedMsg);
            }
            default: {
                throw new IllegalStateException("unhandled transactionStatus: " + (Object)((Object)this.status));
            }
        }
    }

    public final void endOrAndStartElse() {
        switch (this.status) {
            case Active: {
                S snapshot = this.getSnapshot();
                if (snapshot == null) {
                    throw new IllegalStateException();
                }
                ((AbstractTransactionSnapshot)snapshot).restore();
                this.storeSnapshot(((AbstractTransactionSnapshot)snapshot).parent);
                break;
            }
            case Committed: {
                String commitMsg = MessageFormat.format("Can't call endOrAndStartElse on already committed transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(commitMsg);
            }
            case Aborted: {
                String abortMsg = MessageFormat.format("Can't call endOrAndStartElse on already aborted transaction '%s'", ((AbstractTransactionConfiguration)this.config).getFamilyName());
                throw new DeadTransactionException(abortMsg);
            }
            default: {
                throw new IllegalStateException("unhandled transactionStatus: " + (Object)((Object)this.status));
            }
        }
    }

    protected S takeSnapshot() {
        throw new UnsupportedOperationException();
    }

    protected S getSnapshot() {
        throw new UnsupportedOperationException();
    }

    protected void storeSnapshot(S snapshot) {
        throw new UnsupportedOperationException();
    }
}

