/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public class IntRef {
    private int value;

    public IntRef() {
        this(0);
    }

    public IntRef(int value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public final int get() {
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final int set(int newValue) {
        int oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final int dec() {
        --this.value;
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final int inc() {
        ++this.value;
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final int inc(int amount) {
        if (amount == 0) {
            return this.value;
        }
        this.value += amount;
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final int dec(int amount) {
        return this.inc(-amount);
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final void await(int desired) {
        if (desired != this.value) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final int awaitLargerThan(int than) {
        if (this.value <= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final int awaitLargerOrEqualThan(int than) {
        if (this.value < than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final int awaitSmallerThan(int than) {
        if (this.value >= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final int awaitSmallerOrEqualThan(int than) {
        if (this.value > than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final int awaitNotEqualTo(int than) {
        if (this.value == than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public final String toString() {
        return String.format("IntRef(value=%s)", this.value);
    }

    @TransactionalMethod(readonly=true)
    public final int hashCode() {
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public final boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof IntRef)) {
            return false;
        }
        IntRef that = (IntRef)thatObj;
        return that.value == this.value;
    }
}

