/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.metadata;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.FieldGranularity;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.FieldMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;

public class MetadataRepository_FieldTest {
    private MetadataRepository repository;

    @Before
    public void setUp() {
        this.repository = new MetadataRepository();
    }

    @Test
    public void nonTransactionalObject() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(NonTransactional.class);
        Assert.assertFalse((boolean)classMetadata.isTransactionalObject());
        Assert.assertFalse((boolean)classMetadata.hasManagedFields());
        Assert.assertFalse((boolean)classMetadata.hasManagedFieldsWithFieldGranularity());
        Assert.assertFalse((boolean)classMetadata.hasManagedFieldsWithObjectGranularity());
    }

    @Test
    public void whenTransactionalObjectWithField() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(TransactionalObjectWithField.class);
        Assert.assertTrue((boolean)classMetadata.isTransactionalObject());
        Assert.assertTrue((boolean)classMetadata.isTransactionalObjectWithObjectGranularFields());
        Assert.assertTrue((boolean)classMetadata.hasManagedFields());
        Assert.assertFalse((boolean)classMetadata.hasManagedFieldsWithFieldGranularity());
        Assert.assertTrue((boolean)classMetadata.hasManagedFieldsWithObjectGranularity());
        FieldMetadata fieldMetadata = classMetadata.getFieldMetadata("field");
        Assert.assertNotNull((Object)fieldMetadata);
        Assert.assertEquals((Object)"field", (Object)fieldMetadata.getName());
        Assert.assertTrue((boolean)fieldMetadata.isManagedField());
    }

    @Test
    public void whenTransactionalObjectWithExcludedField() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(TransactionalObjectWithExcludedField.class);
        Assert.assertTrue((boolean)classMetadata.isTransactionalObject());
        Assert.assertFalse((boolean)classMetadata.isTransactionalObjectWithObjectGranularFields());
        Assert.assertFalse((boolean)classMetadata.hasManagedFieldsWithFieldGranularity());
        Assert.assertFalse((boolean)classMetadata.hasManagedFieldsWithObjectGranularity());
        FieldMetadata fieldMetadata = classMetadata.getFieldMetadata("field");
        Assert.assertNotNull((Object)fieldMetadata);
        Assert.assertFalse((boolean)fieldMetadata.isManagedField());
    }

    @Test
    public void whenTransactionalObjectWithFinalField() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(TransactionalObjectWithFinalField.class);
        Assert.assertTrue((boolean)classMetadata.isTransactionalObject());
        Assert.assertFalse((boolean)classMetadata.hasManagedFieldsWithObjectGranularity());
        Assert.assertFalse((boolean)classMetadata.hasManagedFieldsWithFieldGranularity());
        Assert.assertFalse((boolean)classMetadata.hasManagedFields());
        Assert.assertFalse((boolean)classMetadata.isTransactionalObjectWithObjectGranularFields());
        FieldMetadata fieldMetadata = classMetadata.getFieldMetadata("field");
        Assert.assertNotNull((Object)fieldMetadata);
        Assert.assertFalse((boolean)fieldMetadata.isManagedField());
    }

    @Test
    public void whenTransactionalObjectWithVolatileField() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(TransactionalObjectWithVolatileField.class);
        Assert.assertTrue((boolean)classMetadata.isTransactionalObject());
        Assert.assertFalse((boolean)classMetadata.isTransactionalObjectWithObjectGranularFields());
        Assert.assertFalse((boolean)classMetadata.hasManagedFieldsWithObjectGranularity());
        Assert.assertFalse((boolean)classMetadata.hasManagedFieldsWithFieldGranularity());
        FieldMetadata fieldMetadata = classMetadata.getFieldMetadata("field");
        Assert.assertNotNull((Object)fieldMetadata);
        Assert.assertFalse((boolean)fieldMetadata.isManagedField());
        Assert.assertFalse((boolean)fieldMetadata.hasFieldGranularity());
    }

    @Test
    public void whenTransactionalObjectWithFieldGranularityField() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(TransactionalObjectWithFieldGranularityField.class);
        Assert.assertTrue((boolean)classMetadata.isTransactionalObject());
        Assert.assertFalse((boolean)classMetadata.isTransactionalObjectWithObjectGranularFields());
        Assert.assertFalse((boolean)classMetadata.hasManagedFieldsWithObjectGranularity());
        Assert.assertTrue((boolean)classMetadata.hasManagedFieldsWithFieldGranularity());
        FieldMetadata fieldMetadata = classMetadata.getFieldMetadata("field");
        Assert.assertNotNull((Object)fieldMetadata);
        Assert.assertTrue((boolean)fieldMetadata.isManagedField());
        Assert.assertTrue((boolean)fieldMetadata.hasFieldGranularity());
    }

    @Test
    public void whenTransactionalObjectMixedGranularityFields() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(TransactionalObjectMixedGranularityFields.class);
        Assert.assertTrue((boolean)classMetadata.isTransactionalObject());
        Assert.assertTrue((boolean)classMetadata.isTransactionalObjectWithObjectGranularFields());
        Assert.assertTrue((boolean)classMetadata.hasManagedFieldsWithObjectGranularity());
        Assert.assertTrue((boolean)classMetadata.hasManagedFieldsWithFieldGranularity());
        FieldMetadata fieldGranular = classMetadata.getFieldMetadata("fieldGranular");
        Assert.assertNotNull((Object)fieldGranular);
        Assert.assertTrue((boolean)fieldGranular.isManagedField());
        Assert.assertTrue((boolean)fieldGranular.hasFieldGranularity());
        FieldMetadata objectGranular = classMetadata.getFieldMetadata("objectGranular");
        Assert.assertNotNull((Object)objectGranular);
        Assert.assertTrue((boolean)objectGranular.isManagedField());
        Assert.assertFalse((boolean)objectGranular.hasFieldGranularity());
    }

    @TransactionalObject
    class TransactionalObjectMixedGranularityFields {
        @FieldGranularity
        private int fieldGranular;
        private int objectGranular;

        TransactionalObjectMixedGranularityFields() {
        }
    }

    @TransactionalObject
    class TransactionalObjectWithFieldGranularityField {
        @FieldGranularity
        private int field;

        TransactionalObjectWithFieldGranularityField() {
        }
    }

    @TransactionalObject
    class TransactionalObjectWithVolatileField {
        volatile int field;

        TransactionalObjectWithVolatileField() {
        }
    }

    @TransactionalObject
    class TransactionalObjectWithFinalField {
        final int field = 10;

        TransactionalObjectWithFinalField() {
        }
    }

    @TransactionalObject
    class TransactionalObjectWithExcludedField {
        @org.multiverse.annotations.NonTransactional
        int field;

        TransactionalObjectWithExcludedField() {
        }
    }

    @TransactionalObject
    class TransactionalObjectWithField {
        int field;

        TransactionalObjectWithField() {
        }
    }

    class NonTransactional {
        int field;

        NonTransactional() {
        }
    }
}

