/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.metadata;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.instrumentation.metadata.MethodMetadata;

public class MetadataRepository_InterfaceTest {
    private MetadataRepository repository;

    @Before
    public void setUp() {
        this.repository = new MetadataRepository();
    }

    @Test
    public void whenNonTransactionalInterface() {
        ClassMetadata metadata = this.repository.loadClassMetadata(NonTransactionalInterface.class);
        Assert.assertNotNull((Object)metadata);
        Assert.assertTrue((boolean)metadata.isInterface());
        Assert.assertFalse((boolean)metadata.isIgnoredClass());
        Assert.assertFalse((boolean)metadata.isTransactionalObject());
        Assert.assertFalse((boolean)metadata.isTransactionalObjectWithObjectGranularFields());
        Assert.assertFalse((boolean)metadata.hasManagedFieldsWithFieldGranularity());
        Assert.assertFalse((boolean)metadata.hasManagedFields());
        Assert.assertFalse((boolean)metadata.hasTransactionalMethods());
    }

    @Test
    public void whenEmptyTransactionalInterface() {
        ClassMetadata metadata = this.repository.loadClassMetadata(EmptyTransactionalInterface.class);
        Assert.assertNotNull((Object)metadata);
        Assert.assertTrue((boolean)metadata.isInterface());
        Assert.assertFalse((boolean)metadata.isIgnoredClass());
        Assert.assertTrue((boolean)metadata.isTransactionalObject());
        Assert.assertFalse((boolean)metadata.isTransactionalObjectWithObjectGranularFields());
        Assert.assertFalse((boolean)metadata.hasManagedFieldsWithFieldGranularity());
        Assert.assertFalse((boolean)metadata.hasManagedFields());
        Assert.assertFalse((boolean)metadata.hasTransactionalMethods());
    }

    @Test
    public void whenNonEmptyTransactionalInterface() {
        ClassMetadata metadata = this.repository.loadClassMetadata(NonEmptyTransactionalInterface.class);
        Assert.assertNotNull((Object)metadata);
        Assert.assertTrue((boolean)metadata.isInterface());
        Assert.assertFalse((boolean)metadata.isIgnoredClass());
        Assert.assertTrue((boolean)metadata.isTransactionalObject());
        Assert.assertFalse((boolean)metadata.isTransactionalObjectWithObjectGranularFields());
        Assert.assertFalse((boolean)metadata.hasManagedFieldsWithFieldGranularity());
        Assert.assertFalse((boolean)metadata.hasManagedFields());
        Assert.assertTrue((boolean)metadata.hasTransactionalMethods());
        MethodMetadata methodMetadata = metadata.getMethodMetadata("someMethod", "()V");
        Assert.assertNotNull((Object)methodMetadata);
        Assert.assertTrue((boolean)methodMetadata.isAbstract());
        Assert.assertTrue((boolean)methodMetadata.isTransactional());
    }

    @Test
    public void whenInterfaceExtendsTransactionalInterface() {
        ClassMetadata metadata = this.repository.loadClassMetadata(InterfaceExtendsTransactionalInterface.class);
        Assert.assertNotNull((Object)metadata);
        Assert.assertTrue((boolean)metadata.isInterface());
        Assert.assertFalse((boolean)metadata.isIgnoredClass());
        Assert.assertTrue((boolean)metadata.isTransactionalObject());
        Assert.assertFalse((boolean)metadata.isTransactionalObjectWithObjectGranularFields());
        Assert.assertFalse((boolean)metadata.hasManagedFieldsWithFieldGranularity());
        Assert.assertFalse((boolean)metadata.hasManagedFields());
        Assert.assertFalse((boolean)metadata.hasTransactionalMethods());
    }

    static interface InterfaceExtendsTransactionalInterface
    extends EmptyTransactionalInterface {
    }

    @TransactionalObject
    static interface NonEmptyTransactionalInterface {
        public void someMethod();
    }

    @TransactionalObject
    static interface EmptyTransactionalInterface {
    }

    static interface NonTransactionalInterface {
    }
}

