/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.metadata;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;

public class MetadataRepository_ObjectTest {
    private MetadataRepository repository;

    @Before
    public void setUp() {
        this.repository = new MetadataRepository();
    }

    @Test
    public void whenNonTransactionalObject() {
        ClassMetadata metadata = this.repository.loadClassMetadata(Object.class);
        Assert.assertNotNull((Object)metadata);
        Assert.assertTrue((boolean)metadata.isIgnoredClass());
        Assert.assertFalse((boolean)metadata.isTransactionalObject());
    }

    @Test
    public void whenObjectTransactional() {
        ClassMetadata metadata = this.repository.loadClassMetadata(Person.class);
        Assert.assertNotNull((Object)metadata);
        Assert.assertFalse((boolean)metadata.isIgnoredClass());
        Assert.assertTrue((boolean)metadata.isTransactionalObject());
        Assert.assertTrue((boolean)metadata.isTransactionalObjectWithObjectGranularFields());
        Assert.assertTrue((boolean)metadata.hasTransactionalMethods());
    }

    @Test
    public void whenObjectImplementingTransactionalInterface() {
        ClassMetadata metadata = this.repository.loadClassMetadata(ObjectImplementingTransactionalInterface.class);
        Assert.assertNotNull((Object)metadata);
        Assert.assertFalse((boolean)metadata.isInterface());
        Assert.assertFalse((boolean)metadata.isIgnoredClass());
        Assert.assertTrue((boolean)metadata.isTransactionalObject());
        Assert.assertFalse((boolean)metadata.isTransactionalObjectWithObjectGranularFields());
    }

    @Test
    public void whenObjectExtendsTransactionalObject() {
        ClassMetadata metadata = this.repository.loadClassMetadata(ObjectExtendingTransactionalObject.class);
        Assert.assertNotNull((Object)metadata);
        Assert.assertFalse((boolean)metadata.isInterface());
        Assert.assertFalse((boolean)metadata.isIgnoredClass());
        Assert.assertTrue((boolean)metadata.isTransactionalObject());
        Assert.assertFalse((boolean)metadata.isTransactionalObjectWithObjectGranularFields());
    }

    class ObjectExtendingTransactionalObject
    extends TxObject {
        ObjectExtendingTransactionalObject() {
        }
    }

    @TransactionalObject
    class TxObject {
        TxObject() {
        }
    }

    class ObjectImplementingTransactionalInterface
    implements TransactionalInterface {
        ObjectImplementingTransactionalInterface() {
        }
    }

    @TransactionalObject
    static interface TransactionalInterface {
    }

    @TransactionalObject
    class Person {
        int age;

        Person() {
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int newAge) {
            this.age = newAge;
        }
    }
}

