/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.metadata;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.instrumentation.metadata.MethodMetadata;
import org.multiverse.instrumentation.metadata.MethodType;

public class MetadataRepository_SetterTest {
    private MetadataRepository repo;

    @Before
    public void setUp() {
        this.repo = new MetadataRepository();
    }

    @Test
    public void whenPrimitiveSetter() {
        ClassMetadata classMetadata = this.repo.loadClassMetadata(SetterObject.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("setValue", "(I)V");
        Assert.assertEquals((Object)MethodType.setter, (Object)methodMetadata.getMethodType());
    }

    @Test
    public void whenObjectSetter() {
        ClassMetadata classMetadata = this.repo.loadClassMetadata(SetterObject.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("setObjectValue", "(Ljava/lang/Object;)V");
        Assert.assertEquals((Object)MethodType.setter, (Object)methodMetadata.getMethodType());
    }

    @Test
    public void whenSetterWithUnboxing() {
        ClassMetadata classMetadata = this.repo.loadClassMetadata(SetterObject.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("setWithAutoUnboxing", "(Ljava/lang/Integer;)V");
        Assert.assertEquals((Object)MethodType.unknown, (Object)methodMetadata.getMethodType());
    }

    @Test
    public void whenStrangeName_thenStillSetter() {
        ClassMetadata classMetadata = this.repo.loadClassMetadata(SetterObject.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("strangeName", "(I)V");
        Assert.assertEquals((Object)MethodType.setter, (Object)methodMetadata.getMethodType());
    }

    @Test
    public void whenSetterReturnsValue() {
        ClassMetadata classMetadata = this.repo.loadClassMetadata(SetterObject.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("setValueAndReturn", "(I)I");
        Assert.assertEquals((Object)MethodType.unknown, (Object)methodMetadata.getMethodType());
    }

    @Test
    public void whenSetterDoesMore() {
        ClassMetadata classMetadata = this.repo.loadClassMetadata(SetterObject.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("setValueAndDoMore", "(I)V");
        Assert.assertEquals((Object)MethodType.unknown, (Object)methodMetadata.getMethodType());
    }

    @Test
    public void whenSetterThrowsException() {
        ClassMetadata classMetadata = this.repo.loadClassMetadata(SetterObject.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("setValueAndThrowException", "(I)V");
        Assert.assertEquals((Object)MethodType.unknown, (Object)methodMetadata.getMethodType());
    }

    @Test
    public void whenAbstractSetter() {
        ClassMetadata classMetadata = this.repo.loadClassMetadata(SetterObject.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("abstractSet", "(I)V");
        Assert.assertEquals((Object)MethodType.unknown, (Object)methodMetadata.getMethodType());
    }

    @Test
    public void regressionTest() {
        ClassMetadata classMetadata = this.repo.loadClassMetadata(RegressionStack.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("incSize", "(I)V");
        Assert.assertEquals((Object)MethodType.unknown, (Object)methodMetadata.getMethodType());
    }

    @TransactionalObject
    class RegressionStack {
        int size;

        RegressionStack() {
        }

        private void incSize(int amount) {
            this.size += amount;
        }
    }

    abstract class SetterObject {
        private int value;
        private Object objectValue;

        SetterObject() {
        }

        abstract void abstractSet(int var1);

        void setObjectValue(Object o) {
            this.objectValue = o;
        }

        void setValue(int newValue) {
            this.value = newValue;
        }

        void setWithAutoUnboxing(Integer newValue) {
            this.value = newValue;
        }

        void setValueAndThrowException(int newValue) {
            this.value = newValue;
            throw new RuntimeException();
        }

        void setValueAndDoMore(int newValue) {
            this.value = ++newValue;
        }

        void strangeName(int newValue) {
            this.value = newValue;
        }

        int setValueAndReturn(int newValue) {
            this.value = newValue;
            return this.value;
        }
    }
}

