/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.metadata;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.instrumentation.metadata.MethodMetadata;
import org.multiverse.instrumentation.metadata.TransactionMetadata;

public class MetadataRepository_TransactionTest {
    private MetadataRepository repository;

    @Before
    public void setUp() {
        this.repository = new MetadataRepository();
    }

    @Test
    public void whenDefaultSettings() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(DefaultSettings.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("method", "()V");
        TransactionMetadata transactionMetadata = methodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)transactionMetadata);
        Assert.assertNull((Object)transactionMetadata.trackReads);
        Assert.assertNull((Object)transactionMetadata.readOnly);
        Assert.assertFalse((boolean)transactionMetadata.interruptible);
        Assert.assertTrue((boolean)transactionMetadata.writeSkew);
        Assert.assertEquals((long)1000L, (long)transactionMetadata.maxRetries);
        Assert.assertEquals((Object)"org.multiverse.instrumentation.metadata.MetadataRepository_TransactionTest$DefaultSettings.method()", (Object)transactionMetadata.familyName);
    }

    @Test
    public void whenReadonlyMethod() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(ReadonlyMethod.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("method", "()V");
        TransactionMetadata transactionMetadata = methodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)transactionMetadata);
        Assert.assertTrue((boolean)transactionMetadata.readOnly);
        Assert.assertNull((Object)transactionMetadata.trackReads);
        Assert.assertFalse((boolean)transactionMetadata.interruptible);
        Assert.assertTrue((boolean)transactionMetadata.writeSkew);
        Assert.assertEquals((long)1000L, (long)transactionMetadata.maxRetries);
        Assert.assertEquals((Object)"org.multiverse.instrumentation.metadata.MetadataRepository_TransactionTest$ReadonlyMethod.method()", (Object)transactionMetadata.familyName);
    }

    @Test
    public void whenUpdateMethod() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(DefaultUpdateMethod.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("method", "()V");
        TransactionMetadata transactionMetadata = methodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)transactionMetadata);
        Assert.assertFalse((boolean)transactionMetadata.readOnly);
        Assert.assertNull((Object)transactionMetadata.trackReads);
        Assert.assertFalse((boolean)transactionMetadata.interruptible);
        Assert.assertTrue((boolean)transactionMetadata.writeSkew);
        Assert.assertEquals((long)1000L, (long)transactionMetadata.maxRetries);
        Assert.assertEquals((Object)"org.multiverse.instrumentation.metadata.MetadataRepository_TransactionTest$DefaultUpdateMethod.method()", (Object)transactionMetadata.familyName);
    }

    @Test
    public void whenAutomaticReadTracking() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(AutomaticReadTracking.class);
        MethodMetadata enabledMethodMetadata = classMetadata.getMethodMetadata("enabled", "()V");
        TransactionMetadata enabledTransactionMetadata = enabledMethodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)enabledTransactionMetadata);
        Assert.assertTrue((boolean)enabledTransactionMetadata.trackReads);
        MethodMetadata disabledMethodMetadata = classMetadata.getMethodMetadata("disabled", "()V");
        TransactionMetadata disabledTransactionMetadata = disabledMethodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)disabledTransactionMetadata);
        Assert.assertFalse((boolean)disabledTransactionMetadata.trackReads);
    }

    @Test
    public void whenInterrupted() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(Interrupted.class);
        MethodMetadata enabledMethodMetadata = classMetadata.getMethodMetadata("enabled", "()V");
        TransactionMetadata enabledTransactionMetadata = enabledMethodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)enabledTransactionMetadata);
        Assert.assertTrue((boolean)enabledTransactionMetadata.interruptible);
        MethodMetadata disabledMethodMetadata = classMetadata.getMethodMetadata("disabled", "()V");
        TransactionMetadata disabledTransactionMetadata = disabledMethodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)disabledTransactionMetadata);
        Assert.assertFalse((boolean)disabledTransactionMetadata.interruptible);
    }

    @Test
    public void whenWriteSkewAllowed() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(WriteSkewAllowed.class);
        MethodMetadata enabledMethodMetadata = classMetadata.getMethodMetadata("enabled", "()V");
        TransactionMetadata enabledTransactionMetadata = enabledMethodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)enabledTransactionMetadata);
        Assert.assertTrue((boolean)enabledTransactionMetadata.writeSkew);
        MethodMetadata disabledMethodMetadata = classMetadata.getMethodMetadata("disabled", "()V");
        TransactionMetadata disabledTransactionMetadata = disabledMethodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)disabledTransactionMetadata);
        Assert.assertFalse((boolean)disabledTransactionMetadata.writeSkew);
        MethodMetadata nowAllowedAndDefaultNonAutomaticReadTracking = classMetadata.getMethodMetadata("nowAllowedAndDefaultNonAutomaticReadTracking", "()V");
        TransactionMetadata nowAllowedAndDefaultNonAutomaticReadTrackingMetadata = disabledMethodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)nowAllowedAndDefaultNonAutomaticReadTracking);
        Assert.assertFalse((boolean)nowAllowedAndDefaultNonAutomaticReadTrackingMetadata.writeSkew);
        Assert.assertTrue((boolean)nowAllowedAndDefaultNonAutomaticReadTrackingMetadata.trackReads);
        MethodMetadata nowAllowedAndAutomaticReadTracking = classMetadata.getMethodMetadata("nowAllowedAndAutomaticReadTracking", "()V");
        TransactionMetadata nowAllowedAndAutomaticReadTrackingMetadata = disabledMethodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)nowAllowedAndAutomaticReadTracking);
        Assert.assertFalse((boolean)nowAllowedAndAutomaticReadTrackingMetadata.writeSkew);
        Assert.assertTrue((boolean)nowAllowedAndAutomaticReadTrackingMetadata.trackReads);
    }

    @Test
    public void whenMaxRetryCount() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(MaxRetryCountProblem.class);
        MethodMetadata explicitValueMethodMetadata = classMetadata.getMethodMetadata("explicitValue", "()V");
        TransactionMetadata explicitValueTransactionMetadata = explicitValueMethodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)explicitValueTransactionMetadata);
        Assert.assertEquals((long)100L, (long)explicitValueTransactionMetadata.maxRetries);
        MethodMetadata defaultValueMethodMetadata = classMetadata.getMethodMetadata("defaultValue", "()V");
        TransactionMetadata defaultValueTransactionMetadata = defaultValueMethodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)defaultValueTransactionMetadata);
        Assert.assertEquals((long)1000L, (long)defaultValueTransactionMetadata.maxRetries);
    }

    @Test
    public void whenTimeout() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(Timeout.class);
        MethodMetadata explicitValueMethodMetadata = classMetadata.getMethodMetadata("explicitValue", "()V");
        TransactionMetadata explicitValueTransactionMetadata = explicitValueMethodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)explicitValueTransactionMetadata);
        Assert.assertEquals((long)TimeUnit.HOURS.toNanos(10L), (long)explicitValueTransactionMetadata.timeoutNs);
        MethodMetadata defaultValueMethodMetadata = classMetadata.getMethodMetadata("defaultValue", "()V");
        TransactionMetadata defaultValueTransactionMetadata = defaultValueMethodMetadata.getTransactionalMetadata();
        Assert.assertNotNull((Object)defaultValueTransactionMetadata);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)defaultValueTransactionMetadata.timeoutNs);
        MethodMetadata explicitValueWithoutTimeUnit = classMetadata.getMethodMetadata("explicitValueWithoutTimeUnit", "()V");
        TransactionMetadata explicitValueWithoutTimeUnitTransactionMetadata = explicitValueWithoutTimeUnit.getTransactionalMetadata();
        Assert.assertNotNull((Object)explicitValueWithoutTimeUnitTransactionMetadata);
        Assert.assertEquals((long)TimeUnit.SECONDS.toNanos(10L), (long)explicitValueWithoutTimeUnitTransactionMetadata.timeoutNs);
    }

    class Timeout {
        Timeout() {
        }

        @TransactionalMethod(timeout=10L, timeoutTimeUnit=TimeUnit.HOURS)
        void explicitValue() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertEquals((long)TimeUnit.HOURS.toNanos(10L), (long)tx.getConfiguration().getTimeoutNs());
        }

        @TransactionalMethod(timeout=10L)
        void explicitValueWithoutTimeUnit() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertEquals((long)TimeUnit.SECONDS.toNanos(10L), (long)tx.getConfiguration().getTimeoutNs());
        }

        @TransactionalMethod
        void defaultValue() {
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            Assert.assertEquals((long)Long.MAX_VALUE, (long)tx.getConfiguration().getTimeoutNs());
        }
    }

    class MaxRetryCountProblem {
        MaxRetryCountProblem() {
        }

        @TransactionalMethod(maxRetries=100)
        void explicitValue() {
        }

        @TransactionalMethod
        void defaultValue() {
        }
    }

    class WriteSkewAllowed {
        WriteSkewAllowed() {
        }

        @TransactionalMethod(writeSkew=false)
        void nowAllowedAndDefaultNonAutomaticReadTracking() {
        }

        @TransactionalMethod(writeSkew=false, trackReads=false)
        void nowAllowedAndAutomaticReadTracking() {
        }

        @TransactionalMethod(trackReads=true, writeSkew=true)
        void enabled() {
        }

        @TransactionalMethod(trackReads=true, writeSkew=false)
        void disabled() {
        }
    }

    class Interrupted {
        Interrupted() {
        }

        @TransactionalMethod(interruptible=true)
        void enabled() throws InterruptedException {
        }

        @TransactionalMethod(trackReads=false)
        void disabled() {
        }
    }

    class AutomaticReadTracking {
        AutomaticReadTracking() {
        }

        @TransactionalMethod(trackReads=true)
        void enabled() {
        }

        @TransactionalMethod(trackReads=false)
        void disabled() {
        }
    }

    class DefaultUpdateMethod {
        DefaultUpdateMethod() {
        }

        @TransactionalMethod(readonly=false)
        void method() {
        }
    }

    class ReadonlyMethod {
        ReadonlyMethod() {
        }

        @TransactionalMethod(readonly=true)
        void method() {
        }
    }

    class DefaultSettings {
        DefaultSettings() {
        }

        @TransactionalMethod
        void method() {
        }
    }
}

