/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.multiverse.compiler.MultiverseCompilerArguments;
import org.multiverse.instrumentation.Clazz;
import org.multiverse.instrumentation.FileSystemFiler;
import org.multiverse.instrumentation.Instrumentor;
import org.multiverse.instrumentation.SystemOutImportantInstrumenterLogger;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.utils.SystemOut;
import org.objectweb.asm.tree.ClassNode;

public final class MultiverseCompiler {
    private ClassLoader compilerClassLoader;

    public static void main(String[] args) {
        MultiverseCompilerArguments cli = MultiverseCompiler.createCli(args);
        MultiverseCompiler multiverseCompiler = new MultiverseCompiler();
        multiverseCompiler.run(cli);
    }

    private void run(MultiverseCompilerArguments cli) {
        SystemOut.println((String)"Multiverse: initializing compiler", (Object[])new Object[0]);
        Instrumentor instrumentor = MultiverseCompiler.createInstrumentor(cli.instrumentorName);
        File targetDirectory = new File(cli.targetDirectory);
        this.compilerClassLoader = new MyClassLoader(targetDirectory, MultiverseCompiler.class.getClassLoader());
        if (!targetDirectory.isDirectory()) {
            SystemOut.println((String)"Multiverse: target directory '%s' to instrument is not found, skipping instrumentation", (Object[])new Object[]{targetDirectory});
            return;
        }
        if (cli.optimize) {
            SystemOut.println((String)"Multiverse: bytecode is optimized", (Object[])new Object[0]);
            instrumentor.setOptimize(true);
        }
        if (cli.dumpBytecode) {
            SystemOut.println((String)"Multiverse: bytecode is to dumped %s for debugging purposes", (Object[])new Object[]{instrumentor.getDumpDirectory()});
            instrumentor.setDumpBytecode(true);
        }
        if (cli.verbose) {
            instrumentor.setLog(new SystemOutImportantInstrumenterLogger());
        }
        SystemOut.println((String)"Multiverse: using org.multiverse.instrumentation.Instrumentor %s version %s", (Object[])new Object[]{instrumentor.getInstrumentorName(), instrumentor.getInstrumentorVersion()});
        instrumentor.setFiler(new FileSystemFiler(targetDirectory));
        SystemOut.println((String)"Multiverse: instrumenting targetDirectory %s", (Object[])new Object[]{targetDirectory});
        this.applyRecursive(targetDirectory, instrumentor);
    }

    private static MultiverseCompilerArguments createCli(String[] args) {
        CmdLineParser parser = null;
        try {
            MultiverseCompilerArguments cli = new MultiverseCompilerArguments();
            parser = new CmdLineParser((Object)cli);
            parser.parseArgument(args);
            return cli;
        }
        catch (CmdLineException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            System.err.println("java -jar myprogram.jar [options...] compilername target");
            if (parser != null) {
                parser.printUsage((OutputStream)System.out);
            }
            System.exit(-1);
            return null;
        }
    }

    public void applyRecursive(File directory, Instrumentor instrumentor) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.applyRecursive(file, instrumentor);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            this.transform(file, instrumentor);
        }
    }

    private void transform(File file, Instrumentor clazzCompiler) {
        Clazz clazz = this.load(file);
        Clazz result = clazzCompiler.process(clazz);
        this.write(file, result);
    }

    private Clazz load(File file) {
        ClassNode node = AsmUtils.loadAsClassNode(file);
        Clazz clazz = new Clazz(node.name);
        clazz.setBytecode(AsmUtils.toBytecode(node));
        clazz.setClassLoader(this.compilerClassLoader);
        return clazz;
    }

    public void write(File file, Clazz clazz) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write(clazz.getBytecode());
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Instrumentor createInstrumentor(String compilerClassName) {
        SystemOut.println((String)String.format("Multiverse: using Instrumentor '%s'", compilerClassName), (Object[])new Object[0]);
        Constructor constructor = MultiverseCompiler.getMethod(compilerClassName);
        try {
            return (Instrumentor)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            String msg = String.format("Failed to initialize Instrumentor '%s'.The constructor is not accessable.", compilerClassName);
            throw new IllegalArgumentException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("Failed to initialize Instrumentor '%s'.The constructor threw an exception.", compilerClassName);
            SystemOut.println((String)msg, (Object[])new Object[0]);
            throw new IllegalArgumentException(msg, e);
        }
        catch (InstantiationException e) {
            String msg = String.format("Failed to initialize Instrumentor '%s'.The class could not be instantiated.", compilerClassName);
            SystemOut.println((String)msg, (Object[])new Object[0]);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static Constructor getMethod(String className) {
        Constructor<?> method;
        Class<?> compilerClazz;
        if (className == null) {
            throw new NullPointerException();
        }
        try {
            compilerClazz = MultiverseCompiler.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Failed to initialize Instrumentor '%s'.Is not an existing class (it can't be found using the Thread.currentThread.getContextClassLoader).", className);
            SystemOut.println((String)msg, (Object[])new Object[0]);
            throw new IllegalArgumentException(msg, e);
        }
        if (!Instrumentor.class.isAssignableFrom(compilerClazz)) {
            String msg = String.format("Failed to initialize Instrumentor '%s'.Is not an subclass of org.multiverse.compiler.Instrumentor).", className);
            SystemOut.println((String)msg, (Object[])new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        try {
            method = compilerClazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = String.format("Failed to initialize Instrumentor '%s'.A no arg constructor is not found.", compilerClazz);
            SystemOut.println((String)msg, (Object[])new Object[0]);
            throw new IllegalArgumentException(msg, e);
        }
        return method;
    }

    class MyClassLoader
    extends ClassLoader {
        private final File rootDirectory;

        protected MyClassLoader(File rootDirectory, ClassLoader parent) {
            super(parent);
            this.rootDirectory = rootDirectory;
        }

        public Class findClass(String className) throws ClassNotFoundException {
            String filename = className.replace('.', '/') + ".class";
            File file = new File(this.rootDirectory, filename);
            if (!file.exists()) {
                return super.findClass(className);
            }
            ClassNode node = AsmUtils.loadAsClassNode(file);
            byte[] bytecode = AsmUtils.toBytecode(node);
            return this.defineClass(className, bytecode, 0, bytecode.length, null);
        }

        @Override
        public InputStream getResourceAsStream(String resource) {
            String filename;
            int indexOfLastDot = resource.lastIndexOf(".");
            if (indexOfLastDot == -1) {
                filename = resource;
            } else {
                String begin = resource.substring(0, indexOfLastDot).replace('.', '/');
                String end = resource.substring(indexOfLastDot);
                filename = begin + end;
            }
            File file = new File(this.rootDirectory, filename);
            if (file.exists()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return super.getResourceAsStream(resource);
        }
    }
}

