/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.javaagent;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.multiverse.MultiverseConstants;
import org.multiverse.instrumentation.Instrumentor;
import org.multiverse.instrumentation.SystemOutImportantInstrumenterLogger;
import org.multiverse.javaagent.JavaAgentFiler;
import org.multiverse.javaagent.MultiverseClassFileTransformer;
import org.multiverse.utils.SystemOut;

public final class MultiverseJavaAgent {
    public static final String KEY = "org.multiverse.javaagent.instrumentor";

    public static void premain(String agentArgs, Instrumentation inst) throws UnmodifiableClassException {
        MultiverseJavaAgent.printMultiverseJavaAgentInfo();
        Instrumentor compiler = MultiverseJavaAgent.loadClazzCompiler();
        inst.addTransformer(new MultiverseClassFileTransformer(compiler));
    }

    private static Instrumentor loadClazzCompiler() {
        Instrumentor compiler = MultiverseJavaAgent.createInstrumentor();
        boolean verbose = MultiverseJavaAgent.getSystemBooleanProperty("verbose", false);
        if (verbose) {
            compiler.setLog(new SystemOutImportantInstrumenterLogger());
        }
        compiler.setFiler(new JavaAgentFiler());
        boolean dumpBytecode = MultiverseJavaAgent.getSystemBooleanProperty("dumpBytecode", false);
        compiler.setDumpBytecode(dumpBytecode);
        if (dumpBytecode) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            File dumpDirectory = new File(MultiverseJavaAgent.getSystemProperty("dumpDirectory", tmpDir));
            SystemOut.println((String)String.format("Multiverse: Bytecode from Javaagent will be dumped to '%s'", dumpDirectory.getAbsolutePath()), (Object[])new Object[0]);
            compiler.setDumpDirectory(dumpDirectory);
        }
        SystemOut.println((String)"Multiverse: Javaaagent won't apply code optimizations (see compiletime instrumentation)", (Object[])new Object[0]);
        return compiler;
    }

    private static void printMultiverseJavaAgentInfo() {
        SystemOut.println((String)"Multiverse: Using JavaAgent", (Object[])new Object[0]);
        if (MultiverseConstants.___SANITY_CHECKS_ENABLED) {
            SystemOut.println((String)"Sanity checks are enabled.", (Object[])new Object[0]);
        }
    }

    private static Instrumentor createInstrumentor() {
        String instrumentorClassName = MultiverseJavaAgent.getSystemProperty("instrumentor", "org.multiverse.stms.alpha.instrumentation.AlphaStmInstrumentor");
        SystemOut.println((String)String.format("Multiverse: Initializing org.multiverse.instrumentation.Instrumentor '%s'", instrumentorClassName), (Object[])new Object[0]);
        Constructor constructor = MultiverseJavaAgent.getMethod(instrumentorClassName);
        try {
            Instrumentor instrumentor = (Instrumentor)constructor.newInstance(new Object[0]);
            SystemOut.println((String)"Multiverse: Initialized '%s-%s'", (Object[])new Object[]{instrumentor.getInstrumentorName(), instrumentor.getInstrumentorVersion()});
            return instrumentor;
        }
        catch (IllegalAccessException e) {
            String msg = String.format("Failed to initialize Instrumentor through System property '%s' with value '%s'.The constructor is not accessable.", KEY, instrumentorClassName);
            throw new IllegalArgumentException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("Failed to initialize Instrumentor through System property '%s' with value '%s'.The constructor threw an exception.", KEY, instrumentorClassName);
            SystemOut.println((String)msg, (Object[])new Object[0]);
            throw new IllegalArgumentException(msg, e);
        }
        catch (InstantiationException e) {
            String msg = String.format("Failed to initialize Instrumentor through System property '%s' with value '%s'.The class could not be instantiated.", KEY, instrumentorClassName);
            SystemOut.println((String)msg, (Object[])new Object[0]);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static boolean getSystemBooleanProperty(String property, boolean defaultValue) {
        String value = MultiverseJavaAgent.getSystemProperty(property, "" + defaultValue);
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        String msg = String.format("property %s with value '%s' is not a boolean (true/false).", property, value);
        throw new IllegalArgumentException(msg);
    }

    private static String getSystemProperty(String property, String defaultValue) {
        String fullProperty = "org.multiverse.javaagent." + property;
        return System.getProperty(fullProperty, defaultValue);
    }

    private static Constructor getMethod(String className) {
        Constructor<?> method;
        Class<?> compilerClazz;
        try {
            compilerClazz = ClassLoader.getSystemClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Failed to initialize Instrumentor through System property '%s' with value '%s'.Is not an existing class (it can't be found using the Thread.currentThread.getContextClassLoader).", KEY, className);
            SystemOut.println((String)msg, (Object[])new Object[0]);
            throw new IllegalArgumentException(msg, e);
        }
        if (!Instrumentor.class.isAssignableFrom(compilerClazz)) {
            String msg = String.format("Failed to initialize Instrumentor through System property '%s' with value '%s'.Is not an subclass of org.multiverse.compiler.Instrumentor).", KEY, className);
            SystemOut.println((String)msg, (Object[])new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        try {
            method = compilerClazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = String.format("Failed to initialize Instrumentor through System property '%s' with value '%s'.A no arg constructor is not found.", KEY, compilerClazz);
            SystemOut.println((String)msg, (Object[])new Object[0]);
            throw new IllegalArgumentException(msg, e);
        }
        return method;
    }
}

