/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.metadata;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.instrumentation.metadata.FullFamilyNameStrategy;

public class FullFamilynameStrategyTest {
    private FullFamilyNameStrategy strategy;

    @Before
    public void setUp() {
        this.strategy = new FullFamilyNameStrategy();
    }

    @Test
    public void testNoPackage() {
        String result = this.strategy.create("Foo", "foo", "(LBar;)LFooBar;");
        Assert.assertEquals((Object)"Foo.foo(Bar)", (Object)result);
    }

    @Test
    public void testAllObjects() {
        String result = this.strategy.create("java/lang/String", "foo", "(Ljava/lang/String;)Ljava/lang/String;");
        Assert.assertEquals((Object)"java.lang.String.foo(java.lang.String)", (Object)result);
    }

    @Test
    public void testNoArgMethod() {
        String result = this.strategy.create("java/lang/String", "foo", "()V");
        Assert.assertEquals((Object)"java.lang.String.foo()", (Object)result);
    }

    @Test
    public void testPrimitiveArg() {
        String result = this.strategy.create("java/lang/String", "foo", "(I)V");
        Assert.assertEquals((Object)"java.lang.String.foo(int)", (Object)result);
    }

    @Test
    public void testComplex() {
        String result = this.strategy.create("java/lang/String", "foo", "(Ljava/lang/String;ILjava/util/LinkedList;)Ljava/lang/String;");
        Assert.assertEquals((Object)"java.lang.String.foo(java.lang.String,int,java.util.LinkedList)", (Object)result);
    }
}

