/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation;

import java.io.File;
import org.multiverse.instrumentation.Clazz;
import org.multiverse.instrumentation.Filer;
import org.multiverse.instrumentation.asm.AsmUtils;

public class DumpingFiler
implements Filer {
    private final Filer filer;
    private final File dumpDirectory;

    public DumpingFiler(Filer filer, File dumpDirectory) {
        if (filer == null || dumpDirectory == null) {
            throw new NullPointerException();
        }
        this.dumpDirectory = dumpDirectory;
        this.filer = filer;
    }

    @Override
    public void createClassFile(Clazz clazz) {
        File file = new File(this.dumpDirectory, clazz.getName() + ".class");
        AsmUtils.writeToFile(file, clazz.getBytecode());
        this.filer.createClassFile(clazz);
    }
}

