/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation;

import java.util.LinkedList;
import org.multiverse.instrumentation.AbstractInstrumentationPhase;
import org.multiverse.instrumentation.Clazz;
import org.multiverse.instrumentation.CompileException;
import org.multiverse.instrumentation.Environment;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.Instrumentor;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MemberNode;

public class PreventReinstrumentationInstrumentationPhase
extends AbstractInstrumentationPhase {
    private static final String INSTRUMENTOR_NAME = "instrumentorName";
    private static final String INSTRUMENTOR_VERSION = "instrumentorVersion";
    private final Instrumentor instrumentor;

    public PreventReinstrumentationInstrumentationPhase(Instrumentor instrumentor) {
        super("PreventReinstrumentationInstrumentationPhase");
        if (instrumentor == null) {
            throw new NullPointerException();
        }
        this.instrumentor = instrumentor;
    }

    @Override
    protected Clazz doInstrument(Environment environment, Clazz originalClazz) {
        ClassNode original = AsmUtils.loadAsClassNode(originalClazz.getBytecode());
        AnnotationNode instrumentedAnnotationNode = AsmUtils.getVisibleAnnotation((MemberNode)original, InstrumentationStamp.class);
        if (instrumentedAnnotationNode != null) {
            this.ensureCorrectClazzCompiler(instrumentedAnnotationNode, original);
            environment.getLog().lessImportant("%s already is instrumented", originalClazz.getName());
            return null;
        }
        AnnotationNode annotationNode = this.createInstrumentedAnnotationNode();
        if (original.visibleAnnotations == null) {
            original.visibleAnnotations = new LinkedList();
        }
        original.visibleAnnotations.add(annotationNode);
        byte[] bytecode = AsmUtils.toBytecode(original);
        return new Clazz(originalClazz, bytecode);
    }

    private void ensureCorrectClazzCompiler(AnnotationNode instrumentedAnnotationNode, ClassNode original) {
        String foundCompilerName = (String)AsmUtils.getAnnotationValue(instrumentedAnnotationNode, INSTRUMENTOR_NAME);
        if (!this.instrumentor.getName().equals(foundCompilerName)) {
            String msg = String.format("Failed to instrument already instrumented class '%s'. The current instrumentor '%s' does not match the previous used instrumentor '%s' and therefor can't be used in combination with the Stm '%s'. To solve this problem you need to make sure that you using the correct instrumentor or you need to delete the classes and reinstrument them with this instrumentor.", original.name, this.instrumentor.getName(), foundCompilerName, this.instrumentor.getStmName());
            throw new CompileException(msg);
        }
        String foundCompilerVersion = (String)AsmUtils.getAnnotationValue(instrumentedAnnotationNode, INSTRUMENTOR_VERSION);
        if (!this.instrumentor.getVersion().equals(foundCompilerVersion)) {
            String msg = String.format("Failed to instrument already instrumented class '%s'. The new instrumentor version '%s' does not match the previous instrumentor version. '%s'.And because the instrumentation process is not backwards compatible, thisclass can't be used with the current Stm. The Multiverse instrumentation process is not backwards compatible. To solve the problem you need to delete the classes and reinstrument them with this instrumentor %s.%s to solve the problem.", original.name, this.instrumentor.getVersion(), foundCompilerVersion, this.instrumentor.getName(), this.instrumentor.getVersion());
            throw new CompileException(msg);
        }
    }

    private AnnotationNode createInstrumentedAnnotationNode() {
        String desc = Type.getType(InstrumentationStamp.class).getDescriptor();
        AnnotationNode annotationNode = new AnnotationNode(desc);
        annotationNode.values = new LinkedList();
        annotationNode.values.add(INSTRUMENTOR_NAME);
        annotationNode.values.add(this.instrumentor.getName());
        annotationNode.values.add(INSTRUMENTOR_VERSION);
        annotationNode.values.add(this.instrumentor.getVersion());
        return annotationNode;
    }
}

