/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.metadata;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.instrumentation.metadata.MethodMetadata;
import org.multiverse.instrumentation.metadata.MethodType;

public class MetadataRepository_GetterTest {
    private MetadataRepository repo;

    @Before
    public void setUp() {
        this.repo = new MetadataRepository();
    }

    @Test
    public void whenSimpleGetter() {
        ClassMetadata personMetadata = this.repo.loadClassMetadata(Person.class);
        MethodMetadata getNameMetadata = personMetadata.getMethodMetadata("getName", "()Ljava/lang/String;");
        Assert.assertEquals((Object)MethodType.getter, (Object)getNameMetadata.getMethodType());
    }

    @Test
    public void whenAbstractGetter() {
        ClassMetadata personMetadata = this.repo.loadClassMetadata(Person.class);
        MethodMetadata getNameMetadata = personMetadata.getMethodMetadata("getAbstractName", "()Ljava/lang/String;");
        Assert.assertEquals((Object)MethodType.unknown, (Object)getNameMetadata.getMethodType());
    }

    @Test
    public void nameDoesntMatterForGetter() {
        ClassMetadata personMetadata = this.repo.loadClassMetadata(Person.class);
        MethodMetadata getNameMetadata = personMetadata.getMethodMetadata("emanTeg", "()Ljava/lang/String;");
        Assert.assertEquals((Object)MethodType.getter, (Object)getNameMetadata.getMethodType());
    }

    @Test
    public void whenVoidGetter_thenNoGetter() {
        ClassMetadata personMetadata = this.repo.loadClassMetadata(Person.class);
        MethodMetadata getNameMetadata = personMetadata.getMethodMetadata("getNameWithoutValue", "()V");
        Assert.assertEquals((Object)MethodType.unknown, (Object)getNameMetadata.getMethodType());
    }

    @Test
    public void whenGetterHasArgument_thenNoGetter() {
        ClassMetadata personMetadata = this.repo.loadClassMetadata(Person.class);
        MethodMetadata getNameMetadata = personMetadata.getMethodMetadata("getName", "(Ljava/lang/String;)Ljava/lang/String;");
        Assert.assertEquals((Object)MethodType.unknown, (Object)getNameMetadata.getMethodType());
    }

    @Test
    public void whenGetterIsMoreComplex_thenNoGetter() {
        ClassMetadata personMetadata = this.repo.loadClassMetadata(Person.class);
        MethodMetadata getNameMetadata = personMetadata.getMethodMetadata("getNameTooComplex", "()Ljava/lang/String;");
        Assert.assertEquals((Object)MethodType.unknown, (Object)getNameMetadata.getMethodType());
    }

    @Test
    public void whenGetterIsConstant_thenNoGetter() {
        ClassMetadata personMetadata = this.repo.loadClassMetadata(Person.class);
        MethodMetadata getNameMetadata = personMetadata.getMethodMetadata("getConstantName", "()Ljava/lang/String;");
        Assert.assertEquals((Object)MethodType.unknown, (Object)getNameMetadata.getMethodType());
    }

    abstract class Person {
        String name;

        Person() {
        }

        public String getName() {
            return this.name;
        }

        public String emanTeg() {
            return this.name;
        }

        public void setName(String newName) {
            this.name = newName;
        }

        public void getNameWithoutValue() {
        }

        public abstract String getAbstractName();

        public String getName(String fake) {
            return this.name;
        }

        public String getNameTooComplex() {
            System.out.println("make me complex");
            return this.name;
        }

        public String get() {
            return this.name.toString();
        }

        public String getConstantName() {
            return "Peter";
        }
    }
}

