/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.metadata;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.instrumentation.metadata.CompactFamilyNameStrategy;

public class CompactFamilyNameStrategyTest {
    private CompactFamilyNameStrategy strategy;

    @Before
    public void setUp() {
        this.strategy = new CompactFamilyNameStrategy();
    }

    @Test
    public void testGetPackages() {
        String[] packages = this.strategy.getPackages("Foo");
        Assert.assertEquals((long)0L, (long)packages.length);
        packages = this.strategy.getPackages("org/Foo");
        Assert.assertEquals((long)1L, (long)packages.length);
        Assert.assertEquals((Object)"org", (Object)packages[0]);
        packages = this.strategy.getPackages("org/bla/Foo");
        Assert.assertEquals((long)2L, (long)packages.length);
        Assert.assertEquals((Object)"org", (Object)packages[0]);
        Assert.assertEquals((Object)"bla", (Object)packages[1]);
    }

    @Test
    public void testAllJavaLangObjects() {
        String result = this.strategy.create("java/lang/String", "foo", "(Ljava/lang/String;)Ljava/lang/String;");
        Assert.assertEquals((Object)"String.foo(String)", (Object)result);
    }

    @Test
    public void testNoPackage() {
        String result = this.strategy.create("Foo", "foo", "(LBar;)LFooBar;");
        Assert.assertEquals((Object)"Foo.foo(Bar)", (Object)result);
    }

    @Test
    public void testCompactOwner() {
        String result = this.strategy.create("org/foobar/Foo", "foo", "()V");
        Assert.assertEquals((Object)"o.f.Foo.foo()", (Object)result);
    }

    @Test
    public void testCompactArguments() {
        String result = this.strategy.create("Bar", "foo", "(Lorg/foo/Foo;)V");
        Assert.assertEquals((Object)"Bar.foo(o.f.Foo)", (Object)result);
    }

    @Test
    public void testNoArgMethod() {
        String result = this.strategy.create("java/lang/String", "foo", "()V");
        Assert.assertEquals((Object)"String.foo()", (Object)result);
    }

    @Test
    public void testPrimitiveArg() {
        String result = this.strategy.create("java/lang/String", "foo", "(I)V");
        Assert.assertEquals((Object)"String.foo(int)", (Object)result);
    }

    @Test
    public void testComplex() {
        String result = this.strategy.create("java/lang/String", "foo", "(Ljava/lang/String;ILjava/util/LinkedList;)Ljava/lang/String;");
        Assert.assertEquals((Object)"String.foo(String,int,j.u.LinkedList)", (Object)result);
    }
}

