/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.metadata;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.NonTransactional;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.instrumentation.metadata.MethodMetadata;

public class MetadataRepository_MethodTest {
    private MetadataRepository repository;

    @Before
    public void setUp() {
        this.repository = new MetadataRepository();
    }

    @Test
    public void whenObjectWithTransactionalMethod() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(ObjectWithTransactionalMethod.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("foo", "()V");
        Assert.assertNotNull((Object)methodMetadata);
        Assert.assertTrue((boolean)methodMetadata.isTransactional());
        Assert.assertFalse((boolean)methodMetadata.isAbstract());
        Assert.assertFalse((boolean)methodMetadata.isConstructor());
    }

    @Test
    public void whenTransactionalObjectWithMethod() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(TransactionalObjectWithMethod.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("foo", "()V");
        Assert.assertNotNull((Object)methodMetadata);
        Assert.assertTrue((boolean)methodMetadata.isTransactional());
        Assert.assertFalse((boolean)methodMetadata.isAbstract());
        Assert.assertFalse((boolean)methodMetadata.isConstructor());
    }

    @Test
    public void whenTransactionalInterfaceWithMethod() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(TransactionalInterfaceWithMethod.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("foo", "()V");
        Assert.assertNotNull((Object)methodMetadata);
        Assert.assertTrue((boolean)methodMetadata.isTransactional());
        Assert.assertTrue((boolean)methodMetadata.isAbstract());
        Assert.assertFalse((boolean)methodMetadata.isConstructor());
    }

    @Test
    public void whenTransactionalObjectWithExcludedMethod() {
        ClassMetadata classMetadata = this.repository.loadClassMetadata(TransactionalObjectWithExcludedMethod.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata("foo", "()V");
        Assert.assertNotNull((Object)methodMetadata);
        Assert.assertFalse((boolean)methodMetadata.isTransactional());
        Assert.assertFalse((boolean)methodMetadata.isAbstract());
        Assert.assertFalse((boolean)methodMetadata.isConstructor());
    }

    @TransactionalObject
    class TransactionalObjectWithExcludedMethod {
        TransactionalObjectWithExcludedMethod() {
        }

        @NonTransactional
        public void foo() {
        }
    }

    @TransactionalObject
    static interface TransactionalInterfaceWithMethod {
        public void foo();
    }

    @TransactionalObject
    class TransactionalObjectWithMethod {
        TransactionalObjectWithMethod() {
        }

        public void foo() {
        }
    }

    class ObjectWithTransactionalMethod {
        ObjectWithTransactionalMethod() {
        }

        @TransactionalMethod
        public void foo() {
        }
    }
}

