/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.metadata;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.instrumentation.metadata.Multikey;

public class MultikeyTest {
    @Test
    public void test() {
        Multikey key = new Multikey(new Object[0]);
        Assert.assertFalse((boolean)key.equals(null));
        Assert.assertTrue((boolean)key.equals((Object)key));
    }

    @Test
    public void whenNoFields() {
        Multikey key1 = new Multikey(new Object[0]);
        Multikey key2 = new Multikey(new Object[0]);
        Assert.assertTrue((boolean)key1.equals((Object)key2));
        Assert.assertEquals((long)key1.hashCode(), (long)key2.hashCode());
    }

    @Test
    public void whenFieldsMatch() {
        Multikey key1 = new Multikey(new Object[]{"a"});
        Multikey key2 = new Multikey(new Object[]{"a"});
        Assert.assertTrue((boolean)key1.equals((Object)key2));
        Assert.assertEquals((long)key1.hashCode(), (long)key2.hashCode());
    }

    @Test
    public void whenFieldsNotMatch() {
        Multikey key1 = new Multikey(new Object[]{"a"});
        Multikey key2 = new Multikey(new Object[]{"b"});
        Assert.assertFalse((boolean)key1.equals((Object)key2));
        Assert.assertTrue((!Integer.valueOf(key1.hashCode()).equals(key2.hashCode()) ? 1 : 0) != 0);
    }

    @Test
    public void whenDifferenceInFieldNumber() {
        Multikey key1 = new Multikey(new Object[]{"a"});
        Multikey key2 = new Multikey(new Object[]{"a", "a"});
        Assert.assertFalse((boolean)key1.equals((Object)key2));
        Assert.assertTrue((!Integer.valueOf(key1.hashCode()).equals(key2.hashCode()) ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Multikey key = new Multikey(new Object[]{"a", "b", "c"});
        Assert.assertEquals((Object)"Multikey(a, b, c)", (Object)key.toString());
    }
}

