/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.metadata;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.multiverse.instrumentation.metadata.FieldMetadata;
import org.multiverse.instrumentation.metadata.MethodMetadata;
import org.multiverse.instrumentation.metadata.Multikey;

public final class ClassMetadata {
    private final String className;
    private final Map<String, FieldMetadata> fields = new HashMap<String, FieldMetadata>();
    private final Map<Multikey, MethodMetadata> methods = new HashMap<Multikey, MethodMetadata>();
    private final List<ClassMetadata> interfaces = new LinkedList<ClassMetadata>();
    private boolean isTransactionalObject;
    private ClassMetadata superClassMetadata;
    private boolean ignoredClass;
    private int access;

    public ClassMetadata(String className) {
        this.className = className;
    }

    public MethodMetadata createMethodMetadata(String methodName, String desc) {
        if (methodName == null || desc == null) {
            throw new NullPointerException();
        }
        Multikey methodKey = new Multikey(methodName, desc);
        if (this.methods.containsKey(methodKey)) {
            String msg = String.format("There already is method metadata for %s.%s%s", this.className, methodName, desc);
            throw new IllegalArgumentException(msg);
        }
        MethodMetadata method = new MethodMetadata(this, methodName, desc);
        this.methods.put(methodKey, method);
        return method;
    }

    public List<ClassMetadata> getInterfaces() {
        return this.interfaces;
    }

    public boolean isIgnoredClass() {
        return this.ignoredClass;
    }

    public void setIgnoredClass(boolean ignoredClass) {
        this.ignoredClass = ignoredClass;
    }

    public ClassMetadata getSuperClassMetadata() {
        return this.superClassMetadata;
    }

    public void setSuperClassMetadata(ClassMetadata superClassMetadata) {
        this.superClassMetadata = superClassMetadata;
    }

    public MethodMetadata getMethodMetadata(String name, String desc) {
        MethodMetadata methodMetadata = this.methods.get(new Multikey(name, desc));
        if (methodMetadata == null && this.superClassMetadata != null) {
            methodMetadata = this.superClassMetadata.getMethodMetadata(name, desc);
        }
        return methodMetadata;
    }

    public FieldMetadata getFieldMetadata(String fieldName) {
        FieldMetadata fieldMetadata = this.fields.get(fieldName);
        if (fieldMetadata != null) {
            return fieldMetadata;
        }
        if (this.superClassMetadata != null && (fieldMetadata = this.superClassMetadata.getFieldMetadata(fieldName)) != null) {
            return fieldMetadata;
        }
        for (ClassMetadata interfaceMetadata : this.interfaces) {
            fieldMetadata = interfaceMetadata.getFieldMetadata(fieldName);
            if (fieldMetadata == null) continue;
            return fieldMetadata;
        }
        return null;
    }

    public FieldMetadata createFieldMetadata(String fieldname) {
        if (fieldname == null) {
            throw new NullPointerException();
        }
        if (this.fields.containsKey(fieldname)) {
            String msg = String.format("There already is field metadata for %s.%s", this.className, fieldname);
            throw new IllegalArgumentException(msg);
        }
        FieldMetadata fieldMetadata = new FieldMetadata(this, fieldname);
        this.fields.put(fieldname, fieldMetadata);
        return fieldMetadata;
    }

    public boolean hasManagedFieldsWithFieldGranularity() {
        for (FieldMetadata field : this.fields.values()) {
            if (!field.isManagedField() || !field.hasFieldGranularity()) continue;
            return true;
        }
        return false;
    }

    public boolean hasManagedFieldsWithObjectGranularity() {
        for (FieldMetadata field : this.fields.values()) {
            if (!field.isManagedField() || field.hasFieldGranularity()) continue;
            return true;
        }
        return false;
    }

    public boolean hasManagedFields() {
        for (FieldMetadata field : this.fields.values()) {
            if (!field.isManagedField()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.className;
    }

    public boolean isTransactionalObject() {
        return this.isTransactionalObject;
    }

    public void setIsTransactionalObject(boolean isTransactionalObject) {
        this.isTransactionalObject = isTransactionalObject;
    }

    public boolean isTransactionalObjectWithObjectGranularFields() {
        if (this.isParentTransactionalObjectWithObjectGranularFields()) {
            return true;
        }
        if (this.isTransactionalObject()) {
            for (FieldMetadata fieldMetadata : this.fields.values()) {
                if (!fieldMetadata.isManagedField() || fieldMetadata.hasFieldGranularity()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isParentTransactionalObjectWithObjectGranularFields() {
        return this.superClassMetadata != null && this.superClassMetadata.isTransactionalObjectWithObjectGranularFields();
    }

    public boolean hasTransactionalMethods() {
        for (MethodMetadata methodMetadata : this.methods.values()) {
            if (!methodMetadata.isTransactional()) continue;
            return true;
        }
        return false;
    }

    public boolean isFirstGenerationTransactionalObjectWithObjectGranularFields() {
        if (!this.isTransactionalObject) {
            return false;
        }
        if (!this.hasManagedFieldsWithObjectGranularity()) {
            return false;
        }
        if (this.superClassMetadata == null) {
            return true;
        }
        return !this.superClassMetadata.isTransactionalObjectWithObjectGranularFields();
    }

    public String getTranlocalName() {
        return this.className + "__Tranlocal";
    }

    public String getTranlocalSnapshotName() {
        return this.className + "__TranlocalSnapshot";
    }

    public int getAccess() {
        return this.access;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public final boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public String toString() {
        return this.className;
    }
}

