/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.performancetool;

import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.multiverse.performancetool.PerformanceToolArguments;

public class PerformanceTool {
    public static void main(String[] args) throws InterruptedException {
        PerformanceToolArguments cli = PerformanceTool.createCli(args);
        PerformanceTool multiverseCompiler = new PerformanceTool();
        multiverseCompiler.run(cli);
    }

    private void run(PerformanceToolArguments arguments) throws InterruptedException {
        System.out.println("Multiverse Threoretical STM Performance Benchmark");
        this.printSettings(arguments);
        this.printWarning();
        long durationNs = this.executeBenchmark(arguments);
        this.printResults(arguments, durationNs);
    }

    private void printResults(PerformanceToolArguments cli, long durationNs) {
        double transactionsPerSecondPerThread = 1.0 * (double)cli.transactionCount * (double)TimeUnit.SECONDS.toNanos(1L) / (double)durationNs;
        double transactionsPerSecond = transactionsPerSecondPerThread * (double)cli.threadCount;
        NumberFormat nf = this.createNumberFormat();
        System.out.println("[finished]----------------------------------------------------------");
        System.out.printf("Duration: %s seconds\n", TimeUnit.NANOSECONDS.toSeconds(durationNs));
        System.out.printf("Duration: %s nanoseconds\n", nf.format(durationNs));
        System.out.printf("Update transactions/second: %s \n", nf.format(transactionsPerSecond));
        System.out.printf("Update transactions/second: %s per core\n", nf.format(transactionsPerSecondPerThread));
    }

    private NumberFormat createNumberFormat() {
        return NumberFormat.getInstance(Locale.ENGLISH);
    }

    private long executeBenchmark(PerformanceToolArguments arguments) throws InterruptedException {
        AtomicLong clock = new AtomicLong();
        Barrier startBarrier = new Barrier();
        Thread[] threads = new Thread[arguments.threadCount];
        for (int k = 0; k < arguments.threadCount; ++k) {
            threads[k] = new StressThread(k + 1, arguments.transactionCount, clock, arguments.strict, startBarrier);
            threads[k].start();
        }
        System.out.println("[starting]----------------------------------------------------------");
        long startNs = System.nanoTime();
        startBarrier.open();
        for (Thread thread : threads) {
            thread.join();
        }
        return System.nanoTime() - startNs;
    }

    private void printSettings(PerformanceToolArguments cli) {
        NumberFormat nf = this.createNumberFormat();
        System.out.println("Number of available processors: " + Runtime.getRuntime().availableProcessors());
        System.out.println("Number of threads: " + nf.format(cli.threadCount));
        System.out.println("Update transaction count per thread: " + nf.format(cli.transactionCount));
        System.out.println("Update transaction count in total: " + nf.format(cli.transactionCount * (long)cli.threadCount));
        System.out.println("Strict tick: " + cli.strict);
    }

    private void printWarning() {
        System.out.println("[info]--------------------------------------------------------------");
        System.out.println("Watch out with hyperthreading since the number of virtual cores");
        System.out.println("increase but the actual number of cores remains the same. In");
        System.out.println("this benchmark hyperthreading could cause a performance");
        System.out.println("slowdown, because multiple threads will compete for the same");
        System.out.println("non virtual core. Use the -t argument for configuring the number");
        System.out.println("of threads.");
    }

    private static PerformanceToolArguments createCli(String[] args) {
        CmdLineParser parser = null;
        try {
            PerformanceToolArguments cli = new PerformanceToolArguments();
            parser = new CmdLineParser((Object)cli);
            parser.parseArgument(args);
            return cli;
        }
        catch (CmdLineException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            System.err.println("java -jar myprogram.jar [options...]");
            if (parser != null) {
                parser.printUsage((OutputStream)System.out);
            }
            System.exit(-1);
            return null;
        }
    }

    private class StressThread
    extends Thread {
        private final long transactionCount;
        private final AtomicLong clock;
        private final boolean strict;
        private Barrier barrier;

        public StressThread(int id, long transactionCount, AtomicLong clock, boolean strict, Barrier barrier) {
            super("StressThread-" + id);
            this.transactionCount = transactionCount;
            this.clock = clock;
            this.strict = strict;
            this.barrier = barrier;
        }

        @Override
        public void run() {
            NumberFormat nf = PerformanceTool.this.createNumberFormat();
            this.barrier.awaitOpen();
            for (long k = 0L; k < this.transactionCount; ++k) {
                if (this.strict) {
                    this.clock.incrementAndGet();
                } else {
                    long value = this.clock.get();
                    this.clock.compareAndSet(value, value + 1L);
                }
                if (k <= 0L || k % 10000000L != 0L) continue;
                System.out.printf("%s is at %s\n", this.getName(), nf.format(k));
            }
        }
    }

    static class Barrier {
        private boolean open = false;

        Barrier() {
        }

        public synchronized void open() {
            this.open = true;
            this.notifyAll();
        }

        public synchronized void awaitOpen() {
            while (!this.open) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

