/*
 * Decompiled with CFR 0.152.
 */
package org.mutantcat.justsimple.dao.mybatis;

import java.io.Closeable;
import java.io.InputStream;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.mutantcat.justsimple.annotation.Instance;

@Instance(name="mybatis")
public class Mybatis {
    private static SqlSessionFactory sqlSessionFactory;
    private static SqlSession sessionInstance;

    public Mybatis() {
        try {
            String resource = "mybatis-config.xml";
            if (this.getClass().getClassLoader().getResource(resource) != null) {
                InputStream inputStream = Resources.getResourceAsStream((String)resource);
                sqlSessionFactory = new SqlSessionFactoryBuilder().build(inputStream);
            } else {
                System.out.println("\u82e5\u60f3\u4f7f\u7528Mybatis\u4f5c\u4e3aORM\u6846\u67b6\u9700\u8981\u5b9a\u4e49mybatis-config.xml");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close(Closeable any) {
        try {
            if (any != null) {
                any.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return sqlSessionFactory;
    }

    public SqlSession getSession() {
        return sqlSessionFactory.openSession();
    }

    public <T> T getMapper(Class<T> mapperClass) {
        try {
            Configuration configuration;
            if (sessionInstance == null) {
                sessionInstance = sqlSessionFactory.openSession();
            }
            if (!(configuration = sqlSessionFactory.getConfiguration()).hasMapper(mapperClass)) {
                configuration.addMapper(mapperClass);
            }
            return (T)sessionInstance.getMapper(mapperClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T getMapper(SqlSession session, Class<T> mapperClass) {
        Configuration configuration = sqlSessionFactory.getConfiguration();
        if (!configuration.hasMapper(mapperClass)) {
            configuration.addMapper(mapperClass);
        }
        return (T)session.getMapper(mapperClass);
    }
}

