/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mvel2.CompileException;
import org.mvel2.ErrorDetail;
import org.mvel2.ParserConfiguration;
import org.mvel2.ast.Function;
import org.mvel2.ast.LineLabel;
import org.mvel2.integration.Interceptor;
import org.mvel2.util.MethodStub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserContext
implements Serializable {
    private String sourceFile;
    private int lineCount = 1;
    private int lineOffset;
    private ParserConfiguration parserConfiguration = new ParserConfiguration();
    private ArrayList<String> indexedVariables;
    private HashMap<String, Class> variables;
    private Map<String, Class> inputs;
    private transient HashMap<String, Map<String, Class>> typeParameters;
    private transient Type[] lastTypeParameters;
    private HashMap<String, Function> globalFunctions;
    private transient List<ErrorDetail> errorList;
    private HashMap<String, Set<Integer>> sourceMap;
    private LineLabel lastLineLabel;
    private transient Object rootParser;
    private boolean compiled = false;
    private boolean strictTypeEnforcement = false;
    private boolean strongTyping = false;
    private boolean fatalError = false;
    private boolean retainParserState = false;
    private boolean debugSymbols = false;
    private boolean blockSymbols = false;
    private boolean executableCodeReached = false;
    private boolean indexAllocation = false;

    public ParserContext() {
    }

    public ParserContext(boolean debugSymbols) {
        this.debugSymbols = debugSymbols;
    }

    public ParserContext(Object rootParser) {
        this.rootParser = rootParser;
    }

    public ParserContext(ParserConfiguration parserConfiguration) {
        this.parserConfiguration = parserConfiguration;
    }

    public ParserContext(Map<String, Object> imports, Map<String, Interceptor> interceptors, String sourceFile) {
        this.sourceFile = sourceFile;
        this.parserConfiguration = new ParserConfiguration(imports, interceptors);
    }

    public boolean hasVarOrInput(String name) {
        return this.variables != null && this.variables.containsKey(name) || this.inputs != null && this.inputs.containsKey(name);
    }

    public Class getVarOrInputType(String name) {
        if (this.variables != null && this.variables.containsKey(name)) {
            return this.variables.get(name);
        }
        if (this.inputs != null && this.inputs.containsKey(name)) {
            return this.inputs.get(name);
        }
        return Object.class;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int setLineCount(int lineCount) {
        short s = (short)lineCount;
        this.lineCount = s;
        return s;
    }

    public int incrementLineCount(int increment) {
        return this.lineCount += increment;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public void setLineOffset(short lineOffset) {
        this.lineOffset = lineOffset;
    }

    public void setLineAndOffset(int lineCount, int lineOffset) {
        this.lineCount = lineCount;
        this.addKnownLine(this.lineCount);
        this.lineOffset = lineOffset;
    }

    public Class getImport(String name) {
        return this.parserConfiguration.getImport(name);
    }

    public MethodStub getStaticImport(String name) {
        return this.parserConfiguration.getStaticImport(name);
    }

    public Object getStaticOrClassImport(String name) {
        return this.parserConfiguration.getStaticOrClassImport(name);
    }

    public void addPackageImport(String packageName) {
        this.parserConfiguration.addPackageImport(packageName);
    }

    public boolean hasImport(String name) {
        return this.parserConfiguration.hasImport(name);
    }

    public void addImport(Class cls) {
        this.addImport(cls.getSimpleName(), cls);
    }

    public void addImport(String name, Class cls) {
        this.parserConfiguration.addImport(name, cls);
    }

    public void addImport(String name, Method method) {
        this.addImport(name, new MethodStub(method));
    }

    public void addImport(String name, MethodStub method) {
        this.parserConfiguration.addImport(name, method);
    }

    public void initializeTables() {
        if (this.variables == null) {
            this.variables = new LinkedHashMap<String, Class>();
        }
        if (this.inputs == null) {
            this.inputs = new LinkedHashMap<String, Class>();
        }
    }

    public void addVariable(String name, Class type, boolean failIfNewAssignment) {
        this.initializeTables();
        if (this.variables.containsKey(name) && failIfNewAssignment) {
            throw new CompileException("statically-typed variable already defined in scope: " + name);
        }
        if (type == null) {
            type = Object.class;
        }
        this.variables.put(name, type);
    }

    public void addVariable(String name, Class type) {
        this.initializeTables();
        if (this.variables.containsKey(name)) {
            return;
        }
        if (type == null) {
            type = Object.class;
        }
        this.variables.put(name, type);
    }

    public void addVariables(Map<String, Class> variables) {
        if (variables == null) {
            return;
        }
        this.initializeTables();
        for (Map.Entry<String, Class> entry : variables.entrySet()) {
            this.addVariable(entry.getKey(), entry.getValue());
        }
    }

    public void addInput(String name, Class type) {
        if (this.inputs == null) {
            this.inputs = new LinkedHashMap<String, Class>();
        }
        if (this.inputs.containsKey(name)) {
            return;
        }
        if (type == null) {
            type = Object.class;
        }
        this.inputs.put(name, type);
    }

    public void addInput(String name, Class type, Class[] typeParameters) {
        if (type == null) {
            type = Object.class;
        }
        this.addInput(name, type);
        if (this.typeParameters == null) {
            this.typeParameters = new LinkedHashMap<String, Map<String, Class>>();
        }
        if (this.typeParameters.get(name) == null) {
            this.typeParameters.put(name, new LinkedHashMap());
        }
        Map<String, Class> t = this.typeParameters.get(name);
        if (typeParameters.length != type.getTypeParameters().length) {
            throw new RuntimeException("wrong number of type parameters for: " + type.getName());
        }
        TypeVariable<Class<T>>[] tvs = type.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            t.put(tvs[i].getName(), typeParameters[i]);
        }
    }

    public void addInputs(Map<String, Class> inputs) {
        if (inputs == null) {
            return;
        }
        for (Map.Entry<String, Class> entry : inputs.entrySet()) {
            this.addInput(entry.getKey(), entry.getValue());
        }
    }

    public void processTables() {
        for (String name : this.variables.keySet()) {
            this.inputs.remove(name);
        }
    }

    public Map<String, Class> getInputs() {
        return this.inputs;
    }

    public void setInputs(Map<String, Class> inputs) {
        this.inputs = inputs;
    }

    public List<ErrorDetail> getErrorList() {
        return this.errorList;
    }

    public void setErrorList(List<ErrorDetail> errorList) {
        this.errorList = errorList;
    }

    public void addError(ErrorDetail errorDetail) {
        if (this.errorList == null) {
            this.errorList = new ArrayList<ErrorDetail>();
        }
        if (errorDetail.isCritical()) {
            this.fatalError = true;
        }
        this.errorList.add(errorDetail);
    }

    public boolean isFatalError() {
        return this.fatalError;
    }

    public void setFatalError(boolean fatalError) {
        this.fatalError = fatalError;
    }

    public boolean isStrictTypeEnforcement() {
        return this.strictTypeEnforcement;
    }

    public void setStrictTypeEnforcement(boolean strictTypeEnforcement) {
        this.strictTypeEnforcement = strictTypeEnforcement;
    }

    public boolean isStrongTyping() {
        return this.strongTyping;
    }

    public void setStrongTyping(boolean strongTyping) {
        this.strongTyping = strongTyping;
        if (this.strongTyping) {
            this.strictTypeEnforcement = true;
        }
    }

    public boolean isRetainParserState() {
        return this.retainParserState;
    }

    public void setRetainParserState(boolean retainParserState) {
        this.retainParserState = retainParserState;
    }

    public Object getRootParser() {
        return this.rootParser;
    }

    public void setRootParser(Object rootParser) {
        this.rootParser = rootParser;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        if (sourceFile != null) {
            this.sourceFile = sourceFile;
        }
    }

    public Map<String, Interceptor> getInterceptors() {
        return this.parserConfiguration.getInterceptors();
    }

    public void setInterceptors(Map<String, Interceptor> interceptors) {
        this.parserConfiguration.setInterceptors(interceptors);
    }

    public Map<String, Object> getImports() {
        return this.parserConfiguration.getImports();
    }

    public void setImports(Map<String, Object> imports) {
        if (imports == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : imports.entrySet()) {
            Object val = entry.getValue();
            if (val instanceof Class) {
                this.addImport(entry.getKey(), (Class)val);
                continue;
            }
            if (val instanceof Method) {
                this.addImport(entry.getKey(), (Method)val);
                continue;
            }
            if (val instanceof MethodStub) {
                this.addImport(entry.getKey(), (MethodStub)val);
                continue;
            }
            throw new RuntimeException("invalid element in imports map: " + entry.getKey() + " (" + val + ")");
        }
    }

    public HashMap<String, Class> getVariables() {
        return this.variables;
    }

    public void setVariables(HashMap<String, Class> variables) {
        this.variables = variables;
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public void setCompiled(boolean compiled) {
        this.compiled = compiled;
    }

    public boolean isDebugSymbols() {
        return this.debugSymbols;
    }

    public void setDebugSymbols(boolean debugSymbols) {
        this.debugSymbols = debugSymbols;
    }

    public boolean isKnownLine(String sourceName, int lineNumber) {
        return this.sourceMap != null && this.sourceMap.containsKey(sourceName) && this.sourceMap.get(sourceName).contains(lineNumber);
    }

    public void addKnownLine(String sourceName, int lineNumber) {
        if (this.sourceMap == null) {
            this.sourceMap = new LinkedHashMap<String, Set<Integer>>();
        }
        if (!this.sourceMap.containsKey(sourceName)) {
            this.sourceMap.put(sourceName, new HashSet());
        }
        this.sourceMap.get(sourceName).add(lineNumber);
    }

    public void addKnownLine(int lineNumber) {
        this.addKnownLine(this.sourceFile, lineNumber);
    }

    public LineLabel getLastLineLabel() {
        return this.lastLineLabel;
    }

    public LineLabel setLastLineLabel(LineLabel lastLineLabel) {
        this.lastLineLabel = lastLineLabel;
        return this.lastLineLabel;
    }

    public boolean hasImports() {
        return this.parserConfiguration.hasImports();
    }

    public void declareFunction(Function function) {
        if (this.globalFunctions == null) {
            this.globalFunctions = new LinkedHashMap<String, Function>();
        }
        this.globalFunctions.put(function.getName(), function);
    }

    public Function getFunction(String name) {
        if (this.globalFunctions == null) {
            return null;
        }
        return this.globalFunctions.get(name);
    }

    public Map getFunctions() {
        return this.globalFunctions;
    }

    public boolean hasFunction(String name) {
        return this.globalFunctions != null && this.globalFunctions.containsKey(name);
    }

    public boolean hasFunction() {
        return this.globalFunctions != null && this.globalFunctions.size() != 0;
    }

    public Map<String, Class> getTypeParameters(String name) {
        if (this.typeParameters == null) {
            return null;
        }
        return this.typeParameters.get(name);
    }

    public Type[] getTypeParametersAsArray(String name) {
        Class c = this.inputs.get(name);
        if (c == null) {
            return null;
        }
        TypeVariable<Class<T>>[] tp = c.getTypeParameters();
        Type[] types = new Type[tp.length];
        Map<String, Class> typeVars = this.getTypeParameters(name);
        if (typeVars == null) {
            return null;
        }
        for (int i = 0; i < tp.length; ++i) {
            types[i] = typeVars.get(tp[i].toString());
        }
        return types;
    }

    public boolean isBlockSymbols() {
        return this.blockSymbols;
    }

    public void setBlockSymbols(boolean blockSymbols) {
        this.blockSymbols = blockSymbols;
    }

    public boolean isExecutableCodeReached() {
        return this.executableCodeReached;
    }

    public void setExecutableCodeReached(boolean executableCodeReached) {
        this.executableCodeReached = executableCodeReached;
    }

    private void initIndexedVariables() {
        if (this.indexedVariables == null) {
            this.indexedVariables = new ArrayList();
        }
    }

    public ArrayList<String> getIndexedVariables() {
        this.initIndexedVariables();
        return this.indexedVariables;
    }

    public void addIndexedVariables(String[] variables) {
        this.initIndexedVariables();
        for (String s : variables) {
            if (this.indexedVariables.contains(s)) continue;
            this.indexedVariables.add(s);
        }
    }

    public void addIndexedVariable(String variable) {
        this.initIndexedVariables();
        if (!this.indexedVariables.contains(variable)) {
            this.indexedVariables.add(variable);
        }
    }

    public void addIndexedVariables(Collection<String> variables) {
        this.initIndexedVariables();
        for (String s : variables) {
            if (this.indexedVariables.contains(s)) continue;
            this.indexedVariables.add(s);
        }
    }

    public int variableIndexOf(String name) {
        return this.indexedVariables != null ? this.indexedVariables.indexOf(name) : -1;
    }

    public boolean hasIndexedVariables() {
        return this.indexedVariables != null && this.indexedVariables.size() != 0;
    }

    public boolean isIndexAllocation() {
        return this.indexAllocation;
    }

    public void setIndexAllocation(boolean indexAllocation) {
        this.indexAllocation = indexAllocation;
    }

    public ParserConfiguration getParserConfiguration() {
        return this.parserConfiguration;
    }

    public Type[] getLastTypeParameters() {
        return this.lastTypeParameters;
    }

    public void setLastTypeParameters(Type[] lastTypeParameters) {
        this.lastTypeParameters = lastTypeParameters;
    }
}

