/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mvel2.CompileException;
import org.mvel2.ast.ASTNode;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.ParseTools;

public class StaticImportNode
extends ASTNode {
    private Class declaringClass;
    private String methodName;
    private transient Method method;

    public StaticImportNode(char[] expr) {
        try {
            this.name = expr;
            this.declaringClass = Thread.currentThread().getContextClassLoader().loadClass(new String(ParseTools.subset(expr, 0, ArrayTools.findLast('.', expr))));
            this.methodName = new String(ParseTools.subset(expr, ArrayTools.findLast('.', expr) + 1));
            if (this.resolveMethod() == null) {
                throw new CompileException("can not find method for static import: " + this.declaringClass.getName() + "." + this.methodName);
            }
        }
        catch (Exception e) {
            throw new CompileException("unable to import class", e);
        }
    }

    private Method resolveMethod() {
        for (Method meth : this.declaringClass.getMethods()) {
            if (!Modifier.isStatic(meth.getModifiers()) || !this.methodName.equals(meth.getName())) continue;
            this.method = meth;
            return this.method;
        }
        return null;
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.method == null) {
            this.method = this.resolveMethod();
        }
        factory.createVariable(this.methodName, this.method);
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }
}

