/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvel2.CompileException;
import org.mvel2.ConversionException;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.OptimizationFailure;
import org.mvel2.PropertyAccessException;
import org.mvel2.ast.Function;
import org.mvel2.ast.TypeDescriptor;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.MethodStub;
import org.mvel2.util.ParseTools;
import org.mvel2.util.PropertyTools;
import org.mvel2.util.StringAppender;

public class PropertyAccessor {
    private int start = 0;
    private int cursor = 0;
    private char[] property;
    private int length;
    private Object thisReference;
    private Object ctx;
    private Object curr;
    private boolean first = true;
    private boolean nullHandle = false;
    private VariableResolverFactory variableFactory;
    private static final int DONE = -1;
    private static final int NORM = 0;
    private static final int METH = 1;
    private static final int COL = 2;
    private static final int WITH = 3;
    private static final Object[] EMPTYARG = new Object[0];
    private static final WeakHashMap<Class, WeakHashMap<Integer, Member>> READ_PROPERTY_RESOLVER_CACHE = new WeakHashMap(10);
    private static final WeakHashMap<Class, WeakHashMap<Integer, Member>> WRITE_PROPERTY_RESOLVER_CACHE = new WeakHashMap(10);
    private static final WeakHashMap<Class, WeakHashMap<Integer, Object[]>> METHOD_RESOLVER_CACHE = new WeakHashMap(10);

    public PropertyAccessor(char[] property, Object ctx) {
        this.property = property;
        this.length = property.length;
        this.ctx = ctx;
    }

    public PropertyAccessor(char[] property, Object ctx, VariableResolverFactory resolver, Object thisReference) {
        this.property = property;
        this.length = property.length;
        this.ctx = ctx;
        this.variableFactory = resolver;
        this.thisReference = thisReference;
    }

    public PropertyAccessor(char[] property, Object ctx, Object thisRef, VariableResolverFactory resolver, Object thisReference) {
        this.property = property;
        this.length = property.length;
        this.ctx = ctx;
        this.thisReference = thisRef;
        this.variableFactory = resolver;
        this.thisReference = thisReference;
    }

    public PropertyAccessor(VariableResolverFactory resolver, Object thisReference) {
        this.variableFactory = resolver;
        this.thisReference = thisReference;
    }

    public PropertyAccessor(char[] property, int offset, int end, Object ctx, VariableResolverFactory resolver) {
        this.property = property;
        this.cursor = offset;
        this.length = end;
        this.ctx = ctx;
        this.variableFactory = resolver;
    }

    public PropertyAccessor(String property, Object ctx) {
        this.property = property.toCharArray();
        this.length = this.property.length;
        this.ctx = ctx;
    }

    public static Object get(String property, Object ctx) {
        return new PropertyAccessor(property, ctx).get();
    }

    public static Object get(char[] property, Object ctx, VariableResolverFactory resolver, Object thisReference) {
        return new PropertyAccessor(property, ctx, resolver, thisReference).get();
    }

    public static Object get(char[] property, int offset, int end, Object ctx, VariableResolverFactory resolver) {
        return new PropertyAccessor(property, offset, end, ctx, resolver).get();
    }

    public static Object get(String property, Object ctx, VariableResolverFactory resolver, Object thisReference) {
        return new PropertyAccessor(property.toCharArray(), ctx, resolver, thisReference).get();
    }

    public static void set(Object ctx, String property, Object value) {
        new PropertyAccessor(property, ctx).set(value);
    }

    public static void set(Object ctx, VariableResolverFactory resolver, String property, Object value) {
        new PropertyAccessor(property.toCharArray(), ctx, resolver, null).set(value);
    }

    private Object get() {
        this.curr = this.ctx;
        try {
            while (this.cursor < this.length) {
                switch (this.nextToken()) {
                    case 0: {
                        this.curr = this.getBeanProperty(this.curr, this.capture());
                        break;
                    }
                    case 1: {
                        this.curr = this.getMethod(this.curr, this.capture());
                        break;
                    }
                    case 2: {
                        this.curr = this.getCollectionProperty(this.curr, this.capture());
                        break;
                    }
                    case 3: {
                        this.curr = this.getWithProperty(this.curr);
                        break;
                    }
                }
                if (this.nullHandle) {
                    if (this.curr == null) {
                        return null;
                    }
                    this.nullHandle = false;
                }
                this.first = false;
            }
            return this.curr;
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException("could not access property", e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException("could not access property", e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyAccessException("array or collections index out of bounds in property: " + new String(this.property), e);
        }
        catch (PropertyAccessException e) {
            throw new PropertyAccessException("failed to access property: " + new String(this.property) + ": " + e.getMessage(), e);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw new PropertyAccessException("null pointer exception in property: " + new String(this.property), e);
        }
        catch (Exception e) {
            throw new PropertyAccessException("unknown exception in expression: " + new String(this.property), e);
        }
    }

    private void set(Object value) {
        block22: {
            this.curr = this.ctx;
            try {
                int oLength = this.length;
                this.length = ParseTools.findAbsoluteLast(this.property);
                this.curr = this.get();
                if (this.curr == null) {
                    throw new PropertyAccessException("cannot bind to null context: " + new String(this.property));
                }
                this.length = oLength;
                if (this.nextToken() == 2) {
                    int start = ++this.cursor;
                    this.whiteSpaceSkip();
                    if (this.cursor == this.length || this.scanTo(']')) {
                        throw new PropertyAccessException("unterminated '['");
                    }
                    String ex = new String(this.property, start, this.cursor - start);
                    if (this.curr instanceof Map) {
                        ((Map)this.curr).put(MVEL.eval(ex, this.ctx, this.variableFactory), value);
                    } else if (this.curr instanceof List) {
                        ((List)this.curr).set(MVEL.eval(ex, this.ctx, this.variableFactory, Integer.class), value);
                    } else if (this.curr.getClass().isArray()) {
                        Array.set(this.curr, MVEL.eval(ex, this.ctx, this.variableFactory, Integer.class), DataConversion.convert(value, ParseTools.getBaseComponentType(this.curr.getClass())));
                    } else {
                        throw new PropertyAccessException("cannot bind to collection property: " + new String(this.property) + ": not a recognized collection type: " + this.ctx.getClass());
                    }
                    return;
                }
                String tk = this.capture();
                Member member = PropertyAccessor.checkWriteCache(this.curr.getClass(), tk == null ? 0 : tk.hashCode());
                if (member == null) {
                    member = value != null ? PropertyTools.getFieldOrWriteAccessor(this.curr.getClass(), tk, value.getClass()) : PropertyTools.getFieldOrWriteAccessor(this.curr.getClass(), tk);
                    PropertyAccessor.addWriteCache(this.curr.getClass(), tk.hashCode(), member);
                }
                if (member instanceof Method) {
                    Method meth = (Method)member;
                    if (value != null && !meth.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
                        if (!DataConversion.canConvert(meth.getParameterTypes()[0], value.getClass())) {
                            throw new ConversionException("cannot convert type: " + value.getClass() + ": to " + meth.getParameterTypes()[0]);
                        }
                        meth.invoke(this.curr, DataConversion.convert(value, meth.getParameterTypes()[0]));
                    } else {
                        meth.invoke(this.curr, value);
                    }
                    break block22;
                }
                if (member != null) {
                    Field fld = (Field)member;
                    if (value != null && !fld.getType().isAssignableFrom(value.getClass())) {
                        if (!DataConversion.canConvert(fld.getType(), value.getClass())) {
                            throw new ConversionException("cannot convert type: " + value.getClass() + ": to " + fld.getType());
                        }
                        fld.set(this.curr, DataConversion.convert(value, fld.getType()));
                    } else {
                        fld.set(this.curr, value);
                    }
                    break block22;
                }
                if (this.curr instanceof Map) {
                    ((Map)this.curr).put(MVEL.eval(tk, this.ctx, this.variableFactory), value);
                    break block22;
                }
                throw new PropertyAccessException("could not access property (" + tk + ") in: " + this.ctx.getClass().getName());
            }
            catch (InvocationTargetException e) {
                throw new PropertyAccessException("could not access property", e);
            }
            catch (IllegalAccessException e) {
                throw new PropertyAccessException("could not access property", e);
            }
        }
    }

    private int nextToken() {
        this.start = this.cursor;
        block0 : switch (this.property[this.start]) {
            case '[': {
                return 2;
            }
            case '.': {
                while (this.cursor < this.length && ParseTools.isWhitespace(this.property[this.cursor])) {
                    ++this.cursor;
                }
                if (this.start + 1 == this.length) break;
                this.cursor = ++this.start;
                switch (this.property[this.start]) {
                    case '?': {
                        this.cursor = ++this.start;
                        this.nullHandle = true;
                        break block0;
                    }
                    case '{': {
                        return 3;
                    }
                }
            }
        }
        while (this.cursor < this.length && ParseTools.isWhitespace(this.property[this.cursor])) {
            ++this.cursor;
        }
        this.start = this.cursor;
        while (++this.cursor < this.length && Character.isJavaIdentifierPart(this.property[this.cursor])) {
        }
        if (this.cursor < this.length) {
            while (ParseTools.isWhitespace(this.property[this.cursor])) {
                ++this.cursor;
            }
            switch (this.property[this.cursor]) {
                case '[': {
                    return 2;
                }
                case '(': {
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    private String capture() {
        return new String(this.property, this.start, this.trimLeft(this.cursor) - this.start);
    }

    protected int trimLeft(int pos) {
        while (pos > 0 && ParseTools.isWhitespace(this.property[pos - 1])) {
            --pos;
        }
        return pos;
    }

    public static void clearPropertyResolverCache() {
        READ_PROPERTY_RESOLVER_CACHE.clear();
        WRITE_PROPERTY_RESOLVER_CACHE.clear();
        METHOD_RESOLVER_CACHE.clear();
    }

    public static void reportCacheSizes() {
        System.out.println("read property cache: " + READ_PROPERTY_RESOLVER_CACHE.size());
        for (Class cls : READ_PROPERTY_RESOLVER_CACHE.keySet()) {
            System.out.println(" [" + cls.getName() + "]: " + READ_PROPERTY_RESOLVER_CACHE.get(cls).size() + " entries.");
        }
        System.out.println("write property cache: " + WRITE_PROPERTY_RESOLVER_CACHE.size());
        for (Class cls : WRITE_PROPERTY_RESOLVER_CACHE.keySet()) {
            System.out.println(" [" + cls.getName() + "]: " + WRITE_PROPERTY_RESOLVER_CACHE.get(cls).size() + " entries.");
        }
        System.out.println("method cache: " + METHOD_RESOLVER_CACHE.size());
        for (Class cls : METHOD_RESOLVER_CACHE.keySet()) {
            System.out.println(" [" + cls.getName() + "]: " + METHOD_RESOLVER_CACHE.get(cls).size() + " entries.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addReadCache(Class cls, Integer property, Member member) {
        WeakHashMap<Class, WeakHashMap<Integer, Member>> weakHashMap = READ_PROPERTY_RESOLVER_CACHE;
        synchronized (weakHashMap) {
            WeakHashMap<Integer, Member> nestedMap = READ_PROPERTY_RESOLVER_CACHE.get(cls);
            if (nestedMap == null) {
                nestedMap = new WeakHashMap();
                READ_PROPERTY_RESOLVER_CACHE.put(cls, nestedMap);
            }
            nestedMap.put(property, member);
        }
    }

    private static Member checkReadCache(Class cls, Integer property) {
        WeakHashMap<Integer, Member> map = READ_PROPERTY_RESOLVER_CACHE.get(cls);
        if (map != null) {
            return map.get(property);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addWriteCache(Class cls, Integer property, Member member) {
        WeakHashMap<Class, WeakHashMap<Integer, Member>> weakHashMap = WRITE_PROPERTY_RESOLVER_CACHE;
        synchronized (weakHashMap) {
            WeakHashMap<Integer, Member> map = WRITE_PROPERTY_RESOLVER_CACHE.get(cls);
            if (map == null) {
                map = new WeakHashMap();
                WRITE_PROPERTY_RESOLVER_CACHE.put(cls, map);
            }
            map.put(property, member);
        }
    }

    private static Member checkWriteCache(Class cls, Integer property) {
        Map map = WRITE_PROPERTY_RESOLVER_CACHE.get(cls);
        if (map != null) {
            return (Member)map.get(property);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addMethodCache(Class cls, Integer property, Method member) {
        WeakHashMap<Class, WeakHashMap<Integer, Object[]>> weakHashMap = METHOD_RESOLVER_CACHE;
        synchronized (weakHashMap) {
            WeakHashMap<Integer, Object> map = METHOD_RESOLVER_CACHE.get(cls);
            if (map == null) {
                map = new WeakHashMap();
                METHOD_RESOLVER_CACHE.put(cls, map);
            }
            map.put(property, new Object[]{member, member.getParameterTypes()});
        }
    }

    private static Object[] checkMethodCache(Class cls, Integer property) {
        Map map = METHOD_RESOLVER_CACHE.get(cls);
        if (map != null) {
            return (Object[])map.get(property);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getBeanProperty(Object ctx, String property) throws IllegalAccessException, InvocationTargetException {
        Object tryStatic;
        if (this.first) {
            if ("this".equals(property)) {
                return this.ctx;
            }
            if (AbstractParser.LITERALS.containsKey(property)) {
                return AbstractParser.LITERALS.get(property);
            }
            if (this.variableFactory != null && this.variableFactory.isResolveable(property)) {
                return this.variableFactory.getVariableResolver(property).getValue();
            }
        }
        if (ctx != null) {
            Class<?> cls = ctx instanceof Class ? (Class<?>)ctx : ctx.getClass();
            Member member = PropertyAccessor.checkReadCache(cls, property.hashCode());
            if (member == null) {
                member = PropertyTools.getFieldOrAccessor(cls, property);
                PropertyAccessor.addReadCache(cls, property.hashCode(), member);
            }
            if (member instanceof Method) {
                try {
                    return ((Method)member).invoke(ctx, EMPTYARG);
                }
                catch (IllegalAccessException e) {
                    Member member2 = member;
                    synchronized (member2) {
                        Object object;
                        try {
                            ((Method)member).setAccessible(true);
                            object = ((Method)member).invoke(ctx, EMPTYARG);
                            ((Method)member).setAccessible(false);
                        }
                        catch (Throwable throwable) {
                            ((Method)member).setAccessible(false);
                            throw throwable;
                        }
                        return object;
                    }
                }
            }
            if (member != null) {
                return ((Field)member).get(ctx);
            }
            if (ctx instanceof Map && ((Map)ctx).containsKey(property)) {
                return ((Map)ctx).get(property);
            }
            if ("length".equals(property) && ctx.getClass().isArray()) {
                return Array.getLength(ctx);
            }
            if (ctx instanceof Class) {
                Class c = (Class)ctx;
                for (Method m : c.getMethods()) {
                    if (!property.equals(m.getName())) continue;
                    if (MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL) {
                        return m.invoke(ctx, ParseTools.EMPTY_OBJ_ARR);
                    }
                    return m;
                }
            } else if (PropertyHandlerFactory.hasPropertyHandler(cls)) {
                return PropertyHandlerFactory.getPropertyHandler(cls).getProperty(property, ctx, this.variableFactory);
            }
        }
        if ((tryStatic = this.tryStaticAccess()) != null) {
            if (tryStatic instanceof Class || tryStatic instanceof Method) {
                return tryStatic;
            }
            return ((Field)tryStatic).get(null);
        }
        throw new PropertyAccessException("could not access property: " + property);
    }

    private void whiteSpaceSkip() {
        if (this.cursor < this.length) {
            while (ParseTools.isWhitespace(this.property[this.cursor]) && ++this.cursor < this.length) {
            }
        }
    }

    private boolean scanTo(char c) {
        while (this.cursor < this.length) {
            if (this.property[this.cursor] == c) {
                return false;
            }
            ++this.cursor;
        }
        return true;
    }

    private Object getWithProperty(Object ctx) {
        ParseTools.WithStatementPair[] pvp;
        String root = new String(this.property, 0, this.cursor - 1).trim();
        int start = this.cursor + 1;
        int[] res = ParseTools.balancedCaptureWithLineAccounting(this.property, this.cursor, '{');
        this.cursor = res[0];
        for (ParseTools.WithStatementPair aPvp : pvp = ParseTools.parseWithExpressions(root, ParseTools.subset(this.property, start, this.cursor++ - start))) {
            if (aPvp.getParm() == null) {
                MVEL.eval(aPvp.getValue(), ctx, this.variableFactory);
                continue;
            }
            MVEL.setProperty(ctx, aPvp.getParm(), MVEL.eval(aPvp.getValue(), ctx, this.variableFactory));
        }
        return ctx;
    }

    private Object getCollectionProperty(Object ctx, String prop) throws Exception {
        if (prop.length() != 0) {
            ctx = this.getBeanProperty(ctx, prop);
        }
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length || this.scanTo(']')) {
            throw new PropertyAccessException("unterminated '['");
        }
        prop = new String(this.property, start, this.cursor++ - start);
        if (ctx instanceof Map) {
            return ((Map)ctx).get(MVEL.eval(prop, ctx, this.variableFactory));
        }
        if (ctx instanceof List) {
            return ((List)ctx).get((Integer)MVEL.eval(prop, ctx, this.variableFactory));
        }
        if (ctx instanceof Collection) {
            int count = (Integer)MVEL.eval(prop, ctx, this.variableFactory);
            if (count > ((Collection)ctx).size()) {
                throw new PropertyAccessException("index [" + count + "] out of bounds on collections");
            }
            Iterator iter = ((Collection)ctx).iterator();
            for (int i = 0; i < count; ++i) {
                iter.next();
            }
            return iter.next();
        }
        if (ctx.getClass().isArray()) {
            return Array.get(ctx, (Integer)MVEL.eval(prop, ctx, this.variableFactory));
        }
        if (ctx instanceof CharSequence) {
            return Character.valueOf(((CharSequence)ctx).charAt((Integer)MVEL.eval(prop, ctx, this.variableFactory)));
        }
        TypeDescriptor td = new TypeDescriptor(this.property, 0);
        try {
            return TypeDescriptor.getClassReference(AbstractParser.getCurrentThreadParserContext(), td);
        }
        catch (Exception e) {
            throw new PropertyAccessException("illegal use of []: unknown type: " + (ctx == null ? null : ctx.getClass().getName()));
        }
    }

    private Object getMethod(Object ctx, String name) throws Exception {
        Class[] parameterTypes;
        Method m;
        Class<?> cls;
        Object[] cache;
        Object[] args;
        int st = this.cursor;
        this.cursor = ParseTools.balancedCapture(this.property, this.cursor, '(');
        String tk = this.cursor - st > 1 ? new String(this.property, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() == 0) {
            args = ParseTools.EMPTY_OBJ_ARR;
        } else {
            String[] subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            args = new Object[subtokens.length];
            for (int i = 0; i < subtokens.length; ++i) {
                args[i] = MVEL.eval(subtokens[i], this.thisReference, this.variableFactory);
            }
        }
        if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(name)) {
            Object ptr = this.variableFactory.getVariableResolver(name).getValue();
            if (ptr instanceof Method) {
                ctx = ((Method)ptr).getDeclaringClass();
                name = ((Method)ptr).getName();
            } else if (ptr instanceof MethodStub) {
                ctx = ((MethodStub)ptr).getClassReference();
                name = ((MethodStub)ptr).getMethodName();
            } else {
                if (ptr instanceof Function) {
                    ((Function)ptr).checkArgumentCount(args.length);
                    return ((Function)ptr).call(ctx, this.thisReference, this.variableFactory, args);
                }
                throw new OptimizationFailure("attempt to optimize a method call for a reference that does not point to a method: " + name + " (reference is type: " + (ctx != null ? ctx.getClass().getName() : null) + ")");
            }
            this.first = false;
        }
        if ((cache = PropertyAccessor.checkMethodCache(cls = ctx instanceof Class ? (Class<?>)ctx : ctx.getClass(), PropertyAccessor.createSignature(name, tk))) != null) {
            m = (Method)cache[0];
            parameterTypes = (Class[])cache[1];
        } else {
            m = null;
            parameterTypes = null;
        }
        if (m == null) {
            m = ParseTools.getBestCandidate(args, name, cls, cls.getMethods(), false);
            if (m != null) {
                PropertyAccessor.addMethodCache(cls, PropertyAccessor.createSignature(name, tk), m);
                parameterTypes = m.getParameterTypes();
            }
            if (m == null && (m = ParseTools.getBestCandidate(args, name, cls, cls.getClass().getDeclaredMethods(), false)) != null) {
                PropertyAccessor.addMethodCache(cls, PropertyAccessor.createSignature(name, tk), m);
                parameterTypes = m.getParameterTypes();
            }
        }
        if (m == null) {
            StringAppender errorBuild = new StringAppender();
            for (int i = 0; i < args.length; ++i) {
                errorBuild.append(args[i] != null ? args[i].getClass().getName() : null);
                if (i >= args.length - 1) continue;
                errorBuild.append(", ");
            }
            if ("size".equals(name) && args.length == 0 && cls.isArray()) {
                return Array.getLength(ctx);
            }
            throw new PropertyAccessException("unable to resolve method: " + cls.getName() + "." + name + "(" + errorBuild.toString() + ") [arglength=" + args.length + "]");
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = DataConversion.convert(args[i], parameterTypes[i]);
        }
        try {
            return m.invoke((Object)ctx, args);
        }
        catch (IllegalAccessException e) {
            try {
                m = ParseTools.getWidenedTarget(m);
                PropertyAccessor.addMethodCache(cls, PropertyAccessor.createSignature(name, tk), m);
                return m.invoke((Object)ctx, args);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    private static int createSignature(String name, String args) {
        return name.hashCode() + args.hashCode();
    }

    public int getCursorPosition() {
        return this.cursor;
    }

    protected Object tryStaticAccess() {
        int begin = this.cursor;
        try {
            boolean meth = false;
            int last = this.length;
            block17: for (int i = this.length - 1; i > 0; --i) {
                switch (this.property[i]) {
                    case '.': {
                        if (!meth) {
                            try {
                                this.cursor = last;
                                return Thread.currentThread().getContextClassLoader().loadClass(new String(this.property, 0, this.cursor));
                            }
                            catch (ClassNotFoundException e) {
                                Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(new String(this.property, 0, i));
                                String name = new String(this.property, i + 1, this.property.length - i - 1);
                                try {
                                    return cls.getField(name);
                                }
                                catch (NoSuchFieldException nfe) {
                                    for (Method m : cls.getMethods()) {
                                        if (!name.equals(m.getName())) continue;
                                        return m;
                                    }
                                    return null;
                                }
                            }
                        }
                        meth = false;
                        last = i;
                        continue block17;
                    }
                    case ')': {
                        --i;
                        int d = 1;
                        while (i > 0 && d != 0) {
                            switch (this.property[i]) {
                                case ')': {
                                    ++d;
                                    break;
                                }
                                case '(': {
                                    --d;
                                    break;
                                }
                                case '\"': 
                                case '\'': {
                                    char s = this.property[i];
                                    while (i > 0 && this.property[i] != s && this.property[i - 1] != '\\') {
                                        --i;
                                    }
                                    break;
                                }
                            }
                            --i;
                        }
                        meth = true;
                        last = i++;
                        continue block17;
                    }
                    case '\'': {
                        while (--i > 0 && (this.property[i] != '\'' || this.property[i - 1] == '\\')) {
                        }
                        continue block17;
                    }
                    case '\"': {
                        while (--i > 0 && (this.property[i] != '\"' || this.property[i - 1] == '\\')) {
                        }
                        continue block17;
                    }
                }
            }
        }
        catch (Exception cnfe) {
            this.cursor = begin;
        }
        return null;
    }
}

