/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.io.Serializable;
import java.util.ArrayList;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.ast.BlockNode;
import org.mvel2.ast.NestedStatement;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;
import org.mvel2.util.PropertyTools;
import org.mvel2.util.StringAppender;

public class WithNode
extends BlockNode
implements NestedStatement {
    protected String nestParm;
    protected ExecutableStatement nestedStatement;
    protected ParmValuePair[] withExpressions;

    public WithNode(char[] expr, char[] block, int fields, ParserContext pCtx) {
        this.name = expr;
        this.block = block;
        if ((fields & 0x10) != 0) {
            pCtx.setBlockSymbols(true);
        }
        this.nestParm = ParseTools.createStringTrimmed(expr);
        this.nestedStatement = (ExecutableStatement)ParseTools.subCompileExpression(this.nestParm.toCharArray());
        this.egressType = this.nestedStatement.getKnownEgressType();
        this.compileWithExpressions(pCtx);
        if (pCtx != null) {
            pCtx.setBlockSymbols(false);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object ctxObject = this.nestedStatement.getValue(ctx, thisValue, factory);
        if (ctxObject == null) {
            throw new CompileException("with-block against null pointer");
        }
        for (ParmValuePair pvp : this.withExpressions) {
            if (pvp.getSetExpression() != null) {
                MVEL.executeSetExpression(pvp.getSetExpression(), ctxObject, factory, pvp.getStatement().getValue(ctx, thisValue, factory));
                continue;
            }
            pvp.getStatement().getValue(ctxObject, ctxObject, factory);
        }
        return ctxObject;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    private void compileWithExpressions(ParserContext pCtx) {
        ArrayList<ParmValuePair> parms = new ArrayList<ParmValuePair>();
        String parm = "";
        int start = 0;
        int end = -1;
        int oper = -1;
        block12: for (int i = 0; i < this.block.length; ++i) {
            switch (this.block[i]) {
                case '(': 
                case '[': 
                case '{': {
                    i = ParseTools.balancedCapture(this.block, i, this.block[i]);
                    continue block12;
                }
                case '*': {
                    if (i >= this.block.length || this.block[i + 1] != '=') continue block12;
                    oper = 2;
                    continue block12;
                }
                case '/': {
                    if (i < this.block.length && this.block[i + 1] == '/') {
                        end = i;
                        while (i < this.block.length && this.block[i] != '\n') {
                            ++i;
                        }
                        if (parm != null) continue block12;
                        start = i;
                        continue block12;
                    }
                    if (i < this.block.length && this.block[i + 1] == '*') {
                        end = i;
                        while (i < this.block.length) {
                            switch (this.block[i++]) {
                                case '*': {
                                    if (i < this.block.length && this.block[i] != '/') break;
                                }
                            }
                        }
                        if (parm != null) continue block12;
                        start = i;
                        continue block12;
                    }
                    if (i >= this.block.length || this.block[i + 1] != '=') continue block12;
                    oper = 3;
                    continue block12;
                }
                case '-': {
                    if (i >= this.block.length || this.block[i + 1] != '=') continue block12;
                    oper = 1;
                    continue block12;
                }
                case '+': {
                    if (i >= this.block.length || this.block[i + 1] != '=') continue block12;
                    oper = 0;
                    continue block12;
                }
                case '=': {
                    parm = ParseTools.createStringTrimmed(this.block, start, i - start - (oper != -1 ? 1 : 0));
                    start = ++i;
                    continue block12;
                }
                case ',': {
                    if (end == -1) {
                        end = i;
                    }
                    if (parm == null) {
                        parms.add(new ParmValuePair(null, (ExecutableStatement)ParseTools.subCompileExpression(new StringAppender(this.nestParm).append('.').append(ParseTools.subset(this.block, start, end - start)).toChars()), this.egressType, pCtx));
                        oper = -1;
                        start = ++i;
                    } else {
                        parms.add(new ParmValuePair(parm, (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.createShortFormOperativeAssignment(this.nestParm + "." + parm, ParseTools.subset(this.block, start, end - start), oper)), this.egressType, pCtx));
                        parm = null;
                        oper = -1;
                        start = ++i;
                    }
                    end = -1;
                }
            }
        }
        end = this.block.length;
        if (start != end) {
            if (parm == null) {
                parms.add(new ParmValuePair(null, (ExecutableStatement)ParseTools.subCompileExpression(new StringAppender(this.nestParm).append('.').append(ParseTools.subset(this.block, start, end - start)).toChars()), this.egressType, pCtx));
            } else {
                parms.add(new ParmValuePair(parm, (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.createShortFormOperativeAssignment(this.nestParm + "." + parm, ParseTools.subset(this.block, start, end - start), oper)), this.egressType, pCtx));
            }
        }
        this.withExpressions = new ParmValuePair[parms.size()];
        parms.toArray(this.withExpressions);
    }

    public ExecutableStatement getNestedStatement() {
        return this.nestedStatement;
    }

    public ParmValuePair[] getWithExpressions() {
        return this.withExpressions;
    }

    public static final class ParmValuePair
    implements Serializable {
        private Serializable setExpression;
        private ExecutableStatement statement;

        public ParmValuePair() {
        }

        public ParmValuePair(String parameter, ExecutableStatement statement, Class ingressType, ParserContext pCtx) {
            if (parameter != null && parameter.length() != 0) {
                this.setExpression = MVEL.compileSetExpression(parameter, ingressType != null ? PropertyTools.getReturnType(ingressType, parameter, pCtx) : Object.class, pCtx);
            }
            this.statement = statement;
        }

        public Serializable getSetExpression() {
            return this.setExpression;
        }

        public void setSetExpression(Serializable setExpression) {
            this.setExpression = setExpression;
        }

        public ExecutableStatement getStatement() {
            return this.statement;
        }

        public void setStatement(ExecutableStatement statement) {
            this.statement = statement;
        }
    }
}

