/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.Operator;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.And;
import org.mvel2.ast.BinaryOperation;
import org.mvel2.ast.Contains;
import org.mvel2.ast.Convertable;
import org.mvel2.ast.DeclTypedVarNode;
import org.mvel2.ast.Function;
import org.mvel2.ast.Instance;
import org.mvel2.ast.LiteralNode;
import org.mvel2.ast.Or;
import org.mvel2.ast.RegExMatchNode;
import org.mvel2.ast.Soundslike;
import org.mvel2.ast.Strsim;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.Accessor;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableAccessor;
import org.mvel2.compiler.ExecutableLiteral;
import org.mvel2.util.ASTLinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerTools {
    public static ASTLinkedList optimizeAST(ASTLinkedList astLinkedList, boolean secondPassOptimization, ParserContext ctx) {
        ASTNode tkOp2;
        ASTNode tkOp;
        ASTNode tk;
        ASTLinkedList optimizedAst = new ASTLinkedList();
        while (astLinkedList.hasMoreNodes()) {
            tk = astLinkedList.nextNode();
            if (tk.getFields() == -1) {
                optimizedAst.addTokenNode(tk);
                continue;
            }
            if (astLinkedList.hasMoreNodes()) {
                tkOp = astLinkedList.nextNode();
                if (tkOp.getFields() == -1) {
                    optimizedAst.addTokenNode(tk, tkOp);
                    continue;
                }
                if (tkOp.isOperator() && tkOp.getOperator() < 21) {
                    int op2;
                    int op = tkOp.getOperator();
                    if (op == -1) {
                        throw new CompileException("illegal use of operator: " + tkOp.getName());
                    }
                    BinaryOperation bo = new BinaryOperation(op, tk, astLinkedList.nextNode(), ctx);
                    tkOp2 = null;
                    while (astLinkedList.hasMoreNodes() && (tkOp2 = astLinkedList.nextNode()).isOperator() && tkOp2.getFields() != -1 && (op2 = tkOp2.getOperator().intValue()) != -1 && op2 < 21) {
                        if (Operator.PTABLE[op2] > Operator.PTABLE[op]) {
                            bo.setRightMost(new BinaryOperation(op2, bo.getRightMost(), astLinkedList.nextNode(), ctx));
                        } else if (bo.getOperation() != op2 && Operator.PTABLE[op] == Operator.PTABLE[op2]) {
                            if (Operator.PTABLE[bo.getOperation()] == Operator.PTABLE[op2]) {
                                bo = new BinaryOperation(op2, bo, astLinkedList.nextNode(), ctx);
                            } else {
                                bo.setRight(new BinaryOperation(op2, bo.getRight(), astLinkedList.nextNode(), ctx));
                            }
                        } else if (Operator.PTABLE[bo.getOperation()] >= Operator.PTABLE[op2]) {
                            bo = new BinaryOperation(op2, bo, astLinkedList.nextNode(), ctx);
                        } else {
                            bo.setRight(new BinaryOperation(op2, bo.getRight(), astLinkedList.nextNode(), ctx));
                        }
                        op = op2;
                        tkOp = tkOp2;
                    }
                    if (tkOp2 != null && tkOp2 != tkOp) {
                        CompilerTools.optimizeOperator(tkOp2.getOperator(), bo, tkOp2, astLinkedList, optimizedAst);
                        continue;
                    }
                    optimizedAst.addTokenNode(bo);
                    continue;
                }
                if (!tkOp.isOperator() && tk.getLiteralValue() instanceof Class) {
                    optimizedAst.addTokenNode(new DeclTypedVarNode(tkOp.getName(), (Class)tk.getLiteralValue(), 0, ctx));
                    continue;
                }
                if (tkOp.isOperator()) {
                    CompilerTools.optimizeOperator(tkOp.getOperator(), tk, tkOp, astLinkedList, optimizedAst);
                    continue;
                }
                optimizedAst.addTokenNode(tk, tkOp);
                continue;
            }
            optimizedAst.addTokenNode(tk);
        }
        if (secondPassOptimization) {
            astLinkedList = optimizedAst;
            astLinkedList.reset();
            optimizedAst = new ASTLinkedList();
            while (astLinkedList.hasMoreNodes()) {
                tk = astLinkedList.nextNode();
                if (tk.getFields() == -1) {
                    optimizedAst.addTokenNode(tk);
                    continue;
                }
                if (astLinkedList.hasMoreNodes()) {
                    tkOp = astLinkedList.nextNode();
                    if (tkOp.getFields() == -1) {
                        optimizedAst.addTokenNode(tk, tkOp);
                        continue;
                    }
                    if (tkOp.isOperator() && (tkOp.getOperator() == 21 || tkOp.getOperator() == 22)) {
                        tkOp2 = null;
                        ASTNode bool = null;
                        switch (tkOp.getOperator()) {
                            case 21: {
                                bool = new And(tk, astLinkedList.nextNode(), ctx.isStrongTyping());
                                break;
                            }
                            case 22: {
                                bool = new Or(tk, astLinkedList.nextNode(), ctx.isStrongTyping());
                            }
                        }
                        while (astLinkedList.hasMoreNodes() && (tkOp2 = astLinkedList.nextNode()).isOperator() && (tkOp2.isOperator(21) || tkOp2.isOperator(22))) {
                            tkOp = tkOp2;
                            switch (tkOp.getOperator()) {
                                case 21: {
                                    bool = new And(bool, astLinkedList.nextNode(), ctx.isStrongTyping());
                                    break;
                                }
                                case 22: {
                                    bool = new Or(bool, astLinkedList.nextNode(), ctx.isStrongTyping());
                                }
                            }
                        }
                        optimizedAst.addTokenNode(bool);
                        if (tkOp2 == null || tkOp2 == tkOp) continue;
                        optimizedAst.addTokenNode(tkOp2);
                        continue;
                    }
                    optimizedAst.addTokenNode(tk, tkOp);
                    continue;
                }
                optimizedAst.addTokenNode(tk);
            }
        }
        return optimizedAst;
    }

    private static void optimizeOperator(int operator, ASTNode tk, ASTNode tkOp, ASTLinkedList astLinkedList, ASTLinkedList optimizedAst) {
        switch (operator) {
            case 24: {
                optimizedAst.addTokenNode(new RegExMatchNode(tk, astLinkedList.nextNode()));
                break;
            }
            case 26: {
                optimizedAst.addTokenNode(new Contains(tk, astLinkedList.nextNode()));
                break;
            }
            case 25: {
                optimizedAst.addTokenNode(new Instance(tk, astLinkedList.nextNode()));
                break;
            }
            case 36: {
                optimizedAst.addTokenNode(new Convertable(tk, astLinkedList.nextNode()));
                break;
            }
            case 28: {
                optimizedAst.addTokenNode(new Strsim(tk, astLinkedList.nextNode()));
                break;
            }
            case 27: {
                optimizedAst.addTokenNode(new Soundslike(tk, astLinkedList.nextNode()));
                break;
            }
            default: {
                optimizedAst.addTokenNode(tk, tkOp);
            }
        }
    }

    public static Map<String, Function> extractAllDeclaredFunctions(CompiledExpression compile) {
        LinkedHashMap<String, Function> allFunctions = new LinkedHashMap<String, Function>();
        ASTLinkedList instructions = new ASTLinkedList(compile.getInstructions());
        while (instructions.hasMoreNodes()) {
            ASTNode n = instructions.nextNode();
            if (!(n instanceof Function)) continue;
            allFunctions.put(n.getName(), (Function)n);
        }
        return allFunctions;
    }

    public static void expectType(Accessor expression, Class type, boolean compileMode) {
        Class retType = expression.getKnownEgressType();
        if (compileMode ? !(retType != null && type.isAssignableFrom(retType) || Object.class.equals((Object)retType) && !AbstractParser.getCurrentThreadParserContext().isStrictTypeEnforcement()) : retType == null || !Object.class.equals((Object)retType) && !type.isAssignableFrom(retType)) {
            throw new CompileException("was expecting type: " + type.getName() + "; but found type: " + (retType != null ? retType.getName() : "null"));
        }
    }

    public static void expectType(ASTNode node, Class type, boolean compileMode) {
        Class retType = node.getEgressType();
        if (compileMode ? !(retType != null && type.isAssignableFrom(retType) || !AbstractParser.getCurrentThreadParserContext().isStrictTypeEnforcement() && !AbstractParser.getCurrentThreadParserContext().isStrictTypeEnforcement()) : retType == null || !Object.class.equals((Object)retType) && !type.isAssignableFrom(retType)) {
            throw new CompileException("was expecting type: " + type.getName() + "; but found type: " + (retType != null ? retType.getName() : "null"));
        }
    }

    public static Class getReturnTypeFromOp(int operation, Class left, Class right) {
        switch (operation) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 36: {
                return Boolean.class;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return left;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return Integer.class;
            }
            case 20: {
                return String.class;
            }
        }
        return null;
    }

    public static Accessor extractAccessor(ASTNode n) {
        if (n instanceof LiteralNode) {
            return new ExecutableLiteral(n.getLiteralValue());
        }
        return new ExecutableAccessor(n, n.getEgressType());
    }
}

