/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.tests.core.AbstractTest;
import org.mvel2.util.Make;

public class ArithmeticTests
extends AbstractTest {
    public void testMath() {
        Map vars = ArithmeticTests.createTestMap();
        Serializable s = MVEL.compileExpression((String)"pi * hour");
        ArithmeticTests.assertEquals((Object)188, (Object)MVEL.executeExpression((Object)s, (Map)vars));
    }

    public void testMath2() {
        ArithmeticTests.assertEquals((Object)3, (Object)this.test("foo.number-1"));
    }

    public void testMath3() {
        ArithmeticTests.assertEquals((Object)33.333333333333336, (Object)this.test("(10 * 5) * 2 / 3"));
    }

    public void testMath4() {
        double val = 19.0;
        ArithmeticTests.assertEquals((Object)val, (Object)this.test("(100 % 3) * 2 - 1 / 1 + 8 + (5 * 2)"));
    }

    public void testMath4a() {
        String expression = "(100 % 90) * 20 - 15 / 16 + 80 + (50 * 21)";
        System.out.println("Expression: " + expression);
        ArithmeticTests.assertEquals((Object)1329.0625, (Object)MVEL.eval((String)expression));
    }

    public void testMath5() {
        ArithmeticTests.assertEquals((Object)17.999401018268944, (Object)this.test("300.5 / 5.3 / 2.1 / 1.5"));
    }

    public void testMath5a() {
        String expression = "300.5 / 5.3 / 2.1 / 1.5";
        System.out.println("Expression: " + expression);
        ArithmeticTests.assertEquals((Object)17.999401018268944, (Object)MVEL.eval((String)expression));
    }

    public void testMath6() {
        double val = 1601.0;
        String expression = "(300 * five + 1) + (100 / 2 * 2)";
        System.out.println(">>" + expression + "<<");
        Map vars = ArithmeticTests.createTestMap();
        ArithmeticTests.assertEquals((Object)val, (Object)MVEL.eval((String)expression, (Map)vars));
        Serializable s = MVEL.compileExpression((String)expression);
        ArithmeticTests.assertEquals((Object)val, (Object)MVEL.executeExpression((Object)s, (Map)vars));
    }

    public void testMath7() {
        double val = 19.0;
        ArithmeticTests.assertEquals((Object)val, (Object)this.test("(100 % 3) * 2 - 1 / 1 + 8 + (5 * 2)"));
    }

    public void testMath8() {
        double val = 15134.28;
        ArithmeticTests.assertEquals((Object)val, (Object)this.test("5 * (100.56 * 30.1)"));
    }

    public void testPowerOf() {
        ArithmeticTests.assertEquals((Object)25, (Object)this.test("5 ** 2"));
    }

    public void testSignOperator() {
        String expr = "int x = 15; -x";
        HashMap vars = new HashMap();
        vars.clear();
        Serializable s = MVEL.compileExpression((String)expr);
        ArithmeticTests.assertEquals((Object)-15, (Object)MVEL.executeExpression((Object)s, vars));
    }

    public void testMath14() {
        ArithmeticTests.assertEquals((Object)36, (Object)this.test("10-5*2 + 5*8-4"));
    }

    public void testMath15() {
        String ex = "100-500*200 + 500*800-400";
        ArithmeticTests.assertEquals((Object)299700, (Object)this.test(ex));
    }

    public void testMath16() {
        String ex = "100-500*200*150 + 500*800-400";
        ArithmeticTests.assertEquals((Object)-14600300, (Object)this.test(ex));
    }

    public void testMath17() {
        String ex = "(100d * 50d) * 20d / 30d * 2d";
        Object o = this.test(ex);
        ArithmeticTests.assertEquals((Object)6666.666666666667, (Object)o);
    }

    public void testMath18() {
        String ex = "a = 100d; b = 50d; c = 20d; d = 30d; e = 2d; (a * b) * c / d * e";
        System.out.println("Expression: " + ex);
        Serializable s = MVEL.compileExpression((String)ex);
        ArithmeticTests.assertEquals((Object)6666.666666666667, (Object)MVEL.executeExpression((Object)s, new HashMap()));
    }

    public void testMath19() {
        String ex = "a = 100; b = 500; c = 200; d = 150; e = 500; f = 800; g = 400; a-b*c*d + e*f-g";
        System.out.println("Expression: " + ex);
        ArithmeticTests.assertEquals((Object)-14600300, (Object)ArithmeticTests.testCompiledSimple(ex, new HashMap()));
    }

    public void testMath32() {
        String ex = "x = 20; y = 10; z = 5; x-y-z";
        System.out.println("Expression: " + ex);
        ArithmeticTests.assertEquals((Object)5, (Object)ArithmeticTests.testCompiledSimple(ex, new HashMap()));
    }

    public void testMath33() {
        String ex = "x = 20; y = 2; z = 2; x/y/z";
        System.out.println("Expression: " + ex);
        Serializable s = MVEL.compileExpression((String)ex);
        ArithmeticTests.assertEquals((Object)5, (Object)MVEL.executeExpression((Object)s, new HashMap()));
    }

    public void testMath20() {
        String ex = "10-5*7-3*8-6";
        System.out.println("Expression: " + ex);
        ArithmeticTests.assertEquals((Object)-55, (Object)this.test(ex));
    }

    public void testMath21() {
        String expression = "100-50*70-30*80-60";
        System.out.println("Expression: " + expression);
        ArithmeticTests.assertEquals((Object)-5860, (Object)this.test(expression));
    }

    public void testMath22() {
        String expression = "(100-50)*70-30*(20-9)**3";
        System.out.println("Expression: " + expression);
        ArithmeticTests.assertEquals((Object)((int)(3500.0 - 30.0 * Math.pow(11.0, 3.0))), (Object)this.test(expression));
    }

    public void testMath22b() {
        String expression = "a = 100; b = 50; c = 70; d = 30; e = 20; f = 9; g = 3; (a-b)*c-d*(e-f)**g";
        System.out.println("Expression: " + expression);
        ArithmeticTests.assertEquals((Object)((int)(3500.0 - 30.0 * Math.pow(11.0, 3.0))), (Object)ArithmeticTests.testCompiledSimple(expression, new HashMap()));
    }

    public void testMath23() {
        String expression = "10 ** (3)*10**3";
        System.out.println("Expression: " + expression);
        ArithmeticTests.assertEquals((Object)((int)(Math.pow(10.0, 3.0) * Math.pow(10.0, 3.0))), (Object)this.test(expression));
    }

    public void testMath24() {
        String expression = "51 * 52 * 33 / 24 / 15 + 45 * 66 * 47 * 28 + 19";
        double val = 3908782.1;
        System.out.println("Expression: " + expression);
        System.out.println("Expected Result: " + val);
        ArithmeticTests.assertEquals((Object)val, (Object)this.test(expression));
    }

    public void testMath25() {
        String expression = "51 * (40 - 1000 * 50) + 100 + 50 * 20 / 10 + 11 + 12 - 80";
        double val = -2547817.0;
        System.out.println("Expression: " + expression);
        System.out.println("Expected Result: " + val);
        ArithmeticTests.assertEquals((Object)val, (Object)this.test(expression));
    }

    public void testMath26() {
        String expression = "5 + 3 * 8 * 2 ** 2";
        int val = (int)(5.0 + 24.0 * Math.pow(2.0, 2.0));
        System.out.println("Expression: " + expression);
        System.out.println("Expected Result: " + val);
        Object result = this.test(expression);
        ArithmeticTests.assertEquals((Object)val, (Object)result);
    }

    public void testMath27() {
        String expression = "50 + 30 * 80 * 20 ** 3 * 51";
        double val = 50.0 + 2400.0 * Math.pow(20.0, 3.0) * 51.0;
        System.out.println("Expression: " + expression);
        System.out.println("Expected Result: " + val);
        Object result = this.test(expression);
        ArithmeticTests.assertEquals((Object)((int)val), (Object)result);
    }

    public void testMath28() {
        String expression = "50 + 30 + 80 + 11 ** 2 ** 2 * 51";
        double val = 160.0 + Math.pow(Math.pow(11.0, 2.0), 2.0) * 51.0;
        Object result = this.test(expression);
        ArithmeticTests.assertEquals((Object)((int)val), (Object)result);
    }

    public void testMath29() {
        String expression = "10 + 20 / 4 / 4";
        System.out.println("Expression: " + expression);
        double val = 11.25;
        ArithmeticTests.assertEquals((Object)val, (Object)MVEL.eval((String)expression));
    }

    public void testMath30() {
        String expression = "40 / 20 + 10 + 60 / 21";
        System.out.println("Expression: " + expression);
        double val = 14.857142857142858;
        ArithmeticTests.assertEquals((Object)val, (Object)MVEL.eval((String)expression));
    }

    public void testMath31() {
        String expression = "40 / 20 + 5 - 4 + 8 / 2 * 2 * 6 ** 2 + 6 - 8";
        double val = 3.0 + 8.0 * Math.pow(6.0, 2.0) + 6.0 - 8.0;
        ArithmeticTests.assertEquals((Object)val, (Object)MVEL.eval((String)expression));
    }

    public void testMath34() {
        String expression = "a+b-c*d*x/y-z+10";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 200);
        map.put("b", 100);
        map.put("c", 150);
        map.put("d", 2);
        map.put("x", 400);
        map.put("y", 300);
        map.put("z", 75);
        Serializable s = MVEL.compileExpression((String)expression);
        ArithmeticTests.assertEquals((Object)-165.0, (Object)MVEL.executeExpression((Object)s, map));
    }

    public void testMath34_Interpreted() {
        String expression = "a+b-c*x/y-z";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 200);
        map.put("b", 100);
        map.put("c", 150);
        map.put("x", 400);
        map.put("y", 300);
        map.put("z", 75);
        ArithmeticTests.assertEquals((Object)25.0, (Object)MVEL.eval((String)expression, map));
    }

    public void testMath35() {
        String expression = "b/x/b/b*y+a";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 10);
        map.put("b", 20);
        map.put("c", 30);
        map.put("x", 40);
        map.put("y", 50);
        map.put("z", 60);
        ArithmeticTests.assertNumEquals(10.0625, MVEL.executeExpression((Object)MVEL.compileExpression((String)expression), map));
    }

    public void testMath35_Interpreted() {
        String expression = "b/x/b/b*y+a";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 10);
        map.put("b", 20);
        map.put("c", 30);
        map.put("x", 40);
        map.put("y", 50);
        map.put("z", 60);
        ArithmeticTests.assertNumEquals(10.0625, MVEL.eval((String)expression, map));
    }

    public void testMath36() {
        String expression = "b/x*z/a+x-b+x-b/z+y";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 10);
        map.put("b", 20);
        map.put("c", 30);
        map.put("x", 40);
        map.put("y", 50);
        map.put("z", 60);
        Serializable s = MVEL.compileExpression((String)expression);
        ArithmeticTests.assertNumEquals(112.66666666666666, MVEL.executeExpression((Object)s, map));
    }

    public void testMath37() {
        String expression = "x+a*a*c/x*b*z+x/y-b";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 10);
        map.put("b", 20);
        map.put("c", 30);
        map.put("x", 2);
        map.put("y", 2);
        map.put("z", 60);
        Serializable s = MVEL.compileExpression((String)expression);
        ArithmeticTests.assertNumEquals(1799983.0, MVEL.executeExpression((Object)s, map));
    }

    public void testMath38() {
        String expression = "100 + 200 - 300 + 400 - 500 + 105 / 205 - 405 + 305 * 206";
        double res = 62325.51219512195;
        System.out.println("Expression: " + expression);
        System.out.println("CorrectResult:" + res);
        ArithmeticTests.assertEquals((Object)res, (Object)MVEL.eval((String)expression));
    }

    public void testMath39() {
        String expression = "147 + 60 / 167 % 448 + 36 * 23 / 166";
        double res = 152.34723324435467;
        System.out.println("Expression: " + expression);
        System.out.println("CorrectRes: " + res);
        ArithmeticTests.assertEquals((Object)res, (Object)MVEL.eval((String)expression));
    }

    public void testMath40() {
        String expression = "228 - 338 % 375 - 103 + 260 + 412 * 177 + 121";
        double res = 73092.0;
        System.out.println("Expression: " + expression);
        System.out.println("CorrectRes: " + res);
        ArithmeticTests.assertEquals((Object)res, (Object)MVEL.eval((String)expression, Double.class));
    }

    public void testMath41() {
        String expression = "304d - 246d / 242d % 235d / 425d - 326d + 355d * 264d % 308d";
        double res = 65.99760816723386;
        System.out.println("Expression: " + expression);
        System.out.println("CorrectRes: " + res);
        ArithmeticTests.assertEquals((Object)res, (Object)MVEL.eval((String)expression));
    }

    public void testMath42() {
        String expression = "11d - 7d / 3d * 18d % 14d * 8d * 11d - 2d - 11d / 13d + 14d";
        double res = 22.153846153846153;
        System.out.println("Expression: " + expression);
        System.out.println("CorrectRes: " + res);
        ArithmeticTests.assertEquals((Object)res, (Object)MVEL.eval((String)expression));
    }

    public void testMath43() {
        String expression = "4d/3d*6d%8d*5d*8d+7d+9d*1d";
        double res = 16.0;
        System.out.println("Expression: " + expression);
        System.out.println("CorrectRes: " + res);
        ArithmeticTests.assertEquals((Object)res, (Object)MVEL.eval((String)expression));
    }

    public void testMath44() {
        String expression = "6d+8d/9d*1d*9d*10d%4d*4d-4d*6d*3d";
        double res = -66.0;
        System.out.println("Expression: " + expression);
        System.out.println("CorrectRes: " + res);
        ArithmeticTests.assertEquals((Object)res, (Object)MVEL.eval((String)expression));
    }

    public void testMath44b() {
        String expression = "a+b/c*d*e*f%g*h-i*j*k";
        double res = -66.0;
        Serializable s = MVEL.compileExpression((String)expression);
        HashMap<String, Double> vars = new HashMap<String, Double>();
        vars.put("a", 6.0);
        vars.put("b", 8.0);
        vars.put("c", 9.0);
        vars.put("d", 1.0);
        vars.put("e", 9.0);
        vars.put("f", 10.0);
        vars.put("g", 4.0);
        vars.put("h", 4.0);
        vars.put("i", 4.0);
        vars.put("j", 6.0);
        vars.put("k", 3.0);
        ArithmeticTests.assertEquals((Object)res, (Object)MVEL.executeExpression((Object)s, vars));
    }

    public void testOperatorPrecedence() {
        String ex = "_x_001 = 500.2; _x_002 = 200.8; _r_001 = 701; _r_001 == _x_001 + _x_002 || _x_001 == 500 + 0.1";
        ArithmeticTests.assertEquals((Object)true, (Object)this.test(ex));
    }

    public void testOperatorPrecedence2() {
        String ex = "_x_001 = 500.2; _x_002 = 200.8; _r_001 = 701; _r_001 == _x_001 + _x_002 && _x_001 == 500 + 0.2";
        ArithmeticTests.assertEquals((Object)true, (Object)this.test(ex));
    }

    public void testOperatorPrecedence3() {
        String ex = "_x_001 = 500.2; _x_002 = 200.9; _r_001 = 701; _r_001 == _x_001 + _x_002 && _x_001 == 500 + 0.2";
        ArithmeticTests.assertEquals((Object)false, (Object)this.test(ex));
    }

    public void testOperatorPrecedence4() {
        String ex = "_x_001 = 500.2; _x_002 = 200.9; _r_001 = 701; _r_001 == _x_001 + _x_002 || _x_001 == 500 + 0.2";
        ArithmeticTests.assertEquals((Object)true, (Object)this.test(ex));
    }

    public void testOperatorPrecedence5() {
        String ex = "_x_001 == _x_001 / 2 - _x_001 + _x_001 + _x_001 / 2 && _x_002 / 2 == _x_002 / 2";
        HashMap<String, Number> vars = new HashMap<String, Number>();
        vars.put("_x_001", 500.2);
        vars.put("_x_002", 200.9);
        vars.put("_r_001", 701);
        ExpressionCompiler compiler = new ExpressionCompiler(ex);
        ArithmeticTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)compiler.compile(), vars));
    }

    public void testModulus() {
        ArithmeticTests.assertEquals((Object)0, (Object)this.test("38392 % 2"));
    }

    public void testBitwiseOr1() {
        ArithmeticTests.assertEquals((Object)6, (Object)this.test("2|4"));
    }

    public void testBitwiseOr2() {
        ArithmeticTests.assertEquals((Object)true, (Object)this.test("(2 | 1) > 0"));
    }

    public void testBitwiseOr3() {
        ArithmeticTests.assertEquals((Object)true, (Object)this.test("(2|1) == 3"));
    }

    public void testBitwiseOr4() {
        ArithmeticTests.assertEquals((Object)7, (Object)this.test("2|five"));
    }

    public void testBitwiseAnd1() {
        ArithmeticTests.assertEquals((Object)2, (Object)this.test("2 & 3"));
    }

    public void testBitwiseAnd2() {
        ArithmeticTests.assertEquals((Object)1, (Object)this.test("five & 3"));
    }

    public void testShiftLeft() {
        ArithmeticTests.assertEquals((Object)4, (Object)this.test("2 << 1"));
    }

    public void testShiftLeft2() {
        ArithmeticTests.assertEquals((Object)10, (Object)this.test("five << 1"));
    }

    public void testUnsignedShiftLeft() {
        ArithmeticTests.assertEquals((Object)2, (Object)this.test("-2 <<< 0"));
    }

    public void testShiftRight() {
        ArithmeticTests.assertEquals((Object)128, (Object)this.test("256 >> 1"));
    }

    public void testShiftRight2() {
        ArithmeticTests.assertEquals((Object)2, (Object)this.test("five >> 1"));
    }

    public void testUnsignedShiftRight() {
        ArithmeticTests.assertEquals((Object)0x7FFFFFFD, (Object)this.test("-5 >>> 1"));
    }

    public void testUnsignedShiftRight2() {
        ArithmeticTests.assertEquals((Object)0x7FFFFFFD, (Object)this.test("(five - 10) >>> 1"));
    }

    public void testShiftRightAssign() {
        ArithmeticTests.assertEquals((Object)1, (Object)this.test("_zZz = 5; _zZz >>= 2"));
    }

    public void testShiftLeftAssign() {
        ArithmeticTests.assertEquals((Object)40, (Object)this.test("_yYy = 10; _yYy <<= 2"));
    }

    public void testUnsignedShiftRightAssign() {
        String exp = "_xXx = -5; _xXx >>>= 2";
        Serializable s = MVEL.compileExpression((String)exp);
        ArithmeticTests.assertEquals((Object)0x3FFFFFFE, (Object)MVEL.executeExpression((Object)s, new HashMap()));
    }

    public void testXOR() {
        ArithmeticTests.assertEquals((Object)3, (Object)this.test("1 ^ 2"));
    }

    public void testXOR2() {
        ArithmeticTests.assertEquals((Object)7, (Object)this.test("five ^ 2"));
    }

    public void testInvert() {
        ArithmeticTests.assertEquals((Object)-11, (Object)this.test("~10"));
    }

    public void testInvert2() {
        ArithmeticTests.assertEquals((Object)-12, (Object)this.test("~(10 + 1)"));
    }

    public void testInvert3() {
        ArithmeticTests.assertEquals((Object)-61, (Object)this.test("~10 + (1 + ~50)"));
    }

    public void testDeepPropertyAdd() {
        ArithmeticTests.assertEquals((Object)10, (Object)this.test("foo.countTest+ 10"));
    }

    public void testDeepAssignmentIncrement() {
        String ex = "foo.countTest += 5; if (foo.countTest == 5) { foo.countTest = 0; return true; } else { foo.countTest = 0; return false; }";
        Map vars = ArithmeticTests.createTestMap();
        ArithmeticTests.assertEquals((Object)true, (Object)MVEL.eval((String)ex, (Map)vars));
        ArithmeticTests.assertEquals((Object)true, (Object)this.test("foo.countTest += 5; if (foo.countTest == 5) { foo.countTest = 0; return true; } else { foo.countTest = 0; return false; }"));
    }

    public void testDeepAssignmentWithBlock() {
        String ex = "with (foo) { countTest += 5 }; if (foo.countTest == 5) { foo.countTest = 0; return true; } else { foo.countTest = 0; return false; }";
        Map vars = ArithmeticTests.createTestMap();
        ArithmeticTests.assertEquals((Object)true, (Object)MVEL.eval((String)ex, (Map)vars));
        ArithmeticTests.assertEquals((Object)true, (Object)this.test("with (foo) { countTest += 5 }; if (foo.countTest == 5) { foo.countTest = 0; return true; } else { foo.countTest = 0; return false; }"));
    }

    public void testOperativeAssignMod() {
        int val = 5;
        ArithmeticTests.assertEquals((Object)(val %= 2), (Object)this.test("int val = 5; val %= 2; val"));
    }

    public void testOperativeAssignDiv() {
        int val = 10;
        ArithmeticTests.assertEquals((Object)(val /= 2), (Object)this.test("int val = 10; val /= 2; val"));
    }

    public void testOperativeAssignShift1() {
        int val = 5;
        ArithmeticTests.assertEquals((Object)(val <<= 2), (Object)this.test("int val = 5; val <<= 2; val"));
    }

    public void testOperativeAssignShift2() {
        int val = 5;
        ArithmeticTests.assertEquals((Object)(val >>= 2), (Object)this.test("int val = 5; val >>= 2; val"));
    }

    public void testOperativeAssignShift3() {
        int val = -5;
        ArithmeticTests.assertEquals((Object)(val >>>= 2), (Object)this.test("int val = -5; val >>>= 2; val"));
    }

    public void testAssignPlus() {
        ArithmeticTests.assertEquals((Object)10, (Object)this.test("xx0 = 5; xx0 += 4; xx0 + 1"));
    }

    public void testAssignPlus2() {
        ArithmeticTests.assertEquals((Object)10, (Object)this.test("xx0 = 5; xx0 =+ 4; xx0 + 1"));
    }

    public void testAssignDiv() {
        ArithmeticTests.assertEquals((Object)2.0, (Object)this.test("xx0 = 20; xx0 /= 10; xx0"));
    }

    public void testAssignMult() {
        ArithmeticTests.assertEquals((Object)36, (Object)this.test("xx0 = 6; xx0 *= 6; xx0"));
    }

    public void testAssignSub() {
        ArithmeticTests.assertEquals((Object)11, (Object)this.test("xx0 = 15; xx0 -= 4; xx0"));
    }

    public void testAssignSub2() {
        ArithmeticTests.assertEquals((Object)-95, (Object)this.test("xx0 = 5; xx0 =- 100"));
    }

    public void testBooleanStrAppend() {
        ArithmeticTests.assertEquals((Object)"footrue", (Object)this.test("\"foo\" + true"));
    }

    public void testStringAppend() {
        String ex = "c + 'bar'";
        Map vars = ArithmeticTests.createTestMap();
        ArithmeticTests.assertEquals((Object)"catbar", (Object)MVEL.eval((String)ex, (Map)vars));
        Serializable s = MVEL.compileExpression((String)ex);
        ArithmeticTests.assertEquals((Object)"catbar", (Object)MVEL.executeExpression((Object)s, (Map)vars));
    }

    public void testNegation() {
        ArithmeticTests.assertEquals((Object)1, (Object)this.test("-(-1)"));
    }

    public void testStrongTypingModeComparison() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrongTyping(true);
        parserContext.addInput("a", Long.class);
        CompiledExpression compiledExpression = new ExpressionCompiler("a==0").compile(parserContext);
        HashMap<String, Long> variables = new HashMap<String, Long>();
        variables.put("a", 0L);
        MVEL.executeExpression((Object)compiledExpression, variables);
    }

    public void testJIRA158() {
        Serializable s = MVEL.compileExpression((String)"(float) (4/2 + Math.sin(1))", (ParserContext)ParserContext.create().stronglyTyped());
        ArithmeticTests.assertEquals((Object)Float.valueOf((float)(2.0 + Math.sin(1.0))), (Object)MVEL.executeExpression((Object)s));
    }

    public void testJIRA162() {
        Serializable s = MVEL.compileExpression((String)"1d - 2d + (3d * var1) * var1", (ParserContext)ParserContext.create().withInput("var1", Double.TYPE));
        HashMap<String, Double> vars = new HashMap<String, Double>();
        vars.put("var1", 1.0);
        ArithmeticTests.assertEquals((Object)2.0, (Object)MVEL.executeExpression((Object)s, vars));
    }

    public void testJIRA161() {
        Serializable s = MVEL.compileExpression((String)"1==-(-1)", (ParserContext)ParserContext.create().stronglyTyped());
        ArithmeticTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)s));
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        CompiledExpression compiledExpression = new ExpressionCompiler("1==-(-1)").compile(ctx);
        ArithmeticTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)compiledExpression));
    }

    public void testJIRA163() {
        Serializable s = MVEL.compileExpression((String)"1d - 2d + (3d * 4d) * var1", (ParserContext)ParserContext.create().withInput("var1", Double.TYPE));
        HashMap<String, Double> vars = new HashMap<String, Double>();
        vars.put("var1", 1.0);
        ArithmeticTests.assertEquals((Object)11.0, (Object)MVEL.executeExpression((Object)s, vars));
    }

    public void testJIRA164() {
        Serializable s = MVEL.compileExpression((String)"1 / (var1 + var1) * var1", (ParserContext)ParserContext.create().stronglyTyped().withInput("var1", Double.TYPE));
        HashMap<String, Double> vars = new HashMap<String, Double>();
        double var1 = 1.0;
        vars.put("var1", var1);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        ArithmeticTests.assertEquals((Object)(1.0 / (var1 + var1) * var1), (Object)MVEL.executeExpression((Object)s, vars));
        s = MVEL.compileExpression((String)"1 / (var1 + var1) * var1", (ParserContext)ParserContext.create().withInput("var1", Double.TYPE));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ArithmeticTests.assertEquals((Object)(1.0 / (var1 + var1) * var1), (Object)MVEL.executeExpression((Object)s, vars));
    }

    public void testJIRA164b() {
        Serializable s = MVEL.compileExpression((String)"1 + 1 / (var1 + var1) * var1", (ParserContext)ParserContext.create().stronglyTyped().withInput("var1", Double.TYPE));
        HashMap<String, Double> vars = new HashMap<String, Double>();
        double var1 = 1.0;
        vars.put("var1", var1);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        ArithmeticTests.assertEquals((Object)(1.0 + 1.0 / (var1 + var1) * var1), (Object)MVEL.executeExpression((Object)s, vars));
        s = MVEL.compileExpression((String)"1 + 1 / (var1 + var1) * var1", (ParserContext)ParserContext.create().withInput("var1", Double.TYPE));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ArithmeticTests.assertEquals((Object)(1.0 + 1.0 / (var1 + var1) * var1), (Object)MVEL.executeExpression((Object)s, vars));
    }

    public void testJIRA164c() {
        Serializable s = MVEL.compileExpression((String)"1 + 1 / (var1 + var1 + 2 + 3) * var1", (ParserContext)ParserContext.create().stronglyTyped().withInput("var1", Double.TYPE));
        HashMap<String, Double> vars = new HashMap<String, Double>();
        double var1 = 1.0;
        vars.put("var1", var1);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        ArithmeticTests.assertEquals((Object)(1.0 + 1.0 / (var1 + var1 + 2.0 + 3.0) * var1), (Object)MVEL.executeExpression((Object)s, vars));
        s = MVEL.compileExpression((String)"1 + 1 / (var1 + var1 + 2 + 3) * var1", (ParserContext)ParserContext.create().withInput("var1", Double.TYPE));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ArithmeticTests.assertEquals((Object)(1.0 + 1.0 / (var1 + var1 + 2.0 + 3.0) * var1), (Object)MVEL.executeExpression((Object)s, vars));
    }

    public void testJIRA164d() {
        Serializable s = MVEL.compileExpression((String)"1 + 1 + 1 / (var1 + var1) * var1", (ParserContext)ParserContext.create().stronglyTyped().withInput("var1", Double.TYPE));
        HashMap<String, Double> vars = new HashMap<String, Double>();
        double var1 = 1.0;
        vars.put("var1", var1);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        ArithmeticTests.assertEquals((Object)(2.0 + 1.0 / (var1 + var1) * var1), (Object)MVEL.executeExpression((Object)s, vars));
        s = MVEL.compileExpression((String)"1 + 1 + 1 / (var1 + var1) * var1", (ParserContext)ParserContext.create().withInput("var1", Double.TYPE));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ArithmeticTests.assertEquals((Object)(2.0 + 1.0 / (var1 + var1) * var1), (Object)MVEL.executeExpression((Object)s, vars));
    }

    public void testJIRA164e() {
        Serializable s = MVEL.compileExpression((String)"10 + 11 + 12 / (var1 + var1 + 51 + 71) * var1 + 13 + 14", (ParserContext)ParserContext.create().stronglyTyped().withInput("var1", Double.TYPE));
        HashMap<String, Double> vars = new HashMap<String, Double>();
        double var1 = 1.0;
        vars.put("var1", var1);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        ArithmeticTests.assertEquals((Object)Float.valueOf((float)(21.0 + 12.0 / (var1 + var1 + 51.0 + 71.0) * var1 + 13.0 + 14.0)), (Object)Float.valueOf(((Double)MVEL.executeExpression((Object)s, vars)).floatValue()));
        s = MVEL.compileExpression((String)"10 + 11 + 12 / (var1 + var1 + 51 + 71) * var1 + 13 + 14", (ParserContext)ParserContext.create().withInput("var1", Double.TYPE));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ArithmeticTests.assertEquals((Object)Float.valueOf((float)(21.0 + 12.0 / (var1 + var1 + 51.0 + 71.0) * var1 + 13.0 + 14.0)), (Object)Float.valueOf(((Double)MVEL.executeExpression((Object)s, vars)).floatValue()));
    }

    public void testJIRA164f() {
        Serializable s = MVEL.compileExpression((String)"10 + 11 + 12 / (var1 + 1 + var1 + 51 + 71) * var1 + 13 + 14", (ParserContext)ParserContext.create().stronglyTyped().withInput("var1", Double.TYPE));
        HashMap<String, Double> vars = new HashMap<String, Double>();
        double var1 = 1.0;
        vars.put("var1", var1);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        ArithmeticTests.assertEquals((Object)Float.valueOf((float)(21.0 + 12.0 / (var1 + 1.0 + var1 + 51.0 + 71.0) * var1 + 13.0 + 14.0)), (Object)Float.valueOf(((Double)MVEL.executeExpression((Object)s, vars)).floatValue()));
        s = MVEL.compileExpression((String)"10 + 11 + 12 / (var1 + 1 + var1 + 51 + 71) * var1 + 13 + 14", (ParserContext)ParserContext.create().withInput("var1", Double.TYPE));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ArithmeticTests.assertEquals((Object)Float.valueOf((float)(21.0 + 12.0 / (var1 + 1.0 + var1 + 51.0 + 71.0) * var1 + 13.0 + 14.0)), (Object)Float.valueOf(((Double)MVEL.executeExpression((Object)s, vars)).floatValue()));
    }

    public void testJIRA164g() {
        Serializable s = MVEL.compileExpression((String)"1 - 2 + (3 * var1) * var1", (ParserContext)ParserContext.create().stronglyTyped().withInput("var1", Double.TYPE));
        HashMap<String, Double> vars = new HashMap<String, Double>();
        double var1 = 1.0;
        vars.put("var1", var1);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        ArithmeticTests.assertEquals((Object)Float.valueOf((float)(-1.0 + 3.0 * var1 * var1)), (Object)Float.valueOf(((Double)MVEL.executeExpression((Object)s, vars)).floatValue()));
        s = MVEL.compileExpression((String)"1 - 2 + (3 * var1) * var1", (ParserContext)ParserContext.create().withInput("var1", Double.TYPE));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ArithmeticTests.assertEquals((Object)Float.valueOf((float)(-1.0 + 3.0 * var1 * var1)), (Object)Float.valueOf(((Double)MVEL.executeExpression((Object)s, vars)).floatValue()));
    }

    public void testJIRA164h() {
        Serializable s = MVEL.compileExpression((String)"1 - var1 * (var1 * var1 * (var1 * var1) * var1) * var1", (ParserContext)ParserContext.create().stronglyTyped().withInput("var1", Double.TYPE));
        HashMap<String, Double> vars = new HashMap<String, Double>();
        double var1 = 2.0;
        vars.put("var1", var1);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        ArithmeticTests.assertEquals((Object)Float.valueOf((float)(1.0 - var1 * (var1 * var1 * (var1 * var1) * var1) * var1)), (Object)Float.valueOf(((Double)MVEL.executeExpression((Object)s, vars)).floatValue()));
        s = MVEL.compileExpression((String)"1 - var1 * (var1 * var1 * (var1 * var1) * var1) * var1", (ParserContext)ParserContext.create().withInput("var1", Double.TYPE));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ArithmeticTests.assertEquals((Object)Float.valueOf((float)(1.0 - var1 * (var1 * var1 * (var1 * var1) * var1) * var1)), (Object)Float.valueOf(((Double)MVEL.executeExpression((Object)s, vars)).floatValue()));
    }

    public void testJIRA180() {
        Serializable s = MVEL.compileExpression((String)"-Math.sin(0)");
        MVEL.executeExpression((Object)s);
    }

    public void testJIRA208() {
        String[] testCases;
        LinkedHashMap<String, Integer> vars = new LinkedHashMap<String, Integer>();
        vars.put("bal", 999);
        for (String expr : testCases = new String[]{"bal - 80 - 90 - 30", "bal-80-90-30", "100 + 80 == 180", "100+80==180"}) {
            System.out.println("Evaluating '" + expr + "': ......");
            Object val1 = MVEL.eval((String)expr, vars);
            ArithmeticTests.assertNotNull((Object)val1);
            Serializable compiled = MVEL.compileExpression((String)expr);
            Object val2 = MVEL.executeExpression((Object)compiled, vars);
            ArithmeticTests.assertNotNull((Object)val2);
            ArithmeticTests.assertEquals((String)("expression did not evaluate correctly: " + expr), (Object)val1, (Object)val2);
        }
    }

    public void testJIRA1208a() {
        ArithmeticTests.assertEquals((Object)799, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"bal - 80 - 90 - 30"), (Map)Make.Map.$()._((Object)"bal", (Object)999)._()));
    }

    public void testJIRA208b() {
        String[] testCases;
        LinkedHashMap<String, Integer> vars = new LinkedHashMap<String, Integer>();
        vars.put("bal", 999);
        for (String expr : testCases = new String[]{"bal / 80 * 80"}) {
            System.out.println("Evaluating '" + expr + "': ......");
            Object val1 = MVEL.eval((String)expr, vars);
            ArithmeticTests.assertNotNull((Object)val1);
            Serializable compiled = MVEL.compileExpression((String)expr);
            Object val2 = MVEL.executeExpression((Object)compiled, vars);
            ArithmeticTests.assertNotNull((Object)val2);
            ArithmeticTests.assertEquals((String)("expression did not evaluate correctly: " + expr), (Object)val1, (Object)val2);
        }
    }

    public void testJIRA210() {
        String[] testCases;
        LinkedHashMap<String, BigDecimal> vars = new LinkedHashMap<String, BigDecimal>();
        vars.put("bal", new BigDecimal("999.99"));
        for (String expr : testCases = new String[]{"bal - 1 + \"abc\""}) {
            System.out.println("Evaluating '" + expr + "': ......");
            Object val1 = MVEL.eval((String)expr, vars);
            ArithmeticTests.assertNotNull((Object)val1);
            Serializable compiled = MVEL.compileExpression((String)expr);
            Object val2 = MVEL.executeExpression((Object)compiled, vars);
            ArithmeticTests.assertNotNull((Object)val2);
            ArithmeticTests.assertEquals((String)("expression did not evaluate correctly: " + expr), (Object)val1, (Object)val2);
        }
    }

    public void testMathDec30() {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("value", 10);
        HashMap<String, Serializable> vars = new HashMap<String, Serializable>();
        vars.put("param", params);
        vars.put("param2", Integer.valueOf(10));
        ArithmeticTests.assertEquals((Object)21, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"1 + 2 * param.value"), vars));
    }

    public void testJIRA99_Interpreted() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("x", 20);
        map.put("y", 10);
        map.put("z", 5);
        ArithmeticTests.assertEquals((Object)5, (Object)MVEL.eval((String)"x - y - z", map));
    }

    public void testJIRA99_Compiled() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("x", 20);
        map.put("y", 10);
        map.put("z", 5);
        ArithmeticTests.assertEquals((Object)5, (Object)ArithmeticTests.testCompiledSimple("x - y - z", map));
    }

    public void testModExpr() {
        String str = "$y % 4 == 0 && $y % 100 != 0 || $y % 400 == 0 ";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("$y", Integer.TYPE);
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        for (int i = 0; i < 500; ++i) {
            int y = i;
            boolean expected = y % 4 == 0 && y % 100 != 0 || y % 400 == 0;
            vars.put("$y", y);
            ArithmeticTests.assertEquals((Object)expected, (Object)MVEL.eval((String)str, vars));
            ArithmeticTests.assertEquals((boolean)expected, (boolean)((Boolean)MVEL.executeExpression((Object)stmt, null, vars)));
        }
    }

    public void testIntsWithDivision() {
        String str = "0 == x - (y/2)";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("x", Integer.TYPE);
        pctx.addInput("y", Integer.TYPE);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("x", 50);
        vars.put("y", 100);
        Boolean result = (Boolean)MVEL.executeExpression((Object)stmt, vars);
        ArithmeticTests.assertTrue((boolean)result);
    }

    public void testMathCeil() {
        String str = "Math.ceil( x/3 ) == 2";
        ParserConfiguration pconf = new ParserConfiguration();
        pconf.addImport("Math", Math.class);
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("x", Integer.TYPE);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("x", 4);
        Boolean result = (Boolean)MVEL.executeExpression((Object)stmt, vars);
        ArithmeticTests.assertTrue((boolean)result);
    }

    public void testMathCeilWithDoubleCaste() {
        String str = "Math.ceil( (double) x / 3 )";
        ParserConfiguration pconf = new ParserConfiguration();
        pconf.addImport("Math", Math.class);
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("x", Integer.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("x", 4);
        ArithmeticTests.assertEquals((Object)Math.ceil(1.3333333333333333), (Object)MVEL.executeExpression((Object)stmt, vars));
    }
}

