/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.tests.core.AbstractTest;
import org.mvel2.tests.core.res.Foo;

public class MutationsTests
extends AbstractTest {
    public void testDeepAssignment() {
        Map map = MutationsTests.createTestMap();
        MutationsTests.assertEquals((Object)"crap", (Object)MutationsTests.testCompiledSimple("foo.bar.assignTest = 'crap'", map));
        MutationsTests.assertEquals((Object)"crap", (Object)MutationsTests.testCompiledSimple("foo.bar.assignTest", map));
    }

    public void testDeepAssignment2() {
        Map map = MutationsTests.createTestMap();
        ExpressionCompiler compiler = new ExpressionCompiler("foo.bar.age = 21");
        ParserContext ctx = new ParserContext();
        ctx.addInput("foo", Foo.class);
        ctx.setStrongTyping(true);
        CompiledExpression ce = compiler.compile(ctx);
        MVEL.executeExpression((Object)ce, (Map)map);
        MutationsTests.assertEquals((int)((Foo)map.get("foo")).getBar().getAge(), (int)21);
    }

    public void testComplexExpression() {
        MutationsTests.assertEquals((Object)"bar", (Object)this.test("a = 'foo'; b = 'bar'; c = 'jim'; list = {a,b,c}; list[1]"));
    }

    public void testAssignment() {
        MutationsTests.assertEquals((Object)true, (Object)this.test("populate(); blahfoo = 'sarah'; blahfoo == 'sarah'"));
    }

    public void testAssignment2() {
        MutationsTests.assertEquals((Object)"sarah", (Object)this.test("populate(); blahfoo = barfoo"));
    }

    public void testAssignment3() {
        MutationsTests.assertEquals(Integer.class, this.test("blah = 5").getClass());
    }

    public void testAssignment4() {
        MutationsTests.assertEquals((Object)102, (Object)this.test("a = 100 + 1 + 1"));
    }

    public void testAssignment6() {
        MutationsTests.assertEquals((Object)"blip", (Object)this.test("array[zero] = array[zero+1]; array[zero]"));
    }

    public void testConstructor() {
        MutationsTests.assertEquals((Object)"foo", (Object)this.test("a = 'foobar'; new String(a.toCharArray(), 0, 3)"));
    }

    public void testStaticVarAssignment() {
        MutationsTests.assertEquals((Object)"1", (Object)this.test("String mikeBrock = 1; mikeBrock"));
    }

    public void testFunctionPointer() {
        String ex = "squareRoot = java.lang.Math.sqrt; squareRoot(4)";
        Object o = MVEL.eval((String)ex, new HashMap());
        MutationsTests.assertEquals((Object)2.0, (Object)o);
        MutationsTests.assertEquals((Object)2.0, (Object)this.test(ex));
    }

    public void testFunctionPointerAsParam() {
        MutationsTests.assertEquals((Object)"2.0", (Object)this.test("squareRoot = Math.sqrt; new String(String.valueOf(squareRoot(4)));"));
    }

    public void testFunctionPointerInAssignment() {
        MutationsTests.assertEquals((Object)5.0, (Object)this.test("squareRoot = Math.sqrt; i = squareRoot(25); return i;"));
    }

    public void testIncrementOperator() {
        MutationsTests.assertEquals((Object)2, (Object)this.test("x = 1; x++; x"));
    }

    public void testPreIncrementOperator() {
        MutationsTests.assertEquals((Object)2, (Object)this.test("x = 1; ++x"));
    }

    public void testDecrementOperator() {
        MutationsTests.assertEquals((Object)1, (Object)this.test("x = 2; x--; x"));
    }

    public void testPreDecrementOperator() {
        MutationsTests.assertEquals((Object)1, (Object)this.test("x = 2; --x"));
    }

    public void testQualifiedStaticTyping() {
        Object val = this.test("java.math.BigDecimal a = new java.math.BigDecimal( 10.0 ); java.math.BigDecimal b = new java.math.BigDecimal( 10.0 ); java.math.BigDecimal c = a + b; return c; ");
        MutationsTests.assertEquals((Object)new BigDecimal(20), (Object)val);
    }

    public void testUnQualifiedStaticTyping() {
        CompiledExpression ce = (CompiledExpression)MVEL.compileExpression((String)"import java.math.BigDecimal; BigDecimal a = new BigDecimal( 10.0 ); BigDecimal b = new BigDecimal( 10.0 ); BigDecimal c = a + b; return c; ");
        MutationsTests.assertEquals((Object)new BigDecimal(20), (Object)MutationsTests.testCompiledSimple("import java.math.BigDecimal; BigDecimal a = new BigDecimal( 10.0 ); BigDecimal b = new BigDecimal( 10.0 ); BigDecimal c = a + b; return c; ", new HashMap()));
    }

    public void testSubExpressionIndexer() {
        MutationsTests.assertEquals((Object)"bar", (Object)this.test("xx = new java.util.HashMap(); xx.put('foo', 'bar'); prop = 'foo'; xx[prop];"));
    }

    public void testAssignListToBean() {
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        MockClass mock = new MockClass();
        MVEL.executeExpression((Object)MVEL.compileExpression((String)"this.values = [0, 1, 2, 3, 4]"), (Object)mock);
        MutationsTests.assertEquals((int)5, (int)mock.getValues().size());
    }

    public static class MockClass {
        List values;

        public List getValues() {
            return this.values;
        }

        public void setValues(List values) {
            this.values = values;
        }
    }
}

