/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.compiler;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.ErrorDetail;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessException;
import org.mvel2.ast.Function;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.optimizers.AbstractOptimizer;
import org.mvel2.optimizers.impl.refl.nodes.WithAccessor;
import org.mvel2.util.ParseTools;
import org.mvel2.util.PropertyTools;
import org.mvel2.util.StringAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyVerifier
extends AbstractOptimizer {
    private static final int DONE = -1;
    private static final int NORM = 0;
    private static final int METH = 1;
    private static final int COL = 2;
    private static final int WITH = 3;
    private List<String> inputs = new LinkedList<String>();
    private boolean first = false;
    private boolean classLiteral = false;
    private boolean resolvedExternally;
    private boolean deepProperty = false;
    private Map<String, Class> paramTypes;
    private Class ctx = null;

    public PropertyVerifier(char[] property, ParserContext parserContext) {
        this.expr = property;
        this.length = this.end = property.length;
        this.pCtx = parserContext;
    }

    public PropertyVerifier(char[] property, int start, int offset, ParserContext parserContext) {
        this.expr = property;
        this.start = start;
        this.length = offset;
        this.end = start + offset;
        this.pCtx = parserContext;
    }

    public PropertyVerifier(String property, ParserContext parserContext) {
        this.expr = property.toCharArray();
        this.length = this.end = this.expr.length;
        this.pCtx = parserContext;
    }

    public PropertyVerifier(String property, ParserContext parserContext, Class root) {
        this.expr = property.toCharArray();
        this.length = this.expr.length;
        this.pCtx = parserContext;
        this.ctx = root;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public Class analyze() {
        this.cursor = this.start;
        this.resolvedExternally = true;
        if (this.ctx == null) {
            this.ctx = Object.class;
            this.first = true;
        }
        while (this.cursor < this.end) {
            this.classLiteral = false;
            switch (this.nextSubToken()) {
                case 0: {
                    this.ctx = this.getBeanProperty(this.ctx, this.capture());
                    break;
                }
                case 1: {
                    this.ctx = this.getMethod(this.ctx, this.capture());
                    break;
                }
                case 2: {
                    this.ctx = this.getCollectionProperty(this.ctx, this.capture());
                    break;
                }
                case 3: {
                    this.ctx = this.getWithProperty(this.ctx);
                    break;
                }
            }
            if (!this.first) {
                this.deepProperty = true;
            }
            this.first = false;
        }
        return this.ctx;
    }

    private void recordTypeParmsForProperty(String property) {
        if (this.pCtx.isStrictTypeEnforcement()) {
            this.paramTypes = this.pCtx.getTypeParameters(property);
            if (this.paramTypes == null) {
                this.pCtx.addTypeParameters(property, this.pCtx.getVarOrInputType(property));
            }
            this.pCtx.setLastTypeParameters(this.pCtx.getTypeParametersAsArray(property));
        }
    }

    private Class getBeanProperty(Class ctx, String property) {
        block30: {
            boolean switchStateReg;
            block32: {
                block31: {
                    Member member;
                    if (this.first) {
                        if (this.pCtx.hasVarOrInput(property)) {
                            if (this.pCtx.isStrictTypeEnforcement()) {
                                this.recordTypeParmsForProperty(property);
                            }
                            return this.pCtx.getVarOrInputType(property);
                        }
                        if (this.pCtx.hasImport(property)) {
                            this.resolvedExternally = false;
                            return this.pCtx.getImport(property);
                        }
                        if (!this.pCtx.isStrongTyping()) {
                            return Object.class;
                        }
                        if (this.pCtx.hasVarOrInput("this")) {
                            if (this.pCtx.isStrictTypeEnforcement()) {
                                this.recordTypeParmsForProperty("this");
                            }
                            ctx = this.pCtx.getVarOrInputType("this");
                            this.resolvedExternally = false;
                        }
                    }
                    this.st = this.cursor;
                    Member member2 = member = ctx != null ? PropertyTools.getFieldOrAccessor(ctx, property) : null;
                    if (member == null && MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL) {
                        return this.getMethod(ctx, property);
                    }
                    if (member instanceof Field) {
                        if (this.pCtx.isStrictTypeEnforcement()) {
                            Field f = (Field)member;
                            if (f.getGenericType() != null && f.getGenericType() instanceof ParameterizedType) {
                                ParameterizedType pt = (ParameterizedType)f.getGenericType();
                                this.pCtx.setLastTypeParameters(pt.getActualTypeArguments());
                                Type[] gpt = pt.getActualTypeArguments();
                                TypeVariable<Class<T>>[] classArgs = ((Class)pt.getRawType()).getTypeParameters();
                                if (gpt.length > 0 && this.paramTypes == null) {
                                    this.paramTypes = new HashMap<String, Class>();
                                }
                                for (int i = 0; i < gpt.length; ++i) {
                                    this.paramTypes.put(classArgs[i].toString(), (Class)gpt[i]);
                                }
                            }
                            return f.getType();
                        }
                        return ((Field)member).getType();
                    }
                    if (member != null) {
                        Class rt;
                        Type parametricReturnType;
                        Method method = (Method)member;
                        if (this.pCtx.isStrictTypeEnforcement() && (parametricReturnType = method.getGenericReturnType()) instanceof ParameterizedType) {
                            this.pCtx.setLastTypeParameters(((ParameterizedType)parametricReturnType).getActualTypeArguments());
                        }
                        return (rt = method.getReturnType()).isPrimitive() ? ParseTools.boxPrimitive(rt) : rt;
                    }
                    if (this.pCtx != null && this.pCtx.hasImport(property)) {
                        return this.pCtx.getImport(property);
                    }
                    if (this.pCtx == null || this.pCtx.getLastTypeParameters() == null) break block30;
                    if (!Collection.class.isAssignableFrom(ctx)) break block31;
                    switchStateReg = false;
                    if (!false) break block32;
                }
                if (!Map.class.isAssignableFrom(ctx)) break block30;
                switchStateReg = true;
                if (!true) break block30;
            }
            Class parm = (Class)this.pCtx.getLastTypeParameters()[switchStateReg ? 1 : 0];
            this.pCtx.setLastTypeParameters(null);
            return parm;
        }
        if (this.pCtx != null && "length".equals(property) && ctx.isArray()) {
            return Integer.class;
        }
        Object tryStaticMethodRef = this.tryStaticAccess();
        if (tryStaticMethodRef != null) {
            if (tryStaticMethodRef instanceof Class) {
                this.classLiteral = true;
                this.resolvedExternally = false;
                return (Class)tryStaticMethodRef;
            }
            if (tryStaticMethodRef instanceof Field) {
                try {
                    return ((Field)tryStaticMethodRef).get(null).getClass();
                }
                catch (Exception e) {
                    throw new CompileException("in verifier: ", this.expr, this.start, e);
                }
            }
            try {
                return ((Method)tryStaticMethodRef).getReturnType();
            }
            catch (Exception e) {
                throw new CompileException("in verifier: ", this.expr, this.start, e);
            }
        }
        if (ctx != null && ctx.getClass() == Class.class) {
            for (Method m : ctx.getMethods()) {
                if (!property.equals(m.getName())) continue;
                return m.getReturnType();
            }
        }
        if (this.pCtx.isStrictTypeEnforcement()) {
            this.addFatalError("unqualified type in strict mode for: " + property, this.start);
        }
        return Object.class;
    }

    private Class getCollectionProperty(Class ctx, String property) {
        if (this.first) {
            if (this.pCtx.hasVarOrInput(property)) {
                ctx = ParseTools.getSubComponentType(this.pCtx.getVarOrInputType(property));
            } else if (this.pCtx.hasImport(property)) {
                this.resolvedExternally = false;
                ctx = ParseTools.getSubComponentType(this.pCtx.getImport(property));
            } else {
                ctx = Object.class;
            }
        }
        if (this.pCtx.isStrictTypeEnforcement()) {
            if (Map.class.isAssignableFrom(property.length() != 0 ? (ctx = this.getBeanProperty(ctx, property)) : ctx)) {
                ctx = this.pCtx.getLastTypeParameters().length != 0 ? this.pCtx.getLastTypeParameters()[1] : Object.class;
            } else if (Collection.class.isAssignableFrom(ctx)) {
                ctx = this.pCtx.getLastTypeParameters().length != 0 ? this.pCtx.getLastTypeParameters()[0] : Object.class;
            } else if (ctx.isArray()) {
                ctx = ParseTools.getBaseComponentType(ctx);
            } else if (this.pCtx.isStrongTyping()) {
                throw new CompileException("unknown collection type: " + ctx + "; property=" + property, this.expr, this.start);
            }
        } else {
            ctx = Object.class;
        }
        ++this.cursor;
        this.skipWhitespace();
        int start = this.cursor;
        if (this.cursor == this.length) {
            throw new PropertyAccessException("unterminated '['", this.expr, this.start);
        }
        if (this.scanTo(']')) {
            this.addFatalError("unterminated [ in token");
        }
        ExpressionCompiler compiler = new ExpressionCompiler(new String(this.expr, start, this.cursor - start));
        compiler.setVerifyOnly(true);
        compiler.compile(this.pCtx);
        ++this.cursor;
        return ctx;
    }

    private Class getMethod(Class ctx, String name) {
        int i;
        Class[] args;
        int st = this.cursor;
        if (this.first) {
            this.first = false;
            if (this.pCtx.hasImport(name)) {
                Method m = this.pCtx.getStaticImport(name).getMethod();
                ctx = m.getDeclaringClass();
                name = m.getName();
            } else if (this.pCtx.hasFunction(name)) {
                this.resolvedExternally = false;
                Function f = this.pCtx.getFunction(name);
                this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, this.end, '(');
                f.checkArgumentCount(ParseTools.parseParameterList(this.cursor - st > 1 ? ParseTools.subset(this.expr, st + 1, this.cursor - st - 1) : new char[]{}, 0, -1).size());
                return f.getEgressType();
            }
        }
        String tk = this.cursor < this.end && this.expr[this.cursor] == '(' && (this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, this.end, '(')) - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        List<Object> subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
        if (subtokens.size() == 0) {
            args = new Class[]{};
            subtokens = Collections.emptyList();
        } else {
            args = new Class[subtokens.size()];
            List<ErrorDetail> errors = this.pCtx.getErrorList().isEmpty() ? this.pCtx.getErrorList() : new ArrayList<ErrorDetail>(this.pCtx.getErrorList());
            CompileException rethrow = null;
            for (i = 0; i < subtokens.size(); ++i) {
                try {
                    args[i] = MVEL.analyze((char[])subtokens.get(i), this.pCtx);
                }
                catch (CompileException e) {
                    e.setExpr(this.expr);
                    e.setCursor(this.st);
                    rethrow = e;
                }
                if (errors.size() < this.pCtx.getErrorList().size()) {
                    for (ErrorDetail detail : this.pCtx.getErrorList()) {
                        if (errors.contains(detail)) continue;
                        detail.setExpr(this.expr);
                        detail.setCursor(new String(this.expr).substring(this.st).indexOf(new String((char[])subtokens.get(i))) + this.st);
                        detail.setColumn(0);
                        detail.setLineNumber(0);
                        detail.calcRowAndColumn();
                    }
                }
                if (rethrow == null) continue;
                throw rethrow;
            }
        }
        Method m = ParseTools.getBestCandidate(args, name, ctx, ctx.getMethods(), this.pCtx.isStrongTyping());
        if (m == null && (m = ParseTools.getBestCandidate(args, name, ctx, ctx.getDeclaredMethods(), this.pCtx.isStrongTyping())) == null) {
            StringAppender errorBuild = new StringAppender();
            for (i = 0; i < args.length; ++i) {
                errorBuild.append(args[i] != null ? args[i].getName() : null);
                if (i >= args.length - 1) continue;
                errorBuild.append(", ");
            }
            if (("size".equals(name) || "length".equals(name)) && args.length == 0 && ctx.isArray()) {
                return Integer.class;
            }
            if (this.pCtx.isStrictTypeEnforcement()) {
                this.addFatalError("unable to resolve method using strict-mode: " + ctx.getName() + "." + name + "(" + errorBuild.toString() + ")");
            }
            return Object.class;
        }
        if (this.pCtx.isStrictTypeEnforcement() && m.getGenericReturnType() != null) {
            HashMap<String, Class> typeArgs = new HashMap<String, Class>();
            Type[] gpt = m.getGenericParameterTypes();
            for (int i2 = 0; i2 < gpt.length; ++i2) {
                if (!(gpt[i2] instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)gpt[i2];
                Class z = this.pCtx.getImport(new String((char[])subtokens.get(i2)));
                if (z == null) continue;
                if (pt.getRawType().equals(Class.class)) {
                    typeArgs.put(pt.getActualTypeArguments()[0].toString(), z);
                    continue;
                }
                typeArgs.put(gpt[i2].toString(), z);
            }
            Type parametricReturnType = m.getGenericReturnType();
            String returnTypeArg = parametricReturnType.toString();
            if (parametricReturnType instanceof ParameterizedType) {
                this.pCtx.setLastTypeParameters(((ParameterizedType)parametricReturnType).getActualTypeArguments());
            }
            if (this.paramTypes != null && this.paramTypes.containsKey(returnTypeArg)) {
                return this.paramTypes.get(returnTypeArg);
            }
            if (typeArgs.containsKey(returnTypeArg)) {
                return (Class)typeArgs.get(returnTypeArg);
            }
        }
        return m.getReturnType();
    }

    private Class getWithProperty(Class ctx) {
        String root = new String(this.expr, 0, this.cursor - 1).trim();
        int start = this.cursor + 1;
        this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.expr, this.cursor, this.end, '{', this.pCtx);
        int n = this.cursor++;
        new WithAccessor(root, this.expr, start, n - start, ctx, this.pCtx.isStrictTypeEnforcement());
        return ctx;
    }

    public boolean isResolvedExternally() {
        return this.resolvedExternally;
    }

    public boolean isClassLiteral() {
        return this.classLiteral;
    }

    public boolean isDeepProperty() {
        return this.deepProperty;
    }

    public Class getCtx() {
        return this.ctx;
    }

    public void setCtx(Class ctx) {
        this.ctx = ctx;
    }
}

