/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.mvel2.MVEL;
import org.mvel2.MVELRuntime;
import org.mvel2.Macro;
import org.mvel2.MacroProcessor;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.WithNode;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.debug.DebugTools;
import org.mvel2.debug.Debugger;
import org.mvel2.debug.Frame;
import org.mvel2.integration.Interceptor;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.tests.core.res.Foo;

public class MacroProcessorTest
extends TestCase {
    private MacroProcessor macroProcessor;

    protected void setUp() throws Exception {
        super.setUp();
        HashMap<String, 1> macros = new HashMap<String, 1>();
        macros.put("insert", new Macro(){

            public String doMacro() {
                return "drools.insert";
            }
        });
        this.macroProcessor = new MacroProcessor();
        this.macroProcessor.setMacros(macros);
    }

    public void testParseString() {
        String raw = "    l.add( \"rule 2 executed \" + str);";
        try {
            String result = this.macroProcessor.parse(raw);
            MacroProcessorTest.assertEquals((String)raw, (String)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MacroProcessorTest.fail((String)("there shouldn't be any exception: " + ex.getMessage()));
        }
    }

    public void testParseConsequenceWithComments() {
        String raw = "    // str is null, we are just testing we don't get a null pointer \n     list.add( p );";
        try {
            String result = this.macroProcessor.parse(raw);
            MacroProcessorTest.assertEquals((String)raw, (String)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MacroProcessorTest.fail((String)("there shouldn't be any exception: " + ex.getMessage()));
        }
    }

    public void testInfiniteLoop() {
        String str = "";
        str = str + "int insuranceAmt = caseRate + (charges * pctDiscount / 100);\n";
        str = str + "update (estimate); \n";
        HashMap<String, 2> macros = new HashMap<String, 2>();
        macros.put("update", new Macro(){

            public String doMacro() {
                return "drools.update";
            }
        });
        String result = MVEL.parseMacros((String)str, macros);
        str = "";
        str = str + "int insuranceAmt = caseRate + (charges * pctDiscount / 100);\n";
        str = str + "drools.update (estimate);";
        MacroProcessorTest.assertEquals((String)str, (String)result);
    }

    public void testMacroSupport() {
        HashMap<String, Foo> vars = new HashMap<String, Foo>();
        vars.put("foo", new Foo());
        HashMap<String, 3> interceptors = new HashMap<String, 3>();
        HashMap<String, 4> macros = new HashMap<String, 4>();
        interceptors.put("Modify", new Interceptor(){

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                ((WithNode)node).getNestedStatement().getValue(null, factory);
                factory.createVariable("mod", (Object)"FOOBAR!");
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                return 0;
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        ExpressionCompiler compiler = new ExpressionCompiler(MVEL.parseMacros((String)"modify (foo) { aValue = 'poo' }; mod", macros));
        ParserContext ctx = new ParserContext(null, interceptors, null);
        ctx.setSourceFile("test.mv");
        ctx.setDebugSymbols(true);
        MacroProcessorTest.assertEquals((Object)"FOOBAR!", (Object)MVEL.executeExpression((Object)compiler.compile(ctx), null, vars));
    }

    public void testMacroSupportWithStrings() {
        HashMap<String, Foo> vars = new HashMap<String, Foo>();
        Foo foo = new Foo();
        vars.put("foo", foo);
        HashMap<String, 5> macros = new HashMap<String, 5>();
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "drools.modify";
            }
        });
        MacroProcessorTest.assertEquals((String)"", (String)foo.aValue);
        ExpressionCompiler compiler = new ExpressionCompiler(MVEL.parseMacros((String)"\"This is an modify()\"", macros));
        ParserContext ctx = new ParserContext(null, null, null);
        ctx.setSourceFile("test.mv");
        ctx.setDebugSymbols(true);
        MacroProcessorTest.assertEquals((Object)"This is an modify()", (Object)MVEL.executeExpression((Object)compiler.compile(ctx), null, vars));
    }

    public void testMacroSupportWithDebugging() {
        HashMap<String, Foo> vars = new HashMap<String, Foo>();
        vars.put("foo", new Foo());
        HashMap<String, 6> interceptors = new HashMap<String, 6>();
        HashMap<String, 7> macros = new HashMap<String, 7>();
        interceptors.put("Modify", new Interceptor(){

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                ((WithNode)node).getNestedStatement().getValue(null, factory);
                factory.createVariable("mod", (Object)"FOOBAR!");
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                return 0;
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        ExpressionCompiler compiler = new ExpressionCompiler(MVEL.parseMacros((String)"System.out.println('hello');\nSystem.out.println('bye');\nmodify (foo) { aValue = 'poo', \n aValue = 'poo' };\n mod", macros));
        ParserContext ctx = new ParserContext(null, interceptors, null);
        ctx.setSourceFile("test.mv");
        ctx.setDebugSymbols(true);
        CompiledExpression compiled = compiler.compile(ctx);
        MVELRuntime.setThreadDebugger((Debugger)new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println(frame.getSourceName() + ":" + frame.getLineNumber());
                return 1;
            }
        });
        MVELRuntime.registerBreakpoint((String)"test.mv", (int)3);
        System.out.println(DebugTools.decompile((CompiledExpression)compiled));
        Assert.assertEquals((Object)"FOOBAR!", (Object)MVEL.executeDebugger((CompiledExpression)compiled, null, (VariableResolverFactory)new MapVariableResolverFactory(vars)));
    }

    public void testParseStringUnmatchedChars() {
        String raw = "result.add( \"\\\"\\' there are } [ unmatched characters in this string (\"  );";
        try {
            String result = this.macroProcessor.parse(raw);
            MacroProcessorTest.assertEquals((String)raw, (String)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MacroProcessorTest.fail((String)("there shouldn't be any exception: " + ex.getMessage()));
        }
    }

    public void testParseConsequenceWithFlowControlBlocks() {
        String raw = "    // str is null, we are just testing we don't get a null pointer \n      if (l.x < 1)  {\n        insert( new RuleLink(\"FIRST.INLET\" , comp, comp) );\n     } else {\n        insert( new RuleLink(\"FIRST.INLET.NOT\" , comp, comp) );\n     }\n    if( 1 < 2 ) { \n        insert( p ); \n    } else { \n        while( true ) {insert(x);}\n    }";
        String expected = "    // str is null, we are just testing we don't get a null pointer \n      if (l.x < 1)  {\n        drools.insert( new RuleLink(\"FIRST.INLET\" , comp, comp) );\n     } else {\n        drools.insert( new RuleLink(\"FIRST.INLET.NOT\" , comp, comp) );\n     }\n    if( 1 < 2 ) { \n        drools.insert( p ); \n    } else { \n        while( true ) {drools.insert(x);}\n    }";
        try {
            String result = this.macroProcessor.parse(raw);
            MacroProcessorTest.assertEquals((String)expected, (String)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MacroProcessorTest.fail((String)("there shouldn't be any exception: " + ex.getMessage()));
        }
    }

    public void testCommentParsingWithMacro() {
        String raw = "/** This is a block comment **/ insert /** This is a second \n\nblock comment insert **/";
        String expected = "/** This is a block comment **/ drools.insert /** This is a second \n\nblock comment insert **/";
        try {
            String result = this.macroProcessor.parse(raw);
            MacroProcessorTest.assertEquals((String)expected, (String)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MacroProcessorTest.fail((String)("there shouldn't be any exception: " + ex.getMessage()));
        }
    }
}

