/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.debug.DebugTools;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.optimizers.dynamic.DynamicOptimizer;
import org.mvel2.tests.core.res.Base;
import org.mvel2.tests.core.res.DerivedClass;
import org.mvel2.tests.core.res.Foo;
import org.mvel2.tests.core.res.TestInterface;
import org.mvel2.util.StringAppender;

public abstract class AbstractTest
extends TestCase {
    private boolean silentTests = Boolean.getBoolean("mvel.tests.silent");

    public void testNothing() {
    }

    protected void setUp() throws Exception {
    }

    protected static Map createTestMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", new Foo());
        map.put("a", null);
        map.put("b", null);
        map.put("c", "cat");
        map.put("BWAH", "");
        map.put("misc", new MiscTestClass());
        map.put("pi", "3.14");
        map.put("hour", 60);
        map.put("zero", 0);
        map.put("array", new String[]{"", "blip"});
        map.put("order", new Order());
        map.put("$id", 20);
        map.put("five", 5);
        map.put("testImpl", new TestInterface(){

            public String getName() {
                return "FOOBAR!";
            }

            public boolean isFoo() {
                return true;
            }
        });
        map.put("derived", new DerivedClass());
        map.put("ipaddr", "10.1.1.2");
        map.put("dt1", new Date(System.currentTimeMillis() - 100000L));
        map.put("dt2", new Date(System.currentTimeMillis()));
        return map;
    }

    protected void tearDown() throws Exception {
    }

    protected Object test(String ex) {
        Thread[] threads = Boolean.getBoolean("mvel.tests.quick") ? new Thread[1] : (System.getProperty("mvel.tests.threadcount") != null ? new Thread[Integer.parseInt(System.getProperty("mvel.tests.threadcount"))] : new Thread[5]);
        Collection results = Collections.synchronizedCollection(new LinkedList());
        long time = System.currentTimeMillis();
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new TestRunner(results, ex));
        }
        if (!this.silentTests) {
            System.out.println("\n[test] begin test for:\n----------------------");
            System.out.println(ex);
            System.out.println("----------------------");
        }
        for (Thread thread1 : threads) {
            if (threads.length > 1) {
                System.out.println("Start Thread.");
                thread1.setPriority(1);
                thread1.start();
                continue;
            }
            thread1.run();
        }
        if (threads.length > 1) {
            boolean threadsRunning = true;
            while (threadsRunning) {
                threadsRunning = false;
                for (Thread thread : threads) {
                    if (!thread.isAlive()) continue;
                    System.out.println("Thread Alive.");
                    threadsRunning = true;
                    break;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
        System.out.println("All threads have stopped.");
        System.out.println("Result Count: " + results.size());
        if (!this.silentTests) {
            System.out.println("[test] finished in: " + (System.currentTimeMillis() - time) + "ms (execution count: " + threads.length * 8 + " [mixed modes])");
            System.out.print("[test] analyzing results ... ");
        }
        Object last = null;
        if (!results.isEmpty() && (last = results.iterator().next()) != null) {
            for (Object o : results) {
                if (o == null) {
                    throw new AssertionError((Object)("differing result in multi-thread test (first array has: " + String.valueOf(last) + "; second has: " + String.valueOf(o) + ")"));
                }
                if (!o.equals(last) && !o.getClass().isArray()) {
                    throw new AssertionError((Object)("differing result in multi-thread test (last was: " + String.valueOf(last) + "; current is: " + String.valueOf(o) + ")"));
                }
                last = o;
            }
        }
        if (!this.silentTests) {
            System.out.println("good!");
        }
        return last;
    }

    protected static Object runSingleTest(String ex) {
        return AbstractTest._test(ex);
    }

    protected static Object testCompiledSimple(String ex) {
        return MVEL.executeExpression((Object)MVEL.compileExpression((String)ex));
    }

    protected static Object testCompiledSimple(String ex, Map map) {
        return MVEL.executeExpression((Object)MVEL.compileExpression((String)ex), (Map)map);
    }

    protected static Object testCompiledSimple(String ex, Object base, Map map) {
        return MVEL.executeExpression((Object)MVEL.compileExpression((String)ex), (Object)base, (Map)map);
    }

    protected static Object _test(String ex) {
        CharArrayWriter writer;
        CharArrayWriter writer2;
        CharArrayWriter writer3;
        ExpressionCompiler compiler = new ExpressionCompiler(ex);
        StringAppender failErrors = new StringAppender();
        CompiledExpression compiled = compiler.compile();
        Object first = null;
        Object second = null;
        Object third = null;
        Object fourth = null;
        Object fifth = null;
        Object sixth = null;
        Object seventh = null;
        Object eighth = null;
        System.out.println(DebugTools.decompile((Serializable)compiled));
        if (!Boolean.getBoolean("mvel2.disable.jit")) {
            OptimizerFactory.setDefaultOptimizer((String)"ASM");
            try {
                first = MVEL.executeExpression((Object)compiled, (Object)new Base(), (Map)AbstractTest.createTestMap());
            }
            catch (Exception e) {
                failErrors.append("\nFIRST TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
                writer3 = new CharArrayWriter();
                e.printStackTrace(new PrintWriter(writer3));
                failErrors.append(writer3.toCharArray());
            }
            try {
                second = MVEL.executeExpression((Object)compiled, (Object)new Base(), (Map)AbstractTest.createTestMap());
            }
            catch (Exception e) {
                failErrors.append("\nSECOND TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
                writer3 = new CharArrayWriter();
                e.printStackTrace(new PrintWriter(writer3));
                failErrors.append(writer3.toCharArray());
            }
        }
        try {
            third = MVEL.eval((String)ex, (Object)new Base(), (Map)AbstractTest.createTestMap());
        }
        catch (Exception e) {
            failErrors.append("\nTHIRD TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
            writer3 = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(writer3));
            failErrors.append(writer3.toCharArray());
        }
        if (first != null && !first.getClass().isArray()) {
            if (!first.equals(second)) {
                System.out.println(failErrors.toString());
                throw new AssertionError((Object)("Different result from test 1 and 2 (Compiled Re-Run / JIT) [first: " + String.valueOf(first) + "; second: " + String.valueOf(second) + "]"));
            }
            if (!first.equals(third)) {
                if (failErrors != null) {
                    System.out.println(failErrors.toString());
                }
                throw new AssertionError((Object)("Different result from test 1 and 3 (Compiled to Interpreted) [first: " + String.valueOf(first) + " (" + (first != null ? first.getClass().getName() : null) + "); third: " + String.valueOf(third) + " (" + (third != null ? third.getClass().getName() : "null") + ")]"));
            }
        }
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        Serializable compiled2 = MVEL.compileExpression((String)ex);
        try {
            fourth = MVEL.executeExpression((Object)compiled2, (Object)new Base(), (Map)AbstractTest.createTestMap());
        }
        catch (Exception e) {
            if (failErrors == null) {
                failErrors = new StringAppender();
            }
            failErrors.append("\nFOURTH TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
            writer2 = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(writer2));
            failErrors.append(writer2.toCharArray());
        }
        try {
            fifth = MVEL.executeExpression((Object)compiled2, (Object)new Base(), (Map)AbstractTest.createTestMap());
        }
        catch (Exception e) {
            e.printStackTrace();
            if (failErrors == null) {
                failErrors = new StringAppender();
            }
            failErrors.append("\nFIFTH TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
            writer2 = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(writer2));
            failErrors.append(writer2.toCharArray());
        }
        if (fourth != null && !fourth.getClass().isArray() && !fourth.equals(fifth)) {
            throw new AssertionError((Object)("Different result from test 4 and 5 (Compiled Re-Run X2) [fourth: " + String.valueOf(fourth) + "; fifth: " + String.valueOf(fifth) + "]"));
        }
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("unittest");
        ctx.setDebugSymbols(true);
        ExpressionCompiler debuggingCompiler = new ExpressionCompiler(ex);
        CompiledExpression compiledD = debuggingCompiler.compile(ctx);
        try {
            sixth = MVEL.executeExpression((Object)compiledD, (Object)new Base(), (Map)AbstractTest.createTestMap());
        }
        catch (Exception e) {
            if (failErrors == null) {
                failErrors = new StringAppender();
            }
            failErrors.append("\nSIXTH TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
            writer = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(writer));
            failErrors.append(writer.toCharArray());
        }
        if (sixth != null && !sixth.getClass().isArray() && !fifth.equals(sixth)) {
            System.out.println("Payload 1 -- No Symbols: ");
            System.out.println(DebugTools.decompile((CompiledExpression)compiled));
            System.out.println();
            System.out.println("Payload 2 -- With Symbols: ");
            System.out.println(DebugTools.decompile((CompiledExpression)compiledD));
            System.out.println();
            throw new AssertionError((Object)("Different result from test 5 and 6 (Compiled to Compiled+DebuggingSymbols) [first: " + String.valueOf(fifth) + "; second: " + String.valueOf(sixth) + "]"));
        }
        try {
            seventh = MVEL.executeExpression((Object)compiledD, (Object)new Base(), (Map)AbstractTest.createTestMap());
        }
        catch (Exception e) {
            if (failErrors == null) {
                failErrors = new StringAppender();
            }
            failErrors.append("\nSEVENTH TEST: { " + ex + " }: EXCEPTION REPORT: \n\n");
            writer = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(writer));
            failErrors.append(writer.toCharArray());
        }
        if (seventh != null && !seventh.getClass().isArray() && !seventh.equals(sixth)) {
            throw new AssertionError((Object)("Different result from test 4 and 5 (Compiled Re-Run / Reflective) [first: " + String.valueOf(first) + "; second: " + String.valueOf(second) + "]"));
        }
        try {
            Serializable xx = AbstractTest.serializationTest((Serializable)compiledD);
            AbstractParser.resetParserContext();
            eighth = MVEL.executeExpression((Object)xx, (Object)new Base(), (VariableResolverFactory)new MapVariableResolverFactory(AbstractTest.createTestMap()));
        }
        catch (Exception e) {
            if (failErrors == null) {
                failErrors = new StringAppender();
            }
            failErrors.append("\nEIGHTH TEST (Serializability): { " + ex + " }: EXCEPTION REPORT: \n\n");
            writer = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(writer));
            failErrors.append(writer.toCharArray());
        }
        if (eighth != null && !eighth.getClass().isArray() && !eighth.equals(seventh)) {
            throw new AssertionError((Object)("Different result from test 7 and 8 (Compiled Re-Run / Reflective) [first: " + String.valueOf(first) + "; second: " + String.valueOf(second) + "]"));
        }
        if (failErrors.length() > 0) {
            System.out.println(DebugTools.decompile((CompiledExpression)compiledD));
            throw new AssertionError((Object)("Detailed Failure Report:\n" + failErrors.toString()));
        }
        return fourth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Serializable serializationTest(Serializable s) throws Exception {
        File file = new File("./mvel_ser_test" + System.currentTimeMillis() + Math.round(Math.random() * 1000.0) + ".tmp");
        InputStream inputStream = null;
        ObjectInputStream objectIn = null;
        try {
            file.createNewFile();
            file.deleteOnExit();
            FileOutputStream fileStream = new FileOutputStream(file);
            ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(fileStream));
            objectOut.writeObject(s);
            objectOut.flush();
            fileStream.flush();
            fileStream.close();
            inputStream = new BufferedInputStream(new FileInputStream(file));
            objectIn = new ObjectInputStream(inputStream);
            Serializable serializable = (Serializable)objectIn.readObject();
            return serializable;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (objectIn != null) {
                objectIn.close();
            }
        }
    }

    public static void assertNumEquals(Object obj, Object obj2) {
        AbstractTest.assertNumEquals(obj, obj2, true);
    }

    public static void assertNumEquals(Object obj, Object obj2, boolean permitRoundingVariance) {
        if (obj == null || obj2 == null) {
            throw new AssertionError((Object)"null value");
        }
        if (obj.getClass().equals(obj2.getClass())) {
            if (obj instanceof Number) {
                double compare = ((Number)obj).doubleValue() - ((Number)obj2).doubleValue();
                if (!(compare <= 1.0E-4) || !(compare >= -1.0E-4)) {
                    throw new AssertionFailedError("expected <" + String.valueOf(obj) + "> but was <" + String.valueOf(obj) + ">");
                }
            } else {
                AbstractTest.assertEquals((Object)obj, (Object)obj2);
            }
        } else if (!(obj = DataConversion.convert((Object)obj, obj2.getClass())).equals(obj2)) {
            if (permitRoundingVariance) {
                obj = DataConversion.convert((Object)obj, Integer.class);
                obj2 = DataConversion.convert((Object)obj2, Integer.class);
                AbstractTest.assertEquals((Object)obj, (Object)obj2);
            } else {
                throw new AssertionFailedError("expected <" + String.valueOf(obj) + "> but was <" + String.valueOf(obj) + ">");
            }
        }
    }

    static {
        DynamicOptimizer.tenuringThreshold = 1;
    }

    public static class Order {
        private int number = 20;

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }
    }

    public class ClassB {
        private Integer i;
        private double d;
        private String s;
        public String date;
        private BigDecimal bigdec;
        private BigInteger bigint;

        public Integer getI() {
            return this.i;
        }

        public void setI(Integer i) {
            this.i = i;
        }

        public double getD() {
            return this.d;
        }

        public void setD(double d) {
            this.d = d;
        }

        public String getS() {
            return this.s;
        }

        public void setS(String s) {
            this.s = s;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public BigDecimal getBigdec() {
            return this.bigdec;
        }

        public void setBigdec(BigDecimal bigdec) {
            this.bigdec = bigdec;
        }

        public BigInteger getBigint() {
            return this.bigint;
        }

        public void setBigint(BigInteger bigint) {
            this.bigint = bigint;
        }
    }

    public class ClassA {
        private Integer i;
        private double d;
        private String s;
        public Date date;
        private BigDecimal bigdec;
        private BigInteger bigint;

        public Integer getI() {
            return this.i;
        }

        public void setI(Integer i) {
            this.i = i;
        }

        public double getD() {
            return this.d;
        }

        public void setD(double d) {
            this.d = d;
        }

        public String getS() {
            return this.s;
        }

        public void setS(String s) {
            this.s = s;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public BigDecimal getBigdec() {
            return this.bigdec;
        }

        public void setBigdec(BigDecimal bigdec) {
            this.bigdec = bigdec;
        }

        public BigInteger getBigint() {
            return this.bigint;
        }

        public void setBigint(BigInteger bigint) {
            this.bigint = bigint;
        }
    }

    public static class Item {
        private String name;

        public Item(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class Message {
        public static final int HELLO = 0;
        public static final int GOODBYE = 1;
        private List items = new ArrayList();
        private String message;
        private int status;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void addItem(Item item) {
            this.items.add(item);
        }

        public List getItems() {
            return this.items;
        }
    }

    public static class Model {
        private List latestHeadlines;

        public List getLatestHeadlines() {
            return this.latestHeadlines;
        }

        public void setLatestHeadlines(List latestHeadlines) {
            this.latestHeadlines = latestHeadlines;
        }
    }

    public static class Drools {
        public void insert(Object obj) {
        }
    }

    public static class Address {
        private String street;

        public Address(String street) {
            this.street = street;
        }

        public String getStreet() {
            return this.street;
        }

        public void setStreet(String street) {
            this.street = street;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Person {
        private String name;
        private int age;
        private String likes;
        private List<Foo> footributes;
        private Map<String, Foo> maptributes;
        private Map<Object, Foo> objectKeyMaptributes;

        public Person() {
        }

        public Person(String name) {
            this.name = name;
        }

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public Person(String name, String likes, int age) {
            this.name = name;
            this.likes = likes;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public List<Foo> getFootributes() {
            return this.footributes;
        }

        public void setFootributes(List<Foo> footributes) {
            this.footributes = footributes;
        }

        public Map<String, Foo> getMaptributes() {
            return this.maptributes;
        }

        public void setMaptributes(Map<String, Foo> maptributes) {
            this.maptributes = maptributes;
        }

        public Map<Object, Foo> getObjectKeyMaptributes() {
            return this.objectKeyMaptributes;
        }

        public void setObjectKeyMaptributes(Map<Object, Foo> objectKeyMaptributes) {
            this.objectKeyMaptributes = objectKeyMaptributes;
        }

        public String toString() {
            return "Person( name==" + this.name + " age==" + this.age + " likes==" + this.likes + " )";
        }
    }

    public static class Context {
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy");
        private Bean bean;

        public Bean getBean() {
            return this.bean;
        }

        public void setBean(Bean bean) {
            this.bean = bean;
        }

        public String formatDate(Date date) {
            return date == null ? null : this.dateFormat.format(date);
        }

        public String formatString(String str) {
            return str == null ? "<NULL>" : str;
        }
    }

    public static class Bean {
        private Date myDate = new Date();

        public Date getToday() {
            return new Date();
        }

        public Date getNullDate() {
            return null;
        }

        public String getNullString() {
            return null;
        }

        public Date getMyDate() {
            return this.myDate;
        }

        public void setMyDate(Date myDate) {
            this.myDate = myDate;
        }
    }

    public static class MiscTestClass {
        int exec = 0;

        public List toList(Object object1, String string, int integer, Map map, List list) {
            ++this.exec;
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(object1);
            l.add(string);
            l.add(new Integer(integer));
            l.add(map);
            l.add(list);
            return l;
        }

        public int getExec() {
            return this.exec;
        }
    }

    protected static class TestRunner
    implements Runnable {
        private Collection results;
        private String expression;

        public TestRunner(Collection results, String expression) {
            this.results = results;
            this.expression = expression;
        }

        public void run() {
            try {
                Object result = AbstractTest.runSingleTest(this.expression);
                this.results.add(result);
            }
            catch (Throwable e) {
                System.out.println("thread terminating due to exception");
                e.printStackTrace();
                return;
            }
        }
    }
}

