/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.integration.ResolverTools;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ClassImportResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.tests.core.AbstractTest;
import org.mvel2.tests.core.res.Bar;
import org.mvel2.tests.core.res.Base;
import org.mvel2.tests.core.res.Foo;
import org.mvel2.tests.core.res.MyEnum;
import org.mvel2.tests.core.res.Thing;

public class WithTests
extends AbstractTest {
    public void testWith() {
        String ex = "with (foo) {aValue = 'One',bValue='Two'}; foo.aValue + foo.bValue;";
        Map vars = WithTests.createTestMap();
        Object o = MVEL.eval((String)ex, (Map)vars);
        WithTests.assertEquals((Object)"OneTwo", (Object)o);
        WithTests.assertEquals((Object)"OneTwo", (Object)this.test("with (foo) {aValue = 'One',bValue='Two'}; foo.aValue + foo.bValue;"));
    }

    public void testWith2() {
        WithTests.assertEquals((Object)"OneTwoOne", (Object)this.test("var y; with (foo) { \naValue = (y = 'One'), // this is a comment \nbValue='Two'  // this is also a comment \n}; \nfoo.aValue + foo.bValue + y;"));
    }

    public void testWith3() {
        String ex = "with (foo) {aValue = 'One',bValue='Two'}; with (foo) {aValue += 'One', bValue += 'Two'}; foo.aValue + foo.bValue;";
        Map vars = WithTests.createTestMap();
        WithTests.assertEquals((Object)"OneOneTwoTwo", (Object)MVEL.eval((String)ex, (Map)vars));
        WithTests.assertEquals((Object)"OneOneTwoTwo", (Object)this.test("with (foo) {aValue = 'One',bValue='Two'}; with (foo) {aValue += 'One', bValue += 'Two'}; foo.aValue + foo.bValue;"));
    }

    public void testWith4() {
        WithTests.assertEquals((Object)10, (Object)this.test("with (foo) {countTest += 5 }; with (foo) { countTest *= 2 }; foo.countTest"));
    }

    public void testWith5() {
        String expr = "with (foo) { countTest += 5, \n// foobar!\naValue = 'Hello',\n/** Comment! **/\nbValue = 'Goodbye'\n }; with (foo) { countTest *= 2 }; foo";
        Map vars = WithTests.createTestMap();
        WithTests.assertEquals((boolean)true, (boolean)(MVEL.eval((String)expr, (Map)vars) instanceof Foo));
        Foo foo = (Foo)this.test(expr);
        WithTests.assertEquals((int)10, (int)foo.getCountTest());
        WithTests.assertEquals((String)"Hello", (String)foo.aValue);
        WithTests.assertEquals((String)"Goodbye", (String)foo.bValue);
    }

    public void testInlineWith() {
        CompiledExpression expr = new ExpressionCompiler("foo.{name='poopy', aValue='bar'}").compile();
        Foo f = (Foo)MVEL.executeExpression((Object)expr, (Map)WithTests.createTestMap());
        WithTests.assertEquals((String)"poopy", (String)f.getName());
        WithTests.assertEquals((String)"bar", (String)f.aValue);
    }

    public void testInlineWith2() {
        CompiledExpression expr = new ExpressionCompiler("foo.{name = 'poopy', aValue = 'bar', bar.{name = 'foobie'}}").compile();
        Foo f = (Foo)MVEL.executeExpression((Object)expr, (Map)WithTests.createTestMap());
        WithTests.assertEquals((String)"poopy", (String)f.getName());
        WithTests.assertEquals((String)"bar", (String)f.aValue);
        WithTests.assertEquals((String)"foobie", (String)f.getBar().getName());
    }

    public void testInlineWith3() {
        CompiledExpression expr = new ExpressionCompiler("foo.{name = 'poopy', aValue = 'bar', bar.{name = 'foobie'}, toUC('doopy')}").compile();
        Foo f = (Foo)MVEL.executeExpression((Object)expr, (Map)WithTests.createTestMap());
        WithTests.assertEquals((String)"poopy", (String)f.getName());
        WithTests.assertEquals((String)"bar", (String)f.aValue);
        WithTests.assertEquals((String)"foobie", (String)f.getBar().getName());
        WithTests.assertEquals((String)"doopy", (String)f.register);
    }

    public void testInlineWith3a() {
        CompiledExpression expr = new ExpressionCompiler("foo.{name='poopy',aValue='bar',bar.{name='foobie'},toUC('doopy')}").compile();
        Foo f = (Foo)MVEL.executeExpression((Object)expr, (Map)WithTests.createTestMap());
        WithTests.assertEquals((String)"poopy", (String)f.getName());
        WithTests.assertEquals((String)"bar", (String)f.aValue);
        WithTests.assertEquals((String)"foobie", (String)f.getBar().getName());
        WithTests.assertEquals((String)"doopy", (String)f.register);
    }

    public void testInlineWith4() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ExpressionCompiler expr = new ExpressionCompiler("new Foo().{ name = 'bar' }");
        ParserContext pCtx = new ParserContext();
        pCtx.addImport(Foo.class);
        CompiledExpression c = expr.compile(pCtx);
        Foo f = (Foo)MVEL.executeExpression((Object)c);
        WithTests.assertEquals((String)"bar", (String)f.getName());
        f = (Foo)MVEL.executeExpression((Object)c);
        WithTests.assertEquals((String)"bar", (String)f.getName());
    }

    public void testInlineWith5() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ParserContext pCtx = new ParserContext();
        pCtx.setStrongTyping(true);
        pCtx.addInput("foo", Foo.class);
        CompiledExpression expr = new ExpressionCompiler("foo.{name='poopy', aValue='bar'}").compile(pCtx);
        Foo f = (Foo)MVEL.executeExpression((Object)expr, (Map)WithTests.createTestMap());
        WithTests.assertEquals((String)"poopy", (String)f.getName());
        WithTests.assertEquals((String)"bar", (String)f.aValue);
    }

    public void testInlineWithImpliedThis() {
        Base b = new Base();
        ExpressionCompiler expr = new ExpressionCompiler(".{ data = 'foo' }");
        CompiledExpression compiled = expr.compile();
        MVEL.executeExpression((Object)compiled, (Object)b);
        WithTests.assertEquals((String)b.data, (String)"foo");
    }

    public void testSingleMethodCall() {
        Base b = new Base();
        HashMap<String, Base> map = new HashMap<String, Base>();
        map.put("base", b);
        MVEL.eval((String)"base.{ populate() }", map);
        WithTests.assertEquals((String)"sarah", (String)b.barfoo);
    }

    public void testWithMultipleMethodCalls() {
        ParserContext ctx = ParserContext.create().stronglyTyped().withInput("foo", Foo.class);
        MVEL.compileExpression((String)"with (foo) { setName('foo'), setBar(null) }", (ParserContext)ctx);
    }

    public void testNewUsingWith() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addImport(Foo.class);
        ctx.addImport(Bar.class);
        Serializable s = MVEL.compileExpression((String)"[ 'foo' : (with ( new Foo() ) { bar = with ( new Bar() ) { name = 'ziggy' } }) ]", (ParserContext)ctx);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        WithTests.assertEquals((String)"ziggy", (String)((Foo)((Map)MVEL.executeExpression((Object)s)).get("foo")).getBar().getName());
    }

    public void testSataticClassImportViaFactoryAndWithModification() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        MapVariableResolverFactory mvf = new MapVariableResolverFactory(WithTests.createTestMap());
        ClassImportResolverFactory classes = new ClassImportResolverFactory(null, null, false);
        classes.addClass(AbstractTest.Person.class);
        ResolverTools.appendFactory((VariableResolverFactory)mvf, (VariableResolverFactory)classes);
        WithTests.assertEquals((Object)21, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"p = new Person('tom'); p.age = 20; with( p ) { age = p.age + 1 }; return p.age;", (Map)classes.getImportedClasses()), (VariableResolverFactory)mvf));
    }

    public void testExecuteCoercionTwice() {
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("foo", new Foo());
        vars.put("$value", new Long(5L));
        ExpressionCompiler compiler = new ExpressionCompiler("with (foo) { countTest = $value };");
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test.mv");
        ctx.setDebugSymbols(true);
        CompiledExpression compiled = compiler.compile(ctx);
        MVEL.executeExpression((Object)compiled, null, vars);
        MVEL.executeExpression((Object)compiled, null, vars);
    }

    public void testExecuteCoercionTwice2() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("foo", new Foo());
        vars.put("$value", new Long(5L));
        ExpressionCompiler compiler = new ExpressionCompiler("with (foo) { countTest = $value };");
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test.mv");
        ctx.setDebugSymbols(true);
        CompiledExpression compiled = compiler.compile(ctx);
        MVEL.executeExpression((Object)compiled, null, vars);
        MVEL.executeExpression((Object)compiled, null, vars);
    }

    public void testNestedWithInList() {
        Recipient recipient1 = new Recipient();
        recipient1.setName("userName1");
        recipient1.setEmail("user1@domain.com");
        Recipient recipient2 = new Recipient();
        recipient2.setName("userName2");
        recipient2.setEmail("user2@domain.com");
        ArrayList<Recipient> list = new ArrayList<Recipient>();
        list.add(recipient1);
        list.add(recipient2);
        String text = "array = [(with ( new Recipient() ) {name = 'userName1', email = 'user1@domain.com' }),(with ( new Recipient() ) {name = 'userName2', email = 'user2@domain.com' })];\n";
        ParserContext context = new ParserContext();
        context.addImport(Recipient.class);
        ExpressionCompiler compiler = new ExpressionCompiler(text);
        CompiledExpression execution = compiler.compile(context);
        List result = (List)MVEL.executeExpression((Object)execution, new HashMap());
        WithTests.assertEquals(list, (Object)result);
    }

    public void testNestedWithInComplexGraph3() {
        Recipients recipients = new Recipients();
        Recipient recipient1 = new Recipient();
        recipient1.setName("user1");
        recipient1.setEmail("user1@domain.com");
        recipients.addRecipient(recipient1);
        Recipient recipient2 = new Recipient();
        recipient2.setName("user2");
        recipient2.setEmail("user2@domain.com");
        recipients.addRecipient(recipient2);
        EmailMessage msg = new EmailMessage();
        msg.setRecipients(recipients);
        msg.setFrom("from@domain.com");
        String text = "";
        text = text + "new EmailMessage().{ ";
        text = text + "     recipients = new Recipients().{ ";
        text = text + "         recipients = [ new Recipient().{ name = 'user1', email = 'user1@domain.com' }, ";
        text = text + "                        new Recipient().{ name = 'user2', email = 'user2@domain.com' } ] ";
        text = text + "     }, ";
        text = text + "     from = 'from@domain.com' }";
        ParserContext context = new ParserContext();
        context.addImport(Recipient.class);
        context.addImport(Recipients.class);
        context.addImport(EmailMessage.class);
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ExpressionCompiler compiler = new ExpressionCompiler(text);
        CompiledExpression execution = compiler.compile(context);
        WithTests.assertEquals((Object)msg, (Object)MVEL.executeExpression((Object)execution));
        WithTests.assertEquals((Object)msg, (Object)MVEL.executeExpression((Object)execution));
        WithTests.assertEquals((Object)msg, (Object)MVEL.executeExpression((Object)execution));
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        context = new ParserContext(context.getParserConfiguration());
        compiler = new ExpressionCompiler(text);
        execution = compiler.compile(context);
        WithTests.assertEquals((Object)msg, (Object)MVEL.executeExpression((Object)execution));
        WithTests.assertEquals((Object)msg, (Object)MVEL.executeExpression((Object)execution));
        WithTests.assertEquals((Object)msg, (Object)MVEL.executeExpression((Object)execution));
    }

    public void testInlineWithWithLiteral() {
        String expr = "'foo'.{ toString() }";
        WithTests.assertEquals((Object)"foo", (Object)MVEL.eval((String)expr));
        Serializable s = MVEL.compileExpression((String)expr);
        WithTests.assertEquals((Object)"foo", (Object)MVEL.executeExpression((Object)s));
    }

    public void testInlineWithWithLiteral2() {
        String expr = "'foo'.{ toString() . toString() . toString() }";
        WithTests.assertEquals((Object)"foo", (Object)MVEL.eval((String)expr));
        Serializable s = MVEL.compileExpression((String)expr);
        WithTests.assertEquals((Object)"foo", (Object)MVEL.executeExpression((Object)s));
    }

    public void testWithAndEnumInPackageImport() {
        ParserConfiguration pconf = new ParserConfiguration();
        pconf.addPackageImport(MyEnum.class.getPackage().getName());
        ParserContext pCtx = new ParserContext(pconf);
        pCtx.setStrongTyping(true);
        pCtx.addInput("thing", Thing.class);
        Thing thing = new Thing("xxx");
        HashMap<String, Thing> vars = new HashMap<String, Thing>();
        vars.put("thing", thing);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)"with( thing ) { myEnum = MyEnum.FULL_DOCUMENTATION }", (ParserContext)pCtx);
        MVEL.executeExpression((Object)stmt, null, vars);
        WithTests.assertEquals((Object)((Object)MyEnum.FULL_DOCUMENTATION), (Object)((Object)thing.getMyEnum()));
    }

    public static class EmailMessage {
        private Recipients recipients;
        private String from;

        public Recipients getRecipients() {
            return this.recipients;
        }

        public void setRecipients(Recipients recipients) {
            this.recipients = recipients;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.recipients == null ? 0 : this.recipients.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EmailMessage other = (EmailMessage)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.recipients == null ? other.recipients != null : !this.recipients.equals(other.recipients));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Recipients {
        private List<Recipient> list = Collections.EMPTY_LIST;

        public void setRecipients(List<Recipient> recipients) {
            this.list = recipients;
        }

        public boolean addRecipient(Recipient recipient) {
            if (this.list == Collections.EMPTY_LIST) {
                this.list = new ArrayList<Recipient>();
            }
            if (!this.list.contains(recipient)) {
                this.list.add(recipient);
                return true;
            }
            return false;
        }

        public boolean removeRecipient(Recipient recipient) {
            return this.list.remove(recipient);
        }

        public List<Recipient> getRecipients() {
            return this.list;
        }

        public Recipient[] toArray() {
            return this.list.toArray(new Recipient[this.list.size()]);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Recipients other = (Recipients)obj;
            if (this.list == null && other.list != null) {
                return false;
            }
            return this.list.equals(other.list);
        }
    }

    public static class Recipient {
        private String name;
        private String email;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Recipient other = (Recipient)obj;
            if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

