/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.compiler.ExpressionCompiler;

public class GenericsTypeInferenceTest
extends TestCase {
    private static final List<String> STRINGS = Arrays.asList("hi", "there", "dude");

    public final void testInferLastTypeParametersFromProperty() {
        ParserContext context = new ParserContext();
        context.setStrongTyping(true);
        context.addInput("a", A.class);
        CompiledExpression compiledExpression = new ExpressionCompiler("a.strings", context).compile();
        Object val = MVEL.executeExpression((Object)compiledExpression, (Object)new AWrapper());
        GenericsTypeInferenceTest.assertTrue((String)("Expression did not evaluate correctly: " + val), (boolean)STRINGS.equals(val));
        GenericsTypeInferenceTest.assertTrue((String)"No type parameters detected", (null != context.getLastTypeParameters() ? 1 : 0) != 0);
        GenericsTypeInferenceTest.assertTrue((String)"Wrong parametric type inferred", (boolean)String.class.equals((Object)context.getLastTypeParameters()[0]));
    }

    public final void testInferLastTypeParametersFromMethod() {
        ParserContext context = new ParserContext();
        context.setStrongTyping(true);
        context.addInput("a", A.class);
        CompiledExpression compiledExpression = new ExpressionCompiler("a.values()", context).compile();
        Object val = MVEL.executeExpression((Object)compiledExpression, (Object)new AWrapper());
        GenericsTypeInferenceTest.assertTrue((String)("Expression did not evaluate correctly: " + val), (boolean)STRINGS.equals(val));
        GenericsTypeInferenceTest.assertTrue((String)"No type parameters detected", (null != context.getLastTypeParameters() ? 1 : 0) != 0);
        GenericsTypeInferenceTest.assertTrue((String)"Wrong parametric type inferred", (boolean)String.class.equals((Object)context.getLastTypeParameters()[0]));
    }

    public final void testInferLastTypeParametersFromPropertyMethod() {
        ParserContext context = new ParserContext();
        context.setStrongTyping(true);
        context.addInput("a", A.class);
        CompiledExpression compiledExpression = new ExpressionCompiler("a.getFooMap()[\"key\"].someMethod()", context).compile();
        Object val = MVEL.executeExpression((Object)compiledExpression, (Object)new AWrapper());
        GenericsTypeInferenceTest.assertEquals((String)"Expression did not evaluate correctly: ", (Object)"bar", (Object)val);
        GenericsTypeInferenceTest.assertNotNull((String)"No type parameters detected", (Object)context.getLastTypeParameters());
        GenericsTypeInferenceTest.assertEquals((String)"Wrong parametric type inferred", String.class, (Object)context.getLastTypeParameters()[0]);
    }

    public final void testTypeByMethod() {
        ParserContext context = new ParserContext();
        context.setStrongTyping(true);
        context.addInput("a", A.class);
        CompiledExpression compiledExpression = new ExpressionCompiler("!a.show", context).compile();
        GenericsTypeInferenceTest.assertEquals(Boolean.class, (Object)compiledExpression.getKnownEgressType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAmazed() {
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        try {
            ParserContext context = new ParserContext();
            context.setStrongTyping(true);
            context.addInput("this", Amazed1.class);
            ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)"list.size", (ParserContext)context);
            Amazed1 a1 = new Amazed1();
            GenericsTypeInferenceTest.assertEquals((Object)new Integer(0), (Object)MVEL.executeExpression((Object)stmt, (Object)a1));
            context = new ParserContext();
            context.setStrongTyping(true);
            context.addInput("this", Amazed2.class);
            stmt = (ExecutableStatement)MVEL.compileExpression((String)"list.size", (ParserContext)context);
            Amazed2 a2 = new Amazed2();
            GenericsTypeInferenceTest.assertEquals((Object)new Integer(0), (Object)MVEL.executeExpression((Object)stmt, (Object)a2));
        }
        finally {
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = false;
        }
    }

    public static class Amazed2 {
        private List list = new ArrayList();

        public List getList() {
            return this.list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Amazed1 {
        private List list = new ArrayList();

        public List<Integer> getList() {
            return this.list;
        }
    }

    public static class FooImpl
    implements Foo {
        public String someMethod() {
            return "bar";
        }
    }

    public static interface Foo {
        public String someMethod();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class A {
        private boolean show;

        public boolean isShow() {
            return this.show;
        }

        public void setShow(boolean show) {
            this.show = show;
        }

        public List<String> getStrings() {
            return STRINGS;
        }

        public List<String> values() {
            return STRINGS;
        }

        public Map<String, Foo> getFooMap() {
            HashMap<String, Foo> map = new HashMap<String, Foo>();
            map.put("key", new Foo(){

                public String someMethod() {
                    return "bar";
                }
            });
            return map;
        }

        public Map<String, Foo> getBarMap() {
            HashMap<String, Foo> map = new HashMap<String, Foo>();
            map.put("key", new FooImpl());
            return map;
        }
    }

    public static class AWrapper {
        public A getA() {
            return new A();
        }
    }
}

