/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.tests.core.AbstractTest;
import org.mvel2.tests.core.res.Bar;
import org.mvel2.tests.core.res.Cheese;
import org.mvel2.tests.core.res.Foo;

public class ArraysTests
extends AbstractTest {
    public void testArrayConstructionSupport1() {
        ArraysTests.assertTrue((boolean)(this.test("new String[5]") instanceof String[]));
    }

    public void testArrayConstructionSupport2() {
        ArraysTests.assertTrue((boolean)((Boolean)this.test("xStr = new String[5]; xStr.size() == 5")));
    }

    public void testArrayConstructionSupport3() {
        String exp = "xStr = new String[5][5]; xStr[4][0] = 'foo'; xStr[4][0]";
        Serializable s = MVEL.compileExpression((String)exp);
        ArraysTests.assertEquals((Object)"foo", (Object)MVEL.executeExpression((Object)s, new HashMap()));
        ArraysTests.assertEquals((Object)"foo", (Object)this.test(exp));
    }

    public void testArrayConstructionSupport4() {
        ArraysTests.assertEquals((Object)10, (Object)this.test("xStr = new String[5][10]; xStr[4][0] = 'foo'; xStr[4].length"));
    }

    public void testArrayDefinitionWithInitializer() {
        String[] compareTo = new String[]{"foo", "bar"};
        String[] results = (String[])MVEL.eval((String)"new String[] { 'foo', 'bar' }");
        for (int i = 0; i < compareTo.length; ++i) {
            if (!compareTo[i].equals(results[i])) {
                throw new AssertionError((Object)"arrays do not match.");
            }
        }
    }

    public void testArrayDefinitionWithCoercion() {
        double[] d = (double[])MVEL.executeExpression((Object)MVEL.compileExpression((String)"new double[] { 1,2,3,4 }"));
        ArraysTests.assertEquals((Object)2.0, (Object)d[1]);
    }

    public void testArrayDefinitionWithCoercion2() {
        float[] d = (float[])MVEL.executeExpression((Object)MVEL.compileExpression((String)"new float[] { 1,2,3,4 }"));
        ArraysTests.assertEquals((Object)Float.valueOf(2.0f), (Object)Float.valueOf(d[1]));
    }

    public void testArrayCreation2() {
        String[][] s = (String[][])this.test("new String[][] {{\"2008-04-01\", \"2008-05-10\"}, {\"2007-03-01\", \"2007-02-12\"}}");
        ArraysTests.assertEquals((String)"2007-03-01", (String)s[1][0]);
    }

    public void testArrayCreation3() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        Serializable ce = MVEL.compileExpression((String)"new String[][] {{\"2008-04-01\", \"2008-05-10\"}, {\"2007-03-01\", \"2007-02-12\"}}");
        String[][] s = (String[][])MVEL.executeExpression((Object)ce);
        ArraysTests.assertEquals((String)"2007-03-01", (String)s[1][0]);
    }

    public void testArrayCreation4() {
        String[][] s = (String[][])this.test("new String[][]{{\"2008-04-01\", \"2008-05-10\"}, {\"2007-03-01\", \"2007-02-12\"}}");
        ArraysTests.assertEquals((String)"2007-03-01", (String)s[1][0]);
    }

    public void testArrayCoercion1() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("bar", Bar.class);
        Serializable s = MVEL.compileSetExpression((String)"bar.intarray[0]", (ParserContext)ctx);
        Foo foo = new Foo();
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)"12");
        ArraysTests.assertEquals((int)12, (int)foo.getBar().getIntarray()[0]);
        foo = new Foo();
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)"13");
        ArraysTests.assertEquals((int)13, (int)foo.getBar().getIntarray()[0]);
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("bar", Bar.class);
        s = MVEL.compileSetExpression((String)"bar.intarray[0]", (ParserContext)ctx);
        foo = new Foo();
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)"12");
        ArraysTests.assertEquals((int)12, (int)foo.getBar().getIntarray()[0]);
        MVEL.executeSetExpression((Serializable)s, (Object)foo, (Object)"13");
        ArraysTests.assertEquals((int)13, (int)foo.getBar().getIntarray()[0]);
    }

    public void testArrayLength() {
        ParserContext context = new ParserContext();
        context.setStrongTyping(true);
        context.addInput("x", String[].class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)"x.length", (ParserContext)context);
    }

    public void testMultiDimensionalArrayType() {
        String str = "$c.cheeses[0][0] = new Cheese('brie', 15)";
        ParserConfiguration pconf = new ParserConfiguration();
        pconf.addImport(Cheese.class);
        ParserContext pctx = new ParserContext(pconf);
        pctx.addInput("$c", Column.class);
        pctx.setStrongTyping(true);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        HashMap<String, Column> vars = new HashMap<String, Column>();
        Column c = new Column("x", 1);
        c.setCheeses(new Cheese[5][5]);
        vars.put("$c", c);
        MVEL.executeExpression((Object)stmt, null, vars);
        ArraysTests.assertEquals((Object)new Cheese("brie", 15), (Object)c.getCheeses()[0][0]);
    }

    public void testAssignmentOnTwoDimensionalArrayUsingIndexedInput() {
        ParserConfiguration conf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(conf);
        pctx.setIndexAllocation(true);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("array", Double[][].class);
        pctx.addIndexedInput("array");
        HashMap vars = new HashMap(){
            {
                this.put("array", new Double[2][2]);
            }
        };
        ArraysTests.assertEquals((Object)42.0, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"array[1][1] = 42.0;\narray[1][1]", (ParserContext)pctx), (Map)vars));
    }

    public class Column {
        private String name;
        private int length;
        private Cheese[][] cheeses;

        public Cheese[][] getCheeses() {
            return this.cheeses;
        }

        public void setCheeses(Cheese[][] cheeses) {
            this.cheeses = cheeses;
        }

        public Column(String name, int length) {
            this.name = name;
            this.length = length;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }
    }
}

