/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.tests.core.AbstractTest;
import org.mvel2.tests.core.res.Base;
import org.mvel2.tests.core.res.Cake;
import org.mvel2.tests.core.res.Foo;

public class PropertyAccessTests
extends AbstractTest {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = false;
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.DYNAMIC);
    }

    public void testSingleProperty() {
        PropertyAccessTests.assertEquals((Object)false, (Object)this.test("fun"));
    }

    public void testMethodOnValue() {
        PropertyAccessTests.assertEquals((Object)"DOG", (Object)this.test("foo.bar.name.toUpperCase()"));
    }

    public void testMethodOnValue2() {
        PropertyAccessTests.assertEquals((Object)"DOG", (Object)this.test("foo. bar. name.toUpperCase()"));
    }

    public void testSimpleProperty() {
        PropertyAccessTests.assertEquals((Object)"dog", (Object)this.test("foo.bar.name"));
    }

    public void testSimpleProperty2() {
        PropertyAccessTests.assertEquals((Object)"cat", (Object)this.test("DATA"));
    }

    public void testPropertyViaDerivedClass() {
        PropertyAccessTests.assertEquals((Object)"cat", (Object)this.test("derived.data"));
    }

    public void testThroughInterface() {
        PropertyAccessTests.assertEquals((Object)"FOOBAR!", (Object)this.test("testImpl.name"));
    }

    public void testThroughInterface2() {
        PropertyAccessTests.assertEquals((Object)true, (Object)this.test("testImpl.foo"));
    }

    public void testMapAccessWithMethodCall() {
        PropertyAccessTests.assertEquals((Object)"happyBar", (Object)this.test("funMap['foo'].happy()"));
    }

    public void testUninitializedInt() {
        PropertyAccessTests.assertEquals((Object)0, (Object)this.test("sarahl"));
    }

    public void testMethodAccess() {
        PropertyAccessTests.assertEquals((Object)"happyBar", (Object)this.test("foo.happy()"));
    }

    public void testMethodAccess2() {
        PropertyAccessTests.assertEquals((Object)"FUBAR", (Object)this.test("foo.toUC( 'fubar' )"));
    }

    public void testMethodAccess3() {
        PropertyAccessTests.assertEquals((Object)true, (Object)this.test("equalityCheck(c, 'cat')"));
    }

    public void testMethodAccess4() {
        PropertyAccessTests.assertEquals(null, (Object)this.test("readBack(null)"));
    }

    public void testMethodAccess5() {
        PropertyAccessTests.assertEquals((Object)"nulltest", (Object)this.test("appendTwoStrings(null, 'test')"));
    }

    public void testMethodAccess6() {
        PropertyAccessTests.assertEquals((Object)true, (Object)this.test("   equalityCheck(   c  \n  ,   \n   'cat'      )   "));
    }

    public void testLiteralPassThrough() {
        PropertyAccessTests.assertEquals((Object)true, (Object)this.test("true"));
    }

    public void testLiteralPassThrough2() {
        PropertyAccessTests.assertEquals((Object)false, (Object)this.test("false"));
    }

    public void testLiteralPassThrough3() {
        PropertyAccessTests.assertEquals(null, (Object)this.test("null"));
    }

    public void testLiteralReduction1() {
        PropertyAccessTests.assertEquals((Object)"foo", (Object)this.test("null or 'foo'"));
    }

    public void testStrAppend() {
        PropertyAccessTests.assertEquals((Object)"foobarcar", (Object)this.test("'foo' + 'bar' + 'car'"));
    }

    public void testStrAppend2() {
        PropertyAccessTests.assertEquals((Object)"foobarcar1", (Object)this.test("'foobar' + 'car' + 1"));
    }

    public void testMapAccess() {
        PropertyAccessTests.assertEquals((Object)"dog", (Object)this.test("funMap['foo'].bar.name"));
    }

    public void testMapAccess2() {
        PropertyAccessTests.assertEquals((Object)"dog", (Object)this.test("funMap.foo.bar.name"));
    }

    public void testStaticMethodFromLiteral() {
        PropertyAccessTests.assertEquals((Object)String.class.getName(), (Object)this.test("String.valueOf(Class.forName('java.lang.String').getName())"));
    }

    public void testObjectInstantiation() {
        this.test("new java.lang.String('foobie')");
    }

    public void testObjectInstantiationWithMethodCall() {
        PropertyAccessTests.assertEquals((Object)"FOOBIE", (Object)this.test("new String('foobie')  . toUpperCase()"));
    }

    public void testObjectInstantiation2() {
        this.test("new String() is String");
    }

    public void testObjectInstantiation3() {
        this.test("new java.text.SimpleDateFormat('yyyy').format(new java.util.Date(System.currentTimeMillis()))");
    }

    public void testThisReference() {
        PropertyAccessTests.assertEquals((boolean)true, (boolean)(this.test("this") instanceof Base));
    }

    public void testThisReference2() {
        PropertyAccessTests.assertEquals((boolean)true, (boolean)(this.test("this.funMap") instanceof Map));
    }

    public void testThisReferenceInMethodCall() {
        PropertyAccessTests.assertEquals((Object)101, (Object)this.test("Integer.parseInt(this.number)"));
    }

    public void testThisReferenceInConstructor() {
        PropertyAccessTests.assertEquals((Object)"101", (Object)this.test("new String(this.number)"));
    }

    public void testStringEscaping() {
        PropertyAccessTests.assertEquals((Object)"\"Mike Brock\"", (Object)this.test("\"\\\"Mike Brock\\\"\""));
    }

    public void testStringEscaping2() {
        PropertyAccessTests.assertEquals((Object)"MVEL's Parser is Fast", (Object)this.test("'MVEL\\'s Parser is Fast'"));
    }

    public void testCompiledMethodCall() {
        PropertyAccessTests.assertEquals(String.class, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"c.getClass()"), (Object)new Base(), (Map)PropertyAccessTests.createTestMap()));
    }

    public void testStaticNamespaceCall() {
        PropertyAccessTests.assertEquals(ArrayList.class, (Object)this.test("java.util.ArrayList"));
    }

    public void testStaticNamespaceClassWithMethod() {
        PropertyAccessTests.assertEquals((Object)"FooBar", (Object)this.test("java.lang.String.valueOf('FooBar')"));
    }

    public void testStaticNamespaceClassWithField() {
        PropertyAccessTests.assertEquals((Object)Integer.MAX_VALUE, (Object)this.test("java.lang.Integer.MAX_VALUE"));
    }

    public void testStaticNamespaceClassWithField2() {
        PropertyAccessTests.assertEquals((Object)Integer.MAX_VALUE, (Object)this.test("Integer.MAX_VALUE"));
    }

    public void testStaticFieldAsMethodParm() {
        PropertyAccessTests.assertEquals((Object)String.valueOf(Integer.MAX_VALUE), (Object)this.test("String.valueOf(Integer.MAX_VALUE)"));
    }

    public void testMagicArraySize() {
        PropertyAccessTests.assertEquals((Object)5, (Object)this.test("stringArray.size()"));
    }

    public void testMagicArraySize2() {
        PropertyAccessTests.assertEquals((Object)5, (Object)this.test("intArray.size()"));
    }

    public void testObjectCreation() {
        PropertyAccessTests.assertEquals((Object)6, (Object)this.test("new Integer( 6 )"));
    }

    public void testCompileTimeLiteralReduction() {
        PropertyAccessTests.assertEquals((Object)1000, (Object)this.test("10 * 100"));
    }

    public void testStringAsCollection() {
        PropertyAccessTests.assertEquals((Object)Character.valueOf('o'), (Object)this.test("abc = 'foo'; abc[1]"));
    }

    public void testInterfaceResolution() {
        Serializable ex = MVEL.compileExpression((String)"foo.collectionTest.size()");
        Map map = PropertyAccessTests.createTestMap();
        Foo foo = (Foo)map.get("foo");
        foo.setCollectionTest(new HashSet());
        Object result1 = MVEL.executeExpression((Object)ex, (Object)foo, (Map)map);
        foo.setCollectionTest(new ArrayList());
        Object result2 = MVEL.executeExpression((Object)ex, (Object)foo, (Map)map);
        PropertyAccessTests.assertEquals((Object)result1, (Object)result2);
    }

    public void testReflectionCache() {
        PropertyAccessTests.assertEquals((Object)"happyBar", (Object)this.test("foo.happy(); foo.bar.happy()"));
    }

    public void testDynamicDeop() {
        Serializable s = MVEL.compileExpression((String)"name");
        PropertyAccessTests.assertEquals((Object)"dog", (Object)MVEL.executeExpression((Object)s, (Object)new Foo()));
        PropertyAccessTests.assertEquals((Object)"dog", (Object)MVEL.executeExpression((Object)s, (Object)new Foo().getBar()));
    }

    public void testVirtProperty() {
        HashMap<String, String> testMap = new HashMap<String, String>();
        testMap.put("test", "foo");
        HashMap<String, HashMap<String, String>> vars = new HashMap<String, HashMap<String, String>>();
        vars.put("mp", testMap);
        PropertyAccessTests.assertEquals((Object)"bar", (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"mp.test = 'bar'; mp.test"), vars));
    }

    public void testBindingCoercion() {
        LinkedList<String> list = new LinkedList<String>();
        list.add("Apple");
        list.add("Peach");
        list.add("Icing");
        Cake cake = new Cake();
        MVEL.setProperty((Object)cake, (String)"ingredients", list);
        PropertyAccessTests.assertTrue((boolean)cake.getIngredients().contains("Apple"));
        PropertyAccessTests.assertTrue((boolean)cake.getIngredients().contains("Peach"));
        PropertyAccessTests.assertTrue((boolean)cake.getIngredients().contains("Icing"));
    }

    public void testMVELCompilerBoth() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        PropertyHandlerFactory.registerPropertyHandler(DynaBean.class, (PropertyHandler)new DynaBeanPropertyHandler());
        TestBean bean = new TestBean("value1");
        LinkedHashMap<String, Object> vars = new LinkedHashMap<String, Object>();
        vars.put("attr", bean);
        ParserContext parserContext = new ParserContext();
        Serializable compiled = MVEL.compileExpression((String)"attr.value", (ParserContext)parserContext);
        PropertyAccessTests.assertEquals((Object)"value1", (Object)MVEL.executeExpression((Object)compiled, null, vars));
        LazyDynaBean dyna = new LazyDynaBean();
        dyna.set("value", "value2");
        vars.put("attr", dyna);
        PropertyAccessTests.assertEquals((Object)"value2", (Object)MVEL.executeExpression((Object)compiled, null, vars));
    }

    public void testMVELCompilerBoth2() {
        PropertyHandlerFactory.registerPropertyHandler(DynaBean.class, (PropertyHandler)new DynaBeanPropertyHandler());
        LinkedHashMap<String, Object> vars = new LinkedHashMap<String, Object>();
        ParserContext parserContext = new ParserContext();
        Serializable compiled = MVEL.compileExpression((String)"attr.value", (ParserContext)parserContext);
        LazyDynaBean dyna = new LazyDynaBean();
        dyna.set("value", "value2");
        vars.put("attr", dyna);
        PropertyAccessTests.assertEquals((Object)"value2", (Object)MVEL.executeExpression((Object)compiled, null, vars));
        TestBean bean = new TestBean("value1");
        vars.put("attr", bean);
        PropertyAccessTests.assertEquals((Object)"value1", (Object)MVEL.executeExpression((Object)compiled, null, vars));
    }

    public void testNullSafe() {
        HashMap ctx = new HashMap();
        HashMap tmp = new HashMap();
        ctx.put("SessionSetupRequest", tmp);
        System.out.println("Result = " + MVEL.getProperty((String)"SessionSetupRequest.?latitude", ctx));
    }

    public void testMVEL226() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        A226 a = new A226();
        Map<String, A226> m = Collections.singletonMap("a", a);
        Map<String, String> nestMap = Collections.singletonMap("foo", "bar");
        String ex = "a.?map['foo']";
        PropertyAccessTests.assertNull((Object)MVEL.getProperty((String)ex, m));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        Serializable s = MVEL.compileExpression((String)ex);
        PropertyAccessTests.assertNull((Object)MVEL.executeExpression((Object)s, m));
        a.map = nestMap;
        PropertyAccessTests.assertEquals((Object)"bar", (Object)MVEL.executeExpression((Object)s, m));
        a.map = null;
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.DYNAMIC);
        s = MVEL.compileExpression((String)ex);
        PropertyAccessTests.assertNull((Object)MVEL.executeExpression((Object)s, m));
        a.map = nestMap;
        PropertyAccessTests.assertEquals((Object)"bar", (Object)MVEL.executeExpression((Object)s, m));
    }

    private void infiniteLoop() {
        try {
            Serializable compiled = MVEL.compileExpression((String)"a['b']['c']");
            Map vars = Collections.singletonMap("a", Collections.emptyMap());
            MVEL.executeExpression((Object)compiled, vars);
            PropertyAccessTests.fail((String)"expected exception");
        }
        catch (CompileException compileException) {
            // empty catch block
        }
    }

    public void testInfiniteLoopWithASMOptimizer() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        this.infiniteLoop();
    }

    public void testInfiniteLoopWithASMOptimizerAO() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        this.infiniteLoop();
    }

    public void testInfiniteLoop() {
        A226 a = new A226();
        Map<String, A226> m = Collections.singletonMap("a", a);
        String ex = "a.map['foo']";
        try {
            MVEL.getProperty((String)ex, m);
            PropertyAccessTests.fail((String)"access to a null field must fail");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testInfiniteLoopAO() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        this.testInfiniteLoop();
    }

    public void testNonHashMapImplMapPutMVEL302() {
        this.test("map=new java.util.Hashtable();map.foo='bar'");
    }

    public void testNullSafeWithDynamicOptimizerMVEL305() {
        Foo foo = new Foo();
        foo.setBar(null);
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.DYNAMIC);
        Serializable s = MVEL.compileExpression((String)"this.?bar.name");
        for (int i = 1; i < 100; ++i) {
            PropertyAccessTests.assertNull((Object)MVEL.executeExpression((Object)s, (Object)foo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStaleReflectiveCollectionAccessor() {
        try {
            OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
            Serializable getFooExpression = MVEL.compileExpression((String)"foo[0]");
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("foo", new String[]{"1", "2", "3"});
            PropertyAccessTests.assertEquals((Object)"1", (Object)MVEL.executeExpression((Object)getFooExpression, vars));
            vars.put("foo", Collections.singletonList("1"));
            PropertyAccessTests.assertEquals((Object)"1", (Object)MVEL.executeExpression((Object)getFooExpression, vars));
            vars.put("foo", new String[]{"1", "2", "3"});
            PropertyAccessTests.assertEquals((Object)"1", (Object)MVEL.executeExpression((Object)getFooExpression, vars));
            OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.DYNAMIC);
        }
        finally {
            OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.DYNAMIC);
        }
    }

    public void testMVEL308() {
        String expression = "foreach(field: updates.entrySet()) { ctx._target[field.key] = field.value; }";
        Serializable compiled = MVEL.compileExpression((String)expression);
        HashMap<String, String> target = new HashMap<String, String>();
        target.put("value", "notnull");
        HashMap<String, HashMap<String, String>> ctx = new HashMap<String, HashMap<String, String>>();
        ctx.put("_target", target);
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("value", null);
        HashMap<String, HashMap<String, Object>> vars = new HashMap<String, HashMap<String, Object>>();
        vars.put("updates", updates);
        vars.put("ctx", ctx);
        for (int i = 0; i < 100; ++i) {
            MVEL.executeExpression((Object)compiled, vars);
        }
        PropertyAccessTests.assertNull(target.get("value"));
    }

    public void testNullListMapArrayValueMVEL312() {
        PropertyAccessTests.assertNull((Object)PropertyAccessTests.runSingleTest("['test1' : null].test1"));
        PropertyAccessTests.assertNull((Object)PropertyAccessTests.runSingleTest("['test1' : null].get('test1')"));
        PropertyAccessTests.assertNull((Object)PropertyAccessTests.runSingleTest("a=['test1' : null];a.test1"));
        PropertyAccessTests.assertNull((Object)PropertyAccessTests.runSingleTest("a=['test1' : null];a.get('test1')"));
        PropertyAccessTests.assertNull((Object)PropertyAccessTests.runSingleTest("[null][0]"));
        PropertyAccessTests.assertNull((Object)PropertyAccessTests.runSingleTest("[null].get(0)"));
        PropertyAccessTests.assertNull((Object)PropertyAccessTests.runSingleTest("a=[null];a[0]"));
        PropertyAccessTests.assertNull((Object)PropertyAccessTests.runSingleTest("a=[null];a.get(0)"));
        PropertyAccessTests.assertNull((Object)PropertyAccessTests.runSingleTest("{null}[0]"));
        PropertyAccessTests.assertNull((Object)PropertyAccessTests.runSingleTest("a={null};a[0]"));
    }

    public void testPublicStaticFieldMVEL314() {
        PropertyAccessTests.assertEquals((Object)Foo.STATIC_BAR, (Object)PropertyAccessTests.runSingleTest("org.mvel2.tests.core.res.Foo.STATIC_BAR"));
    }

    public static class A226 {
        Map<String, Object> map = null;

        public Map<String, Object> getMap() {
            return this.map;
        }
    }

    private static class DynaBeanPropertyHandler
    implements PropertyHandler {
        private DynaBeanPropertyHandler() {
        }

        public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
            return ((DynaBean)contextObj).get(name);
        }

        public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
            ((DynaBean)contextObj).set(name, value);
            return value;
        }
    }

    public static class LazyDynaBean
    implements DynaBean {
        private Map<String, Object> values = new HashMap<String, Object>();

        @Override
        public void set(String key, Object value) {
            this.values.put(key, value);
        }

        @Override
        public Object get(String key) {
            return this.values.get(key);
        }
    }

    public static interface DynaBean {
        public void set(String var1, Object var2);

        public Object get(String var1);
    }

    public static class TestBean {
        private String _value;

        public TestBean(String value) {
            this._value = value;
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String value) {
            this._value = value;
        }
    }
}

