/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.tests.core;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.junit.Assert;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.Macro;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessException;
import org.mvel2.PropertyAccessor;
import org.mvel2.ast.ASTNode;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.integration.Interceptor;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.integration.ResolverTools;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ClassImportResolverFactory;
import org.mvel2.integration.impl.DefaultLocalVariableResolverFactory;
import org.mvel2.integration.impl.IndexedVariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.tests.core.AbstractTest;
import org.mvel2.tests.core.res.Bar;
import org.mvel2.tests.core.res.Base;
import org.mvel2.tests.core.res.Cheese;
import org.mvel2.tests.core.res.Cheesery;
import org.mvel2.tests.core.res.Column;
import org.mvel2.tests.core.res.DefaultKnowledgeHelper;
import org.mvel2.tests.core.res.Foo;
import org.mvel2.tests.core.res.Grid;
import org.mvel2.tests.core.res.KnowledgeHelper;
import org.mvel2.tests.core.res.KnowledgeHelperFixer;
import org.mvel2.tests.core.res.MapObject;
import org.mvel2.tests.core.res.MyClass;
import org.mvel2.tests.core.res.MyInterface;
import org.mvel2.tests.core.res.OverloadedInterface;
import org.mvel2.tests.core.res.PojoStatic;
import org.mvel2.tests.core.res.RuleBaseImpl;
import org.mvel2.tests.core.res.SampleBean;
import org.mvel2.tests.core.res.SampleBeanAccessor;
import org.mvel2.tests.core.res.Ship;
import org.mvel2.tests.core.res.Status;
import org.mvel2.tests.core.res.TestClass;
import org.mvel2.tests.core.res.User;
import org.mvel2.tests.core.res.WorkingMemoryImpl;
import org.mvel2.tests.core.res.res2.ClassProvider;
import org.mvel2.tests.core.res.res2.Outer;
import org.mvel2.tests.core.res.res2.OverloadedClass;
import org.mvel2.tests.core.res.res2.PublicClass;
import org.mvel2.util.ParseTools;
import org.mvel2.util.ReflectionUtil;

public class CoreConfidenceTests
extends AbstractTest {
    private Map<Object, Object> outerMap;
    private Map<Object, Object> innerMap;
    private HashMap<String, Object> context = new HashMap();
    private static final KnowledgeHelperFixer fixer = new KnowledgeHelperFixer();

    public void testWhileUsingImports() {
        HashMap<String, Class> imports = new HashMap<String, Class>();
        imports.put("ArrayList", ArrayList.class);
        imports.put("List", List.class);
        ParserContext context = new ParserContext(imports, null, "testfile");
        ExpressionCompiler compiler = new ExpressionCompiler("List list = new ArrayList(); return (list == empty)", context);
        CoreConfidenceTests.assertTrue((boolean)((Boolean)MVEL.executeExpression((Object)compiler.compile(), (VariableResolverFactory)new DefaultLocalVariableResolverFactory())));
    }

    public void testBooleanModeOnly2() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)DataConversion.convert((Object)this.test("BWAH"), Boolean.class));
    }

    public void testBooleanModeOnly4() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("hour == (hour + 0)"));
    }

    public void testThisReferenceMapVirtualObjects() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap());
        factory.createVariable("this", map);
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.eval((String)"this.foo == 'bar'", map, (VariableResolverFactory)factory));
    }

    public void testThisReferenceMapVirtualObjects1() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap());
        factory.createVariable("this", map);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"this.foo == 'bar'"), map, (VariableResolverFactory)factory));
    }

    public void testThisReferenceMapVirtualObjects2() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap());
        factory.createVariable("this", map);
        if (!Boolean.getBoolean("mvel2.disable.jit")) {
            OptimizerFactory.setDefaultOptimizer((String)"ASM");
        }
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"this.foo == 'bar'"), map, (VariableResolverFactory)factory));
    }

    public void testEvalToBoolean() {
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)MVEL.evalToBoolean((String)"true ", (Object)"true"));
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)MVEL.evalToBoolean((String)"true ", (Object)"true"));
    }

    public void testImport() {
        CoreConfidenceTests.assertEquals(HashMap.class, (Object)this.test("import java.util.HashMap; HashMap;"));
    }

    public void testImport2() {
        HashMap[] maps = (HashMap[])MVEL.eval((String)"import java.util.*; HashMap[] maps = new HashMap[10]; maps", new HashMap());
        CoreConfidenceTests.assertEquals((int)10, (int)maps.length);
    }

    public void testUnusedPackageImport() {
        String expression = "import java.util.*; name == \"Mario\" ";
        Serializable compiledExpression = MVEL.compileExpression((String)expression);
        boolean result = (Boolean)MVEL.executeExpression((Object)compiledExpression, (Object)new MyPerson("Mario"));
        CoreConfidenceTests.assertTrue((boolean)result);
    }

    public void testStaticImport() {
        CoreConfidenceTests.assertEquals((Object)2.0, (Object)this.test("import_static java.lang.Math.sqrt; sqrt(4)"));
    }

    public void testCreationOfSet() {
        CoreConfidenceTests.assertEquals((Object)"foo bar foo bar", (Object)this.test("set = new java.util.LinkedHashSet(); set.add('foo');set.add('bar');output = '';foreach (item : set) {output = output + item + ' ';} foreach (item : set) {output = output + item + ' ';} output = output.trim();if (set.size() == 2) { return output; }"));
    }

    public void testCreationOfList() {
        CoreConfidenceTests.assertEquals((Object)5, (Object)this.test("l = new java.util.LinkedList(); l.add('fun'); l.add('happy'); l.add('fun'); l.add('slide');l.add('crap'); poo = new java.util.ArrayList(l); poo.size();"));
    }

    public void testMapOperations() {
        CoreConfidenceTests.assertEquals((Object)"poo5", (Object)this.test("l = new java.util.ArrayList(); l.add('plop'); l.add('poo'); m = new java.util.HashMap();m.put('foo', l); m.put('cah', 'mah'); m.put('bar', 'foo'); m.put('sarah', 'mike');m.put('edgar', 'poe'); if (m.edgar == 'poe') { return m.foo[1] + m.size(); }"));
    }

    public void testStackOperations() {
        CoreConfidenceTests.assertEquals((Object)10, (Object)this.test("stk = new java.util.Stack();stk.push(5);stk.push(5);stk.pop() + stk.pop();"));
    }

    public void testSystemOutPrint() {
        this.test("a = 0;\r\nSystem.out.println('This is a test');");
    }

    public void testCheeseConstructor() {
        MapVariableResolverFactory mvf = new MapVariableResolverFactory(CoreConfidenceTests.createTestMap());
        ClassImportResolverFactory classes = new ClassImportResolverFactory(null, null, false);
        classes.addClass(Cheese.class);
        ResolverTools.appendFactory((VariableResolverFactory)mvf, (VariableResolverFactory)classes);
        CoreConfidenceTests.assertTrue((boolean)(MVEL.executeExpression((Object)MVEL.compileExpression((String)"cheese = new Cheese(\"cheddar\", 15);", (Map)classes.getImportedClasses()), (VariableResolverFactory)mvf) instanceof Cheese));
    }

    public void testInterceptors() {
        Interceptor testInterceptor = new Interceptor(){

            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                System.out.println("BEFORE Node: " + node.getName());
                return 0;
            }

            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                System.out.println("AFTER Node: " + node.getName());
                return 0;
            }
        };
        HashMap<String, 1> interceptors = new HashMap<String, 1>();
        interceptors.put("test", testInterceptor);
        MVEL.executeExpression((Object)MVEL.compileExpression((String)"@test System.out.println('MIDDLE');", null, interceptors));
    }

    public void testSubtractNoSpace1() {
        CoreConfidenceTests.assertEquals((Object)59, (Object)this.test("hour-1"));
    }

    public void testStrictTypingCompilation() {
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ExpressionCompiler compiler = new ExpressionCompiler("a.foo;\nb.foo;\n x = 5", ctx);
        try {
            compiler.compile();
        }
        catch (CompileException e) {
            e.printStackTrace();
            return;
        }
        CoreConfidenceTests.assertTrue((boolean)false);
    }

    public void testEqualityRegression() {
        ExpressionCompiler compiler = new ExpressionCompiler("price == (new Integer( 5 ) + 5 ) ");
        compiler.compile();
    }

    public void testEvaluationRegression() {
        ExpressionCompiler compiler = new ExpressionCompiler("(p.age * 2)");
        compiler.compile();
        CoreConfidenceTests.assertTrue((boolean)compiler.getParserContextState().getInputs().containsKey("p"));
    }

    public void testIncrementAndAssignWithInputs() {
        ExpressionCompiler compiler = new ExpressionCompiler("total += cheese");
        compiler.compile();
        CoreConfidenceTests.assertTrue((boolean)compiler.getParserContextState().getInputs().containsKey("total"));
        CoreConfidenceTests.assertTrue((boolean)compiler.getParserContextState().getInputs().containsKey("cheese"));
    }

    public void testAssignmentRegression() {
        ExpressionCompiler compiler = new ExpressionCompiler("total = total + $cheese.price");
        compiler.compile();
    }

    public void testTypeRegression() {
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ExpressionCompiler compiler = new ExpressionCompiler("total = 0", ctx);
        compiler.compile();
        CoreConfidenceTests.assertEquals(Integer.class, (Object)compiler.getParserContextState().getVarOrInputType("total"));
    }

    public void testTestIntToLong() {
        String s = "1+(long)a";
        ParserContext pc = new ParserContext();
        pc.addInput("a", Integer.class);
        ExpressionCompiler compiler = new ExpressionCompiler(s, pc);
        CompiledExpression expr = compiler.compile();
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("a", 1);
        Object r = expr.getValue(null, (VariableResolverFactory)new MapVariableResolverFactory(vars));
        CoreConfidenceTests.assertEquals((Object)new Long(2L), (Object)r);
    }

    public void testMapPropertyCreateCondensed() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("map = new java.util.HashMap(); map['test'] = 'foo'; map['test'];"));
    }

    public void testDeepMethod() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("foo.bar.testList.add(new String()); foo.bar.testList == empty"));
    }

    public void testListAccessorAssign() {
        String ex = "a = new java.util.ArrayList(); a.add('foo'); a.add('BAR'); a[1] = 'bar'; a[1]";
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        Serializable s = MVEL.compileExpression((String)ex);
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)MVEL.executeExpression((Object)s, new HashMap()));
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.DYNAMIC);
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)this.test("a = new java.util.ArrayList(); a.add('foo'); a.add('BAR'); a[1] = 'bar'; a[1]"));
    }

    public void testBracketInString() {
        this.test("System.out.println('1)your guess was:');");
    }

    public void testNesting() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("new String(new String(new String(\"foo\")));"));
    }

    public void testTypeCast() {
        CoreConfidenceTests.assertEquals((Object)"10", (Object)this.test("(String) 10"));
    }

    public void testTypeCast2() {
        String ex = "map = new java.util.HashMap(); map.put('doggie', new java.util.ArrayList()); ((java.util.ArrayList) map['doggie']).size()";
        Map map = CoreConfidenceTests.createTestMap();
        CoreConfidenceTests.assertEquals((Object)0, (Object)MVEL.eval((String)ex, (Map)map));
        CoreConfidenceTests.assertEquals((Object)0, (Object)this.test(ex));
    }

    public void testMapAccessSemantics() {
        HashMap outermap = new HashMap();
        HashMap<String, String> innermap = new HashMap<String, String>();
        innermap.put("test", "foo");
        outermap.put("innermap", innermap);
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)CoreConfidenceTests.testCompiledSimple("innermap['test']", outermap, null));
    }

    public void testMapBindingSemantics() {
        HashMap outermap = new HashMap();
        HashMap<String, String> innermap = new HashMap<String, String>();
        innermap.put("test", "foo");
        outermap.put("innermap", innermap);
        MVEL.setProperty(outermap, (String)"innermap['test']", (Object)"bar");
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)CoreConfidenceTests.testCompiledSimple("innermap['test']", outermap, null));
    }

    public void testMapNestedInsideList() {
        ParserContext ctx = new ParserContext();
        ctx.addImport("User", User.class);
        ExpressionCompiler compiler = new ExpressionCompiler("users = [ 'darth'  : new User('Darth', 'Vadar'),\n'bobba' : new User('Bobba', 'Feta') ]; [ users.get('darth'), users.get('bobba') ]", ctx);
        List list = (List)MVEL.executeExpression((Object)compiler.compile(), new HashMap());
        User user = (User)list.get(0);
        CoreConfidenceTests.assertEquals((String)"Darth", (String)user.getFirstName());
        user = (User)list.get(1);
        CoreConfidenceTests.assertEquals((String)"Bobba", (String)user.getFirstName());
        compiler = new ExpressionCompiler("users = [ 'darth'  : new User('Darth', 'Vadar'),\n'bobba' : new User('Bobba', 'Feta') ]; [ users['darth'], users['bobba'] ]", ctx);
        list = (List)MVEL.executeExpression((Object)compiler.compile(), new HashMap());
        user = (User)list.get(0);
        CoreConfidenceTests.assertEquals((String)"Darth", (String)user.getFirstName());
        user = (User)list.get(1);
        CoreConfidenceTests.assertEquals((String)"Bobba", (String)user.getFirstName());
    }

    public void testListNestedInsideList() {
        ParserContext ctx = new ParserContext();
        ctx.addImport("User", User.class);
        ExpressionCompiler compiler = new ExpressionCompiler("users = [ new User('Darth', 'Vadar'), new User('Bobba', 'Feta') ]; [ users.get( 0 ), users.get( 1 ) ]", ctx);
        List list = (List)MVEL.executeExpression((Object)compiler.compile(), new HashMap());
        User user = (User)list.get(0);
        CoreConfidenceTests.assertEquals((String)"Darth", (String)user.getFirstName());
        user = (User)list.get(1);
        CoreConfidenceTests.assertEquals((String)"Bobba", (String)user.getFirstName());
        compiler = new ExpressionCompiler("users = [ new User('Darth', 'Vadar'), new User('Bobba', 'Feta') ]; [ users[0], users[1] ]", ctx);
        list = (List)MVEL.executeExpression((Object)compiler.compile(), new HashMap());
        user = (User)list.get(0);
        CoreConfidenceTests.assertEquals((String)"Darth", (String)user.getFirstName());
        user = (User)list.get(1);
        CoreConfidenceTests.assertEquals((String)"Bobba", (String)user.getFirstName());
    }

    public void testSetSemantics() {
        Bar bar = new Bar();
        Foo foo = new Foo();
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.getProperty((String)"name", (Object)bar));
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.getProperty((String)"name", (Object)foo));
    }

    public void testMapBindingSemantics2() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        HashMap outermap = new HashMap();
        HashMap<String, String> innermap = new HashMap<String, String>();
        innermap.put("test", "foo");
        outermap.put("innermap", innermap);
        MVEL.executeSetExpression((Serializable)MVEL.compileSetExpression((String)"innermap['test']"), outermap, (Object)"bar");
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)CoreConfidenceTests.testCompiledSimple("innermap['test']", outermap, null));
    }

    public void testDynamicImports() {
        ParserContext ctx = new ParserContext();
        ctx.addPackageImport("java.util");
        ExpressionCompiler compiler = new ExpressionCompiler("HashMap", ctx);
        CompiledExpression s = compiler.compile();
        CoreConfidenceTests.assertEquals(HashMap.class, (Object)MVEL.executeExpression((Object)s));
        compiler = new ExpressionCompiler("map = new HashMap(); map.size()", ctx);
        s = compiler.compile();
        CoreConfidenceTests.assertEquals((Object)0, (Object)MVEL.executeExpression((Object)s, (VariableResolverFactory)new DefaultLocalVariableResolverFactory()));
    }

    public void testDynamicImports3() {
        String expression = "import java.util.*; HashMap map = new HashMap(); map.size()";
        ExpressionCompiler compiler = new ExpressionCompiler(expression);
        CompiledExpression s = compiler.compile();
        CoreConfidenceTests.assertEquals((Object)0, (Object)MVEL.executeExpression((Object)s, (VariableResolverFactory)new DefaultLocalVariableResolverFactory()));
        CoreConfidenceTests.assertEquals((Object)0, (Object)MVEL.eval((String)expression, new HashMap()));
    }

    public void testDynamicImportsInList() {
        ParserContext ctx = new ParserContext();
        ctx.addPackageImport("org.mvel2.tests.core.res");
        ExpressionCompiler compiler = new ExpressionCompiler("[ new User('Bobba', 'Feta') ]", ctx);
        List list = (List)MVEL.executeExpression((Object)compiler.compile());
        User user = (User)list.get(0);
        CoreConfidenceTests.assertEquals((String)"Bobba", (String)user.getFirstName());
    }

    public void testDynamicImportsInMap() {
        ParserContext ctx = new ParserContext();
        ctx.addPackageImport("org.mvel2.tests.core.res");
        ExpressionCompiler compiler = new ExpressionCompiler("[ 'bobba' : new User('Bobba', 'Feta') ]", ctx);
        Map map = (Map)MVEL.executeExpression((Object)compiler.compile());
        User user = (User)map.get("bobba");
        CoreConfidenceTests.assertEquals((String)"Bobba", (String)user.getFirstName());
    }

    public void testDynamicImportsOnNestedExpressions() {
        ParserContext ctx = new ParserContext();
        ctx.addPackageImport("org.mvel2.tests.core.res");
        ExpressionCompiler compiler = new ExpressionCompiler("new Cheesery(\"bobbo\", new Cheese(\"cheddar\", 15))", ctx);
        Cheesery p1 = new Cheesery("bobbo", new Cheese("cheddar", 15));
        Cheesery p2 = (Cheesery)MVEL.executeExpression((Object)compiler.compile(), (VariableResolverFactory)new DefaultLocalVariableResolverFactory());
        CoreConfidenceTests.assertEquals((Object)p1, (Object)p2);
    }

    public void testDynamicImportsWithNullConstructorParam() {
        ParserContext ctx = new ParserContext();
        ctx.addPackageImport("org.mvel2.tests.core.res");
        ExpressionCompiler compiler = new ExpressionCompiler("new Cheesery(\"bobbo\", null)", ctx);
        Cheesery p1 = new Cheesery("bobbo", null);
        Cheesery p2 = (Cheesery)MVEL.executeExpression((Object)compiler.compile(), (VariableResolverFactory)new DefaultLocalVariableResolverFactory());
        CoreConfidenceTests.assertEquals((Object)p1, (Object)p2);
    }

    public void testDynamicImportsWithNullConstructorParamWithStrongType() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addPackageImport("org.mvel2.tests.core.res");
        ExpressionCompiler compiler = new ExpressionCompiler("new Cheesery(\"bobbo\", null)", ctx);
        Cheesery p1 = new Cheesery("bobbo", null);
        Cheesery p2 = (Cheesery)MVEL.executeExpression((Object)compiler.compile(), (VariableResolverFactory)new DefaultLocalVariableResolverFactory());
        CoreConfidenceTests.assertEquals((Object)p1, (Object)p2);
    }

    public void testDynamicImportsWithIdentifierSameAsClassWithDiffCase() {
        ParserContext ctx = new ParserContext();
        ctx.addPackageImport("org.mvel2.tests.core.res");
        ctx.setStrictTypeEnforcement(false);
        ExpressionCompiler compiler = new ExpressionCompiler("bar.add(\"hello\")", ctx);
        compiler.compile();
    }

    public void testTypedAssignment() {
        CoreConfidenceTests.assertEquals((Object)"foobar", (Object)this.test("java.util.Map map = new java.util.HashMap(); map.put('conan', 'foobar'); map['conan'];"));
    }

    public void testFQCNwithStaticInList() {
        CoreConfidenceTests.assertEquals((Object)Integer.MIN_VALUE, (Object)this.test("list = [java.lang.Integer.MIN_VALUE]; list[0]"));
    }

    public void testPrecedenceOrder() {
        CoreConfidenceTests.assertTrue((boolean)((Boolean)this.test("5 > 6 && 2 < 1 || 10 > 9")));
    }

    public void testDifferentImplSameCompile() {
        Serializable compiled = MVEL.compileExpression((String)"a.funMap.hello");
        HashMap<String, Base> testMap = new HashMap<String, Base>();
        for (int i = 0; i < 100; ++i) {
            Base b = new Base();
            b.funMap.put("hello", "dog");
            testMap.put("a", b);
            CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.executeExpression((Object)compiled, testMap));
            b = new Base();
            b.funMap.put("hello", "cat");
            testMap.put("a", b);
            CoreConfidenceTests.assertEquals((Object)"cat", (Object)MVEL.executeExpression((Object)compiled, testMap));
        }
    }

    public void testInterfaceMethodCallWithSpace() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultKnowledgeHelper helper = new DefaultKnowledgeHelper();
        map.put("drools", helper);
        Cheese cheese = new Cheese("stilton", 15);
        map.put("cheese", cheese);
        MVEL.executeExpression((Object)MVEL.compileExpression((String)"drools.retract (cheese)"), map);
        CoreConfidenceTests.assertSame((Object)cheese, helper.retracted.get(0));
    }

    public void testInterfaceMethodCallWithMacro() {
        HashMap<String, 2> macros = new HashMap<String, 2>(1);
        macros.put("retract", new Macro(){

            public String doMacro() {
                return "drools.retract";
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultKnowledgeHelper helper = new DefaultKnowledgeHelper();
        map.put("drools", helper);
        Cheese cheese = new Cheese("stilton", 15);
        map.put("cheese", cheese);
        MVEL.executeExpression((Object)MVEL.compileExpression((String)MVEL.parseMacros((String)"retract(cheese)", macros)), map);
        CoreConfidenceTests.assertSame((Object)cheese, helper.retracted.get(0));
    }

    public void testParsingStability1() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("( order.number == 1 || order.number == ( 1+1) || order.number == $id )"));
    }

    public void testParsingStability2() {
        HashMap<String, Class<Dimension>> imports = new HashMap<String, Class<Dimension>>();
        imports.put("java.awt.Dimension", Dimension.class);
        ParserContext parserContext = new ParserContext(imports, null, "sourceFile");
        parserContext.setStrictTypeEnforcement(false);
        ExpressionCompiler compiler = new ExpressionCompiler("( dim.height == 1 || dim.height == ( 1+1) || dim.height == x )", parserContext);
        compiler.compile();
    }

    public void testConcatWithLineBreaks() {
        ParserContext ctx = new ParserContext();
        ctx.setDebugSymbols(true);
        ctx.setSourceFile("source.mv");
        ExpressionCompiler parser = new ExpressionCompiler("\"foo\"+\n\"bar\"", ctx);
        CoreConfidenceTests.assertEquals((Object)"foobar", (Object)MVEL.executeExpression((Object)parser.compile()));
    }

    public void testMethodResolutionWithNullParameter() {
        AbstractTest.Context ctx = new AbstractTest.Context();
        ctx.setBean(new AbstractTest.Bean());
        HashMap vars = new HashMap();
        System.out.println("bean.today: " + MVEL.eval((String)"bean.today", (Object)ctx, vars));
        System.out.println("formatDate(bean.today): " + MVEL.eval((String)"formatDate(bean.today)", (Object)ctx, vars));
        System.out.println("formatString(bean.nullString): " + MVEL.eval((String)"formatString(bean.nullString)", (Object)ctx, vars));
        System.out.println("bean.myDate = bean.nullDate: " + MVEL.eval((String)"bean.myDate = bean.nullDate; return bean.nullDate;", (Object)ctx, vars));
        System.out.println("formatDate(bean.myDate): " + MVEL.eval((String)"formatDate(bean.myDate)", (Object)ctx, vars));
        System.out.println(MVEL.eval((String)"formatDate(bean.nullDate)", (Object)ctx, vars));
    }

    public void testCompileParserContextShouldNotLoopIndefinitelyOnValidJavaExpression() {
        String expr = "\t\tSystem.out.println( message );\nm.setMessage( \"Goodbye cruel world\" );\nSystem.out.println(m.getStatus());\nm.setStatus( Message.GOODBYE );\n";
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(false);
        context.addImport("Message", AbstractTest.Message.class);
        context.addInput("System", Void.TYPE);
        context.addInput("message", Object.class);
        context.addInput("m", Object.class);
        ExpressionCompiler compiler = new ExpressionCompiler(expr, context);
        compiler.compile();
    }

    public void testStaticNested() {
        CoreConfidenceTests.assertEquals((Object)1, (Object)MVEL.eval((String)"org.mvel2.tests.core.AbstractTest$Message.GOODBYE", new HashMap()));
    }

    public void testStaticNestedWithImport() {
        String expr = "Message.GOODBYE;\n";
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(false);
        context.addImport("Message", AbstractTest.Message.class);
        ExpressionCompiler compiler = new ExpressionCompiler(expr, context);
        CoreConfidenceTests.assertEquals((Object)1, (Object)MVEL.executeExpression((Object)compiler.compile()));
    }

    public void testStaticNestedWithMethodCall() {
        String expr = "item = new Item( \"Some Item\"); $msg.addItem( item ); return $msg";
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(false);
        context.addImport("Message", AbstractTest.Message.class);
        context.addImport("Item", AbstractTest.Item.class);
        HashMap<String, AbstractTest.Message> vars = new HashMap<String, AbstractTest.Message>();
        vars.put("$msg", new AbstractTest.Message());
        ExpressionCompiler compiler = new ExpressionCompiler(expr, context);
        AbstractTest.Message msg = (AbstractTest.Message)MVEL.executeExpression((Object)compiler.compile(), vars);
        AbstractTest.Item item = (AbstractTest.Item)msg.getItems().get(0);
        CoreConfidenceTests.assertEquals((String)"Some Item", (String)item.getName());
    }

    public void testsequentialAccessorsThenMethodCall() {
        String expr = "System.out.println(drools.workingMemory); drools.workingMemory.ruleBase.removeRule(\"org.drools.examples\", \"some rule\"); ";
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(true);
        context.addInput("drools", KnowledgeHelper.class);
        RuleBaseImpl ruleBase = new RuleBaseImpl();
        WorkingMemoryImpl wm = new WorkingMemoryImpl(ruleBase);
        DefaultKnowledgeHelper drools = new DefaultKnowledgeHelper(wm);
        HashMap<String, DefaultKnowledgeHelper> vars = new HashMap<String, DefaultKnowledgeHelper>();
        vars.put("drools", drools);
        ExpressionCompiler compiler = new ExpressionCompiler(expr, context);
        MVEL.executeExpression((Object)compiler.compile(), vars);
    }

    public void testPropertyVerfierShoudldNotLoopIndefinately() {
        String expr = "\t\tmodel.latestHeadlines = $list;\nmodel.latestHeadlines.add( 0, (model.latestHeadlines[2]) );";
        ParserContext pCtx = new ParserContext();
        pCtx.addInput("$list", List.class);
        pCtx.addInput("model", AbstractTest.Model.class);
        ExpressionCompiler compiler = new ExpressionCompiler(expr, pCtx);
        compiler.setVerifying(true);
        compiler.compile();
    }

    public void testCompileWithNewInsideMethodCall() {
        String expr = "     p.name = \"goober\";\n     System.out.println(p.name);\n     drools.insert(new Address(\"Latona\"));\n";
        ParserContext context = new ParserContext();
        context.setStrictTypeEnforcement(false);
        context.addImport("Person", AbstractTest.Person.class);
        context.addImport("Address", AbstractTest.Address.class);
        context.addInput("p", AbstractTest.Person.class);
        context.addInput("drools", AbstractTest.Drools.class);
        ExpressionCompiler compiler = new ExpressionCompiler(expr, context);
        compiler.compile();
    }

    public void testBug4() {
        AbstractTest.ClassA A2 = new AbstractTest.ClassA(this);
        AbstractTest.ClassB B2 = new AbstractTest.ClassB(this);
        System.out.println(MVEL.getProperty((String)"date", (Object)A2));
        System.out.println(MVEL.getProperty((String)"date", (Object)B2));
    }

    public void testIndexer() {
        CoreConfidenceTests.assertEquals((Object)"foobar", (Object)CoreConfidenceTests.testCompiledSimple("import java.util.LinkedHashMap; LinkedHashMap map = new LinkedHashMap(); map.put('a', 'foo'); map.put('b', 'bar'); s = ''; foreach (key : map.keySet()) { System.out.println(map[key]); s += map[key]; }; return s;", CoreConfidenceTests.createTestMap()));
    }

    public void testLateResolveOfClass() {
        ParserContext ctx = new ParserContext();
        ctx.addImport(Foo.class);
        ExpressionCompiler compiler = new ExpressionCompiler("System.out.println(new Foo());", ctx);
        System.out.println(MVEL.executeExpression((Object)compiler.compile()));
    }

    public void testClassAliasing() {
        CoreConfidenceTests.assertEquals((Object)"foobar", (Object)this.test("Foo244 = String; new Foo244('foobar')"));
    }

    public void testRandomExpression1() {
        CoreConfidenceTests.assertEquals((Object)"HelloWorld", (Object)this.test("if ((x15 = foo.bar) == foo.bar && x15 == foo.bar) { return 'HelloWorld'; } else { return 'GoodbyeWorld' } "));
    }

    public void testRandomExpression4() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("result = org.mvel2.MVEL.eval('10 * 3'); result == (10 * 3);"));
    }

    public void testRandomExpression5() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("FooClassRef = foo.getClass(); fooInst = new FooClassRef(); name = org.mvel2.MVEL.eval('name', fooInst); return name == 'dog'"));
    }

    public void testRandomExpression6() {
        CoreConfidenceTests.assertEquals((Object)500, (Object)this.test("exprString = '250' + ' ' + '*' + ' ' + '2'; compiledExpr = org.mvel2.MVEL.compileExpression(exprString); return org.mvel2.MVEL.executeExpression(compiledExpr);"));
    }

    public void testRandomExpression7() {
        CoreConfidenceTests.assertEquals((Object)"FOOBAR", (Object)this.test("'foobar'.toUpperCase();"));
    }

    public void testRandomExpression8() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("'someString'.intern(); 'someString'.hashCode() == 'someString'.hashCode();"));
    }

    public void testRandomExpression9() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("_abc = 'someString'.hashCode(); _xyz = _abc + 1; _abc == _xyz"));
    }

    public void testRandomExpression10() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("(_abc = (_xyz = 'someString'.hashCode()) + 1); _abc == _xyz"));
    }

    public void testAddIntToMapWithMapSyntax() throws Throwable {
        this.outerMap = new HashMap<Object, Object>();
        this.innerMap = new HashMap<Object, Object>();
        this.outerMap.put("innerMap", this.innerMap);
        PropertyAccessor.set(this.outerMap, (String)"innerMap['foo']", (Object)42);
        CoreConfidenceTests.assertEquals((Object)42, (Object)this.innerMap.get("foo"));
    }

    public void testUpdateIntInMapWithMapSyntax() throws Throwable {
        this.outerMap = new HashMap<Object, Object>();
        this.innerMap = new HashMap<Object, Object>();
        this.outerMap.put("innerMap", this.innerMap);
        this.innerMap.put("foo", 21);
        PropertyAccessor.set(this.outerMap, (String)"innerMap['foo']", (Object)42);
        CoreConfidenceTests.assertEquals((Object)42, (Object)this.innerMap.get("foo"));
    }

    public void before() {
        HashMap<String, MyBean> map = new HashMap<String, MyBean>();
        MyBean bean = new MyBean();
        bean.setVar(4);
        map.put("bean", bean);
        this.context.put("map", map);
    }

    public void testDeepProperty() {
        this.before();
        Object obj = MVEL.executeExpression((Object)MVEL.compileExpression((String)"map.bean.var"), this.context);
        CoreConfidenceTests.assertEquals((Object)4, (Object)obj);
    }

    public void testDeepProperty2() {
        this.before();
        Object obj = MVEL.executeExpression((Object)MVEL.compileExpression((String)"map.bean.getVar()"), this.context);
        CoreConfidenceTests.assertEquals((Object)4, (Object)obj);
    }

    public void testBooleanEvaluation() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("true||false||false"));
    }

    public void testBooleanEvaluation2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("equalityCheck(1,1)||fun||ackbar"));
    }

    public void testStaticWithExplicitParam() {
        PojoStatic pojo = new PojoStatic("10");
        MVEL.eval((String)"org.mvel2.tests.core.res.AStatic.Process('10')", (Object)pojo, new HashMap());
    }

    public void testSimpleExpression() {
        PojoStatic pojo = new PojoStatic("10");
        MVEL.eval((String)"value!= null", (Object)pojo, new HashMap());
    }

    public void testStaticWithExpressionParam() {
        PojoStatic pojo = new PojoStatic("10");
        CoreConfidenceTests.assertEquals((Object)"java.lang.String", (Object)MVEL.eval((String)"org.mvel2.tests.core.res.AStatic.Process(value.getClass().getName().toString())", (Object)pojo));
    }

    public void testStringIndex() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("a = 'foobar'; a[4] == 'a'"));
    }

    public void testAssertKeyword() {
        ExpressionCompiler compiler = new ExpressionCompiler("assert 1 == 2;");
        CompiledExpression s = compiler.compile();
        try {
            MVEL.executeExpression((Object)s);
        }
        catch (AssertionError e) {
            return;
        }
        CoreConfidenceTests.assertTrue((boolean)false);
    }

    public void testNullSafe() {
        Foo foo = new Foo();
        HashMap<String, Foo> map = new HashMap<String, Foo>();
        map.put("foo", foo);
        String expression = "foo.?bar.name == null";
        Serializable compiled = MVEL.compileExpression((String)expression);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.executeExpression((Object)compiled, map));
        foo.setBar(null);
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)compiled, map));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        compiled = MVEL.compileExpression((String)expression);
        foo.setBar(new Bar());
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.executeExpression((Object)compiled, map));
        foo.setBar(null);
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)compiled, map));
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.eval((String)expression, map));
    }

    public void testMethodInvocationWithCollectionElement() {
        this.context = new HashMap();
        this.context.put("pojo", new POJO());
        this.context.put("number", "1192800637980");
        Object result = MVEL.eval((String)"pojo.function(pojo.dates[0].time)", this.context);
        CoreConfidenceTests.assertEquals((Object)String.valueOf(((POJO)this.context.get("pojo")).getDates().iterator().next().getTime()), (Object)result);
    }

    public void testNestedMethod1() {
        Vector<String> vectorA = new Vector<String>();
        Vector vectorB = new Vector();
        vectorA.add("Foo244");
        HashMap map = new HashMap();
        map.put("vecA", vectorA);
        map.put("vecB", vectorB);
        CoreConfidenceTests.testCompiledSimple("vecB.add(vecA.remove(0)); vecA.add('Foo244');", null, map);
        CoreConfidenceTests.assertEquals((Object)"Foo244", vectorB.get(0));
    }

    public void testDynamicImports2() {
        CoreConfidenceTests.assertEquals(BufferedReader.class, (Object)this.test("import java.io.*; BufferedReader"));
    }

    public void testUseOfVarKeyword() {
        CoreConfidenceTests.assertEquals((Object)"FOO_BAR", (Object)this.test("var barfoo = 'FOO_BAR'; return barfoo;"));
    }

    public void testAssignment5() {
        CoreConfidenceTests.assertEquals((Object)15, (Object)this.test("x = (10) + (5); x"));
    }

    public void testSetExpressions1() {
        HashMap myMap = new HashMap();
        Serializable fooExpr = MVEL.compileSetExpression((String)"foo");
        MVEL.executeSetExpression((Serializable)fooExpr, myMap, (Object)"blah");
        CoreConfidenceTests.assertEquals((Object)"blah", myMap.get("foo"));
        MVEL.executeSetExpression((Serializable)fooExpr, myMap, (Object)"baz");
        CoreConfidenceTests.assertEquals((Object)"baz", myMap.get("foo"));
    }

    public void testDuplicateVariableDeclaration() {
        ParserContext context = new ParserContext();
        ExpressionCompiler compiler = new ExpressionCompiler("String x = \"abc\"; Integer x = new Integer( 10 );", context);
        try {
            compiler.compile();
            CoreConfidenceTests.fail((String)"Compilation must fail with duplicate variable declaration exception.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testFullyQualifiedTypeAndCast() {
        CoreConfidenceTests.assertEquals((Object)1, (Object)this.test("java.lang.Integer number = (java.lang.Integer) '1';"));
    }

    public void testThreadSafetyInterpreter1() {
        System.out.println("First evaluation: " + MVEL.eval((String)"true"));
        new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("Second evaluation: " + MVEL.eval((String)"true"));
            }
        }).start();
    }

    public void testArrayList() throws SecurityException, NoSuchMethodException {
        ArrayList<String> collection = new ArrayList<String>();
        collection.add("I CAN HAS CHEEZBURGER");
        CoreConfidenceTests.assertEquals((Object)collection.size(), (Object)MVEL.eval((String)"size()", collection));
    }

    public void testUnmodifiableCollection() throws SecurityException, NoSuchMethodException {
        Collection collection = new ArrayList<String>();
        collection.add("I CAN HAS CHEEZBURGER");
        collection = Collections.unmodifiableCollection(collection);
        CoreConfidenceTests.assertEquals((Object)collection.size(), (Object)MVEL.eval((String)"size()", collection));
    }

    public void testSingleton() throws SecurityException, NoSuchMethodException {
        Set<String> collection = Collections.singleton("I CAN HAS CHEEZBURGER");
        CoreConfidenceTests.assertEquals((Object)collection.size(), (Object)MVEL.eval((String)"size()", collection));
    }

    public void testJIRA93() {
        Map testMap = CoreConfidenceTests.createTestMap();
        testMap.put("testClass2", new TestClass2());
        Serializable s = MVEL.compileExpression((String)"testClass2.addEqualAuthorizationConstraint(foo, foo.bar, 5)");
        for (int i = 0; i < 5; ++i) {
            MVEL.executeExpression((Object)s, (Map)testMap);
        }
    }

    public void testJIRA96() {
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.addInput("fooString", String[].class);
        ExpressionCompiler compiler = new ExpressionCompiler("fooString[0].toUpperCase()", ctx);
        compiler.compile();
    }

    public void testStringToArrayCast() {
        Object o = this.test("(char[]) 'abcd'");
        CoreConfidenceTests.assertTrue((boolean)(o instanceof char[]));
    }

    public void testStringToArrayCast2() {
        CoreConfidenceTests.assertTrue((boolean)((Boolean)this.test("_xyxy = (char[]) 'abcd'; _xyxy[0] == 'a'")));
    }

    public void testStaticallyTypedArrayVar() {
        String ex = "char[] _c___ = new char[10]; _c___ instanceof char[]";
        CoreConfidenceTests.assertTrue((boolean)((Boolean)this.test(ex)));
    }

    public void testParserErrorHandling() {
        ParserContext ctx = new ParserContext();
        ExpressionCompiler compiler = new ExpressionCompiler("a[", ctx);
        try {
            compiler.compile();
        }
        catch (Exception e) {
            return;
        }
        CoreConfidenceTests.assertTrue((boolean)false);
    }

    public void testJIRA100() {
        CoreConfidenceTests.assertEquals((Object)new BigDecimal(20), (Object)this.test("java.math.BigDecimal axx = new java.math.BigDecimal( 10.0 ); java.math.BigDecimal bxx = new java.math.BigDecimal( 10.0 ); java.math.BigDecimal cxx = axx + bxx; return cxx; "));
    }

    public void testJIRA100b() {
        Serializable s = MVEL.compileExpression((String)"java.math.BigDecimal axx = new java.math.BigDecimal( 10.0 ); java.math.BigDecimal bxx = new java.math.BigDecimal( 10.0 ); java.math.BigDecimal cxx = axx + bxx; return cxx; ");
        CoreConfidenceTests.assertEquals((Object)new BigDecimal(20), (Object)MVEL.executeExpression((Object)s, new HashMap()));
    }

    public void testAssignToBean() {
        AbstractTest.Person person = new AbstractTest.Person();
        MVEL.eval((String)"this.name = 'foo'", (Object)person);
        CoreConfidenceTests.assertEquals((String)"foo", (String)person.getName());
        MVEL.executeExpression((Object)MVEL.compileExpression((String)"this.name = 'bar'"), (Object)person);
        CoreConfidenceTests.assertEquals((String)"bar", (String)person.getName());
    }

    public void testMapAssignmentNestedExpression() {
        HashMap map = new HashMap();
        map.put("map", new HashMap());
        String ex = "map[java.lang.Integer.MAX_VALUE] = 'bar'; map[java.lang.Integer.MAX_VALUE];";
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)ex), map));
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)MVEL.eval((String)ex, map));
    }

    public void testMapAssignmentNestedExpression2() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", "bar");
        map.put("map", new HashMap());
        String ex = "map[x] = 'foo'; map['bar'];";
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)ex), map));
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)MVEL.eval((String)ex, map));
    }

    public void testMethodResolutionOrder() {
        MvelContext mvelContext = new MvelContext();
        MVEL.eval((String)"methodForTest({'1','2'})", (Object)mvelContext);
        MVEL.eval((String)"methodForTest('1')", (Object)mvelContext);
        CoreConfidenceTests.assertTrue((mvelContext.arrayCalled && mvelContext.singleCalled ? 1 : 0) != 0);
    }

    public void testCustomPropertyHandler() {
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        PropertyHandlerFactory.registerPropertyHandler(SampleBean.class, (PropertyHandler)new SampleBeanAccessor());
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)this.test("foo.sampleBean.bar.name"));
        PropertyHandlerFactory.unregisterPropertyHandler(SampleBean.class);
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = false;
    }

    public void testSetAccessorOverloadedEqualsStrictMode() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("foo", Foo.class);
        try {
            CompiledExpression compiledExpression = new ExpressionCompiler("foo.bar = 0", ctx).compile();
        }
        catch (CompileException e) {
            e.printStackTrace();
            return;
        }
        CoreConfidenceTests.assertTrue((boolean)false);
    }

    public void testAdd__Handle__Simple() {
        String result = fixer.fix("update(myObject );");
        this.assertEqualsIgnoreWhitespace("drools.update(myObject );", result);
        result = fixer.fix("update ( myObject );");
        this.assertEqualsIgnoreWhitespace("drools.update( myObject );", result);
    }

    public void testAdd__Handle__withNewLines() {
        String result = fixer.fix("\n\t\n\tupdate( myObject );");
        this.assertEqualsIgnoreWhitespace("\n\t\n\tdrools.update( myObject );", result);
    }

    public void testAdd__Handle__rComplex() {
        String result = fixer.fix("something update( myObject); other");
        this.assertEqualsIgnoreWhitespace("something drools.update( myObject); other", result);
        result = fixer.fix("something update ( myObject );");
        this.assertEqualsIgnoreWhitespace("something drools.update( myObject );", result);
        result = fixer.fix(" update( myObject ); x");
        this.assertEqualsIgnoreWhitespace(" drools.update( myObject ); x", result);
        result = fixer.fix("xxupdate(myObject ) x");
        this.assertEqualsIgnoreWhitespace("xxupdate(myObject ) x", result);
    }

    public void testMultipleMatches() {
        String result = fixer.fix("update(myObject); update(myObject );");
        this.assertEqualsIgnoreWhitespace("drools.update(myObject); drools.update(myObject );", result);
        result = fixer.fix("xxx update(myObject ); update( myObject ); update( yourObject ); yyy");
        this.assertEqualsIgnoreWhitespace("xxx drools.update(myObject ); drools.update( myObject ); drools.update( yourObject ); yyy", result);
    }

    public void testAssert1() {
        String raw = "insert( foo );";
        String result = "drools.insert( foo );";
        this.assertEqualsIgnoreWhitespace("drools.insert( foo );", fixer.fix("insert( foo );"));
    }

    public void testAssert2() {
        String raw = "some code; insert( new String(\"foo\") );\n More();";
        String result = "some code; drools.insert( new String(\"foo\") );\n More();";
        this.assertEqualsIgnoreWhitespace("some code; drools.insert( new String(\"foo\") );\n More();", fixer.fix("some code; insert( new String(\"foo\") );\n More();"));
    }

    public void testAssertLogical() {
        String raw = "some code; insertLogical(new String(\"foo\"));\n More();";
        String result = "some code; drools.insertLogical(new String(\"foo\"));\n More();";
        this.assertEqualsIgnoreWhitespace("some code; drools.insertLogical(new String(\"foo\"));\n More();", fixer.fix("some code; insertLogical(new String(\"foo\"));\n More();"));
    }

    public void testModifyRetractModifyInsert() {
        String raw = "some code; insert( bar ); modifyRetract( foo );\n More(); retract( bar ); modifyInsert( foo );";
        String result = "some code; drools.insert( bar ); drools.modifyRetract( foo );\n More(); drools.retract( bar ); drools.modifyInsert( foo );";
        this.assertEqualsIgnoreWhitespace("some code; drools.insert( bar ); drools.modifyRetract( foo );\n More(); drools.retract( bar ); drools.modifyInsert( foo );", fixer.fix("some code; insert( bar ); modifyRetract( foo );\n More(); retract( bar ); modifyInsert( foo );"));
    }

    public void testAllActionsMushedTogether() {
        String result = fixer.fix("insert(myObject ); update(ourObject);\t retract(herObject);");
        this.assertEqualsIgnoreWhitespace("drools.insert(myObject ); drools.update(ourObject);\t drools.retract(herObject);", result);
        result = fixer.fix("insert( myObject ); update(ourObject);\t retract(herObject  );\ninsert(  myObject ); update(ourObject);\t retract(  herObject  );");
        this.assertEqualsIgnoreWhitespace("drools.insert( myObject ); drools.update(ourObject);\t drools.retract(herObject  );\ndrools.insert(  myObject ); drools.update(ourObject);\t drools.retract(  herObject  );", result);
    }

    public void testLeaveLargeAlone() {
        String original = "yeah yeah yeah minsert( xxx ) this is a long() thing Person (name=='drools') modify a thing";
        String result = fixer.fix("yeah yeah yeah minsert( xxx ) this is a long() thing Person (name=='drools') modify a thing");
        this.assertEqualsIgnoreWhitespace("yeah yeah yeah minsert( xxx ) this is a long() thing Person (name=='drools') modify a thing", result);
    }

    public void testWithNull() {
        String original = null;
        String result = fixer.fix(original);
        this.assertEqualsIgnoreWhitespace(original, result);
    }

    public void testLeaveAssertAlone() {
        String original = "drools.insert(foo)";
        this.assertEqualsIgnoreWhitespace("drools.insert(foo)", fixer.fix("drools.insert(foo)"));
    }

    public void testLeaveAssertLogicalAlone() {
        String original = "drools.insertLogical(foo)";
        this.assertEqualsIgnoreWhitespace("drools.insertLogical(foo)", fixer.fix("drools.insertLogical(foo)"));
    }

    public void testWackyAssert() {
        String raw = "System.out.println($person1.getName() + \" and \" + $person2.getName() +\" are sisters\");\ninsert($person1.getName(\"foo\") + \" and \" + $person2.getName() +\" are sisters\"); yeah();";
        String expected = "System.out.println($person1.getName() + \" and \" + $person2.getName() +\" are sisters\");\ndrools.insert($person1.getName(\"foo\") + \" and \" + $person2.getName() +\" are sisters\"); yeah();";
        this.assertEqualsIgnoreWhitespace("System.out.println($person1.getName() + \" and \" + $person2.getName() +\" are sisters\");\ndrools.insert($person1.getName(\"foo\") + \" and \" + $person2.getName() +\" are sisters\"); yeah();", fixer.fix("System.out.println($person1.getName() + \" and \" + $person2.getName() +\" are sisters\");\ninsert($person1.getName(\"foo\") + \" and \" + $person2.getName() +\" are sisters\"); yeah();"));
    }

    public void testMoreAssertCraziness() {
        String raw = "foobar(); (insert(new String(\"blah\").get()); bangBangYudoHono();)";
        this.assertEqualsIgnoreWhitespace("foobar(); (drools.insert(new String(\"blah\").get()); bangBangYudoHono();)", fixer.fix("foobar(); (insert(new String(\"blah\").get()); bangBangYudoHono();)"));
    }

    public void testRetract() {
        String raw = "System.out.println(\"some text\");retract(object);";
        this.assertEqualsIgnoreWhitespace("System.out.println(\"some text\");drools.retract(object);", fixer.fix("System.out.println(\"some text\");retract(object);"));
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        if (expected == null || actual == null) {
            CoreConfidenceTests.assertEquals((String)expected, (String)actual);
            return;
        }
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        CoreConfidenceTests.assertEquals((String)cleanExpected, (String)cleanActual);
    }

    public void testIncrementInBooleanStatement() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("hour++ < 61 && hour == 61"));
    }

    public void testIncrementInBooleanStatement2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("++hour == 61"));
    }

    public void testStaticallyTypedLong() {
        CoreConfidenceTests.assertEquals((Object)10L, (Object)this.test("10l"));
    }

    public void testNakedMethodCall() {
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        Serializable c = MVEL.compileExpression((String)"tm = System.currentTimeMillis");
        CoreConfidenceTests.assertTrue(((Long)MVEL.executeExpression((Object)c, new HashMap()) > 0L ? 1 : 0) != 0);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        CoreConfidenceTests.assertTrue(((Long)MVEL.executeExpression((Object)c, new HashMap()) > 0L ? 1 : 0) != 0);
        HashMap<String, Foo> map = new HashMap<String, Foo>();
        map.put("foo", new Foo());
        c = MVEL.compileExpression((String)"foo.happy");
        CoreConfidenceTests.assertEquals((Object)"happyBar", (Object)MVEL.executeExpression((Object)c, map));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        c = MVEL.compileExpression((String)"foo.happy");
        CoreConfidenceTests.assertEquals((Object)"happyBar", (Object)MVEL.executeExpression((Object)c, map));
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = false;
    }

    public void testDecl() {
        CoreConfidenceTests.assertEquals((Object)Character.valueOf('d'), (Object)this.test("char chr; chr = 100; chr"));
    }

    public void testInlineUnion() {
        CoreConfidenceTests.assertEquals((Object)"test", (Object)this.test("{'foo', 'test'}[1]"));
    }

    public static double minim(double[] tab) {
        double min = 3.4028234663852886E38;
        for (int i = 0; i < tab.length; ++i) {
            if (!(min > tab[i])) continue;
            min = tab[i];
        }
        return min;
    }

    public void testJIRA113() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("org.mvel2.tests.core.CoreConfidenceTests.minim( new double[] {456.2, 2.3} ) == 2.3"));
    }

    public void testChainedMethodCallsWithParams() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("foo.toUC(\"abcd\").equals(\"ABCD\")"));
    }

    public void testIsUsedInIf() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("c = 'str'; if (c is String) { true; } else { false; } "));
    }

    public void testJIRA122() {
        Serializable s = MVEL.compileExpression((String)"System.out.println('>'+java.lang.Character.toLowerCase(name.charAt(0))); java.lang.Character.toLowerCase(name.charAt(0)) == 'a'");
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "Adam");
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)s, map));
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)s, map));
    }

    public void testJIRA122b() {
        Serializable s = MVEL.compileExpression((String)"System.out.println('>'+java.lang.Character.toLowerCase(name.charAt(0))); java.lang.Character.toLowerCase(name.charAt(0)) == 'a'");
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "Adam");
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)s, map));
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)s, map));
    }

    public void testJIRA103() {
        MvelContext mvelContext = new MvelContext();
        MVEL.setProperty((Object)mvelContext, (String)"regkeys", (Object)"s");
    }

    public void testJIRA103b() {
        MvelContext mvelContext = new MvelContext();
        HashMap<String, MvelContext> map = new HashMap<String, MvelContext>();
        map.put("ctx", mvelContext);
        Serializable c = MVEL.compileExpression((String)"ctx.regkeys = 'foo'");
        MVEL.executeExpression((Object)c, map);
        MVEL.executeExpression((Object)c, map);
    }

    public void testMethodCaching() {
        MVEL.eval((String)"for (pet: getPets()) pet.run();", (Object)new PetStore());
    }

    public void testSetExpressions2() {
        Foo foo = new Foo();
        ArrayList col = new ArrayList();
        Serializable fooExpr = MVEL.compileSetExpression((String)"collectionTest");
        MVEL.executeSetExpression((Serializable)fooExpr, (Object)foo, col);
        CoreConfidenceTests.assertEquals(col, (Object)foo.getCollectionTest());
    }

    public void testInnerClassReference() {
        CoreConfidenceTests.assertEquals(Fruit.Apple.class, (Object)this.test("import " + CoreConfidenceTests.class.getName() + "; CoreConfidenceTests.Fruit.Apple"));
    }

    public void testEdson() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.test("list = new java.util.ArrayList(); list.add(new String('foo')); list[0]"));
    }

    public void testEnumSupport() {
        MyClass myInterface = new MyClass();
        myInterface.setType(MyInterface.MY_ENUM.TWO, true);
        boolean isType = (Boolean)MVEL.eval((String)"isType(org.mvel2.tests.core.res.MyInterface$MY_ENUM.ONE)", (Object)myInterface, Boolean.class);
        System.out.println(isType);
    }

    public void testOperatorPrecedenceOrder() {
        Serializable compiled = MVEL.compileExpression((String)"bean1.successful && bean2.failed || bean1.failed && bean2.successful");
        HashMap<String, BeanB> context = new HashMap<String, BeanB>();
        BeanB bean1 = new BeanB(true);
        BeanB bean2 = new BeanB(false);
        context.put("bean1", bean1);
        context.put("bean2", bean2);
        System.out.println("interpreted: " + MVEL.eval((String)"bean1.successful && bean2.failed || bean1.failed && bean2.successful", context));
        CoreConfidenceTests.assertEquals((bean1.isSuccessful() && bean2.isFailed() || bean1.isFailed() && bean2.isSuccessful() ? 1 : 0) != 0, (boolean)((Boolean)MVEL.executeExpression((Object)compiled, context, Boolean.class)));
    }

    public void testJIRA139() {
        ParserContext ctx = new ParserContext();
        ctx.addImport("ReflectionUtil", ReflectionUtil.class);
        Serializable s = MVEL.compileExpression((String)"ReflectionUtil.getGetter('foo')", (ParserContext)ctx);
        CoreConfidenceTests.assertEquals((Object)ReflectionUtil.getGetter((String)"foo"), (Object)MVEL.executeExpression((Object)s));
    }

    public void testJIRA140() {
        ParserContext ctx = new ParserContext();
        Serializable s = MVEL.compileExpression((String)"import org.mvel2.tests.core.res.*;cols = new Column[] { new Column('name', 20), new Column('age', 2) };grid = new Grid(new Model(cols));", (ParserContext)ctx);
        Grid g = (Grid)MVEL.executeExpression((Object)s, new HashMap());
        CoreConfidenceTests.assertEquals((String)g.getModel().getColumns()[0].getName(), (String)"name");
        CoreConfidenceTests.assertEquals((int)g.getModel().getColumns()[0].getLength(), (int)20);
        CoreConfidenceTests.assertEquals((String)g.getModel().getColumns()[1].getName(), (String)"age");
        CoreConfidenceTests.assertEquals((int)g.getModel().getColumns()[1].getLength(), (int)2);
    }

    public void testVerifierWithIndexedProperties() {
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.addInput("base", Base.class);
        Serializable s = MVEL.compileExpression((String)"base.fooMap['foo'].setName('coffee')", (ParserContext)ctx);
        HashMap<String, Base> vars = new HashMap<String, Base>();
        vars.put("base", new Base());
        MVEL.executeExpression((Object)s, vars);
        CoreConfidenceTests.assertEquals((String)"coffee", (String)((Base)vars.get((Object)"base")).fooMap.get("foo").getName());
    }

    public void testEmpty() {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        Serializable s = MVEL.compileExpression((String)"list = new java.util.ArrayList(); list == empty", (ParserContext)ctx);
        HashMap vars = new HashMap();
        Boolean x = (Boolean)MVEL.executeExpression((Object)s, vars);
        CoreConfidenceTests.assertNotNull((Object)x);
        CoreConfidenceTests.assertTrue((boolean)x);
    }

    public void testMapsAndLists() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addImport(HashMap.class);
        ctx.addImport(ArrayList.class);
        ctx.addInput("list", List.class);
        String expression = "m = new HashMap();\nl = new ArrayList();\nl.add(\"first\");\nm.put(\"content\", l);\nlist.add(((ArrayList)m[\"content\"])[0]);";
        Serializable s = MVEL.compileExpression((String)expression, (ParserContext)ctx);
        HashMap vars = new HashMap();
        ArrayList list = new ArrayList();
        vars.put("list", list);
        Boolean result = (Boolean)MVEL.executeExpression((Object)s, vars);
        CoreConfidenceTests.assertNotNull((Object)result);
        CoreConfidenceTests.assertTrue((boolean)result);
        CoreConfidenceTests.assertEquals((int)1, (int)list.size());
        CoreConfidenceTests.assertEquals((Object)"first", list.get(0));
    }

    public void testMapsAndLists2() {
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addImport(HashMap.class);
        ctx.addImport(ArrayList.class);
        ctx.addInput("list", List.class);
        String expression = "m = new HashMap();\nl = new ArrayList();\nl.add(\"first\");\nm.put(\"content\", l);\nlist.add(((ArrayList)m[\"content\"])[0]);";
        Serializable s = MVEL.compileExpression((String)expression, (ParserContext)ctx);
        HashMap vars = new HashMap();
        ArrayList list = new ArrayList();
        vars.put("list", list);
        Boolean result = (Boolean)MVEL.executeExpression((Object)s, vars);
        CoreConfidenceTests.assertNotNull((Object)result);
        CoreConfidenceTests.assertTrue((boolean)result);
        CoreConfidenceTests.assertEquals((int)1, (int)list.size());
        CoreConfidenceTests.assertEquals((Object)"first", list.get(0));
    }

    public void testReturnBoolean() {
        String ex = "list = new java.util.ArrayList(); return list != null";
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        Serializable s = MVEL.compileExpression((String)ex, (ParserContext)ctx);
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)s, new HashMap()));
    }

    public void testComaProblemStrikesBack() {
        String ex = "a.explanation = \"There is a coma, in here\"";
        ParserContext ctx = new ParserContext();
        ExpressionCompiler compiler = new ExpressionCompiler(ex, ctx);
        CompiledExpression s = compiler.compile();
        Base a = new Base();
        HashMap<String, Base> variables = new HashMap<String, Base>();
        variables.put("a", a);
        MVEL.executeExpression((Object)s, variables);
        CoreConfidenceTests.assertEquals((String)"There is a coma, in here", (String)a.data);
    }

    public void testStringConcatenation() {
        String ex = "services.log((String) \"Drop +5%: \"+$sb+\" avg: $\"+$av+\" price: $\"+$pr );";
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("$sb", String.class);
        ctx.addInput("$av", Double.TYPE);
        ctx.addInput("$pr", Double.TYPE);
        ctx.addInput("services", Services.class);
        try {
            ExpressionCompiler compiler = new ExpressionCompiler(ex, ctx);
            compiler.compile();
        }
        catch (Throwable e) {
            e.printStackTrace();
            CoreConfidenceTests.fail((String)("Should not raise exception: " + e.getMessage()));
        }
    }

    public void testStringConcatenation2() {
        String ex = "services.log( $cheese + \" some string \" );";
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("$cheese", Cheese.class);
        ctx.addInput("services", Services.class);
        try {
            ExpressionCompiler compiler = new ExpressionCompiler(ex, ctx);
            compiler.compile();
        }
        catch (Throwable e) {
            e.printStackTrace();
            CoreConfidenceTests.fail((String)("Should not raise exception: " + e.getMessage()));
        }
    }

    public void testStringConcatenation3() {
        String ex = "services.log($av + \"Drop +5%: \"+$sb+\" avg: $\"+percent($av)+\" price: $\"+$pr );";
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.setStrictTypeEnforcement(true);
        ctx.addInput("$sb", String.class);
        ctx.addInput("$av", Double.TYPE);
        ctx.addInput("$pr", Double.TYPE);
        ctx.addInput("services", Services.class);
        ctx.addImport("percent", MVEL.getStaticMethod(String.class, (String)"valueOf", (Class[])new Class[]{Double.TYPE}));
        try {
            Serializable compiledExpression = MVEL.compileExpression((String)ex, (ParserContext)ctx);
            Services services = new Services(){

                @Override
                public void log(String text) {
                }
            };
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("services", services);
            vars.put("$sb", "RHT");
            vars.put("$av", 15.0);
            vars.put("$pr", 10.0);
            MVEL.executeExpression((Object)compiledExpression, vars);
        }
        catch (Throwable e) {
            e.printStackTrace();
            CoreConfidenceTests.fail((String)("Should not raise exception: " + e.getMessage()));
        }
    }

    public void testMapsWithVariableAsKey() {
        String ex = "aMap[aKey] == 'aValue'";
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(false);
        ExpressionCompiler compiler = new ExpressionCompiler(ex, ctx);
        compiler.setVerifyOnly(true);
        compiler.compile();
        Set requiredInputs = compiler.getParserContextState().getInputs().keySet();
        CoreConfidenceTests.assertTrue((boolean)requiredInputs.contains("aMap"));
        CoreConfidenceTests.assertTrue((boolean)requiredInputs.contains("aKey"));
    }

    public void testMapsWithVariableAsKey2() {
        String ex = "objectKeyMaptributes[$aPerson] == foo";
        Foo foo = new Foo();
        AbstractTest.Person person = new AbstractTest.Person();
        person.setObjectKeyMaptributes(new HashMap<Object, Foo>());
        person.getObjectKeyMaptributes().put(person, foo);
        HashMap<String, Class<AbstractTest.Person>> inputs = new HashMap<String, Class<AbstractTest.Person>>();
        inputs.put("this", AbstractTest.Person.class);
        inputs.put("foo", Foo.class);
        inputs.put("$aPerson", AbstractTest.Person.class);
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.setInputs(inputs);
        Serializable expression = MVEL.compileExpression((String)ex, (ParserContext)ctx);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("foo", foo);
        variables.put("$aPerson", person);
        Boolean result = (Boolean)MVEL.executeExpression((Object)expression, (Object)person, variables);
        CoreConfidenceTests.assertTrue((boolean)result);
    }

    public static void testProjectionUsingThis() {
        HashSet<Bean2> records = new HashSet<Bean2>();
        for (int i = 0; i < 53; ++i) {
            Bean2 record = new Bean2(i);
            records.add(record);
        }
        Object result = MVEL.eval((String)"(_prop in this)", records);
        System.out.println("result: " + result);
    }

    public void testUnaryOpNegation1() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.test("!new Boolean(true)"));
    }

    public void testUnaryOpNegation2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.test("!isdef _foozy_"));
    }

    public void testJIRA151() {
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        Bz b = new Bz();
        ParserContext context = new ParserContext();
        Serializable expression = MVEL.compileExpression((String)"a.foo(value)", (ParserContext)context);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("a", b);
        variables.put("value", 123);
        for (int i = 0; i < 100; ++i) {
            System.out.println("i: " + i);
            System.out.flush();
            MVEL.executeExpression((Object)expression, variables);
        }
    }

    public void testJIRA151b() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        Bz b = new Bz();
        ParserContext context = new ParserContext();
        Serializable expression = MVEL.compileExpression((String)"a.foo(value)", (ParserContext)context);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("a", b);
        variables.put("value", 123);
        for (int i = 0; i < 100; ++i) {
            System.out.println("i: " + i);
            System.out.flush();
            MVEL.executeExpression((Object)expression, variables);
        }
    }

    public void testJIRA153() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.eval((String)"!(true)"));
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"!(true)")));
    }

    public void testMultipleNegations() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"!false")));
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"!!false")));
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"!!!false")));
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"!!!!false")));
    }

    public void testJIRA154() {
        Map m = CoreConfidenceTests.createTestMap();
        m.put("returnTrue", MVEL.getStaticMethod(CoreConfidenceTests.class, (String)"returnTrue", (Class[])new Class[0]));
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.eval((String)"!returnTrue()", (Map)m));
    }

    public void testJIRA154b() {
        ParserContext pctx = new ParserContext();
        pctx.addImport("returnTrue", MVEL.getStaticMethod(CoreConfidenceTests.class, (String)"returnTrue", (Class[])new Class[0]));
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"!(returnTrue())", (ParserContext)pctx)));
    }

    public void testJIRA155() {
        ParserContext pctx = new ParserContext();
        pctx.addImport("returnTrue", MVEL.getStaticMethod(CoreConfidenceTests.class, (String)"returnTrue", (Class[])new Class[0]));
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"!true || returnTrue()", (ParserContext)pctx)));
    }

    public void testJIRA155b() {
        ParserContext pctx = new ParserContext();
        pctx.addImport("returnTrue", MVEL.getStaticMethod(CoreConfidenceTests.class, (String)"returnTrue", (Class[])new Class[0]));
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"!(!true || !returnTrue())", (ParserContext)pctx)));
    }

    public void testJIRA156() throws Throwable {
        ClassProvider provider = new ClassProvider();
        provider.getPrivate().foo();
        PublicClass.class.getMethod("foo", new Class[0]).invoke((Object)provider.getPrivate(), new Object[0]);
        String script = "provider.getPrivate().foo()";
        HashMap<String, ClassProvider> vars = new HashMap<String, ClassProvider>();
        vars.put("provider", provider);
        MVEL.eval((String)script, vars);
    }

    public void testJIRA156b() throws Throwable {
        ClassProvider provider = new ClassProvider();
        provider.getPrivate().foo();
        PublicClass.class.getMethod("foo", new Class[0]).invoke((Object)provider.getPrivate(), new Object[0]);
        String script = "provider.getPrivate().foo()";
        Serializable s = MVEL.compileExpression((String)script);
        HashMap<String, ClassProvider> vars = new HashMap<String, ClassProvider>();
        vars.put("provider", provider);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        MVEL.executeExpression((Object)s, vars);
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        MVEL.executeExpression((Object)s, vars);
    }

    public void testJIRA156c() throws Throwable {
        ClassProvider provider = new ClassProvider();
        provider.getPublic().foo();
        PublicClass.class.getMethod("foo", new Class[0]).invoke((Object)provider.getPublic(), new Object[0]);
        String script = "provider.getPublic().foo()";
        Serializable s = MVEL.compileExpression((String)script);
        HashMap<String, ClassProvider> vars = new HashMap<String, ClassProvider>();
        vars.put("provider", provider);
        MVEL.eval((String)script, vars);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        MVEL.executeExpression((Object)s, vars);
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        MVEL.executeExpression((Object)s, vars);
    }

    public static boolean returnTrue() {
        return true;
    }

    public void testArray() {
        String ex = " TestHelper.method(1, new String[]{\"a\", \"b\"});\n TestHelper.method(2, new String[]{new String(\"a\"), new String(\"b\")});\n TestHelper.method(3, new Fooz[]{new Fooz(\"a\"), new Fooz(\"b\")});";
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addImport(TestHelper.class);
        ctx.addImport(Fooz.class);
        ExpressionCompiler compiler = new ExpressionCompiler(ex, ctx);
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        CompiledExpression expr = compiler.compile();
        MVEL.executeExpression((Object)expr);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        expr = compiler.compile();
        MVEL.executeExpression((Object)expr);
    }

    public void testArray2() {
        String ex = " TestHelper.method(1, {\"a\", \"b\"});\n TestHelper.method(2, {new String(\"a\"), new String(\"b\")});\n TestHelper.method(3, {new Fooz(\"a\"), new Fooz(\"b\")});";
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addImport(TestHelper.class);
        ctx.addImport(Fooz.class);
        ExpressionCompiler compiler = new ExpressionCompiler(ex, ctx);
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        CompiledExpression expr = compiler.compile();
        MVEL.executeExpression((Object)expr);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        expr = compiler.compile();
        MVEL.executeExpression((Object)expr);
    }

    public void testJIRA166() {
        Object v = MVEL.eval((String)"import java.util.regex.Matcher; import java.util.regex.Pattern; if (Pattern.compile(\"hoge\").matcher(\"hogehogehoge\").find()) { 'foo' } else { 'bar' }", new HashMap());
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)v);
    }

    public void testJIRA167() {
        HashMap<String, Beano> context = new HashMap<String, Beano>();
        context.put("bean", new Beano());
        MVEL.eval((String)"bean.property1==null?bean.isProperty2():bean.isProperty3()", context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJIRA168() {
        boolean before = MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL;
        try {
            HashMap<String, Serializable> st = new HashMap<String, Serializable>();
            st.put("__fact__", new ArrayList());
            st.put("__expected__", Integer.valueOf(0));
            String expressionNaked = "__fact__.size == __expected__";
            String expressionNonNaked = "__fact__.size() == __expected__";
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
            ParserContext ctx = new ParserContext();
            for (Map.Entry entry : st.entrySet()) {
                ctx.addInput((String)entry.getKey(), entry.getValue().getClass());
            }
            CompiledExpression expr = new ExpressionCompiler(expressionNaked, ctx).compile();
            Boolean result = (Boolean)MVEL.executeExpression((Object)expr, st);
            CoreConfidenceTests.assertTrue((boolean)result);
            result = (Boolean)MVEL.eval((String)expressionNonNaked, st);
            CoreConfidenceTests.assertTrue((boolean)result);
            result = (Boolean)MVEL.eval((String)expressionNaked, st);
            CoreConfidenceTests.assertTrue((boolean)result);
        }
        finally {
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = before;
        }
    }

    public void testJIRA170() {
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        List<Integer> staticDispatch = Arrays.asList(2, 1, 0);
        List<Integer> multimethodDispatch = Arrays.asList(3, 2, 1);
        this.invokeJIRA170("Strong", this.ctxJIRA170(false, true), this.varsJIRA170(), staticDispatch);
    }

    public void testJIRA170b() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        List<Integer> staticDispatch = Arrays.asList(2, 1, 0);
        List<Integer> multimethodDispatch = Arrays.asList(3, 2, 1);
        this.invokeJIRA170("Strong", this.ctxJIRA170(false, true), this.varsJIRA170(), staticDispatch);
    }

    public void invokeJIRA170(String name, ParserContext pctx, Map<String, ?> vars, Collection<Integer> expected) {
        Serializable expression = MVEL.compileExpression((String)"x.remove((Object) y); x ", (ParserContext)pctx);
        Object result = MVEL.executeExpression((Object)expression, vars);
        CoreConfidenceTests.assertTrue((String)String.format("%s Expected %s, Got %s", name, expected, result), (boolean)expected.equals(result));
        result = MVEL.executeExpression((Object)expression, vars);
        CoreConfidenceTests.assertTrue((String)String.format("%s Expected %s, Got %s", name, expected, result), (boolean)expected.equals(result));
    }

    private Map<String, ?> varsJIRA170() {
        HashMap<String, Serializable> vars = new HashMap<String, Serializable>();
        vars.put("x", new ArrayList<Integer>(Arrays.asList(3, 2, 1, 0)));
        vars.put("y", Integer.valueOf(3));
        return vars;
    }

    private ParserContext ctxJIRA170(boolean strictTypeEnforcement, boolean strongTyping) {
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(strongTyping);
        ctx.addInput("x", Collection.class, new Class[]{Integer.class});
        ctx.addInput("y", Integer.class);
        return ctx;
    }

    public void testJIRA167b() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("current", new JIRA167Step());
        context.put("node", new JIRA167Node());
        MVEL.eval((String)"current.parent==null?node.isServer():(node==current.parent.node)", context);
    }

    public void testJIRA167c() {
        MVEL.eval((String)"true?true:(false)");
    }

    public void testJIRA176() {
        HashMap<String, String> innerMap = new HashMap<String, String>();
        innerMap.put("testKey[MyValue=newValue]", "test");
        HashMap<String, HashMap<String, String>> vars = new HashMap<String, HashMap<String, String>>();
        vars.put("mappo", innerMap);
        CoreConfidenceTests.assertEquals((Object)"test", (Object)MVEL.eval((String)"mappo['testKey[MyValue=newValue]']", vars));
    }

    public void testJIRA176b() {
        HashMap<String, String> innerMap = new HashMap<String, String>();
        innerMap.put("testKey[MyValue=newValue]", "test");
        HashMap<String, HashMap<String, String>> vars = new HashMap<String, HashMap<String, String>>();
        vars.put("mappo", innerMap);
        Serializable s = MVEL.compileExpression((String)"mappo['testKey[MyValue=newValue]']");
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        CoreConfidenceTests.assertEquals((Object)"test", (Object)MVEL.executeExpression((Object)s, vars));
        s = MVEL.compileExpression((String)"mappo['testKey[MyValue=newValue]']");
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        CoreConfidenceTests.assertEquals((Object)"test", (Object)MVEL.executeExpression((Object)s, vars));
    }

    public void testRandomSomething() {
        Foo foo = new Foo();
        foo.setName("foo1");
        Foo foo2 = new Foo();
        foo2.setName("foo2");
        MVEL.setProperty((Object)foo, (String)"name", (Object)5);
        Serializable s = MVEL.compileExpression((String)"name.toUpperCase()", (ParserContext)ParserContext.create().stronglyTyped().withInput("name", String.class));
        Object _return = MVEL.executeExpression((Object)s, (Object)foo);
        System.out.println("returned value: " + String.valueOf(_return));
        _return = MVEL.executeExpression((Object)s, (Object)foo2);
        System.out.println("returned value: " + String.valueOf(_return));
    }

    public void testDeepMethodNameResolution() {
        String expression = "variables = [ \"symbol\" : \"RHT\" ]; \ndrools.getProcessManager().startProcess(\"id\", variables );";
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("drools", KnowledgeRuntimeHelper.class);
        HashMap<String, KnowledgeRuntimeHelper> vars = new HashMap<String, KnowledgeRuntimeHelper>();
        vars.put("drools", new KnowledgeRuntimeHelper());
        Serializable expr = MVEL.compileExpression((String)expression, (ParserContext)ctx);
        MVEL.executeExpression((Object)expr, vars);
    }

    public void testJIRA183() {
        String exp1 = "int end = 'attribute'.indexOf('@');  if(end == -1) { end = 'attribute'.length()} 'attribute'.substring(0, end);";
        Object val1 = MVEL.eval((String)exp1, new HashMap());
        String exp2 = "int end = 'attribute'.indexOf('@');  if(end == -1) { end = 'attribute'.length() } 'attribute'.substring(0, end);";
        Object val2 = MVEL.eval((String)exp2, new HashMap());
    }

    public void testContextAssignments() {
        Foo foo = new Foo();
        MVEL.eval((String)"this.name = 'bar'", (Object)foo);
        CoreConfidenceTests.assertEquals((String)"bar", (String)foo.getName());
    }

    public void testMVEL187() {
        ParserContext context = new ParserContext();
        context.addPackageImport("test");
        context.addInput("outer", Outer.class);
        Serializable compiled = MVEL.compileExpression((String)"outer.getInner().getValue()", (ParserContext)context);
        HashMap<String, Outer> vars = new HashMap<String, Outer>();
        vars.put("outer", new Outer());
        MapVariableResolverFactory varsResolver = new MapVariableResolverFactory(vars);
        CoreConfidenceTests.assertEquals((Object)2, (Object)MVEL.executeExpression((Object)compiled, (VariableResolverFactory)varsResolver));
    }

    public void testMVEL190() {
        ParserContext context = new ParserContext();
        context.addImport(Ship.class);
        context.addImport(MapObject.class);
        context.addInput("obj", MapObject.class);
        Serializable compiled = MVEL.compileExpression((String)"((Ship) obj).getName()", (ParserContext)context);
        HashMap<String, Ship> vars = new HashMap<String, Ship>();
        vars.put("obj", new Ship());
        MapVariableResolverFactory varsResolver = new MapVariableResolverFactory(vars);
        System.out.println(MVEL.executeExpression((Object)compiled, (VariableResolverFactory)varsResolver));
    }

    public void testMethodScoring() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        ParserConfiguration pconf = new ParserConfiguration();
        for (Method m : StaticMethods.class.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers())) continue;
            pconf.addImport(m.getName(), m);
        }
        pconf.addImport("TestCase", TestCase.class);
        ParserContext pctx = new ParserContext(pconf);
        HashMap vars = new HashMap();
        TestCase.assertTrue((boolean)StaticMethods.is(StaticMethods.getList(Formatter.class)));
        Serializable expr = MVEL.compileExpression((String)"TestCase.assertTrue( is( getList( java.util.Formatter ) ) )", (ParserContext)pctx);
        MVEL.executeExpression((Object)expr, vars);
    }

    public void testMethodWithNegativeIntParamMVEL313() {
        CoreConfidenceTests.assertTrue((boolean)((Boolean)CoreConfidenceTests.runSingleTest("ord(true,-1)")));
    }

    public void testSetterViaDotNotation() {
        TestClass tc = new TestClass();
        tc.getExtra().put("test", "value");
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        String expression = "extra.test";
        Serializable compiled = MVEL.compileSetExpression((String)expression, (ParserContext)ctx);
        MVEL.executeSetExpression((Serializable)compiled, (Object)tc, (Object)"value2");
        CoreConfidenceTests.assertEquals((Object)"value2", (Object)tc.getExtra().get("test"));
    }

    public void testSetterViaMapNotation() {
        TestClass tc = new TestClass();
        tc.getExtra().put("test", "value");
        ParserContext ctx = new ParserContext();
        ctx.withInput("this", TestClass.class);
        ctx.setStrongTyping(true);
        String expression = "extra[\"test\"]";
        Serializable compiled = MVEL.compileSetExpression((String)expression, tc.getClass(), (ParserContext)ctx);
        MVEL.executeSetExpression((Serializable)compiled, (Object)tc, (Object)"value3");
        CoreConfidenceTests.assertEquals((Object)"value3", (Object)tc.getExtra().get("test"));
    }

    public void testGetterViaDotNotation() {
        TestClass tc = new TestClass();
        tc.getExtra().put("test", "value");
        HashMap<String, TestClass> vars = new HashMap<String, TestClass>();
        vars.put("tc", tc);
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("tc", tc.getClass());
        String expression = "tc.extra.test";
        Serializable compiled = MVEL.compileExpression((String)expression, (ParserContext)ctx);
        String val = (String)MVEL.executeExpression((Object)compiled, vars);
        CoreConfidenceTests.assertEquals((String)"value", (String)val);
    }

    public void testGetterViaMapNotation() {
        TestClass tc = new TestClass();
        tc.getExtra().put("test", "value");
        HashMap<String, TestClass> vars = new HashMap<String, TestClass>();
        vars.put("tc", tc);
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("tc", tc.getClass());
        String expression = "tc.extra[\"test\"]";
        Serializable compiled = MVEL.compileExpression((String)expression, (ParserContext)ctx);
        String val = (String)MVEL.executeExpression((Object)compiled, vars);
        CoreConfidenceTests.assertEquals((String)"value", (String)val);
    }

    public void testGetterViaMapGetter() {
        TestClass tc = new TestClass();
        tc.getExtra().put("test", "value");
        HashMap<String, TestClass> vars = new HashMap<String, TestClass>();
        vars.put("tc", tc);
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addInput("tc", tc.getClass());
        String expression = "tc.extra.get(\"test\")";
        Serializable compiled = MVEL.compileExpression((String)expression, (ParserContext)ctx);
        String val = (String)MVEL.executeExpression((Object)compiled, vars);
        CoreConfidenceTests.assertEquals((String)"value", (String)val);
    }

    public void testJIRA209() {
        String[] testCases;
        LinkedHashMap<String, BigDecimal> vars = new LinkedHashMap<String, BigDecimal>();
        vars.put("bal", new BigDecimal("999.99"));
        for (String expr : testCases = new String[]{"bal > 200 or bal < 100", "bal > 200 || bal < 100", "bal < 100 and bal > 200", "bal < 100 && bal > 200", "bal > 200 and bal < 100", "bal > 200 && bal < 100"}) {
            System.out.println("Evaluating '" + expr + "': ......");
            Object val1 = MVEL.eval((String)expr, vars);
            CoreConfidenceTests.assertNotNull((Object)val1);
            Serializable compiled = MVEL.compileExpression((String)expr);
            Object val2 = MVEL.executeExpression((Object)compiled, vars);
            CoreConfidenceTests.assertNotNull((Object)val2);
            CoreConfidenceTests.assertEquals((String)("expression did not evaluate correctly: " + expr), (Object)val1, (Object)val2);
        }
    }

    public void testBigDecimalOutput() {
        String str = "import java.math.BigDecimal; BigDecimal test = new BigDecimal(\"50000\"); System.out.println(test / new BigDecimal(\"1.13\"));";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.setStrictTypeEnforcement(true);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        MVEL.executeExpression((Object)stmt, new HashMap());
    }

    public void testConstructor() {
        String ex = " TestHelper.method(new Person('bob', 30), new Person('mark', 40, 999, 55, 10));\n";
        ParserContext ctx = new ParserContext();
        ctx.setStrongTyping(true);
        ctx.addImport(TestHelper.class);
        ctx.addImport(AbstractTest.Person.class);
        try {
            MVEL.compileExpression((String)ex, (ParserContext)ctx);
            CoreConfidenceTests.fail((String)"Constructor should not have been found.");
        }
        catch (CompileException compileException) {
            // empty catch block
        }
    }

    public void testAmbiguousGetName() {
        Map vars = CoreConfidenceTests.createTestMap();
        vars.put("Foo244", Foo.class);
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        Serializable s = MVEL.compileExpression((String)"foo.getClass().getName()");
        System.out.println(MVEL.executeExpression((Object)s, (Map)vars));
        s = MVEL.compileExpression((String)"Foo244.getName()");
        System.out.println(MVEL.executeExpression((Object)s, (Map)vars));
    }

    public void testBindingNullToPrimitiveTypes() {
        Map vars = CoreConfidenceTests.createTestMap();
        ((Foo)vars.get("foo")).setCountTest(10);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        Serializable s = MVEL.compileSetExpression((String)"foo.countTest");
        MVEL.executeSetExpression((Serializable)s, (Object)vars, null);
        CoreConfidenceTests.assertEquals((int)((Foo)vars.get("foo")).getCountTest(), (int)0);
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        s = MVEL.compileSetExpression((String)"foo.countTest");
        MVEL.executeSetExpression((Serializable)s, (Object)vars, null);
        CoreConfidenceTests.assertEquals((int)((Foo)vars.get("foo")).getCountTest(), (int)0);
        MVEL.executeSetExpression((Serializable)s, (Object)vars, null);
        CoreConfidenceTests.assertEquals((int)((Foo)vars.get("foo")).getCountTest(), (int)0);
    }

    public void testBindingNullToPrimitiveTypes2() {
        Map vars = CoreConfidenceTests.createTestMap();
        ((Foo)vars.get("foo")).setCountTest(10);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        Serializable s = MVEL.compileSetExpression((String)"foo.boolTest");
        MVEL.executeSetExpression((Serializable)s, (Object)vars, null);
        CoreConfidenceTests.assertFalse((boolean)((Foo)vars.get("foo")).isBoolTest());
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        s = MVEL.compileSetExpression((String)"foo.boolTest");
        MVEL.executeSetExpression((Serializable)s, (Object)vars, null);
        CoreConfidenceTests.assertFalse((boolean)((Foo)vars.get("foo")).isBoolTest());
        MVEL.executeSetExpression((Serializable)s, (Object)vars, null);
        CoreConfidenceTests.assertFalse((boolean)((Foo)vars.get("foo")).isBoolTest());
    }

    public void testBindingNullToPrimitiveTypes3() {
        Map vars = CoreConfidenceTests.createTestMap();
        ((Foo)vars.get("foo")).setCharTest('a');
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        Serializable s = MVEL.compileSetExpression((String)"foo.charTest");
        MVEL.executeSetExpression((Serializable)s, (Object)vars, null);
        CoreConfidenceTests.assertEquals((int)((Foo)vars.get("foo")).getCharTest(), (int)0);
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        s = MVEL.compileSetExpression((String)"foo.charTest");
        MVEL.executeSetExpression((Serializable)s, (Object)vars, null);
        CoreConfidenceTests.assertEquals((int)((Foo)vars.get("foo")).getCharTest(), (int)0);
        MVEL.executeSetExpression((Serializable)s, (Object)vars, null);
        CoreConfidenceTests.assertEquals((int)((Foo)vars.get("foo")).getCharTest(), (int)0);
    }

    public void testBindingNullToPrimitiveTypes4() {
        Map vars = CoreConfidenceTests.createTestMap();
        ((Foo)vars.get((Object)"foo")).charTestFld = (char)97;
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        Serializable s = MVEL.compileSetExpression((String)"foo.charTestFld");
        MVEL.executeSetExpression((Serializable)s, (Object)vars, null);
        CoreConfidenceTests.assertEquals((int)((Foo)vars.get((Object)"foo")).charTestFld, (int)0);
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        s = MVEL.compileSetExpression((String)"foo.charTestFld");
        MVEL.executeSetExpression((Serializable)s, (Object)vars, null);
        CoreConfidenceTests.assertEquals((int)((Foo)vars.get((Object)"foo")).charTestFld, (int)0);
        MVEL.executeSetExpression((Serializable)s, (Object)vars, null);
        CoreConfidenceTests.assertEquals((int)((Foo)vars.get((Object)"foo")).charTestFld, (int)0);
    }

    public void testBindListToArray() {
        Map vars = CoreConfidenceTests.createTestMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        Serializable s = MVEL.compileSetExpression((String)"foo.charArray");
        MVEL.executeSetExpression((Serializable)s, (Object)vars, list);
        CoreConfidenceTests.assertEquals((int)((Foo)vars.get("foo")).getCharArray().length, (int)3);
    }

    public void testBindListToMultiArray() {
        Map vars = CoreConfidenceTests.createTestMap();
        ArrayList list = new ArrayList();
        ArrayList<String> l1 = new ArrayList<String>();
        l1.add("a");
        l1.add("b");
        l1.add("c");
        ArrayList<String> l2 = new ArrayList<String>();
        l2.add("d");
        l2.add("e");
        l2.add("f");
        ArrayList<String> l3 = new ArrayList<String>();
        l3.add("g");
        l3.add("h");
        l3.add("i");
        list.add(l1);
        list.add(l2);
        list.add(l3);
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        Serializable s = MVEL.compileSetExpression((String)"foo.charArrayMulti");
        MVEL.executeSetExpression((Serializable)s, (Object)vars, list);
        Foo foo = (Foo)vars.get("foo");
        CoreConfidenceTests.assertEquals((int)foo.getCharArrayMulti().length, (int)3);
        CoreConfidenceTests.assertEquals((char)foo.getCharArrayMulti()[2][2], (char)'i');
    }

    public void testMVEL224() {
        ParserContext ctx = new ParserContext();
        MVEL.compileExpression((String)"(pin == 1)", (ParserContext)ctx);
    }

    public void testMVEL221() {
        A221 a1 = new A221();
        a1.b = new B221();
        A221 a2 = new A221();
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        String expression = "this.?b.c";
        Serializable compiledExpression = MVEL.compileExpression((String)expression);
        CoreConfidenceTests.assertEquals(null, (String)((String)MVEL.executeExpression((Object)compiledExpression, (Object)a2, String.class)));
        CoreConfidenceTests.assertEquals((String)"something", (String)((String)MVEL.executeExpression((Object)compiledExpression, (Object)a1, String.class)));
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        compiledExpression = MVEL.compileExpression((String)expression);
        CoreConfidenceTests.assertEquals(null, (String)((String)MVEL.executeExpression((Object)compiledExpression, (Object)a2, String.class)));
        CoreConfidenceTests.assertEquals((String)"something", (String)((String)MVEL.executeExpression((Object)compiledExpression, (Object)a1, String.class)));
    }

    public void testMVEL222() throws IOException {
        String script = "for (int i= 0; i < 10; i++ ){ values[i] = 1.0; }";
        HashMap<String, double[]> scriptVars = new HashMap<String, double[]>();
        double[] values = new double[10];
        scriptVars.put("values", values);
        Serializable expression = MVEL.compileExpression((String)script);
        for (int i = 0; i < 6; ++i) {
            scriptVars.put("values", values);
            MVEL.executeExpression((Object)expression, scriptVars);
        }
    }

    public void testMVEL238() throws IOException {
        String expr = new String(ParseTools.loadFromFile((File)new File("src/test/java/org/mvel2/tests/MVEL238.mvel")));
        Serializable s = MVEL.compileExpression((String)expr);
        System.out.println(MVEL.executeExpression((Object)s, new HashMap()));
        System.out.println(MVEL.executeExpression((Object)s, new HashMap()));
    }

    public void testParsingRegression() {
        String expr = "if (false) {System.out.println(\" foo\")} else {System.out.println(\" bar\")}";
        MVEL.eval((String)expr);
    }

    public void testArrayLength() {
        ParserContext context = new ParserContext();
        context.setStrongTyping(true);
        context.addInput("x", String[].class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)"x.length", (ParserContext)context);
    }

    public void testEmptyConstructorWithSpace() throws Exception {
        ParserConfiguration pconf = new ParserConfiguration();
        pconf.addImport("getString", StaticClassWithStaticMethod.class.getMethod("getString", null));
        String text = "getString( )";
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.setStrictTypeEnforcement(true);
        MVEL.compileExpression((String)text, (ParserContext)pctx);
    }

    public void testJavaLangImport() throws Exception {
        String s = "Exception e = null;";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        MVEL.compileExpression((String)s, (ParserContext)pctx);
    }

    public void testContextFieldNotFound() {
        String str = "'stilton'.equals( type );";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.addInput("this", Cheese.class);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        MVEL.executeExpression((Object)stmt, (Object)new Cheese(), new HashMap());
    }

    public void testVarArgs() throws Exception {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        MVEL.analyze((String)"String.format(\"\");", (ParserContext)parserContext);
    }

    public void testOperatorPrecedence() throws IOException {
        String script = "list = [1, 2, 3]; x = 10; list contains x || x == 20";
        Serializable expression = MVEL.compileExpression((String)script);
        Object result = MVEL.executeExpression((Object)expression, new HashMap());
        CoreConfidenceTests.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    public void testNestedEnum() throws Exception {
        MVEL.eval((String)("import " + Triangle.class.getCanonicalName() + "; Triangle.Foo.OBTUSE"), new HashMap());
    }

    public void testNestedNumInMapKey() {
        String str = "objectKeyMaptributes[Triangle.Foo.OBTUSE]";
        ParserConfiguration pconf = new ParserConfiguration();
        pconf.addImport("Triangle", Triangle.class);
        ParserContext pctx = new ParserContext(pconf);
        pctx.addInput("this", AbstractTest.Person.class);
        pctx.setStrongTyping(true);
        Foo foo = new Foo();
        AbstractTest.Person p = new AbstractTest.Person();
        HashMap<Object, Foo> map = new HashMap<Object, Foo>();
        map.put((Object)Triangle.Foo.OBTUSE, foo);
        p.setObjectKeyMaptributes(map);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        Object o = MVEL.executeExpression((Object)stmt, (Object)p, new HashMap());
    }

    public void testNestedClassWithNestedGenericsOnNakedMethod() {
        String str = "deliveries.size";
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.addInput("this", Triangle.class);
        pctx.setStrongTyping(true);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        CoreConfidenceTests.assertEquals((Object)0, (Object)((Integer)MVEL.executeExpression((Object)stmt, (Object)new Triangle(), new HashMap())));
        str = "deliveries.size == 0";
        stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        CoreConfidenceTests.assertTrue((boolean)((Boolean)MVEL.executeExpression((Object)stmt, (Object)new Triangle(), new HashMap())));
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = false;
    }

    public void testStrictModeAddAll() {
        String str = "list.addAll( o );";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("o", Object.class);
        pctx.addInput("list", ArrayList.class);
        try {
            ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
            CoreConfidenceTests.fail((String)"This should not compileShared, as o is not of a type Collection");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNestedEnumFromJar() throws ClassNotFoundException, SecurityException, NoSuchFieldException {
        String expr = "EventRequest.Status.ACTIVE";
        URL resource = ((Object)((Object)this)).getClass().getResource("/eventing-example.jar");
        CoreConfidenceTests.assertNotNull((Object)resource);
        URLClassLoader loader = new URLClassLoader(new URL[]{resource}, ((Object)((Object)this)).getClass().getClassLoader());
        Class<?> er = loader.loadClass("org.drools.examples.eventing.EventRequest");
        CoreConfidenceTests.assertNotNull(er);
        CoreConfidenceTests.assertEquals((String)"org.drools.examples.eventing.EventRequest", (String)er.getCanonicalName());
        Class<?> st = er.getDeclaredClasses()[0];
        CoreConfidenceTests.assertNotNull(st);
        Field active = st.getField("ACTIVE");
        CoreConfidenceTests.assertNotNull((Object)active);
        ParserConfiguration pconf = new ParserConfiguration();
        pconf.setClassLoader((ClassLoader)loader);
        pconf.addImport(er);
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        Serializable compiled = MVEL.compileExpression((String)expr, (ParserContext)pctx);
        Object result = MVEL.executeExpression((Object)compiled);
        CoreConfidenceTests.assertNotNull((Object)result);
    }

    public void testContextObjMethodCall() {
        String str = "getName() == \"bob\"";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("this", Bar.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        Bar ctx = new Bar();
        ctx.setName("bob");
        Boolean result = (Boolean)MVEL.executeExpression((Object)stmt, (Object)ctx);
        CoreConfidenceTests.assertTrue((boolean)result);
    }

    public void testMapAccessWithNestedMethodCall() {
        String str = "map[aMethod(1)] == \"one\"";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("this", POJO.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        POJO ctx = new POJO();
        ctx.getMap().put("1", "one");
        Boolean result = (Boolean)MVEL.executeExpression((Object)stmt, (Object)ctx);
        CoreConfidenceTests.assertTrue((boolean)result);
    }

    public void testMVEL226() {
        HashMap<String, String> foo = new HashMap<String, String>();
        foo.put("bar", "baz");
        OptimizerFactory.setDefaultOptimizer((String)"reflective");
        Serializable compiledExpression = MVEL.compileExpression((String)"this.bar");
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap());
        CoreConfidenceTests.assertEquals((String)"baz", (String)((String)MVEL.executeExpression((Object)compiledExpression, foo, (VariableResolverFactory)factory, String.class)));
    }

    public void testMapAccessProperty() {
        String str = "map.key";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("this", POJO.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        POJO ctx = new POJO();
        try {
            MVEL.executeExpression((Object)stmt, (Object)ctx);
            CoreConfidenceTests.fail((String)"Expected PropertyAccessException");
        }
        catch (PropertyAccessException ex) {
            CoreConfidenceTests.assertTrue((boolean)ex.getMessage().contains("could not access: key"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapAccessWithNestedPropertyAO() {
        boolean allowCompilerOverride = MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING;
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        try {
            String str = "map[key] == \"one\"";
            ParserConfiguration pconf = new ParserConfiguration();
            ParserContext pctx = new ParserContext(pconf);
            pctx.setStrongTyping(true);
            pctx.addInput("this", POJO.class);
            ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
            POJO ctx = new POJO();
            ctx.getMap().put("1", "one");
            Boolean result = (Boolean)MVEL.executeExpression((Object)stmt, (Object)ctx);
            CoreConfidenceTests.assertTrue((boolean)result);
            result = (Boolean)MVEL.executeExpression((Object)stmt, (Object)ctx);
            CoreConfidenceTests.assertTrue((boolean)result);
        }
        finally {
            MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = allowCompilerOverride;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapAccessWithNestedPropertyAO_ASM() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        boolean allowCompilerOverride = MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING;
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        try {
            String str = "map[key] == \"one\"";
            ParserConfiguration pconf = new ParserConfiguration();
            ParserContext pctx = new ParserContext(pconf);
            pctx.setStrongTyping(true);
            pctx.addInput("this", POJO.class);
            ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
            POJO ctx = new POJO();
            ctx.getMap().put("1", "one");
            Boolean result = (Boolean)MVEL.executeExpression((Object)stmt, (Object)ctx);
            CoreConfidenceTests.assertTrue((boolean)result);
            result = (Boolean)MVEL.executeExpression((Object)stmt, (Object)ctx);
            CoreConfidenceTests.assertTrue((boolean)result);
        }
        finally {
            MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = allowCompilerOverride;
        }
    }

    public void testMapAccessWithNestedProperty() {
        String str = "map[key] == \"one\"";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("this", POJO.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        POJO ctx = new POJO();
        ctx.getMap().put("1", "one");
        Boolean result = (Boolean)MVEL.executeExpression((Object)stmt, (Object)ctx);
        CoreConfidenceTests.assertTrue((boolean)result);
    }

    public void testMapAccessWithNestedPropertyRepeated() {
        String str = "map[key] == \"one\"";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("this", POJO.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        POJO ctx = new POJO();
        ctx.getMap().put("1", "one");
        for (int i = 0; i < 500; ++i) {
            try {
                Boolean result = (Boolean)MVEL.executeExpression((Object)stmt, (Object)ctx);
                CoreConfidenceTests.assertTrue((boolean)result);
                continue;
            }
            catch (RuntimeException ex) {
                if (i == 0) {
                    throw ex;
                }
                throw new IllegalStateException("Expression failed at iteration " + i, ex);
            }
        }
    }

    public void testArrays() {
        String str = "Object[] a = new Object[3]; a[0] = \"a\"; a[1] = \"b\"; a[2] = \"c\"; System.out.println(java.util.Arrays.toString(a));";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        MVEL.executeExpression((Object)stmt, new HashMap());
    }

    public void testFullyQualifiedEnums() {
        String str = "System.out.println( STATIC_ENUM.FOO ); \nSystem.out.println( org.mvel2.tests.core.res.MyInterface$STATIC_ENUM.BAR );\nSystem.out.println( org.mvel2.tests.core.res.MyInterface.MyInnerInterface.INNER_STATIC_ENUM.BAR );\nSystem.out.println( RoundingMode.UP );\nSystem.out.println( java.math.RoundingMode.DOWN );";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("this", MyInterface.class);
        pctx.addImport(MyInterface.STATIC_ENUM.class);
        pctx.addImport(RoundingMode.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
    }

    public void testGenericsMap() throws Exception {
        try {
            String str = "triangle.deliveries[0].containsKey( \"x\" )";
            ParserConfiguration pconf = new ParserConfiguration();
            ParserContext pctx = new ParserContext(pconf);
            pctx.setStrongTyping(true);
            pctx.addInput("triangle", Triangle.class);
            ExecutableStatement executableStatement = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testWithInsideBlock() {
        String str = "Foo f = new Foo(); with(f) { setBoolTest( true ) }; f.isBoolTest()";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("this", Bar.class);
        pctx.addImport(Foo.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        Bar ctx = new Bar();
        Boolean result = (Boolean)MVEL.executeExpression((Object)stmt, (Object)ctx, new HashMap());
        CoreConfidenceTests.assertTrue((boolean)result);
    }

    public void testMethodCallWithSpaces() {
        String[] str = new String[]{"Foo f = new Foo(); f.setBoolTest( true )   ; f.isBoolTest()", "Foo f = new Foo(); f . setBoolTest( true ) ; f.isBoolTest()", "Foo f = new Foo(); f. setBoolTest( true )  ; f.isBoolTest()", "Foo f = new Foo(); f .setBoolTest( true )  ; f.isBoolTest()", "Foo f = new Foo(); f.boolTest = true   ; f.isBoolTest()", "Foo f = new Foo(); f . boolTest = true ; f.isBoolTest()", "Foo f = new Foo(); f. boolTest = true  ; f.isBoolTest()", "Foo f = new Foo(); f .boolTest = true  ; f.isBoolTest()"};
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("this", Bar.class);
        pctx.addImport(Foo.class);
        ArrayList<String> errors = new ArrayList<String>();
        for (String s : str) {
            try {
                ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)s, (ParserContext)pctx);
                Bar ctx = new Bar();
                Boolean result = (Boolean)MVEL.executeExpression((Object)stmt, (Object)ctx, new HashMap());
                CoreConfidenceTests.assertTrue((boolean)result);
            }
            catch (Exception e) {
                e.printStackTrace();
                errors.add("**** Error on expression: " + s + "\n" + e.getMessage());
            }
        }
        CoreConfidenceTests.assertTrue((String)((Object)errors).toString(), (boolean)errors.isEmpty());
    }

    public void testMethodCallWithSpacesASM() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        try {
            this.testMethodCallWithSpaces();
        }
        finally {
            OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.DYNAMIC);
        }
    }

    public void testInlineConstructor() {
        String str = "cheese = new Cheese().{ type = $c.type };";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        pctx.addInput("$c", Cheese.class);
        pctx.addImport(Cheese.class);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        Cheese $c = new Cheese();
        $c.setType("stilton");
        HashMap<String, Cheese> vars = new HashMap<String, Cheese>();
        vars.put("$c", $c);
        Cheese cheese = (Cheese)MVEL.executeExpression((Object)stmt, vars);
        CoreConfidenceTests.assertEquals((String)"stilton", (String)cheese.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStrTriangleEqualsEquals() {
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        try {
            ParserConfiguration pconf = new ParserConfiguration();
            ParserContext pctx = new ParserContext(pconf);
            pctx.addInput("this", Triangle.class);
            pctx.setStrongTyping(true);
            String str = "this.strLabel == this";
            try {
                ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
                CoreConfidenceTests.fail((String)"should have failed");
            }
            catch (CompileException e) {
                System.out.println();
                MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = false;
                return;
            }
        }
        finally {
            MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = false;
        }
    }

    public void testPackageImportEnum() {
        String str = "new Status( START )";
        ParserConfiguration pconf = new ParserConfiguration();
        pconf.addPackageImport("org.mvel2.tests.core.res");
        pconf.addPackageImport("org.mvel2.tests.core.res.Status");
        ParserContext context = new ParserContext(pconf);
        context.setStrongTyping(true);
        Serializable s = MVEL.compileExpression((String)str.trim(), (ParserContext)context);
        CoreConfidenceTests.assertEquals((Object)new Status(0), (Object)MVEL.executeExpression((Object)s));
        CoreConfidenceTests.assertFalse((boolean)new Status(1).equals(MVEL.executeExpression((Object)s)));
    }

    public void testNarrowToWideCompare() {
        Serializable s = MVEL.compileExpression((String)"new String('foo') == new Object()", (ParserContext)ParserContext.create().stronglyTyped());
        CoreConfidenceTests.assertFalse((boolean)((Boolean)MVEL.executeExpression((Object)s)));
    }

    public void testPrimitiveArray() {
        HashMap<String, Object[]> vars = new HashMap<String, Object[]>();
        vars.put("array", new boolean[]{true, false});
        String expression = "a = true; array contains a";
        Serializable compiled = MVEL.compileExpression((String)expression);
        boolean result = (Boolean)MVEL.executeExpression((Object)compiled, vars);
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)result);
        vars = new HashMap();
        vars.put("array", new int[]{1, 3, 4});
        expression = "a = 2; array contains a";
        compiled = MVEL.compileExpression((String)expression);
        result = (Boolean)MVEL.executeExpression((Object)compiled, vars);
        CoreConfidenceTests.assertEquals((boolean)false, (boolean)result);
        expression = "a = 3; array contains a";
        compiled = MVEL.compileExpression((String)expression);
        result = (Boolean)MVEL.executeExpression((Object)compiled, vars);
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)result);
        expression = "a = false; array contains a";
        compiled = MVEL.compileExpression((String)expression);
        result = (Boolean)MVEL.executeExpression((Object)compiled, vars);
        CoreConfidenceTests.assertEquals((boolean)false, (boolean)result);
    }

    public void testPrimitiveArrayWithStrongTyping() {
        String expression = "a = true; new boolean[] { true, false } contains a";
        boolean result = (Boolean)this.compileAndExecuteWithStrongTyping(expression);
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)result);
        expression = "a = 2; new int[] { 1, 3 } contains a";
        result = (Boolean)this.compileAndExecuteWithStrongTyping(expression);
        CoreConfidenceTests.assertEquals((boolean)false, (boolean)result);
        expression = "a = true; array = new boolean[] { true, false }; array contains a";
        result = (Boolean)this.compileAndExecuteWithStrongTyping(expression);
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)result);
    }

    public void testVarArgsParams() {
        CoreConfidenceTests.assertEquals((Object)String.format("null", new Object[0]), (Object)CoreConfidenceTests.runSingleTest("import org.mvel2.tests.core.res.AStatic; a = null; AStatic.process(a)"));
        CoreConfidenceTests.assertEquals((Object)String.format("hello,world,", new Object[0]), (Object)CoreConfidenceTests.runSingleTest("import org.mvel2.tests.core.res.AStatic; AStatic.process(\"hello\",\"world\")"));
        CoreConfidenceTests.assertEquals((Object)String.format("", new Object[0]), (Object)CoreConfidenceTests.runSingleTest("import org.mvel2.tests.core.res.AStatic; AStatic.process()"));
        CoreConfidenceTests.assertEquals((Object)String.format("null", new Object[0]), (Object)CoreConfidenceTests.runSingleTest("import org.mvel2.tests.core.res.AStatic; AStatic.process(null)"));
        CoreConfidenceTests.assertEquals((Object)String.format("xxx", new Object[0]), (Object)CoreConfidenceTests.runSingleTest("String.format(\"xxx\")"));
        CoreConfidenceTests.assertEquals((Object)String.format("%010d", 123), (Object)CoreConfidenceTests.runSingleTest("String.format(\"%010d\", 123)"));
        CoreConfidenceTests.assertEquals((Object)String.format("%010d", 123), (Object)CoreConfidenceTests.runSingleTest("a = new Object[1]; a[0] = 123; String.format(\"%010d\", a)"));
        CoreConfidenceTests.assertEquals((Object)String.format("%010d", 123), (Object)CoreConfidenceTests.runSingleTest("a = 123; String.format(\"%010d\", a)"));
        CoreConfidenceTests.assertEquals((Object)String.format("%010d -- %010d", 123, 456), (Object)CoreConfidenceTests.runSingleTest("a = 123; b = 456; String.format(\"%010d -- %010d\", {a, b})"));
        CoreConfidenceTests.assertEquals((Object)String.format("%010d -- %010d", 123, 456), (Object)CoreConfidenceTests.runSingleTest("a = new Object[2]; a[0] = 123; a[1] = 456; String.format(\"%010d -- %010d\", a)"));
        CoreConfidenceTests.assertEquals((Object)String.format("%010d -- %010d", 123, 456), (Object)CoreConfidenceTests.runSingleTest("String.format(\"%010d -- %010d\", 123, 456)"));
        CoreConfidenceTests.assertEquals((Object)String.format("%010d -- %010d", 123, 456), (Object)CoreConfidenceTests.runSingleTest("a = 123; b = 456; String.format(\"%010d -- %010d\", a, b)"));
    }

    public void testTypedVarArgsParams() {
        String imports = "import org.mvel2.tests.core.CoreConfidenceTests.A;\nimport org.mvel2.tests.core.CoreConfidenceTests.B;\n";
        String invoke0 = imports + "new A().invoke(\"s1\", \"s2\")";
        int result = (Integer)this.compileAndExecuteWithStrongTyping(invoke0);
        CoreConfidenceTests.assertEquals((int)0, (int)result);
        CoreConfidenceTests.assertEquals((Object)0, (Object)CoreConfidenceTests.runSingleTest(invoke0));
        String invokeSum0 = imports + "A.invokeSum(3)";
        result = (Integer)this.compileAndExecuteWithStrongTyping(invokeSum0);
        CoreConfidenceTests.assertEquals((int)3, (int)result);
        CoreConfidenceTests.assertEquals((Object)3, (Object)CoreConfidenceTests.runSingleTest(invokeSum0));
        String invoke3 = imports + "new A().invoke(\"s1\", \"s2\", new B(), new B(), new B())";
        result = (Integer)this.compileAndExecuteWithStrongTyping(invoke3);
        CoreConfidenceTests.assertEquals((int)3, (int)result);
        CoreConfidenceTests.assertEquals((Object)3, (Object)CoreConfidenceTests.runSingleTest(invoke3));
        String invokeSum2 = imports + "A.invokeSum(3, new B(4), new B(5))";
        result = (Integer)this.compileAndExecuteWithStrongTyping(invokeSum2);
        CoreConfidenceTests.assertEquals((int)12, (int)result);
        CoreConfidenceTests.assertEquals((Object)12, (Object)CoreConfidenceTests.runSingleTest(invokeSum2));
    }

    public void testTypedVarArgsConstructor() {
        String imports = "import org.mvel2.tests.core.CoreConfidenceTests.MySet;\n";
        String constructor = imports + "new MySet(\"s1\", \"s2\")";
        MySet result = (MySet)this.compileAndExecuteWithStrongTyping(constructor);
        CoreConfidenceTests.assertTrue((boolean)result.contains("s1"));
        CoreConfidenceTests.assertTrue((boolean)result.contains("s2"));
    }

    public void testTypedVarArgsConstructorASM() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        try {
            this.testTypedVarArgsConstructor();
        }
        finally {
            OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.DYNAMIC);
        }
    }

    private <T> T compileAndExecuteWithStrongTyping(String expression) {
        return this.compileAndExecuteWithStrongTyping(expression, new HashMap());
    }

    private <T> T compileAndExecuteWithStrongTyping(String expression, Map vars) {
        ParserContext context = new ParserContext();
        context.setStrongTyping(true);
        context.setStrictTypeEnforcement(true);
        Serializable compiled = MVEL.compileExpression((String)expression, (ParserContext)context);
        return (T)MVEL.executeExpression((Object)compiled, (Map)vars);
    }

    public void testArrayCreation() {
        CoreConfidenceTests.assertTrue((boolean)Arrays.deepEquals(new Object[0], (Object[])this.compileAndExecuteWithStrongTyping("{}")));
        CoreConfidenceTests.assertTrue((boolean)Arrays.deepEquals(new String[0], (String[])this.compileAndExecuteWithStrongTyping("new String[] {}")));
        CoreConfidenceTests.assertTrue((boolean)Arrays.deepEquals(new String[]{"xyz"}, (String[])this.compileAndExecuteWithStrongTyping("new String[] { \"xyz\" }")));
        CoreConfidenceTests.assertTrue((boolean)Arrays.deepEquals(new String[]{"xyz"}, (String[])this.compileAndExecuteWithStrongTyping("new String[] { new String(\"xyz\") }")));
        CoreConfidenceTests.assertTrue((boolean)Arrays.deepEquals(new String[]{"xyz", "abc"}, (String[])this.compileAndExecuteWithStrongTyping("new String[] { new String(\"xyz\"), new String(\"abc\") }")));
        CoreConfidenceTests.assertTrue((boolean)Arrays.deepEquals(new B[0], (B[])this.compileAndExecuteWithStrongTyping("import org.mvel2.tests.core.CoreConfidenceTests.B;\nnew B[] { }")));
        CoreConfidenceTests.assertTrue((boolean)Arrays.deepEquals(new B[]{new B(5)}, (B[])this.compileAndExecuteWithStrongTyping("import org.mvel2.tests.core.CoreConfidenceTests.B;\nnew B[] { new B(5) }")));
        CoreConfidenceTests.assertTrue((boolean)Arrays.deepEquals(new B[]{new B(), new B(), new B()}, (B[])this.compileAndExecuteWithStrongTyping("import org.mvel2.tests.core.CoreConfidenceTests.B;\nnew B[] {new B(),new B(),new B()}")));
    }

    public void testUppercaseField() {
        String ex = "Field1 == \"foo\" || FIELD2 == \"bar\"";
        ParserContext parserContext2 = new ParserContext();
        parserContext2.setStrictTypeEnforcement(true);
        parserContext2.setStrongTyping(true);
        parserContext2.addInput("this", Bean1.class);
        MVEL.analyze((String)ex, (ParserContext)parserContext2);
    }

    public void testExpressionReturnType() {
        CoreConfidenceTests.assertEquals(String.class, this.expressionReturnType("Field1"));
        CoreConfidenceTests.assertEquals(String.class, this.expressionReturnType("Field1 + FIELD2"));
        CoreConfidenceTests.assertEquals(String.class, this.expressionReturnType("Field1 + 3"));
        CoreConfidenceTests.assertEquals(String.class, this.expressionReturnType("Field1 + 3 + FIELD2"));
        CoreConfidenceTests.assertEquals(Integer.TYPE, this.expressionReturnType("intField"));
        CoreConfidenceTests.assertEquals(Integer.class, this.expressionReturnType("intField = 3"));
        CoreConfidenceTests.assertEquals(Boolean.class, this.expressionReturnType("intField == 3"));
        CoreConfidenceTests.assertEquals(Boolean.class, this.expressionReturnType("intField == \"3\""));
        CoreConfidenceTests.assertEquals(Boolean.class, this.expressionReturnType("intField == 1 || Field1 == \"xxx\""));
        CoreConfidenceTests.assertEquals(Boolean.class, this.expressionReturnType("FIELD2 == \"yyy\" && intField == 1 + 2 || Field1 == \"xxx\""));
    }

    public void testConstantOnLeftExpression() {
        CoreConfidenceTests.assertEquals(Boolean.class, this.expressionReturnType("3 == intField"));
        CoreConfidenceTests.assertEquals(Boolean.class, this.expressionReturnType("\"xxx\" == Field1"));
        CoreConfidenceTests.assertEquals(Boolean.class, this.expressionReturnType("null == Field1"));
    }

    public void testExpressionReturnTypeWithGenerics() {
        CoreConfidenceTests.assertEquals(String.class, this.expressionReturnType("Field1Option.get"));
        CoreConfidenceTests.assertEquals(String.class, this.expressionReturnType("Field1Option.t"));
    }

    public void testModuloReturnType() {
        CoreConfidenceTests.assertEquals(Integer.class, this.expressionReturnType("3 % 2"));
    }

    public void testWrongExpressions() {
        this.wrongExpressionMustFail("Field1 == 3");
        this.wrongExpressionMustFail("Field1 - 3");
        this.wrongExpressionMustFail("intField == 3 || Field1");
    }

    private void wrongExpressionMustFail(String expr) {
        try {
            this.expressionReturnType(expr);
            CoreConfidenceTests.fail((String)("wrong expression '" + expr + "' must fail"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Class<?> expressionReturnType(String expr) {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("this", Bean1.class);
        MVEL.compileExpression((String)expr, (ParserContext)parserContext);
        return MVEL.analyze((String)expr, (ParserContext)parserContext);
    }

    public void testExponentialNotation() {
        CoreConfidenceTests.assertEquals((Object)110.0, (Object)CoreConfidenceTests.runSingleTest("10 + 1.0E+2"));
        CoreConfidenceTests.assertEquals((Object)90.0, (Object)CoreConfidenceTests.runSingleTest("1.0E+2 - 10"));
        CoreConfidenceTests.assertEquals((Object)10.01, (Object)CoreConfidenceTests.runSingleTest("10 + 1.0E-2"));
    }

    public void testShiftOperator() {
        String expression = "1 << 65536L";
        Serializable compiled = MVEL.compileExpression((String)expression, this.context);
        Object result = MVEL.executeExpression((Object)compiled, new HashMap());
        CoreConfidenceTests.assertEquals((Object)1, (Object)result);
        expression = "one << shift";
        HashMap map = new HashMap(){
            {
                this.put("one", 1);
                this.put("shift", 65536L);
            }
        };
        compiled = MVEL.compileExpression((String)expression, this.context);
        result = MVEL.executeExpression((Object)compiled, (Map)map);
        CoreConfidenceTests.assertEquals((Object)1, (Object)result);
        System.out.println(result);
    }

    public void testSystemOutOnPrivateClass() {
        PrintStream originalSystemOut = System.out;
        System.setOut(new MyPrivatePrintStream(System.out));
        String expression = "System.out.println(\"Hello World\");";
        CoreConfidenceTests.runSingleTest(expression);
        System.setOut(originalSystemOut);
    }

    public void testSystemOutWithActualInstanceMethod() {
        PrintStream originalSystemOut = System.out;
        System.setOut(new MyPublicPrintStream(System.out));
        String expression = "System.out.myPrintln(\"Hello World\");";
        CoreConfidenceTests.runSingleTest(expression);
        System.setOut(originalSystemOut);
    }

    public void testMinusOperatorWithoutSpace() {
        String str = "length == $c.length -1";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        ExecutableStatement stmt = (ExecutableStatement)MVEL.compileExpression((String)str, (ParserContext)pctx);
        Column col1 = new Column("x", 0);
        Column col2 = new Column("x", 0);
        HashMap<String, Column> vars = new HashMap<String, Column>();
        vars.put("$c", col2);
        Boolean result = (Boolean)MVEL.executeExpression((Object)stmt, (Object)col1, vars);
        CoreConfidenceTests.assertFalse((boolean)result);
    }

    public void testPrimitiveNumberCoercion() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("a", Integer.TYPE);
        parserContext.addInput("b", Double.TYPE);
        Class clazz = MVEL.analyze((String)"a > b", (ParserContext)parserContext);
        CoreConfidenceTests.assertEquals(Boolean.class, (Object)clazz);
    }

    public void testClassLiteral() {
        try {
            MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
            ParserContext parserContext = new ParserContext();
            parserContext.setStrictTypeEnforcement(true);
            parserContext.setStrongTyping(true);
            parserContext.addInput("a", Class.class);
            MVEL.compileExpression((String)"a == String", (ParserContext)parserContext);
        }
        finally {
            MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = false;
        }
    }

    public void testBigIntegerWithZeroValue() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("a", BigInteger.class);
        Serializable expression = MVEL.compileExpression((String)"a == 0I", (ParserContext)parserContext);
        boolean result = (Boolean)MVEL.executeExpression((Object)expression, (Map)new HashMap(){
            {
                this.put("a", new BigInteger("0"));
            }
        });
        CoreConfidenceTests.assertTrue((boolean)result);
    }

    public void testBigDecimalWithZeroValue() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("a", BigDecimal.class);
        Serializable expression = MVEL.compileExpression((String)"a == 0B", (ParserContext)parserContext);
        boolean result = (Boolean)MVEL.executeExpression((Object)expression, (Map)new HashMap(){
            {
                this.put("a", new BigDecimal("0.0"));
            }
        });
        CoreConfidenceTests.assertTrue((boolean)result);
    }

    public void testMethodReturningPrimitiveTypeAnalysis() {
        String str = "value";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.addInput("this", MyObj.class);
        pctx.setStrongTyping(true);
        Class returnType = MVEL.analyze((String)str, (ParserContext)pctx);
        CoreConfidenceTests.assertEquals(Long.TYPE, (Object)returnType);
    }

    public void testStaticMethodsInvocationWithNullArg() {
        String str = "org.mvel2.tests.core.CoreConfidenceTests$MyObj.doSomething(null, \"abc\")";
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrongTyping(true);
        CoreConfidenceTests.assertEquals((Object)(null + "abc"), (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)str, (ParserContext)pctx)));
    }

    public void testStaticMethodsInvocationWithNullArgASM() {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        this.testStaticMethodsInvocationWithNullArg();
    }

    public void testCovariance() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("this", ImplementationA.class);
        CoreConfidenceTests.assertEquals(Integer.TYPE, (Object)MVEL.analyze((String)"b.value", (ParserContext)parserContext));
        CoreConfidenceTests.assertEquals((Object)42, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"b.value", (ParserContext)parserContext), (Object)new ImplementationA()));
    }

    public void testDivisionType() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("a", BigDecimal.class);
        Serializable expression = MVEL.compileExpression((String)"(a / 3).setScale(2, java.math.BigDecimal.ROUND_HALF_UP)", (ParserContext)parserContext);
        Object result = MVEL.executeExpression((Object)expression, (Map)new HashMap(){
            {
                this.put("a", new BigDecimal("3.0"));
            }
        });
        System.out.println(result);
    }

    public void testPrimitiveNumberCoercionDuringDivisionShouldWorkOnBothSide() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("a", Integer.TYPE);
        parserContext.addInput("b", Integer.TYPE);
        int a = 1;
        int b = 2;
        Integer res = a / b;
        System.out.printf("Result class Java: %s\nResult value: %s\n", res.getClass(), res);
        Boolean resBoolean = (double)(a / b) < 0.99;
        System.out.println("Result Boolean: " + resBoolean);
        Serializable constantDoubleLeft = MVEL.compileExpression((String)"0.99 >= a / b", (ParserContext)parserContext);
        Object resultLeft = MVEL.executeExpression((Object)constantDoubleLeft, (Map)new HashMap(){
            {
                this.put("a", 1);
                this.put("b", 2);
            }
        });
        CoreConfidenceTests.assertEquals((Object)true, (Object)resultLeft);
        Serializable constantDoubleRight = MVEL.compileExpression((String)"a / b < 0.99", (ParserContext)parserContext);
        Object resultRight = MVEL.executeExpression((Object)constantDoubleRight, (Map)new HashMap(){
            {
                this.put("a", 1);
                this.put("b", 2);
            }
        });
        CoreConfidenceTests.assertEquals((Object)true, (Object)resultRight);
        parserContext.addInput("c", Double.TYPE);
        parserContext.addInput("d", Double.TYPE);
        Serializable constantIntRight = MVEL.compileExpression((String)"c / d > 0", (ParserContext)parserContext);
        Object resultRightInt = MVEL.executeExpression((Object)constantIntRight, (Map)new HashMap(){
            {
                this.put("c", 1);
                this.put("d", 2);
            }
        });
        CoreConfidenceTests.assertEquals((Object)true, (Object)resultRightInt);
    }

    public void testNumberCoercion() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("a", Integer.TYPE);
        Serializable longDivByInt = MVEL.compileExpression((String)"15 * Math.round( new java.math.BigDecimal(\"49.4\") ) / 100", (ParserContext)parserContext);
        Object resultLongDivByInt = MVEL.executeExpression((Object)longDivByInt, new HashMap());
        CoreConfidenceTests.assertEquals((Object)7.35, (Object)resultLongDivByInt);
        Serializable intDivByBigDecimal = MVEL.compileExpression((String)"a / new java.math.BigDecimal(\"0.5\")", (ParserContext)parserContext);
        Object resultIntDivByBigDecimal = MVEL.executeExpression((Object)intDivByBigDecimal, (Map)new HashMap(){
            {
                this.put("a", 10);
            }
        });
        CoreConfidenceTests.assertEquals((int)20, (int)((BigDecimal)resultIntDivByBigDecimal).intValue());
        Serializable intDivByDouble = MVEL.compileExpression((String)"a / 0.5", (ParserContext)parserContext);
        Object resultIntDivByDouble = MVEL.executeExpression((Object)intDivByDouble, (Map)new HashMap(){
            {
                this.put("a", 10);
            }
        });
        CoreConfidenceTests.assertEquals((int)20, (int)((Double)resultIntDivByDouble).intValue());
    }

    public void testUntypedClone() {
        String expression = "obj.clone();";
        ParserContext context = new ParserContext();
        context.setStrongTyping(false);
        context.setStrictTypeEnforcement(false);
        MVEL.analyze((String)expression, (ParserContext)context);
        try {
            context.addInput("obj", Object.class);
            context.setStrongTyping(true);
            context.setStrictTypeEnforcement(true);
            MVEL.analyze((String)expression, (ParserContext)context);
            CoreConfidenceTests.fail((String)"Must fail with strong typing");
        }
        catch (CompileException compileException) {
            // empty catch block
        }
    }

    public void testOverloading() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("this", Overloaded.class);
        Overloaded overloaded = new Overloaded();
        CoreConfidenceTests.assertEquals((Object)15, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"method(5, 9, \"x\")", (ParserContext)parserContext), (Object)overloaded));
        CoreConfidenceTests.assertEquals((Object)-3, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"method(5, \"x\", 9)", (ParserContext)parserContext), (Object)overloaded));
        CoreConfidenceTests.assertEquals((Object)-13, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"method(\"x\", 5, 9)", (ParserContext)parserContext), (Object)overloaded));
    }

    public void testPippo() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrongTyping(true);
        CoreConfidenceTests.assertEquals(String.class, (Object)MVEL.analyze((String)"new String(\"b)ar\")", (ParserContext)parserContext));
    }

    public void testReturnTypeExtendingGeneric() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrongTyping(true);
        parserContext.addInput("this", StringConcrete.class);
        CoreConfidenceTests.assertEquals(String.class, (Object)MVEL.analyze((String)"foo.concat(\"bar\")", (ParserContext)parserContext));
        CoreConfidenceTests.assertEquals(String.class, (Object)MVEL.analyze((String)"getFoo().concat(\"bar\")", (ParserContext)parserContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullCollection() throws CompileException {
        boolean allowCompilerOverride = MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING;
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        String[] names = new String[]{"missing"};
        Object[] values = new String[]{null};
        try {
            MVEL.executeExpression((Object)((CompiledExpression)MVEL.compileExpression((String)"1; missing[3]")), (VariableResolverFactory)new IndexedVariableResolverFactory(names, values));
            CoreConfidenceTests.fail((String)"Should throw a NullPointerExcption");
        }
        catch (Exception exception) {
        }
        finally {
            MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = allowCompilerOverride;
        }
    }

    public void testRegExWithCast() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrongTyping(true);
        parserContext.addInput("this", Foo.class);
        CoreConfidenceTests.assertEquals(Boolean.class, (Object)MVEL.analyze((String)"(String)bar.name ~= '[a-z].+'", (ParserContext)parserContext));
    }

    public void testUnwantedImport() {
        ParserConfiguration conf = new ParserConfiguration();
        conf.addPackageImport("java.util");
        conf.addPackageImport("org.mvel2.tests.core.res");
        ParserContext pctx = new ParserContext(conf);
        MVEL.analysisCompile((String)"ScenarioType.Set.ADD", (ParserContext)pctx);
        CoreConfidenceTests.assertNull(conf.getImports().get("Set"));
    }

    public void testUnaryNegative() {
        ParserConfiguration conf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("value", Integer.TYPE);
        HashMap vars = new HashMap(){
            {
                this.put("value", 42);
            }
        };
        CoreConfidenceTests.assertEquals((Object)-42, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"-value", (ParserContext)pctx), (Map)vars));
    }

    public void testUnaryNegativeWithSpace() {
        ParserConfiguration conf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("value", Integer.TYPE);
        HashMap vars = new HashMap(){
            {
                this.put("value", 42);
            }
        };
        CoreConfidenceTests.assertEquals((Object)-42, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"- value", (ParserContext)pctx), (Map)vars));
    }

    public void testStaticMethodInvocation() {
        ParserConfiguration conf = new ParserConfiguration();
        conf.addImport(ARef.class);
        conf.addImport(BRef.class);
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("value", String.class);
        HashMap vars = new HashMap(){
            {
                this.put("value", "1234");
            }
        };
        CoreConfidenceTests.assertEquals((Object)0, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"ARef.getSize(value)", (ParserContext)pctx), (Map)vars));
        CoreConfidenceTests.assertEquals((Object)4, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"BRef.getSize(value)", (ParserContext)pctx), (Map)vars));
    }

    public void testMultiplyIntByDouble() {
        ParserConfiguration conf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("i", Integer.class);
        pctx.addInput("d", Double.class);
        HashMap vars = new HashMap(){
            {
                this.put("i", 10);
                this.put("d", 0.3);
            }
        };
        CoreConfidenceTests.assertEquals((Object)3.0, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"i*d", (ParserContext)pctx), (Map)vars));
        CoreConfidenceTests.assertEquals((Object)3.0, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"i*0.3", (ParserContext)pctx), (Map)vars));
    }

    public void testCharToStringCoercionForComparison() {
        ParserConfiguration conf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("ch", Character.class);
        HashMap vars = new HashMap(){
            {
                this.put("ch", Character.valueOf('a'));
            }
        };
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"ch == \"a\"", (ParserContext)pctx), (Map)vars));
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"ch == \"b\"", (ParserContext)pctx), (Map)vars));
    }

    public void testFieldNameWithUnderscore() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("this", Underscore.class);
        Underscore underscore = new Underscore();
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"_id == \"test\"", (ParserContext)parserContext), (Object)underscore));
    }

    public void testEmptyOperatorOnStrings() {
        ParserConfiguration conf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("nullString", String.class);
        pctx.addInput("emptyString", String.class);
        pctx.addInput("blankString", String.class);
        pctx.addInput("nonEmptyString", String.class);
        HashMap vars = new HashMap(){
            {
                this.put("nullString", null);
                this.put("emptyString", "");
                this.put("blankString", "   ");
                this.put("nonEmptyString", "abc");
            }
        };
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"nullString == empty", (ParserContext)pctx), (Map)vars));
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"emptyString == empty", (ParserContext)pctx), (Map)vars));
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"blankString == empty", (ParserContext)pctx), (Map)vars));
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"nonEmptyString == empty", (ParserContext)pctx), (Map)vars));
    }

    public void testEmptyOperatorOnBoolean() {
        ParserConfiguration conf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("bNull", Boolean.class);
        pctx.addInput("bTrue", Boolean.class);
        pctx.addInput("bFalse", Boolean.class);
        HashMap vars = new HashMap(){
            {
                this.put("bNull", null);
                this.put("bTrue", true);
                this.put("bFalse", false);
            }
        };
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"bNull == empty", (ParserContext)pctx), (Map)vars));
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"bTrue == empty", (ParserContext)pctx), (Map)vars));
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"bFalse == empty", (ParserContext)pctx), (Map)vars));
    }

    public void testEmptyOperatorOnInteger() {
        ParserConfiguration conf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("nullInt", Integer.class);
        pctx.addInput("zero", Integer.class);
        pctx.addInput("nonZero", Integer.class);
        HashMap vars = new HashMap(){
            {
                this.put("nullInt", null);
                this.put("zero", 0);
                this.put("nonZero", 42);
            }
        };
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"nullInt == empty", (ParserContext)pctx), (Map)vars));
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"zero == empty", (ParserContext)pctx), (Map)vars));
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"nonZero == empty", (ParserContext)pctx), (Map)vars));
    }

    public void testInstanceofOnInnerClass() {
        ParserConfiguration conf = new ParserConfiguration();
        conf.addImport(ARef.class);
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("value", Object.class);
        HashMap vars = new HashMap(){
            {
                this.put("value", new ARef());
            }
        };
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"value instanceof ARef", (ParserContext)pctx), (Map)vars));
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)("value instanceof " + ARef.class.getCanonicalName()), (ParserContext)pctx), (Map)vars));
    }

    public void testInstanceofWithPackageImport() {
        ParserConfiguration conf = new ParserConfiguration();
        conf.addPackageImport("org.mvel2.tests.core");
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("value", Object.class);
        HashMap vars = new HashMap(){
            {
                this.put("value", new CoreConfidenceTests());
            }
        };
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"value instanceof CoreConfidenceTests", (ParserContext)pctx), (Map)vars));
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)("value instanceof " + CoreConfidenceTests.class.getCanonicalName()), (ParserContext)pctx), (Map)vars));
    }

    public void testInstanceofWithPackageImportAndInnerClass() {
        ParserConfiguration conf = new ParserConfiguration();
        conf.addPackageImport("org.mvel2.tests.core.CoreConfidenceTests");
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("value", Object.class);
        HashMap vars = new HashMap(){
            {
                this.put("value", new ARef());
            }
        };
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"value instanceof ARef", (ParserContext)pctx), (Map)vars));
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)("value instanceof " + ARef.class.getCanonicalName()), (ParserContext)pctx), (Map)vars));
    }

    public void testCompilerExceptionFormatting() throws Exception {
        try {
            Object value = this.test("\n2x * 3\n");
            CoreConfidenceTests.fail((String)"Invalid expression should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testHandleNumericConversionBug() {
        String[] testLiterals = new String[]{"0x20", "020"};
        String baseExpression = "int foo = ";
        for (String literal : testLiterals) {
            char[] decExpr = (baseExpression + literal).toCharArray();
            CoreConfidenceTests.assertEquals((Object)Integer.decode(literal), (Object)ParseTools.handleNumericConversion((char[])decExpr, (int)baseExpression.length(), (int)literal.length()));
        }
    }

    public void testNoArgMethodInheritance() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("a", Parent.class);
        parserContext.addInput("b", Child.class);
        CoreConfidenceTests.assertEquals(Object.class, (Object)MVEL.analyze((String)"a.getSomething()", (ParserContext)parserContext));
        CoreConfidenceTests.assertEquals(String.class, (Object)MVEL.analyze((String)"b.getSomething()", (ParserContext)parserContext));
    }

    public void testMethodOverloadMatch() throws Exception {
        OverloadedClass c = new OverloadedClass();
        Method found = ParseTools.getExactMatch((String)"putXX", (Class[])new Class[]{Integer.TYPE, String.class}, Void.TYPE, OverloadedInterface.class);
        Method correct = OverloadedInterface.class.getMethod("putXX", Integer.TYPE, String.class);
        CoreConfidenceTests.assertEquals((Object)correct, (Object)found);
    }

    public void testInvokeMethodInAbstractClass() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("a", O1.class);
        CoreConfidenceTests.assertEquals(String.class, (Object)MVEL.analyze((String)"a.getObj().getValue()", (ParserContext)parserContext));
        HashMap vars = new HashMap(){
            {
                this.put("a", new O1());
            }
        };
        CoreConfidenceTests.assertEquals((Object)"value", (Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)"a.getObj().getValue()", (ParserContext)parserContext), (Map)vars));
    }

    public void testParseGenericMap() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("conv", Convention.class);
        CoreConfidenceTests.assertEquals(List.class, (Object)MVEL.analyze((String)"conv.getComms().get(\"test\")", (ParserContext)parserContext));
    }

    public void testInvokeVarargConstructor() {
        ParserConfiguration conf = new ParserConfiguration();
        conf.addImport(Thingy.class);
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("name", String.class);
        HashMap vars = new HashMap(){
            {
                this.put("name", "test");
            }
        };
        Thingy result = (Thingy)MVEL.executeExpression((Object)MVEL.compileExpression((String)"new Thingy(name)", (ParserContext)pctx), (Map)vars);
        CoreConfidenceTests.assertEquals((String)"test", (String)result.getName());
    }

    public void testGenericsWithOr() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("o", OrderLine.class);
        parserContext.addInput("p", Product.class);
        Class clazz = MVEL.analyze((String)"p.id == o.product.id || p.category == o.product.category", (ParserContext)parserContext);
        CoreConfidenceTests.assertEquals(Boolean.class, (Object)clazz);
    }

    public void testAnalyzeTernary() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("value", String.class);
        parserContext.addInput("x", Integer.class);
        parserContext.addInput("y", Integer.class);
        parserContext.addInput("z", Integer.class);
        Class clazz = MVEL.analyze((String)"z = (value == \"ALU\" ? x : y);", (ParserContext)parserContext);
        CoreConfidenceTests.assertEquals(Integer.class, (Object)clazz);
    }

    public void testAnalyzeWrongTernary() {
        ParserContext parserContext = new ParserContext();
        parserContext.setStrictTypeEnforcement(true);
        parserContext.setStrongTyping(true);
        parserContext.addInput("value", String.class);
        parserContext.addInput("x", Integer.class);
        parserContext.addInput("y", Integer.class);
        parserContext.addInput("z", Integer.class);
        try {
            Class clazz = MVEL.analyze((String)"z = (value = \"ALU\" ? x : y);", (ParserContext)parserContext);
            CoreConfidenceTests.fail((String)"parse of this expression should raise an error");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testPrimitiveSubtyping() {
        ParserConfiguration conf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        BigDecimal result = (BigDecimal)MVEL.executeExpression((Object)MVEL.compileExpression((String)"java.math.BigDecimal.valueOf(100)", (ParserContext)pctx), new HashMap());
        CoreConfidenceTests.assertEquals((String)"100", (String)result.toString());
    }

    public void testUseVariableFactoryWithArithmeticOperation() {
        this.checkOperation("3 + 4 * i.get()", 43);
        this.checkOperation("2 * 3 + 4 * i.get()", 46);
        this.checkOperation("1 + 2 * 3 + i.get()", 17);
        this.checkOperation("2 * 3 + 4 * i.get()", 46);
        this.checkOperation("1 + 2 * 3 + 4 * i.get()", 47);
        this.checkOperation("1 + 2 * 3 + i.get() * 4", 47);
        this.checkOperation("1 + 2 * 3 + i.get() + 4", 21);
        this.checkOperation("4 * i.get() + 5", 45);
        this.checkOperation("3 + 4 * i.get() + 5", 48);
        this.checkOperation("2 * 3 + 4 * i.get() + 5", 51);
        this.checkOperation("1 + 2 * 3 + 4 * i.get() + 5", 52);
        this.checkOperation("1 + 2 * 3 + 4 * i.get() * 5", 207);
        this.checkOperation("i.get() + 1 + 2 * 3 + 4 * i.get()", 57);
    }

    private void checkOperation(String expression, int expectedResult) {
        AtomicInteger i = new AtomicInteger(10);
        MapVariableResolverFactory factory = new MapVariableResolverFactory(new HashMap());
        factory.createVariable("i", (Object)i);
        ParserConfiguration pconf = new ParserConfiguration();
        ParserContext pctx = new ParserContext(pconf);
        pctx.setStrictTypeEnforcement(true);
        pctx.setStrongTyping(true);
        pctx.addInput("i", AtomicInteger.class);
        Serializable compiledExpr = MVEL.compileExpression((String)expression, (ParserContext)pctx);
        int result = (Integer)MVEL.executeExpression((Object)compiledExpr, null, (VariableResolverFactory)factory);
        CoreConfidenceTests.assertEquals((int)expectedResult, (int)result);
    }

    public void test_BigDecimal_ASMoptimizerSupport() {
        Serializable compiled = MVEL.compileExpression((String)"big = new java.math.BigDecimal(\"10000\"); if (big.compareTo(30000B) > 0) then ;");
        HashMap vars = new HashMap();
        for (int i = 0; i < 1000; ++i) {
            try {
                MVEL.executeExpression((Object)compiled, vars);
                continue;
            }
            catch (CompileException e) {
                e.printStackTrace();
                CoreConfidenceTests.fail((String)("Failed after #executions: " + i));
            }
        }
    }

    public void testLiteralToStringWithSpaceASM() throws Throwable {
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
        this.testLiteralToStringWithSpace();
    }

    public void testLiteralToStringWithSpace() throws Throwable {
        String expr = "'foo'. hashCode()";
        int hashCode = "foo".hashCode();
        Serializable s = MVEL.compileExpression((String)expr);
        CoreConfidenceTests.assertEquals((Object)hashCode, (Object)MVEL.executeExpression((Object)s));
    }

    public void testGetBestCandidateForBigDecimalArg() {
        Class[] arguments = new Class[]{BigDecimal.class};
        Method method = ParseTools.getBestCandidate((Class[])arguments, (String)"round", Math.class, (Method[])Math.class.getMethods(), (boolean)true);
        CoreConfidenceTests.assertEquals(Long.TYPE, method.getReturnType());
        Assert.assertArrayEquals((Object[])new Class[]{Double.TYPE}, (Object[])method.getParameterTypes());
        arguments = new Class[]{BigDecimal.class, BigDecimal.class};
        method = ParseTools.getBestCandidate((Class[])arguments, (String)"max", Math.class, (Method[])Math.class.getMethods(), (boolean)true);
        CoreConfidenceTests.assertEquals(Double.TYPE, method.getReturnType());
        Assert.assertArrayEquals((Object[])new Class[]{Double.TYPE, Double.TYPE}, (Object[])method.getParameterTypes());
        arguments = new Class[]{BigDecimal.class, BigDecimal.class};
        method = ParseTools.getBestCandidate((Class[])arguments, (String)"scalb", Math.class, (Method[])Math.class.getMethods(), (boolean)true);
        CoreConfidenceTests.assertEquals(Double.TYPE, method.getReturnType());
        Assert.assertArrayEquals((Object[])new Class[]{Double.TYPE, Integer.TYPE}, (Object[])method.getParameterTypes());
    }

    public static interface Product {
        public String getId();

        public String getCategory();
    }

    public static interface OrderLine<T extends Product> {
        public T getProduct();
    }

    public static class Thingy
    implements Serializable {
        private String name;
        private String version;
        private Object[] items;

        public Thingy(String name, String version, Object ... items) {
            this.name = name;
            this.version = version;
            this.items = items;
        }

        public Thingy(String name) {
            this.name = name;
            this.version = null;
            this.items = null;
        }

        public void print() {
            System.out.println("Printing rule " + this.name);
        }

        public String getName() {
            return this.name;
        }
    }

    public class Convention {
        private final Map<String, List<String>> comms;

        public Convention(Map<String, List<String>> comms) {
            this.comms = comms;
        }

        public Map<String, List<String>> getComms() {
            return this.comms;
        }
    }

    public static abstract class O3 {
        public String getValue() {
            return "value";
        }
    }

    public static class O2
    extends O3 {
    }

    public static class O1 {
        public O2 getObj() {
            return new O2();
        }
    }

    public static class Child
    extends Parent {
        @Override
        public String getSomething() {
            return null;
        }
    }

    public static class Parent {
        public Object getSomething() {
            return null;
        }
    }

    public static class Underscore {
        public String get_id() {
            return "test";
        }
    }

    public static class BRef
    extends ARef {
        public static int getSize(String s) {
            return s.length();
        }
    }

    public static class ARef {
        public static int getSize(String s) {
            return 0;
        }
    }

    public static class StringConcrete
    extends AbstractBase<String> {
        public StringConcrete() {
            this.foo = new String();
        }
    }

    public static abstract class AbstractBase<T> {
        protected T foo;

        public T getFoo() {
            return this.foo;
        }
    }

    public static class Overloaded {
        public int method(int i, int j, String s) {
            return i + j + s.length();
        }

        public int method(int i, String s, int j) {
            return i + s.length() - j;
        }

        public int method(String s, int i, int j) {
            return s.length() - i - j;
        }
    }

    public static class ImplementationB
    implements InterfaceB {
        public int getValue() {
            return 42;
        }
    }

    public static class ImplementationA
    implements InterfaceA {
        @Override
        public ImplementationB getB() {
            return new ImplementationB();
        }

        public void setB(InterfaceB b) {
        }
    }

    public static interface InterfaceB {
    }

    public static interface InterfaceA {
        public InterfaceB getB();
    }

    public static class MyObj {
        public long valueField;

        public MyObj(long value) {
            this.valueField = value;
        }

        public long getValue() {
            return this.valueField;
        }

        public static String doSomething(MyObj s1, String s2) {
            return s1 + s2;
        }
    }

    public static class MyPublicPrintStream
    extends PrintStream {
        public MyPublicPrintStream(OutputStream os) {
            super(os);
        }

        @Override
        public void println(String s) {
            super.println(s);
        }

        public void myPrintln(String s) {
            super.println(s);
        }
    }

    private static class MyPrivatePrintStream
    extends PrintStream {
        public MyPrivatePrintStream(OutputStream os) {
            super(os);
        }

        @Override
        public void println(String s) {
            super.println(s);
        }
    }

    public static class Option<T> {
        public final T t;

        public Option(T t) {
            this.t = t;
        }

        public boolean isDefined() {
            return this.t != null;
        }

        public T get() {
            return this.t;
        }
    }

    public static class Bean1 {
        private String Field1;
        private String FIELD2;
        private int intField;

        public String getField1() {
            return this.Field1;
        }

        public void setField1(String Field1) {
            this.Field1 = Field1;
        }

        public String getFIELD2() {
            return this.FIELD2;
        }

        public void setFIELD2(String FIELD2) {
            this.FIELD2 = FIELD2;
        }

        public int getIntField() {
            return this.intField;
        }

        public void setIntField(int intField) {
            this.intField = intField;
        }

        public Option<String> getField1Option() {
            return new Option<String>(this.Field1);
        }
    }

    public static class MySet {
        private Set<String> set = new HashSet<String>();

        public MySet(String ... strings) {
            this.add(strings);
        }

        public void add(String ... strings) {
            for (String s : strings) {
                this.set.add(s);
            }
        }

        public boolean contains(String s) {
            return this.set.contains(s);
        }

        public String toString() {
            return this.set.toString();
        }
    }

    public static class B {
        private int value;

        public B() {
        }

        public B(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            return other != null && other instanceof B && this.value == ((B)other).value;
        }
    }

    public static class A {
        public int invoke(String s1, String s2, B ... bs) {
            return bs.length;
        }

        public static int invokeSum(int start, B ... bs) {
            for (B b : bs) {
                start += b.getValue();
            }
            return start;
        }
    }

    public static class Triangle {
        private List<Map<String, Object>> deliveries = new ArrayList<Map<String, Object>>();
        private Object objLabel = "Triangle";
        private String strLabel = "Triangle";
        private Double doubleVal = 29.0;

        public List<Map<String, Object>> getDeliveries() {
            return this.deliveries;
        }

        public Object getObjLabel() {
            return this.objLabel;
        }

        public void setObjLabel(Object objLabel) {
            this.objLabel = objLabel;
        }

        public String getStrLabel() {
            return this.strLabel;
        }

        public void setStrLabel(String strLabel) {
            this.strLabel = strLabel;
        }

        public Double getDoubleVal() {
            return this.doubleVal;
        }

        public void setDoubleVal(Double doubleVal) {
            this.doubleVal = doubleVal;
        }

        public static enum Foo {
            INCOMPLETE,
            UNCLASSIFIED,
            EQUILATERAL,
            ISOSCELES,
            RECTANGLED,
            ISOSCELES_RECTANGLED,
            ACUTE,
            OBTUSE;

        }
    }

    public static class StaticClassWithStaticMethod {
        public static String getString() {
            return "hello";
        }
    }

    public static class B221 {
        public String c = "something";
    }

    public static class A221 {
        public B221 b;
    }

    public static class StaticMethods {
        public static <T> boolean is(List<T> arg) {
            return true;
        }

        public static boolean is(Collection arg) {
            throw new RuntimeException("Wrong method called");
        }

        public static List<Object> getList(Class<?> arg) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(arg);
            return result;
        }

        public static String throwException() {
            throw new RuntimeException("this should throw an exception");
        }
    }

    public static class KnowledgeRuntimeHelper {
        public ProcessManager getProcessManager() {
            return new ProcessManager();
        }
    }

    public static class ProcessManager {
        public void startProcess(String name, Map<String, Object> variables) {
            System.out.println("Process started");
        }
    }

    public static class JIRA167Node {
        public boolean isServer() {
            return true;
        }
    }

    public static class JIRA167Step {
        public String getParent() {
            return null;
        }
    }

    public static class Beano {
        public String getProperty1() {
            return null;
        }

        public boolean isProperty2() {
            return true;
        }

        public boolean isProperty3() {
            return false;
        }
    }

    public static class Fooz {
        public Fooz(String id) {
        }
    }

    public static class TestHelper {
        public static void method(int id, Object[] arr) {
            System.out.println(id + " -> " + arr.length);
        }

        public static void method(Object obj1, Object obj2) {
            System.out.println(obj1 + "-> " + obj2);
        }

        public static Calendar minDate() {
            return Calendar.getInstance();
        }

        public static Calendar maxDate() {
            return Calendar.getInstance();
        }
    }

    public class Bz
    extends Az {
    }

    public class Az {
        public void foo(String s) {
        }
    }

    public static final class Bean2 {
        public final int _prop;

        public Bean2(int prop_) {
            this._prop = prop_;
        }

        public int getProp() {
            return this._prop;
        }

        public String toString() {
            return Integer.toString(this._prop);
        }
    }

    public static interface Services {
        public static final String A_CONST = "Hello World";

        public void log(String var1);
    }

    public static class BeanB {
        private boolean successful;

        public BeanB(boolean successful) {
            this.successful = successful;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public boolean isFailed() {
            return !this.successful;
        }
    }

    public class Fruit {

        public class Apple {
        }
    }

    public static class Cat
    extends Pet {
        @Override
        public void run() {
            System.out.println("cat is running");
        }
    }

    public static class Dog
    extends Pet {
        @Override
        public void run() {
            System.out.println("dog is running");
        }
    }

    public static class Pet {
        public void run() {
        }
    }

    public static class PetStore {
        public List getPets() {
            ArrayList<Pet> pets = new ArrayList<Pet>();
            pets.add(new Dog());
            pets.add(new Cat());
            return pets;
        }
    }

    public static class MvelContext {
        public boolean singleCalled;
        public boolean arrayCalled;
        public String[] regkeys;

        public void methodForTest(String string) {
            System.out.println("sigle param method called!");
            this.singleCalled = true;
        }

        public void methodForTest(String[] strings) {
            System.out.println("array param method called!");
            this.arrayCalled = true;
        }

        public void setRegkeys(String[] regkeys) {
            this.regkeys = regkeys;
        }

        public void setRegkeys(String regkey) {
            this.regkeys = regkey.split(",");
        }
    }

    public static class TestClass2 {
        public void addEqualAuthorizationConstraint(Foo leg, Bar ctrlClass, Integer authorization) {
        }
    }

    public class POJO {
        private Set<Date> dates = new HashSet<Date>();
        private Map<String, Object> map = new HashMap<String, Object>();

        public POJO() {
            this.dates.add(new Date());
        }

        public Set<Date> getDates() {
            return this.dates;
        }

        public void setDates(Set<Date> dates) {
            this.dates = dates;
        }

        public String function(long num) {
            return String.valueOf(num);
        }

        public String aMethod(long num) {
            return String.valueOf(num);
        }

        public Map<String, Object> getMap() {
            return this.map;
        }

        public void setMap(Map<String, Object> map) {
            this.map = map;
        }

        public String getKey() {
            return "1";
        }
    }

    public class MyBean {
        int var;

        public int getVar() {
            return this.var;
        }

        public void setVar(int var) {
            this.var = var;
        }
    }

    public static class MyPerson {
        private String name;

        public MyPerson(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

